/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerClobAsciiInputStream;
import com.microsoft.sqlserver.jdbc.SQLServerClobAsciiOutputStream;
import com.microsoft.sqlserver.jdbc.SQLServerClobCharacterReader;
import com.microsoft.sqlserver.jdbc.SQLServerClobWriter;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.text.Format;
import java.text.MessageFormat;

public final class SQLServerClob
implements Clob,
Serializable {
    private String sData;
    SQLServerConnection con;
    private SQLCollation sqlCollation;

    public SQLServerClob(SQLServerConnection sQLServerConnection, String string) {
        this.con = sQLServerConnection;
        this.sData = string;
    }

    public InputStream getAsciiStream() throws SQLServerException {
        if (null != this.sqlCollation && !this.sqlCollation.supportsAsciiConversion()) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
            Object[] objectArray = new Object[]{"java.sql.Clob", "AsciiStream"};
            SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
        }
        if (null == this.sData) {
            return null;
        }
        return new SQLServerClobAsciiInputStream(this);
    }

    void setSQLCollation(SQLCollation sQLCollation) {
        this.sqlCollation = sQLCollation;
    }

    public Reader getCharacterStream() throws SQLServerException {
        if (null == this.sData) {
            return null;
        }
        return new SQLServerClobCharacterReader(this);
    }

    public String getSubString(long l2, int n2) throws SQLServerException {
        Object[] objectArray;
        MessageFormat messageFormat;
        if ((null == this.sData || 0 == this.sData.length()) && 1L == l2 && n2 >= 0) {
            return "";
        }
        if (null == this.sData || l2 <= 0L || l2 > (long)this.sData.length()) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            objectArray = new Object[]{new Long(l2)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        if (n2 < 0) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            objectArray = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        if (--l2 + (long)n2 > (long)this.sData.length()) {
            n2 = this.sData.length() - (int)l2;
        }
        return this.sData.substring((int)l2, (int)l2 + n2);
    }

    public long length() throws SQLServerException {
        if (this.sData == null) {
            return 0L;
        }
        return this.sData.length();
    }

    public long position(Clob clob, long l2) throws SQLServerException {
        try {
            if (null == clob || 0L == clob.length()) {
                return -1L;
            }
            return this.position(clob.getSubString(1L, (int)clob.length()), l2);
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, null, sQLException.toString(), null, true);
            return 0L;
        }
    }

    public long position(String string, long l2) throws SQLServerException {
        if (l2 <= 0L) {
            return -1L;
        }
        if (null == string || 0 == string.length()) {
            return -1L;
        }
        if (null == this.sData || 0 == this.sData.length()) {
            return -1L;
        }
        int n2 = this.sData.indexOf(string, (int)(l2 - 1L));
        if (-1 == n2) {
            return n2;
        }
        return n2 + 1;
    }

    public void truncate(long l2) throws SQLException {
        if (null == this.sData || (long)this.sData.length() <= l2) {
            return;
        }
        if (l2 < 0L) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            Object[] objectArray = new Object[]{new Long(l2)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        this.sData = this.sData.substring(0, (int)l2);
    }

    public OutputStream setAsciiStream(long l2) throws SQLException {
        return new SQLServerClobAsciiOutputStream(this, l2);
    }

    public Writer setCharacterStream(long l2) throws SQLException {
        return new SQLServerClobWriter(this, l2);
    }

    public int setString(long l2, String string) throws SQLException {
        if (null == string || 0 == string.length()) {
            return 0;
        }
        return this.setString(l2, string, 0, string.length());
    }

    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        Object object;
        Object object2;
        int n4;
        if (string == null || string.length() == 0) {
            return 0;
        }
        if (0 == n3) {
            return 0;
        }
        int n5 = n4 = null == this.sData ? 0 : this.sData.length();
        if (l2 <= 0L || l2 > (long)(n4 + 1)) {
            object2 = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            object = new Object[]{new Long(l2)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object2).format(object), null, true);
        }
        if (n2 < 0 || n2 >= string.length()) {
            object2 = new MessageFormat(SQLServerException.getErrString("R_invalidOffset"));
            object = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object2).format(object), null, true);
        }
        if (n3 < 0 || n2 + n3 > string.length()) {
            object2 = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            object = new Object[]{new Integer(n3)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object2).format(object), null, true);
        }
        if (--l2 + (long)n3 > (long)n4) {
            object2 = new StringBuffer((int)(l2 + (long)n3));
            if (n4 > 0) {
                ((StringBuffer)object2).append(this.sData.substring(0, (int)l2));
            }
            ((StringBuffer)object2).append(string.substring(n2, n2 + n3));
            this.sData = ((StringBuffer)object2).toString();
        } else {
            object2 = this.sData.substring((int)(l2 + (long)n3));
            object = new StringBuffer((int)(l2 + (long)n3 + (long)((String)object2).length()));
            ((StringBuffer)object).append(this.sData.substring(0, (int)l2));
            ((StringBuffer)object).append(string.substring(n2, n2 + n3));
            ((StringBuffer)object).append((String)object2);
            this.sData = ((StringBuffer)object).toString();
        }
        return n3;
    }

    int read(int n2, byte[] byArray, int n3, int n4) throws IOException {
        int n5;
        if (null == byArray) {
            return 0;
        }
        if (n2 < 0) {
            return 0;
        }
        if (n3 < 0 || n3 >= byArray.length) {
            return 0;
        }
        if (n4 <= 0) {
            return 0;
        }
        byte[] byArray2 = null;
        if (null != this.sData && this.sData.length() > 0) {
            byArray2 = this.sData.getBytes("US-ASCII");
        }
        int n6 = n5 = null == byArray2 ? 0 : byArray2.length;
        if (0 == n5) {
            return 0;
        }
        if (n3 + n4 > byArray.length) {
            n4 = byArray.length - n3;
        }
        if (n2 + n4 > n5) {
            n4 = n5 - n2;
        }
        System.arraycopy(byArray2, n2, byArray, n3, n4);
        return n4;
    }

    int read(int n2, char[] cArray, int n3, int n4) {
        int n5;
        if (null == cArray) {
            return 0;
        }
        if (n2 < 0) {
            return 0;
        }
        if (n3 < 0 || n3 >= cArray.length) {
            return 0;
        }
        if (n4 <= 0) {
            return 0;
        }
        int n6 = n5 = null == this.sData ? 0 : this.sData.length();
        if (0 == n5) {
            return 0;
        }
        if (n3 + n4 > cArray.length) {
            n4 = cArray.length - n3;
        }
        if (n2 + n4 > n5) {
            n4 = n5 - n2;
        }
        this.sData.getChars(n2, n2 + n4, cArray, n3);
        return n4;
    }
}

