/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerBlob;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.IOException;
import java.io.InputStream;

final class SQLServerBlobInputStream
extends InputStream {
    private SQLServerBlob parentBlob = null;
    private long streamPos;
    private long markPos;
    private byte[] bSingleByte = new byte[1];

    SQLServerBlobInputStream(SQLServerBlob sQLServerBlob) {
        this.parentBlob = sQLServerBlob;
        this.streamPos = 0L;
        this.markPos = 0L;
    }

    private long getBlobLength() throws IOException {
        try {
            return this.parentBlob.length();
        }
        catch (SQLServerException sQLServerException) {
            throw new IOException(sQLServerException.getMessage());
        }
    }

    private void checkClosed() throws IOException {
        if (null == this.parentBlob) {
            throw new IOException(SQLServerException.getErrString("R_streamIsClosed"));
        }
    }

    private boolean isEOS() throws IOException {
        return this.streamPos >= this.getBlobLength();
    }

    public long skip(long l2) throws IOException {
        this.checkClosed();
        if (l2 < 0L) {
            return 0L;
        }
        if (this.isEOS()) {
            return 0L;
        }
        long l3 = this.getBlobLength();
        if (0L == l3) {
            return 0L;
        }
        if (this.streamPos >= l3) {
            return 0L;
        }
        if (this.streamPos + l2 > l3) {
            long l4 = l3 - this.streamPos;
            this.streamPos = l3;
            return l4;
        }
        this.streamPos += l2;
        return l2;
    }

    public int available() throws IOException {
        this.checkClosed();
        if (this.isEOS()) {
            return 0;
        }
        long l2 = this.getBlobLength();
        if (0L == l2) {
            return 0;
        }
        if (this.streamPos >= l2) {
            return 0;
        }
        return (int)(l2 - this.streamPos);
    }

    public int read() throws IOException {
        this.checkClosed();
        if (this.isEOS()) {
            return -1;
        }
        int n2 = this.read(this.bSingleByte, 0, 1);
        return 0 == n2 ? -1 : this.bSingleByte[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        this.checkClosed();
        if (null == byArray) {
            return 0;
        }
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.checkClosed();
        if (null == byArray) {
            return 0;
        }
        if (this.isEOS()) {
            return -1;
        }
        int n4 = this.parentBlob.read((int)this.streamPos, byArray, n2, n3);
        this.streamPos += (long)n4;
        return n4;
    }

    public void mark(int n2) {
        this.markPos = this.streamPos;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
        this.checkClosed();
        this.parentBlob = null;
    }

    public void reset() throws IOException {
        this.checkClosed();
        this.streamPos = this.markPos;
    }
}

