/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerBlobInputStream;
import com.microsoft.sqlserver.jdbc.SQLServerBlobOutputStream;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.Format;
import java.text.MessageFormat;

public final class SQLServerBlob
implements Blob,
Serializable {
    private byte[] bData;
    private SQLServerConnection con;

    public SQLServerBlob(SQLServerConnection sQLServerConnection, byte[] byArray) {
        this.con = sQLServerConnection;
        this.bData = byArray;
    }

    public InputStream getBinaryStream() throws SQLServerException {
        if (null == this.bData) {
            return null;
        }
        return new SQLServerBlobInputStream(this);
    }

    public byte[] getBytes(long l2, int n2) throws SQLServerException {
        Object[] objectArray;
        MessageFormat messageFormat;
        if ((null == this.bData || 0 == this.bData.length) && 1L == l2 && n2 >= 0) {
            return new byte[0];
        }
        if (null == this.bData || l2 <= 0L || l2 > (long)this.bData.length) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            objectArray = new Object[]{new Long(l2)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        if (n2 < 0) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            objectArray = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        int n3 = n2;
        if (--l2 + (long)n2 > (long)this.bData.length) {
            n3 = this.bData.length - (int)l2;
        }
        objectArray = new byte[n3];
        System.arraycopy(this.bData, (int)l2, objectArray, 0, n3);
        return objectArray;
    }

    public long length() throws SQLServerException {
        if (null == this.bData) {
            return 0L;
        }
        return this.bData.length;
    }

    public long position(Blob blob, long l2) throws SQLServerException {
        try {
            if (null == blob || 0L == blob.length()) {
                return -1L;
            }
            return this.position(blob.getBytes(1L, (int)blob.length()), l2);
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, null, sQLException.toString(), null, true);
            return 0L;
        }
    }

    public long position(byte[] byArray, long l2) throws SQLServerException {
        if (l2 <= 0L) {
            return -1L;
        }
        if (null == this.bData || 0 == this.bData.length) {
            return -1L;
        }
        if (null == byArray || 0 == byArray.length) {
            return -1L;
        }
        if (--l2 >= (long)this.bData.length) {
            return -1L;
        }
        int n2 = byArray.length;
        if (n2 > this.bData.length) {
            return -1L;
        }
        int n3 = this.bData.length - n2;
        for (int i2 = (int)l2; i2 <= n3; ++i2) {
            boolean bl2 = true;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (this.bData[i2 + i3] == byArray[i3]) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            return i2 + 1;
        }
        return -1L;
    }

    public void truncate(long l2) throws SQLException {
        Object object;
        if (null == this.bData || (long)this.bData.length <= l2) {
            return;
        }
        if (l2 < 0L) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            Object[] objectArray = new Object[]{new Long(l2)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
        object = new byte[(int)l2];
        System.arraycopy(this.bData, 0, object, 0, (int)l2);
        this.bData = object;
    }

    public OutputStream setBinaryStream(long l2) throws SQLException {
        return new SQLServerBlobOutputStream(this, l2);
    }

    public int setBytes(long l2, byte[] byArray) throws SQLException {
        if (null == byArray) {
            return 0;
        }
        return this.setBytes(l2, byArray, 0, byArray.length);
    }

    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        Object[] objectArray;
        Object object;
        int n4;
        if (null == byArray || 0 == byArray.length) {
            return 0;
        }
        if (0 == n3) {
            return 0;
        }
        int n5 = n4 = null == this.bData ? 0 : this.bData.length;
        if (l2 <= 0L || l2 > (long)(n4 + 1)) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            objectArray = new Object[]{new Long(l2)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
        if (n2 < 0 || n2 >= byArray.length) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidOffset"));
            objectArray = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
        if (n3 < 0 || n2 + n3 > byArray.length) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            objectArray = new Object[]{new Integer(n3)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
        if (--l2 + (long)n3 >= (long)n4) {
            object = new byte[(int)(l2 + (long)n3)];
            if (n4 > 0) {
                System.arraycopy(this.bData, 0, object, 0, (int)l2);
            }
            System.arraycopy(byArray, n2, object, (int)l2, n3);
            this.bData = (byte[])object;
        } else {
            System.arraycopy(byArray, n2, this.bData, (int)l2, n3);
        }
        return n3;
    }

    int read(int n2, byte[] byArray, int n3, int n4) {
        int n5;
        if (null == byArray) {
            return 0;
        }
        if (n3 < 0 || n3 >= byArray.length) {
            return 0;
        }
        if (n4 <= 0) {
            return 0;
        }
        int n6 = n5 = null == this.bData ? 0 : this.bData.length;
        if (0 == n5) {
            return 0;
        }
        if (n2 < 0 || n2 >= n5) {
            return 0;
        }
        if (n3 + n4 > byArray.length) {
            n4 = byArray.length - n3;
        }
        if (n2 + n4 > n5) {
            n4 = n5 - n2;
        }
        System.arraycopy(this.bData, n2, byArray, n3, n4);
        return n4;
    }
}

