/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.BaseInputStream;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.ServerDTVImpl;
import com.microsoft.sqlserver.jdbc.TDSReader;
import java.io.IOException;

final class PLPInputStream
extends BaseInputStream {
    static final long PLP_NULL = -1L;
    private static final long UNKNOWN_PLP_LEN = -2L;
    private static final byte[] EMPTY_PLP_BYTES;
    int payloadLength;
    private static final int PLP_EOS = -1;
    private int currentChunkRemain;
    private int markedChunkRemain;
    private int leftOverReadLimit = 0;
    private byte[] oneByteArray = new byte[1];
    static final /* synthetic */ boolean $assertionsDisabled;

    static final PLPInputStream makeTempStream(TDSReader tDSReader, boolean bl2, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        return PLPInputStream.makeStream(tDSReader, bl2, bl2, serverDTVImpl);
    }

    static final PLPInputStream makeStream(TDSReader tDSReader, InputStreamGetterArgs inputStreamGetterArgs, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        PLPInputStream pLPInputStream = PLPInputStream.makeStream(tDSReader, inputStreamGetterArgs.isAdaptive, inputStreamGetterArgs.isStreaming, serverDTVImpl);
        if (null != pLPInputStream) {
            pLPInputStream.setLoggingInfo(inputStreamGetterArgs.logContext);
        }
        return pLPInputStream;
    }

    private static final PLPInputStream makeStream(TDSReader tDSReader, boolean bl2, boolean bl3, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        long l2 = tDSReader.readLong();
        if (-1L == l2) {
            return null;
        }
        return new PLPInputStream(tDSReader, l2, bl2, bl3, serverDTVImpl);
    }

    PLPInputStream(TDSReader tDSReader, long l2, boolean bl2, boolean bl3, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        super(tDSReader, bl2, bl3, serverDTVImpl);
        this.payloadLength = -2L != l2 ? (int)l2 : -1;
        this.markedChunkRemain = 0;
        this.currentChunkRemain = 0;
    }

    int getLength() {
        return this.payloadLength;
    }

    byte[] getBytes() throws SQLServerException {
        this.readBytesInternal(null, 0, 0);
        if (-1 == this.currentChunkRemain) {
            return EMPTY_PLP_BYTES;
        }
        byte[] byArray = new byte[-1 != this.payloadLength ? this.payloadLength : this.currentChunkRemain];
        int n2 = 0;
        while (-1 != this.currentChunkRemain) {
            if (byArray.length == n2) {
                byte[] byArray2 = new byte[n2 + this.currentChunkRemain];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                byArray = byArray2;
            }
            n2 += this.readBytesInternal(byArray, n2, this.currentChunkRemain);
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            SQLServerException.makeFromDriverError(null, null, iOException.getMessage(), null, true);
        }
        return byArray;
    }

    public long skip(long l2) throws IOException {
        this.checkClosed();
        if (l2 < 0L) {
            return 0L;
        }
        if (l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        try {
            return this.readBytesInternal(null, 0, (int)l2);
        }
        catch (SQLServerException sQLServerException) {
            throw new IOException(sQLServerException.getMessage());
        }
    }

    public int available() throws IOException {
        this.checkClosed();
        try {
            if (0 == this.currentChunkRemain) {
                this.readBytesInternal(null, 0, 0);
            }
            if (-1 == this.currentChunkRemain) {
                return 0;
            }
            int n2 = this.tdsReader.available();
            if (n2 > this.currentChunkRemain) {
                n2 = this.currentChunkRemain;
            }
            return n2;
        }
        catch (SQLServerException sQLServerException) {
            throw new IOException(sQLServerException.getMessage());
        }
    }

    public int read() throws IOException {
        this.checkClosed();
        try {
            if (-1 != this.readBytesInternal(this.oneByteArray, 0, 1)) {
                return this.oneByteArray[0] & 0xFF;
            }
            return -1;
        }
        catch (SQLServerException sQLServerException) {
            throw new IOException(sQLServerException.getMessage());
        }
    }

    public int read(byte[] byArray) throws IOException {
        if (null == byArray) {
            throw new NullPointerException();
        }
        this.checkClosed();
        if (0 == byArray.length) {
            return 0;
        }
        try {
            return this.readBytesInternal(byArray, 0, byArray.length);
        }
        catch (SQLServerException sQLServerException) {
            throw new IOException(sQLServerException.getMessage());
        }
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (null == byArray) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        this.checkClosed();
        if (0 == n3) {
            return 0;
        }
        try {
            return this.readBytesInternal(byArray, n2, n3);
        }
        catch (SQLServerException sQLServerException) {
            throw new IOException(sQLServerException.getMessage());
        }
    }

    private int readBytesInternal(byte[] byArray, int n2, int n3) throws SQLServerException {
        if (-1 == this.currentChunkRemain) {
            return -1;
        }
        int n4 = 0;
        while (true) {
            if (0 == this.currentChunkRemain) {
                this.currentChunkRemain = (int)this.tdsReader.readUnsignedInt();
                if (!$assertionsDisabled && this.currentChunkRemain < 0) {
                    throw new AssertionError();
                }
                if (0 == this.currentChunkRemain) {
                    this.currentChunkRemain = -1;
                    break;
                }
            }
            if (n4 == n3) break;
            int n5 = n3 - n4;
            if (n5 > this.currentChunkRemain) {
                n5 = this.currentChunkRemain;
            }
            if (null == byArray) {
                this.tdsReader.skip(n5);
            } else {
                this.tdsReader.readBytes(byArray, n2 + n4, n5);
            }
            n4 += n5;
            this.currentChunkRemain -= n5;
        }
        if (n4 > 0) {
            if (this.isReadLimitSet && this.leftOverReadLimit > 0) {
                this.leftOverReadLimit -= n4;
                if (this.leftOverReadLimit < 0) {
                    this.clearCurrentMark();
                }
            }
            return n4;
        }
        if (-1 == this.currentChunkRemain) {
            return -1;
        }
        return 0;
    }

    public void mark(int n2) {
        if (null != this.tdsReader && n2 > 0) {
            this.currentMark = this.tdsReader.mark();
            this.markedChunkRemain = this.currentChunkRemain;
            this.leftOverReadLimit = n2;
            this.setReadLimit(n2);
        }
    }

    public void close() throws IOException {
        if (null == this.tdsReader) {
            return;
        }
        while (this.skip(this.tdsReader.getConnection().getTDSPacketSize()) != -1L) {
        }
        this.closeHelper();
    }

    public void reset() throws IOException {
        this.resetHelper();
        this.leftOverReadLimit = this.readLimit;
        this.currentChunkRemain = this.markedChunkRemain;
    }

    static {
        $assertionsDisabled = !PLPInputStream.class.desiredAssertionStatus();
        EMPTY_PLP_BYTES = new byte[0];
    }
}

