﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:user="http://dotnet.aspx.cc/"
 exclude-result-prefixes="msxsl user">

<msxsl:script language="JavaScript" implements-prefix="user">
    function xmlDateTime(nodelist) {
      return Date.parse(nodelist.replace(/-/g,"/"));
    }
</msxsl:script>


  <xsl:template match="/">
    <html>
      <head>
        <title>所有短信</title>
        <style type="text/css">
          p { margin:10px}
          #time{ float:right;}
          #name{ font-weight:bold}
          div { border: 2px  #C9D7F1 solid; padding:5px; margin-bottom:1em}
        </style>
      </head>
      <body>
        <h1>爱让一切都对了为您导出的短信</h1>
        <p>导出了<xsl:value-of select ="Messages/count"/>条消息</p>
        <xsl:for-each select="Messages/Message">
        <xsl:sort order="ascending" select="user:xmlDateTime(string(time))" data-type="number"/>
          <div>
            <p>
              <xsl:value-of select ="location"/>
              <span id="time">
                <xsl:value-of select ="time"/> , <xsl:value-of select ="time2"/>
              </span>
            </p>
            <p>
              <span id="name">
                <xsl:value-of select="name"/>：
              </span>
              <xsl:value-of select="content"/>
            </p>
          </div>
        </xsl:for-each>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>