/**
 * @author littleli
 */

// 子树缩进的距离
var INDENT = 20;

qqbrowser.js.widgets.treeItem = qqbrowser.js.base.Class(qqbrowser.js.widgets.widget, {
	className: "qqbrowser.js.widget.treeitem",
	
	_root: null,
	
	_treeRow: null,
	_treeChildren: null,
	
	// treeRow中显示的内容
	expandIcon: null,
	treeLabel: null,
	renameInput: null,
	
	// 标识在其父节点中的位置
	index: null,
	layer: null,
	
	_itemClickListener: null,
	_itemDblkClickListener: null,
	_itemContextMenuListener: null,
	
	// 展开/收起事件的listener
	_itemExpandListener: null,
	_itemFoldListener: null,
	
	// 编辑状态的listener
	_itemEditingListener: null,
	_itemEditingEndListener: null,
	
	_renameInputEventListener: null,
	
	oldTitle: null,
	// 记录此treeitem状态的变量,当然像tab那样放到逻辑中也是可以的，后期再调整
	title: null,
	
	// 公开用于设置该treeitem状态的标识位
	// 以后再考虑封装的更好
	expanded: false,
	hasChildren: null,
	mayhaveChildren: null,
	
	editing: null,
	selected: null,
	draggable: null,
	
	/**
	 * @param {String} id 后台收藏项的id
	 * @param {Object} root treeitem对应插入的树的根节点
	 * @param {Number} layer treeitem对应插入的树的层次，用于计算缩进的距离
	 * @param {boolean} isTop treeitem对应插入的位置是否是顶部，如果不是那么插到尾部
	 */
	initialize: function(id, root, layer, isTop, draggable) {
		var _this = this;
		
		this._element = document.createElement("div");
		this._element.id = id;
		this._element.className = "tree-item";
		this._element.setAttribute("role","treeitem");
		this._element.treeitem = this;

		// init treeRow Element
		this._treeRow = document.createElement("div");
		this._treeRow.className = "tree-row";
	
		
		this.initTreeRow();
		
		// init treeChildren Element
		this._treeChildren = document.createElement("div");
		this._treeChildren.className = "tree-children";
		
		// 整个treeitem事件绑定
		// 单击时只显示内容区的内容
		this._element.addEventListener("click", function(event) {
			//_this.setSelected(true);
			
			if (_this._itemClickListener !== null) {
				_this._itemClickListener.apply(this, [event, _this]);
			}
			
			event.stopPropagation();
			
		}, false);
		
		// 双击的话展开该treeitem并显示内容区的内容
		this._element.addEventListener("dblclick", function() {
			
			_this.expand();
			
			if (_this._itemDblkClickListener !== null) {
				_this._itemDblkClickListener.apply(this, [_this]);
			}
			
			event.stopPropagation();
			
		}, false);
		
		// 右键菜单的事件绑定
		this._element.addEventListener("contextmenu", function(event) {
			
			
			if (_this._itemContextMenuListener !== null) {
				_this._itemContextMenuListener.apply(this, [event, _this]);
			}
			
			event.stopPropagation();
		});

		this._element.appendChild(this._treeRow);
		this._element.appendChild(this._treeChildren);

		if (root instanceof qqbrowser.js.widgets.treeItem) {
			
			this._root = root;

			// 插入到父节点的treeChildren节点中，并设置父节点相应的属性
			if (isTop && root._treeChildren.firstChild) {
				root._treeChildren.insertBefore(this._element, root._treeChildren.firstChild);
			} else {
				this.insert(root._treeChildren);
			}
			
//			if (root._treeChildren) {
//				root._treeChildren(this._element);
//			}
			
			root.setHasChildren(true);
		} else {
			
			this._root = root;
			root.appendChild(this._element);
		}
		
		if (typeof layer === "number" && layer > 0) {
			this.setLayer(layer);
		} else {
			this.setLayer(0);
		}

		qqbrowser.js.widgets.widget.prototype.initialize.apply(this, [id]);
	},
	
	initTreeRow: function() {
		var _this = this;
		this.expandIcon = document.createElement("span");
		this.expandIcon.className = "expand-icon";
		
		this.expandIcon.addEventListener("click", function() {
			_this.expand();
			
			event.stopPropagation();
		}, false);
		
		
		this.treeLabel = document.createElement("span");
		this.treeLabel.className = "tree-label";
		
		this._treeRow.appendChild(this.expandIcon);
		this._treeRow.appendChild(this.treeLabel);
	},

	setDraggable: function(draggable) {
		if (draggable) {
			this.draggable = true;
			this._element.setAttribute("draggable", "true");
			this._treeRow.setAttribute("draggable", "true");
		} else {
			this.draggable = false;
			this._element.setAttribute("draggable", "false");
			this._treeRow.setAttribute("draggable", "false");
		}
	},

	// 如果拖动后该节点的层数发生变化应该如何处理呢？
	// 先预留一下吧，考虑的还是太清楚
	// 此时是不是应该重新生成一个节点及相关的子树呢？
	setLayer: function(layer) {
		
		if (typeof layer !== "number") {
			return;
		}
		
		this.layer = layer;
		
		this._treeRow.style.webkitPaddingStart = [layer * INDENT, "px"].join("");

	},
	
	setTitle: function(title) {
		if (typeof title === "string") {
			this.title = title;
			this.treeLabel.innerText = title;
		}
	},
	
	setHasChildren: function(hasChildren) {
		if (hasChildren === undefined || hasChildren === null) {
			return;
		}
		this.hasChildren = hasChildren;
		
		if(hasChildren) {
			
			this._element.setAttribute("has-children", "true");
			this._element.setAttribute("may-have-children", "");
			
			this._treeRow.setAttribute("has-children", "true");
			this._treeRow.setAttribute("may-have-children", "true");
			
		} else{
			this._element.removeAttribute("has-children");
			this._element.removeAttribute("may-have-children");
			this._treeRow.removeAttribute("has-children");
			this._treeRow.removeAttribute("may-have-children");
			
		} 
	},
	
	setSelected: function(selected) {
		if (selected === undefined || selected === null) {
			return;
		}
		this.selected = selected;
		if(selected) {
			this._element.setAttribute("selected", "");
			this._treeRow.setAttribute("selected", "");
		} else{
			this._element.removeAttribute("selected");
			this._treeRow.removeAttribute("selected");
		} 
	},
	
	// 树展开时候的显示
	expand: function() {
		var _this = this;
		
		// 如果该treeitem没有
		if (!this.hasChildren) {
			return;
		}
		//this._expanded = expanded;
		if (!this.expanded) {
			this.showSubTree();
		} else {
			// 完成状态的改变
			this.hideSubTree();
		}
	},
	
	showSubTree: function() {
		var _this = this;
		
		this.expanded = true;
		this._element.setAttribute("expanded", "");
		this._treeChildren.setAttribute("expanded", "");
		
		if (_this._itemExpandListener !== null) {
			_this._itemExpandListener.apply(this, [_this]);
		}

	},
	
	hideSubTree: function() {
		var _this = this;
		
		this.expanded = false;
		this._element.removeAttribute("expanded", "");
		this._treeChildren.removeAttribute("expanded", "");
		
		if (_this._itemFoldListener !== null) {
			_this._itemFoldListener.apply(this, [_this]);
		}
	},
	
	setEditing: function(editing) {
		var _this = this;
		if (!this.editing) {

			this.setDraggable(false);
			this.renameInput = document.createElement("input");
			this.renameInput.type = "text";
			this.oldTitle = this.title;
		
			this.renameInput.value = this.title;
			this.treeLabel.innerText = "";
			this.treeLabel.appendChild(this.renameInput);
			this.renameInput.focus();
			this.renameInput.select();
			
			// 出现input时的事件绑定
			this.renameInput.addEventListener("keydown", function() {
				if (event.keyCode === 13) {
					_this.setEditing(false);
				} else if (event.keyCode === 27) {
					this.value = _this.title;
					_this.setEditing(false);
				}
				
				
				if (_this._renameInputEventListener !== null) {
					_this._renameInputEventListener.apply(this, [event]);
				}
				
				event.stopPropagation();
			}, false);
			
			this.renameInput.addEventListener("click", function() {
				if (_this._renameInputEventListener !== null) {
					_this._renameInputEventListener.apply(this, [event]);
				}
				event.stopPropagation();
			}, false);
			
			// 失去焦点以后的行为
			this.renameInput.addEventListener("blur", function() {
				_this.setEditing(false);
				
				event.stopPropagation();
			}, false);
			
			this.editing = true;
			this._element.setAttribute("editing", "");
			
		} else { // 可能需要做一些调整
			if (this.renameInput !== null) {
				if (this.renameInput.value.trim() !== "") { // 解决title为空的情况
					var tempTitle = this.renameInput.value;
					if (tempTitle.length > 128) { // 命名长充的128限制
						this.title = tempTitle.substr(0, 128);
					} else {
						this.title = tempTitle;
					}
				}
				
	
				this.treeLabel.removeChild(this.renameInput);
				this.renameInput = null;
				
				this.setTitle(this.title);
				this.setDraggable(true);

				// 内容区和导航区的数据同步
				// 不需要，因为选中导航区时，
				//this.listItem.setTitle(this.title);
			}
			
			if (this._itemEditingEndListener !== null) {
				this._itemEditingEndListener.apply(this, [_this]);
			}
			
			this.editing = false;
			this._element.removeAttribute("editing");
		}

	},
	
	remove: function() {
		// 先解除自引用
		this._element.treeitem = null;
		if (this._element.parentElement) {
			this._element.parentElement.removeChild(this._element);
		}
	},
	
	onItemClick: function(func) {
		this._itemClickListener = func;
	},
	
	onItemDblClick: function(func) {
		this._itemDblkClickListener = func;
	},
	
	onItemContextMenu: function(func) {
		this._itemContextMenuListener = func;
	},
	
	onItemExpand: function(func) {
		this._itemExpandListener = func;
	},
	
	onItemFold: function(func) {
		this._itemFoldListener = func;
	},
	
	onRenameInput: function(func) {
		this._renameInputEventListener = func;
	}, 
	
	onEditEnd: function(func) {
		this._itemEditingEndListener = func;
	}
	
	
	
});

qqbrowser.js.widgets.tree = qqbrowser.js.base.Class(qqbrowser.js.widgets.widget, {
	className: "qqbrowser.js.widgets.tree",
	
	root: null,
	_tree: null,
	
	
	initialize:function(){
		
		this._element = document.createElement("div");
		
		

		qqbrowser.js.widgets.widget.prototype.initialize.apply(this, [id]);
	}
});