/**
 * @fileoverview This file provides a class that represents a two-state toggle button widget.
 * @author littleli
 * @author luangong
 * @version 1.0
 */

/**
 * @constructor
 */
qqbrowser.js.widgets.ToggleButton = qqbrowser.js.base.Class(qqbrowser.js.widgets.widget, {
	className: "qqbrowser.js.widgets.ToggleButton",
	_bindElement: null,
	_active: false,
	_activeListener: null,
	_inactiveListener: null,
	_toggleListener: null,

	initialize: function(id) {
		var _this = this;

		this._element = document.createElement("div");
		this.setClass("qqbrowser-widgets-toggle-button");

		this._element.onmouseover = function(event) {
			_this.addClass("hover");
			if (null !== _this._bindElement) {
				_this._bindElement.addClass("hover");
			}
		};

		this._element.onmouseout = function(event) {
			_this.removeClass("hover");
			_this.setState(false);
			if (null !== _this._bindElement) {
				_this._bindElement.removeClass("hover");
			}
		};

		this._element.ondblclick = function(event) {
			event.stopPropagation();
			return false;
		};

		this._element.oncontextmenu = function(event) {
			event.stopPropagation();
			return false;
		};

		this._element.onmousedown = function() {
			// FIXME: 按下鼠标左键使 toggle button 恢复到 inactive 状态时，
			// 还应该保持其 hover 状态
			if (event.button === 0 || event.button === 1) {
				_this.toggleState();
				if (_this._active) {
					if (_this._activeListener) {
						_this._activeListener.call(_this);
					}
				} else {
					if (_this._inactiveListener) {
						_this._inactiveListener.call(_this);
					}
				}
				if (_this._toggleListener) {
					_this._toggleListener.call(_this);
				}
			}
		};

		qqbrowser.js.widgets.widget.prototype.initialize.apply(this, [id]);
	},

	setState: function(active) {
		if (active) {
			this.addClass("pressed");
			this._active = true;
		} else {
			this.removeClass("pressed");
			this._active = false;
		}
	},

	getState: function() {
		return this._active;
	},

	toggleState: function() {
		this._active = !this._active;
		this.toggleClass("pressed");
	},

	onActive: function(func) {
		this._activeListener = func;
	},

	onInactive: function(func) {
		this._inactiveListener = func;
	},

	onToggled: function(func) {
		this._toggleListener = func;
	},

	bind: function(newElement) {
		this._bindElement = newElement;
	}
});
