qqbrowser.js.widgets.menu = qqbrowser.js.base.Class(qqbrowser.js.widgets.widget, {
	className: "qqbrowser.js.widgets.menu",
	
	menuItems:null,
	items:null,
	
	// 标识
	visibility: null,
	
	selectedIndex: -1,
	selectedItem: null,
	
	_showListener: null,
	_hideListener: null,
	
	initialize: function(id) {
		var _this = this;
		
		this._element = document.createElement("div");
		this.setClass("qqbrowser-widgets-menu");
		
		this.menuItems = new Array();
		this.items = new Array();
		
		document.addEventListener("click",function(){
			_this.hide();
		},false);
		qqbrowser.js.widgets.widget.prototype.initialize.apply(this, [id]);
	},

	build : function(menuData) {
		for(var i=0;i<menuData.length;i++){
			for(var j=0;j<menuData[i].length;++j){
				var item = new qqbrowser.js.widgets.menuItem("",this,menuData[i][j]);
				this.items.push(item);
				this._element.appendChild(item._element);
			}
			if(i !== menuData.length-1){
				var hr = document.createElement("LI");
				hr.setClass("hr");
				this._element.appendChild(hr);
			}					
		}
	},
	funcBind: function(func){
		var len = func.length;
		
		for(var i=0;i<len;i++){			
			this.items[i].touchOff = func[i];		
		}
	},
	itemsStatus:function(status){
		var len = this.items.length;
		for(var i=0;i<len;i++){
			if(this.status[i]){
				this.items[i].enable();
			}else{
				this.items[i].disable();
			}
		}
	},
	// show的时候得确定
	show: function(itemsStatus,event) {
		
		this.visibility = true;
		
		var len = this.items.length, left, top;
		for (var i =0; i < len; i++) {
			if(itemsStatus && itemsStatus[i]) {
				this.items[i].enable();
			} else {
				this.items[i].disable();
			}
		}
		
		// 下面两行必须设置，否则第一次show的时候，_element在文档末尾，从而影响了document.body.scrollHeight 的计算方式
		// TODO 最好是在bookmark.css中给#context-menu增加样式 left: 0px; top: 0px。下面2行则去除
		this._element.style.left = '0px';
		this._element.style.top = '0px';
		
		// 如果display为none，offsetHeight取值为0，因此每次都先把display修改为block
		// TODO 可考虑用visibility替代display
		this._element.style.display = 'block';
		
		left = Math.min(document.body.scrollLeft + event.clientX, Math.max(0, document.body.scrollWidth - this._element.offsetWidth));
		top  = Math.min(document.body.scrollTop  + event.clientY, Math.max(0, document.body.scrollHeight - this._element.offsetHeight)) + 1;
		
		this._element.style.left = left + 'px';
		this._element.style.top = top + 'px';
		
		this.showHandler();
		
		if (this._showListener) {
			this._showListener.apply(this, []);
		}
	},
	
	hide: function() {
		
		this.visibility = false;
		
		this._element.style.display = "none";
		
		if (this._hideListener) {
			this._hideListener.apply(this, []);
		}
	},
	
	showHandler: function() {
		document.addEventListener("keydown", this.keyDownHandler, false);
		document.addEventListener("mousedown", this.mouseDownHandler, false);
	},
	
	hideHandler: function() {
		
	},
	
	keyDownHandler: function(e) {
		
	},
	
	mouseDownHandler: function(e) {
		
	},
	
	onShow: function(func) {
		this._showListener = func;
	},
	
	onHide: function(func) {
		this._hideListener = func;
	}
	
	
});

qqbrowser.js.widgets.menuItem = qqbrowser.js.base.Class(qqbrowser.js.widgets.widget, {
	className: "qqbrowser.js.widgets.menuItem",
	
	menu: null,
	
	icon: null,
	title: null,
	subMenuIcon: null,
	
	isDisabled: false,
	isHidden: false,
	isSelected: false,
	isChecked: false,
	
	initialize: function(id, menu, itemData) {
		var _this = this;
		
		// 保存该Item属于的menu
		this.menu = menu;
		
		
		
		this._element = document.createElement("li");
		this.setClass("qqbrowser-widgets-menuItem");
		
		this._element.item = this;
		
		this.initItem(itemData);
		this._element.onclick = function(event){
			event.stopPropagation();
			return false;
		};
		this._element.addEventListener("mouseover", function() {
			_this.addClass("hover");
			_this.menu.selectedIndex = _this.id;
			_this.menu.selectedItem = _this;
			
			event.stopPropagation();
		}, false);
		
		this._element.addEventListener("mouseout", function() {
			_this.removeClass("hover");
			_this.removeClass("pressed");
			
			event.stopPropagation();
		}, false);
		
		this._element.addEventListener("mousedown", function() {
			_this.removeClass("hover");
			_this.addClass("pressed");
			
			event.stopPropagation();
		}, false);
		
		
		this._element.addEventListener("mouseup", function() {
			
			
		},false);
		
		this._element.addEventListener("contextmenu", function() {
			// 禁止menuItem的contextmenu事件
			event.preventDefault();
			event.stopPropagation();
		}, false);
		
		qqbrowser.js.widgets.widget.prototype.initialize.apply(this, [id]);
	},
	
	initItem: function(data) {
		
		var _this = this;
		
		if(typeof(data.icon) !== "undefined") {
			this.icon = document.createElement("img");
			this.setIcon(data.icon);
			this._element.appendChild(this.icon);
		}
		if(typeof(data.title) !== "undefined" || typeof(data) === "string") {
			var data = data.title || data;
			this.title = document.createElement("span");
			this.setTitle(data);
			this._element.appendChild(this.title);
		}
		
		if(data.hasSubMenu) {
			this._element.addClass("parent");
		}
		
		if(data.isSelected) {
			this._element.addClass("selected");
		}
		
		this.disable();
	},
	
	setIcon: function(iconName) {
		if (iconName === undefined) {
			return;
		}
		this.icon.src = iconName;
	},
	
	setTitle: function(titleName) {
		if (titleName === undefined) {
			return;
		}
		this.title.innerText = titleName;
	},
	touchOff: function(){
	},
	disable:function(){
		this.addClass("disable");
		this._element.onclick = function(event){
			event.stopPropagation();
			return false;
		};
	},
	enable: function(){
		var _this = this;
		this.removeClass("disable");
		
		this._element.onclick = function(event){
			_this.menu.hide();
			if(_this.touchOff){
				_this.touchOff();
			}
			event.stopPropagation();
		};
	}
	
});