/**
 * @author littleli
 */

qqbrowser.js.widgets.listItem = qqbrowser.js.base.Class(qqbrowser.js.widgets.widget, {
	className: "qqbrowser.js.widget.listitem",
	
	container: null,
	
	treeitem: null,
	
	iconElement: null,
	labelElement: null,
	urlElement: null,
	closeButton: null,
	
	labelInput: null,
	urlInput: null,
	
	_itemClickListener: null,
	_itemDblkClickListener: null,
	_itemContextMenuListener: null,
	_closeButtonClickListener: null,
	
	
	// 编辑时的事件
	_itemEditingListener: null,
	_itemEditingEndListener: null,
	
	
	_inputEventListener: null,
	_root: null,
	
	type: null, // 标记该item是folder类型还是为url类型
	
	// 标识在其父节点中的位置
	index: null,
	
	multiSelected: null,
	oldTitle: null,
	title: null,
	url: null,
	
	// 用于标注选中但list失焦后的元素，此时可以键盘上下键进行相应的选中操作
	lead: null,
	editing: null,
	draggable: null,
	selected: null,
	
	titleFocus: false,
	urlFocus: false,

	// 标识是否为离线虚拟数据的标识
	isOffline: false,

	/**
	 * @param {String} id 后台收藏项的id
	 * @param (Ojbect) root treeitem对应插入的树的根节点
	 */
	initialize: function(id, type) {
		var _this = this;


		// 和导航区中的treeItem建立连接
		var tempTreeItem = document.getElementById(id);
		
		if ( tempTreeItem && tempTreeItem.treeitem) {
			this.treeitem = tempTreeItem.treeitem;
			tempTreeItem.treeitem.listitem = this;
		}
		
		this._element = document.createElement("div");
		this._element.id = id;
		
		
		
		this._element.setAttribute("role", "listitem");
		// 设置该listitem的类型 
		if (type === "folder") {
			this._element.className = "folder";
		} else {
			this._element.className = "url";
		}
		this.type = type;

/*		this.draggable = true;
		this._element.setAttribute("draggable", "true");*/

		this._element.listitem = this;

		// init treeRow Element
		this.labelElement = document.createElement("div");
		this.labelElement.className = "label";
		
		this.urlElement = document.createElement("div");
		this.urlElement.className = "url";
		
		this.closeButton = document.createElement("button");
		//this.closeButton.setAttribute("tabindex", "-1");
		
		// 整个listitem事件绑定
		// 单击时只显示内容区的内容
		this._element.addEventListener("click", function(event) {
			
			
			if (_this._itemClickListener !== null) {
				_this._itemClickListener.apply(this, [event, _this]);
			}
			
			event.stopPropagation();
			
		}, false);
		
		// 双击的话展开该treeitem并显示内容区的内容
		this._element.addEventListener("dblclick", function(event) {
			
			if (_this._itemDblkClickListener !== null) {
				_this._itemDblkClickListener.apply(this, [event, _this]);
			}
			
			event.stopPropagation();
			
		}, false);
		
		// 右键菜单的事件绑定
		this._element.addEventListener("contextmenu", function(event) {
			
			
			if (_this._itemContextMenuListener !== null) {
				_this._itemContextMenuListener.apply(this, [event, _this]);
			}
			
			event.stopPropagation();
		}, false);
		
		this.closeButton.addEventListener("click", function(event){
			
			if (_this._closeButtonClickListener !== null) {
				_this._closeButtonClickListener.apply(this, [event, _this]);
			}
			
			event.stopPropagation();
		}, false);
		
		// 
		// 解决双击listItem的关闭按钮后打开文件夹或url链接的行为
		this.closeButton.addEventListener("dblclick", function(event){
			
			event.stopPropagation();
		}, false);

		if (this.type === "url") {
			this.iconElement = document.createElement("img");
			this.iconElement.className = "img";
			this._element.appendChild(this.iconElement);
		}
		
		this._element.appendChild(this.labelElement);
		this._element.appendChild(this.urlElement);
		this._element.appendChild(this.closeButton);

		
		qqbrowser.js.widgets.widget.prototype.initialize.apply(this, [id]);
		
		
	},

	// 设置该item是否为离线数据的函数
	setOffline: function(offline) {
		if (offline) {
			this.offline = true;
			this._element.setAttribute('offline', '');
		} else {
			this.offline = false;
			this._element.removeAttribute('offline');
		}
	},

	setDraggable: function(draggable) {
		if (draggable) {
			this.draggable = true;
			this._element.setAttribute("draggable", "true");
		} else {
			this.draggable = false;
			this._element.setAttribute("draggable", "false");
		}
	},

	setTitle: function(title) {
		if (typeof title === "string" && title !== "") {
			this.title = title;
			this.labelElement.innerText = title;
		}
	},
	
	setIcon: function(path) {
		if (typeof path === "string" && path !== "") {
			this.iconElement.src = path;
		}
	},
	
	setUrl: function(url) {
		if (typeof url === "string" && url !== "" && this.type !== "folder") {
			this.url = url;
			this.urlElement.innerText = url;
		}
	},
	
	setSelected: function(selected) {
		if (typeof selected !== "boolean") {
			return;
		}
		this.selected = selected;
		if(selected) {
			this._element.setAttribute("selected", "");
		} else{
			this._element.removeAttribute("selected");
		} 
	},
	
	setLead: function(lead) {
		if (typeof lead !== "boolean") {
			return;
		}
		
		this.lead = lead;
		if (lead) {
			this._element.setAttribute("lead", "");
		} else {
			this._element.removeAttribute("lead");
		}
	},
	
	setEditing: function(editing) {
		if (typeof editing !== "boolean") {
			return;
		}
		
		var _this = this;
		
		if (editing) {
//			if (this.type !== "folder") {
//				this.urlInput = document.createElement("input");
//				this.urlInput.type = "text";
//				this.urlInput.value = this.url;
//				this.urlElement.innerText = "";
//				this.urlElement.appendChild(this.urlInput);
//				
//				
//				// 出现input时的事件绑定
//				this.urlInput.addEventListener("keydown", function() {
//					if (_this._inputEventListener !== null) {
//						_this._inputEventListener.apply(this, [event, _this]);
//					}
//					
//					event.stopPropagation();
//				}, false);
//				
//				this.urlInput.addEventListener("click", function() {
//					if (_this._inputEventListener !== null) {
//						_this._inputEventListener.apply(this, [event, _this]);
//					}
//					event.stopPropagation();
//				}, false);
//				
//				this.urlInput.addEventListener("focus", function() {
//					_this.urlFocus = true;
//					
//					event.stopPropagation();
//				}, false);
//				
//				this.urlInput.addEventListener("blur", function() {
//					_this.urlFocus = false;
//					
//					setTimeout(function() {
//						if (!_this.urlFocus && !_this.titleFocus) {
//							_this.setEditing(false);
//						}
//					},100);
//					
//					event.stopPropagation();
//				}, false);
//			}
			
			this.setDraggable(false);

			this.labelInput = document.createElement("input");
			this.labelInput.type = "text";
			this.oldTitle = this.title;
			this.labelInput.value = this.title;
			this.labelElement.innerText = "";
			this.labelElement.appendChild(this.labelInput);
			this.labelInput.focus();
			this.labelInput.select();
			
			// 出现input时的事件绑定
			this.labelInput.addEventListener("keydown", function() {
				
				if (event.keyCode === 13) {
					_this.setEditing(false);
				} else if (event.keyCode === 27) {
					this.value = _this.title;
					_this.setEditing(false);
				}
				
				if (_this._inputEventListener !== null) {
					_this._inputEventListener.apply(this, [event, _this]);
				}
				
				event.stopPropagation();
			}, false);
			
			this.labelInput.addEventListener("click", function() {
				if (_this._inputEventListener !== null) {
					_this._inputEventListener.apply(this, [event, _this]);
				}
				
				event.stopPropagation();
			}, false);
			
			this.labelInput.addEventListener("focus", function() {
				
				event.stopPropagation();
			}, false);
			
			this.labelInput.addEventListener("blur", function() {
				_this.setEditing(false);
				
				event.stopPropagation();
				
			}, false);
				
			if(_this._itemEditingListener !== null) {
				_this._itemEditingListener.apply(this, [_this]);
			}
			
			this._element.setAttribute("editing", "");
			
		} else { // 可能需要做一些调整

			this.setDraggable(true);
			if (this.labelInput !== null) {
				
				if (this.type !== "folder" && this.urlInput) {
					
					this.url = this.urlInput.value;
					this.urlElement.removeChild(this.urlInput);
					this.urlInput = null;
					this.setUrl(this.url);
				}
				if (this.labelInput.value.trim() !== "") { // 处理名字为空的情况
					var tempTitle = this.labelInput.value;
					if (tempTitle.length > 128) { // 命名长充的128限制
						this.title = tempTitle.substr(0, 128);
					} else {
						this.title = tempTitle;
					}
				}
				
				this.labelElement.removeChild(this.labelInput);
				this.labelInput = null;


				this.setTitle(this.title);
				this.setDraggable(true);
			}
			
			this._element.removeAttribute("editing");
			
			if (this._itemEditingEndListener !== null) {
				this._itemEditingEndListener.apply(this, [_this]);
			}
		}

		this.editing = editing;
	
	},
	
	remove: function() {
		// 解决dnd问题时辅助div的同步删除问题
		var preElement = this._element.previousSibling;
		if (preElement && !(preElement instanceof qqbrowser.js.widgets.listItem)) {
			this._element.parentElement.removeChild(preElement);
		}
		// 先解除自引用
		this._element.listitem = null;
		if (this._element.parentElement) {
			this._element.parentElement.removeChild(this._element);
		}
	},
	
	onItemClick: function(func) {
		this._itemClickListener = func;
	},
	
	onItemDblClick: function(func) {
		this._itemDblkClickListener = func;
	},
	
	onItemContextMenu: function(func) {
		this._itemContextMenuListener = func;
	},
	
	onInputEvent: function(func) {
		this._inputEventListener = func;
	},
	
	onEditing: function(func) {
		this._itemEditingListener = func;
	},
	
	onEditEnd: function(func) {
		this._itemEditingEndListener = func;
	}, 
	
	onCloseButtonClick: function(func) {
		this._closeButtonClickListener = func;
	}
	
	
});

qqbrowser.js.widgets.list = qqbrowser.js.base.Class(qqbrowser.js.widgets.widget, {
	className: "qqbrowser.js.widgets.list",
	
	_container: null,
	
	// 用于标识此list元素是否 
	hasElementFocus: null,
	
	_listFocusListener: null,
	_listBlurListener: null,
	_listKeyDownListener: null,
	
	initialize:function(id, container){
		var _this = this;
		
		this._element = document.createElement("list");
		
		// 属性设置
		this._element.id = "list";
		this._element.setAttribute("contextmenu", "#context-menu");
		// 设置为这样的话可以用上focus的属性
		this._element.setAttribute("tabIndex", "2");
		this._element.setAttribute("list", "listbox");
		
		
		this._container = container;
		
		// 如果没有直接的focus事件只能够用全局加上局部click的方法进行模拟
		// 绑定focus时的事件
		this._element.addEventListener("focus", function(event) {
			//alert(focus);
			_this.setFocus(true);
			
			if (_this._listFocusListener !== null) {
				_this._listFocusListener.apply(this, [event]);
			}
			
			event.stopPropagation();
		}, false);
		
		// 绑定blur时的事件
		this._element.addEventListener("blur", function(event) {
			//alert(blur);
			_this.setFocus(false);
			
			if (_this._listFocusListener !== null) {
				_this._listFocusListener.apply(this, [event]);
			}
			
			event.stopPropagation();
		}, false);
		
		this._element.addEventListener("keydown", function(event) {
			
			if(_this._listKeyDownListener !== null) {
				_this._listKeyDownListener.apply(this, [event]);
			}
		}, false);
		
		
		this.insert(container);
		
		qqbrowser.js.widgets.widget.prototype.initialize.apply(this, [id]);
	},
	
	setFocus: function(isFocus) {
		// 类型检测
		if (typeof isFocus !== "bool") {
			return;
		}
		
		if(isFocus) {
			this._element.setAttribute("haselementfocus", "hasElementFocus");
			
		} else {
			this._element.removeAttribute("haselementfocus");
		}
		
		// 这个变量的意义不是太明显
		this.hasElementFocus = isFocus;
	}, 
	
	/**
	 *  重置所有item的选中状态
	 */
	setAllListReset: function() {
		var children = this._element.children;
		var len = children.length;
		if (len > 0) {
			for (var i = 0; i < len; i++) {
				if (children[i].listitem) {
					children[i].listitem.setSelected(false);
					
					// 为了还原多选之后的选中状态标识
					children[i].listitem.multiSelected = null;
				}
			}
		}
	},
	
	
	onFocus : function(func) {
		this._listFocusListener = func;
	},
	
	onBlur: function(func) {
		this._listKeyDownListener = func;
	},
	
	onKeyDown: function(func) {
		this._listKeyDownListener = func;
	}
	
	
});