//infobar.js

qqbrowser.js.widgets.infobar = qqbrowser.js.base.Class(qqbrowser.js.widgets.widget, {
	className: "qqbrowser.js.widgets.infobar",
	
	_icon: null,
	_text: null,
	_action: null,
	_close: null,
	
	_action: null,
	
	_showListener: null,
	_hideListener: null,
	
	initialize: function(id) {
		var _this = this;
		
		this._element = document.createElement("div");
		this.setClass("qqbrowser-widgets-infobar");
		
		this._initIcon();
		this._initText();
		this._initAction();
		this._initClose();
		
		this.show(false);
		qqbrowser.js.widgets.widget.prototype.initialize.apply(this, [id]);
	},
	
	_initIcon: function() {
		this._icon = document.createElement("div");
		this._icon.setAttribute("class", "qqbrowser-widgets-infobar-icon");
		this._element.appendChild(this._icon);
	},
	
	_initText: function() {
		this._text = document.createElement("div");
		this._text.setAttribute("class", "qqbrowser-widgets-infobar-text");
		this._element.appendChild(this._text);
	},
	
	_initAction: function() {
		var _this = this;
		
		this._action = document.createElement("div");
		this._action.setAttribute("class", "qqbrowser-widgets-infobar-action");
		this._element.appendChild(this._action);
	},
	
	_initClose: function() {
		var _this = this;
		
		this._close = new qqbrowser.js.widgets.button("qqbrowser-widgets-infobar-close");
		this._close.setClass("qqbrowser-widgets-infobar-close");
		this._close.insert(this._element);
		this._close.onclick(function(event) {
			_this.show(false);
		});
	},
	
	show: function(visible) {
		if (visible === this._visible) {
			return;
		}
		this._visible = visible;
		
		if (visible) {
			this._element.style.display = "-webkit-box";
			if (this._showListener) {
				this._showListener.apply(this, []);
			}
		} else {
			this._element.style.display = "none";
			if (this._hideListener) {
				this._hideListener.apply(this, []);
			}
		}
	},
	
	isVisible: function() {
		return this._visible;
	},
	
	setIcon: function(newIcon) {
		this._icon.style.backgroundImage = ["url(qqbrowser://skin/images/infobar/", newIcon, ")"].join("");
	},
	
	setText: function(newText) {
		this._text.innerText = newText;
	},
	
	setHtml: function(newHtml) {
		this._text.innerHTML = newHtml;
	},
	
	
	addAction: function(action) {
		if (action.insert) {
			action.addClass("qqbrowser-widgets-infobar-button");
			action.insert(this._action);
		} else {
			this._action.appendChild(action);
		}
	},
	
	showClose: function(visible) {
		if (visible) {
			this._close.show(true);
		} else {
			this._close.show(false);
		}
	},
	
	onShow: function(func) {
		this._showListener = func;
	},
	
	onHide: function(func) {
		this._hideListener = func;
	}
});