/*
 * @author littleli
 * @description 查找栏控件封装
 * @data 2011-06-29
 */

qqbrowser.js.widgets.findbar = qqbrowser.js.base.Class(qqbrowser.js.widgets.widget, {
	className : "qqbrowser.js.widgets.findbar",
	
	// findbar的基本控件构成
	_closeButton: null,
	_icon: null,
	_placeholder: null,
	_inputSpace : null,
	_input: null,
	_findCount: null,
	_currentCount: null,
	_totalCount: null,
	_findButton: null,
	_nextButton: null,
	_previousButton: null,
	_isFocus: null,
	
	_showListener: null,
	_hideListener: null,
	_closeButtonClickListener: null,
	_inputEventListener: null,
	_findButtonClickListener: null,
	_nextButtonClickListener: null,
	_previousButtonClickListener: null,
	_findFinishListener: null,
	
	initialize: function(id) {
		var _this = this;
		
		this._element = document.createElement("div");
		this.setClass("qqbrowser-widgets-findbar");
		
		
		this._initClose();
		this._initInput();
		this._initButtons();
		
		qqbrowser.js.widgets.widget.prototype.initialize.apply(this, [id]);
		
		this.show(true);
	} ,
	
	_initClose: function() {
		var _this = this;
		this._closeButton = document.createElement("div");
		this._closeButton.setAttribute("id", "qqbrowser-widgets-findbar-close");
		this._closeButton.setAttribute("class", "qqbrowser-widgets-findbar-close");
		this._closeButton.addEventListener("click", function(){
			if (_this._closeButtonClickListener !== null) {
				_this._closeButtonClickListener.apply(this, [event]);
			}
			
			event.stopPropagation();
			
		}, false);
		this._element.appendChild(this._closeButton);
	},
	
	_initInput: function() {
		var _this = this;
		this._input = document.createElement("div");
		this._input.setAttribute("id", "qqbrowser-widgets-findbar-input");
		// init icon
		this._icon = document.createElement("div");
		this._icon.setAttribute("id", "qqbrowser-widgets-findbar-icon");
		this._input.appendChild(this._icon);
		
		// init placeholder
		this._placeholder = document.createElement("div");
		this._placeholder.setAttribute("id", "qqbrowser-widgets-findbar-placeholder");
		this._placeholder.innerText = "输入查找内容";
		
		this._placeholder.addEventListener("click", function(event) {
			_this.showPlaceholder(false);
			qqbrowser.js.logic.viewManager.setFocus2Skin(document.getElementById("qqbrowser-widgets-findbar-inputSpace"));
			event.stopPropagation();
		}, false);
		
		
		this._input.appendChild(this._placeholder);
		
		// init inputSpace
		this._inputSpace = document.createElement("input");
		this._inputSpace.setAttribute("id", "qqbrowser-widgets-findbar-inputSpace");
		
		// 测试时使用，启动时focus将默认设置到此input元素中
//		inputSpace.setAttribute("autofocus", "true");
		this._input.appendChild(this._inputSpace);
		
		this._input.addEventListener("click", function() {
			// do this self work 
			//alert("click");
			
			if (_this._inputEventListener !== null) {
				_this._inputEventListener.apply(this, [event]);
			}
			
			event.stopPropagation();
			
		}, false);
		
		// 绑定input的focus事件
		this._inputSpace.addEventListener("mousedown", function() {
			// 和全局的mousedown事件有关联，所以必须要在这里阻止其冒泡，不然的话焦点会被地址栏抢走
			event.stopPropagation();
			
		}, false);
		
		// 绑定input的focus事件
		this._inputSpace.addEventListener("focus", function() {
			// do this self work 
			//alert("focus");
			
			if (_this._inputEventListener !== null) {
				_this._inputEventListener.apply(this, [event]);
			}
			
			event.stopPropagation();
			
		}, false);
		
		// 绑定keyup事件
		this._inputSpace.addEventListener("keydown", function() {
			// do this self work 
			// 严禁掉该input框的Ctrl+Z和Ctrl+Y操作
			if (event.ctrlKey && event.keyCode == 90 || event.ctrlKey && event.keyCode == 89) {
				event.preventDefault();
			}
			
			if (_this._inputEventListener !== null) {
				_this._inputEventListener.apply(this, [event]);
			}
			
			event.stopPropagation();
			
		}, false);
		
		// 绑定keyup事件
		this._inputSpace.addEventListener("keyup", function() {
			// do this self work 
			
			
			if (_this._inputEventListener !== null) {
				_this._inputEventListener.apply(this, [event]);
			}
			
			event.stopPropagation();
			
		}, false);
		
		// 绑定input的blur事件
		this._inputSpace.addEventListener("blur", function() {
			// do this self work 
			
			if (_this._inputEventListener !== null) {
				_this._inputEventListener.apply(this, [event]);
			}
			
			event.stopPropagation();
			
		}, false);
		
		this._initFindCount();
		
		this._element.appendChild(this._input);
	},
	
	_initFindCount : function() {
		this._findCount = document.createElement("div");
		this._findCount.setAttribute("id", "qqbrowser-widgets-findbar-findCount");
		
		this._currentCount = document.createElement("div");
		this._totalCount = document.createElement("div");
		
		this._findCount.appendChild(this._currentCount);
		this._findCount.appendChild(this._totalCount);
		
		this._input.appendChild(this._findCount);
	},
	
	_initButtons : function() {
		var _this = this;
		
		// init findButton
		this._findButton = new qqbrowser.js.widgets.button("qqbrowser-widgets-findbar-findButton");
		this._findButton.setText("查找");
		this._findButton.onclick(function(event) {
			// do self work
			
			if(_this._findButtonClickListener!== null) {
				_this._findButtonClickListener.apply(this, [event]);
			}
			event.stopPropagation();
		});
		
		
		// init nextButton
		this._nextButton = new qqbrowser.js.widgets.button("qqbrowser-widgets-findbar-nextButton");
		this._nextButton.setText("下一个");
		this._nextButton.onclick(function(event) {
			// do self work
			
			if (_this._nextButtonClickListener !== null) {
				_this._nextButtonClickListener.apply(this, [event]);
			}
			event.stopPropagation();
		});
		
		// init previousButton
		this._previousButton = new qqbrowser.js.widgets.button("qqbrowser-widgets-findbar-previousButton");
		this._previousButton.setText("上一个");
		this._previousButton.onclick(function(event) {
			// do self work
			
			if (_this._previousButtonClickListener !== null) {
				_this._previousButtonClickListener.apply(this, [event]);
			}
			event.stopPropagation();
		});
		
		this._findButton.insert(this._element);
		this._nextButton.insert(this._element);
		this._previousButton.insert(this._element);
	},
	
	show: function(visible) {
		
		if (visible === this._visible) {
			return;
		}
		
		this._visible = visible;
		
		if (visible) {
			this._element.style.display = "-webkit-box";
			browser.log("onPageFind", "_showListener:" + this._showListener);
			if (this._showListener) {
				browser.log("onPageFind", "_showListener");
				this._showListener.apply(this, []);
			}
		} else {
			this._element.style.display = "none";
			if (this._hideListener) {
				this._hideListener.apply(this, []);
			}
		}
	},
	
	showFindCount : function(visible) {
		if (visible) {
			this._findCount.style.display = "-webkit-box";
		} else {
			this._findCount.style.display = "none";
		}
	},
	
	showPlaceholder: function(visible) {
		if(!visible) {
			this._placeholder.style.display = "none";
		} else {
			this._placeholder.style.display = "-webkit-box";
		}
	},
	
	getInputContent : function() {
		return this._inputSpace.value.toString();
	},
	
	setInputContent: function(newContent) {
		// 如果传进为null或者undefined统统设置为空字符串
		if (!newContent) {
			newContent = "";
		}
		this._inputSpace.value = newContent;
	},
	
	isFocus : function() {
		return this._isFocus;
	},
	
	setIcon : function(newIcon) {
		this._icon.style.background = ["url(qqbrowser://skin/images/toolbar/", newIcon, ") no-repeat"].join("");
	},
	
	setCurrentCount : function(newCurrentCount) {
		this._currentCount.innerText = ["第", newCurrentCount, "个"].join("");
	},
	
	setTotalCount : function(newTotalCount) {
		this._totalCount.innerText = ["/共", newTotalCount, "个"].join("");
	},
	
	onInputEvent : function(func) {
		this._inputEventListener = func;
	},
	
	onFindButtonClickEvent: function(func) {
		this._findButtonClickListener = func;
	},
	
	onNextButtonClickEvent : function(func) {
		this._nextButtonClickListener = func;
	},
	
	onPreviousButtonClickEvent : function(func) {
		this._previousButtonClickListener = func;
	},
	
	onShowListener : function(func) {
		this._showListener = func;
	},
	
	onHideListener : function(func) {
		this._hideListener = func;
	},
	
	onCloseButtonClickEvent: function(func) {
		this._closeButtonClickListener = func;
	}
	
});