/**
 * Created by .
 * User: crisweng
 * Date: 11-8-2
 * Time: 上午11:16
 * modify favbar.js
 */
qqbrowser.js.widgets.favbar = qqbrowser.js.base.Class(qqbrowser.js.widgets.widget,{
    className: "qqbrowser.js.widgets.favbar",

    _addFavButton: null,
    _addFavMenuButton: null,
    _favHolder: null,
    _favMore: null,
    _favDrop: null,
    _hSep: null,
    _isInit: null,
    _rootId:null,
    _statMessage: null,
    _toterrcnt: null,
    _useFreq: null,
    _oldData: null,
    _isDrag:false,
    _startId:null,
    _mouseX:null,
    _mouseY:null,
    _addFavButtonClickListener:null,
    _FavMoreClickListener: null,
    _favHolderHoverListener: null,
    _FavHolderMenuListener: null,
    _FavItemListener: null,
    _showEventListener: null,
    _hideEventListener: null,
	isOffline: false,
	
	createImg: function(src) {
		if (typeof src !== 'string' || src.length === 0) {
			return '';
		}
		
		return " style=\"background: url('" + src.split('\\').join('/') + "') no-repeat center center;\"";
	},
	
    initialize: function(){
        var _this = this;
	    this._element = document.createElement("div");
		this._element.setAttribute("id","favbar");

        //设置addFavButton
		this._addFavButton = new qqbrowser.js.widgets.button("qqbrowser-widgets-favbar-addfav");
		this._addFavButton.setText("收藏");
		this._addFavButton.setClass("qqbrowser-widgets-favbar-addfav");
        this._addFavButton.insert(this._element);
        
        
        this._addFavMenuButton = new qqbrowser.js.widgets.button("qqbrowser-widgets-favbar-addfavMenu");
        this._addFavMenuButton.setClass("qqbrowser-widgets-favbar-addfavMenu");
        this._addFavMenuButton.insert(this._element);
        this._addFavMenuButton.isEnable = 1;
        // 绑定两个相应的button
        this._addFavButton.bind(this._addFavMenuButton);
        this._addFavMenuButton.bind(this._addFavButton);

        //设置hSep
        this._hSep = document.createElement("div");
	    this._hSep.setAttribute("class", "h-sep");
        this._element.appendChild(this._hSep);

        //设置favHolder
        this._favHolder = document.createElement("div");
        this._favHolder.setAttribute("id","favholder");
        this._element.appendChild(this._favHolder);
        
        /*if(typeof(qqbrowser.js.logic.favbarManager) !== undefined){
            alert(document.getElementById("favholder"));
            var t = setTimeout(function(){
                if(document.getElementById("favholder")){
                    qqbrowser.js.logic.favbarManager.setSortable();
                    clearTimeout(t);
                }
            },500);

        }*/
        
        this._favDrop = document.createElement('div');
        this._favDrop.setAttribute('id', 'favbar-drop-overlay');
        this._element.appendChild(this._favDrop);
        
        
        //设置favMore
        this._favMore = document.createElement("div");
        this._favMore.setAttribute("id","fav-more");
        this._favMore.setAttribute("class","fav-item");
	    this._element.appendChild(this._favMore);
        document.addEventListener("DOMContentLoaded",function(){
            _this._toterrcnt=0;
            
            _this._favMore.addEventListener("mousedown",function(event){
                if(_this._FavMoreClickListener !== null){
                    _this._FavMoreClickListener.apply(this, [event]);
                }
                event.stopPropagation();
            },false);
            
            _this._favMore.addEventListener("mouseup",function(event){
                if(_this._FavMoreClickListener !== null){
                    _this._FavMoreClickListener.apply(this, [event]);
                }
                event.stopPropagation();
            },false);
            
            _this._favMore.addEventListener("mouseover",function(event){
                if(_this._FavMoreClickListener !== null){
                    _this._FavMoreClickListener.apply(this, [event]);
                }
                event.stopPropagation();
            },false);

            _this._addFavButton.onclick(function(event){
                if (_this._addFavButtonClickListener !== null){
				    _this._addFavButtonClickListener.apply(this, [event]);
			    }
                event.stopPropagation();
            });
            _this._favHolder.addEventListener("contextmenu",function(event){
                if(_this._FavHolderMenuListener !== null){
                    _this._FavHolderMenuListener.apply(this, [event]);
                }
            },false);
            _this._favHolder.addEventListener("mouseup",function(event){
                 if(_this._FavItemListener !== null){
                     _this._FavItemListener.apply(this, [event]);
                 }
            },false);
            _this._favHolder.addEventListener("mousedown",function(event){
                _this._mouseX = event.clientX;
                _this._mouseY = event.clientY;
                
                // TODO 解耦合
                MenuFactory.favbarFolderOpen = 1;
            },false);
            
            _this._favHolder.addEventListener('mouseover', function(event) {
            	if ( _this._favHolderHoverListener !== null ) {
            		_this._favHolderHoverListener.apply(this, [event]);
            	}
            	
            	// event.stopPropagation();
            });

       },false);
    },

    fillData: function(para){
		var _this = this;
        var favsData=[];
	    if(null !== para){
		    favsData=para;
	    }
	    // 清空
        var favData, title, type, icon, url, style, id;
        var htmlData = "";
	    for(var i = 0; i < favsData.length; i++){
		    favData = favsData[i];
		    title = Cube.String.htmlEncode(unescape(favData.title));
		    type = favData.type;
		    if(type != 'folder' && !favData.faviconPath) {
			    favData.faviconPath = TAB_DEFAULT_ICON;
		    }
		// folder显示不同图标
		    icon = type == 'folder' ? FAV_BAR_FOLDER_ICON : (favData.faviconPath);
		    url = type == 'folder' ? '' : (favData.url);
		    style = type == 'folder' ? 'fav-folder' : 'fav-item';
		    id = escape(favData.id);
		    htmlData += type == 'folder' ? "<div class='"+style+"' folder='true' url='" + url + "' id='"+id+"' draggable='true'><div class='folder-img'></div><div>"+title+
	                "</div><div class='folder-dropDown'></div></div>" : "<div class='"+style+"' url='" + url + "' id='"+id+"' draggable='true'><div class='img' "+_this.createImg(icon)+"></div><div>"+title+
	                "</div></div>";
			
        }
		
		qqbrowser.bookmark.getOfflineBookmarks(0, 1, function(result) {
			_this.isOffline = false;
			if (JSON.parse(result) != '') {
				htmlData += "<div class='fav-folder' folder='true' url='' id='fav-offline'><div class='folder-img'></div><div>" +
						"未备份到网络的收藏</div><div class='folder-dropDown'></div></div>";
				// 设置本地未备份收藏的标识位
				_this.isOffline = true;
			}
				
			this._favHolder.innerHTML = htmlData;
			
			this.setMore();
			
			$("#favhodler img").bind("error",function(){ // 如果img图片加载错误，那么设置为默认图片
				this.setAttribute("src",TAB_DEFAULT_ICON);
			});
			$('#favholder .fav-folder, #favholder .fav-item').mouseenter(function() {
				if(this.id) {
					qqbrowser.js.logic.tipManager.showFavbarTip($(this), event);
				}
			});
			
			//只能在这加不然拖拽不流畅
			qqbrowser.js.logic.favbarManager.setSortable();							

		}.bind(this));
    },

    setMore: function(){
        var lastIndex = this.lastShowFav();
		var favArray = this._favHolder.childNodes;
		for (var i=0; i<favArray.length; i++){
            if(i < lastIndex){

                favArray[i].style.visibility = "visible";
            } else{
                favArray[i].style.visibility = "hidden";
            }
	    }
        if(lastIndex === favArray.length){
            this._favMore.style.opacity = 0;
			this._favMore.style.visibility = 'hidden';
        } else{
            this._favMore.style.opacity = 1;
			this._favMore.style.visibility = 'visible';
        }
    },

    showElement : function(element,visible) {
		if (visible) {
			element.style.display = "-webkit-box";
		} else {
			element.style.display = "none";
		}
	},
    setState: function(msg){
        this._statMessage = msg;
    },

    getIndex: function(item, items){
        var itemsList = items.childNodes;
	    var len =itemsList.length;
	    for (var i=0;i<len;i++){
		    if (item.id === itemsList[i].id){
			    return i;
		    }
	    }
	    return -1;
    },

    lastShowFav: function(){
        var favArray=this._favHolder.childNodes;
        var tempLocation;
        var display = this._element.style.display;
        if(display === "none"){
            this._element.style.display = "-webkit-box";
        }
	    for (var i=0; i < favArray.length; i++){
		    tempLocation = favArray[i].offsetLeft;
            //browser.log("cris++:","tt"+favArray[i].id +" "+ favArray[i].clientWidth);
		    if (tempLocation + favArray[i].clientWidth+6  > this._favMore.offsetLeft ){
                 if(display === "none"){
                     this._element.style.display = "none";
                }
			    return i;
		    }
	    }
        if(display === "none"){
            this._element.style.display = "none";
        }
	    return favArray.length;
    },

    calcRootId: function(content){
		this._rootId = 1;
		var len = content.length;
        var obj;
		for (var i=0; i<len; i++){
			obj = content[i];
			if ("folder" == obj.type  && "\u6536\u85CF\u5939" ==obj.title){
				this._rootId = parseInt(obj.id);
				break;
			}
		}
    },

    onAddFavButtonClick : function(func) {
	    this._addFavButtonClickListener = func;
    },

    onFavHolderMenuClick: function(func) {
        this._FavHolderMenuListener = func;
    },

    onFavMoreClick: function(func) {
        this._FavMoreClickListener = func;
    },

    onFavItemClick: function(func){
        this._FavItemListener = func;
    },
    onFavHolderHover: function(func) {
    	this._favHolderHoverListener = func;
    },

    callListener: function (isShow) {
		if (isShow) {
			if (this._showEventListener) {
				this._showEventListener.call(this);
			}
		} else {
			if (this._hideEventListener) {
				this._hideEventListener.call(this);
			}
		}
	},

	onShow: function(func) {
		this._showEventListener = func;
	},

	onHide: function(func) {
		this._hideEventListener = func;
	}

});