qqbrowser.js.widgets.downloaditem = qqbrowser.js.base.Class(qqbrowser.js.widgets.widget, {
	className: "qqbrowser.js.widgets.downloaditem",
	
	_process : null,
	_image : null,
	_imageIcon : null,
	_icon : null,
	_title : null,
	_action : null,
	_middleWraper : null,
	_menuButton : null,
	_downloadbar : null,
	
	// 对应下载的一组状态（新建、下载、暂停、完成以及错误）
	_new : null,
	_download : null,
	_pause : null,
	_complete : null,
	_fail : null,

	// 下载进度显示
	_currentSize: null,
	_totalSize : null,
	_timeRemain : null,
	
	// 下载完成的命令
	_completeCommand : null, 
	
	_status : null,
	_itemClickListener : null,
	_menuButtonClickListener : null,
	
	initialize : function(id, downloadbar) {
		var _this = this;
		this._downloadbar = downloadbar;
		this._element = document.createElement("div");
		this.setClass("qqbrowser-widgets-downloaditem");
		this.initItem(id);
		
		// 事件绑定和处理
		this._element.onmouseover = function(event) {
			_this.addClass("hover");
		};

		this._element.onmouseout = function(event) {
			_this.removeClass("hover");
		};



		this._element.onmousedown = function(event) {
			//_this.setActive(true);
			/*event.stopPropagation();*/
			/*return false;*/
		};
		
		this._element.ondblclick = function(event) {
			event.stopPropagation();
			return false;
		};
		
		this.onclick(function(event) {
			if (null !== _this._itemClickListener) {
				_this._itemClickListener.apply(this, [event, _this.id, _this._status]);
			}
            
		});
        this._element.addEventListener("click",function(){
           // alert("image");
           var cmdName = "openfile";

			if (null !== _this._downloadbar._clickCommandListener) {
				_this._downloadbar._clickCommandListener.apply(this, [event, cmdName, _this.id]);
			}
			event.stopPropagation();
        },false);
		
		qqbrowser.js.widgets.widget.prototype.initialize.apply(this, [id]);
	},
	
	
	initItem : function(id) {
		var _this = this;
		
		this._process = document.createElement("div");
		this._process.setAttribute("class", "qqbrowser-widgets-downloaditem-process");
		this._element.appendChild(this._process);
		// 初始化下载icon
		this._image = document.createElement("div");
		this._image.setAttribute("class",
		"qqbrowser-widgets-downloaditem-image");
        this._image.addEventListener("click",function(){
           // alert("image");
           var cmdName = "openfile";

			if (null !== _this._downloadbar._clickCommandListener) {
				_this._downloadbar._clickCommandListener.apply(this, [event, cmdName, _this.id]);
			}
			event.stopPropagation();
        },false);
		this._icon = document.createElement("div");
		this._icon.setAttribute("class",
				"qqbrowser-widgets-downloaditem-action");
		this._image.appendChild(this._icon);
		this._element.appendChild(this._image);
		
		// 初始化中间显示wraper
		this._middleWraper = document.createElement("div");
		this._middleWraper.setAttribute("class",
				"qqbrowser-widgets-downloadbar-wraper");
		this._element.appendChild(this._middleWraper);
		
		// 初始化title
		this._title = document.createElement("div");
		this._title.setAttribute("class",
				"qqbrowser-widgets-downloadbar-title");
        this._title.addEventListener("click",function(){
            //alert("title");
            var cmdName = "openfile";

			if (null !== _this._downloadbar._clickCommandListener) {
				_this._downloadbar._clickCommandListener.apply(this, [event, cmdName, _this.id]);
			}
			event.stopPropagation();
        },false);
		this._middleWraper.appendChild(this._title);
		
		// 初始化action
		this._action = document.createElement("div");
		this._action.setAttribute("class",
				"qqbrowser-widgets-downloadbar-action");
        this._action.addEventListener("click",function(){
            //alert("action");
            var cmdName = "openfile";

			if (null !== _this._downloadbar._clickCommandListener) {
				_this._downloadbar._clickCommandListener.apply(this, [event, cmdName, _this.id]);
			}
			event.stopPropagation();},false);
		this._middleWraper.appendChild(this._action);
		
		this.initNew();
		this.initPause();
        this.initFail();
		this.initComplete();
		
		// TODO
		//this.initFail();
		
		// 初始化dropmunu
		this._menuButton = new qqbrowser.js.widgets.button(
				"qqbrowser-widgets-downloadbar-menubutton");
		this._menuButton
				.setClass("qqbrowser-widgets-downloadbar-menubutton");
		this._menuButton.insert(this._element);
		
		this._menuButton.onclick(function(event) {
			console.info("this is " + _this.id + "\'s menuButton");
			
			
			if (_this._menuButtonClickListener !== null) {
				_this._menuButtonClickListener.apply(this, [ event, _this.id]);
			}
			event.stopPropagation();
		});
		
//		this.setTitle("建党大业");
//		this.setAction("fail");
//		this.setCurrentSize("55MB");
//		this.setTotalSize("/100MB");
//		this.setTimeRemain("  还剩10分钟");
	},
	
	// 下载初始化及下载过程中的显示由这个div共用
	initNew : function() {
		this._new = document.createElement("div");
		this._new.setAttribute("class", "qqbrowser-widgets-downloadbarStatus-download");
		this._new.style.display = "none";
		this._currentSize = document.createElement("span");
		this._totalSize = document.createElement("span");
		this._timeRemain = document.createElement("span");
		this._new.appendChild(this._currentSize);
		this._new.appendChild(this._totalSize);
		this._new.appendChild(this._timeRemain);
		this._action.appendChild(this._new);
	},
	// 下载暂停
	initPause : function() {
		var _this = this;
		this._pause = document.createElement("div");
		this._pause.setAttribute("class", "qqbrowser-widgets-downloadbarStatus-pause");
		this._pause.style.display = "none";
		var text = document.createElement("span");
		text.innerText = "已暂停";
        /*text.style.color = "RGB(133, 153, 174)";*/
		this._pause.appendChild(text);
		var button = document.createElement("span");
		button.innerText = "继续下载";
		button.setAttribute("class",
				"qqbrowser-widgets-downloadbarItem-click");
		this._pause.appendChild(button);
		
		button.onclick = function() {
			console.info("This Item Id is:" + _this.id);
			
			var cmdName = "start";
			
			if (null !== _this._downloadbar._clickCommandListener) {
				_this._downloadbar._clickCommandListener.apply(this, [event, cmdName, _this.id]);
			}
			event.stopPropagation();
		};
		this._action.appendChild(this._pause);
	},
	// 下载失败
	initFail : function() {
        var _this = this;
		this._fail = document.createElement("div");
		this._fail.setAttribute("class", "qqbrowser-widgets-downloadbarStatus-fail");
		this._fail.style.display = "none";
		var redownloadbutton = document.createElement("span");
		redownloadbutton.innerText = "重新下载";
        redownloadbutton.setAttribute("class",
           "qqbrowser-widgets-downloadbarItem-click");
		this._fail.appendChild(redownloadbutton);
		var deletebutton = document.createElement("span");
		deletebutton.innerText = "删除任务";
		deletebutton.setAttribute("class",
				"qqbrowser-widgets-downloadbarItem-click");
		this._fail.appendChild(deletebutton);
        redownloadbutton.onclick = function() {

			var cmdName = "restart";
			if (null !== _this._downloadbar._clickCommandListener) {
				_this._downloadbar._clickCommandListener.apply(this, [event, cmdName, _this.id]);
			}
			event.stopPropagation();
		};
		deletebutton.onclick = function() {
			console.info("This Item Id is:" + _this.id);

			var cmdName = "deltask";

			if (null !== _this._downloadbar._clickCommandListener) {
				_this._downloadbar._clickCommandListener.apply(this, [event, cmdName, _this.id]);
			}
			event.stopPropagation();
		};
		this._action.appendChild(this._fail);
   },
	// 下载完成
	initComplete : function() {
		var _this = this;
		this._complete = document.createElement("div");
		this._complete.setAttribute("class", "qqbrowser-widgets-downloadbarStatus-complete");
		this._complete.style.display = "none";
		this._completeCommand = document.createElement("span");
		this._completeCommand.innerText = "运行";
		this._completeCommand.setAttribute("class",
				"qqbrowser-widgets-downloadbarItem-click");
		this._complete.appendChild(this._completeCommand);
		var right_text = document.createElement("span");
		right_text.innerText = "打开文件夹";
		right_text.setAttribute("class",
				"qqbrowser-widgets-downloadbarItem-click");
		this._complete.appendChild(right_text);
		this._completeCommand.onclick = function() {
            //alert("打开");
			var cmdName = "openfile";
			
			if (null !== _this._downloadbar._clickCommandListener) {
				_this._downloadbar._clickCommandListener.apply(this, [event, cmdName, _this.id]);
			}
			event.stopPropagation();
		};
		right_text.onclick = function() {
			//alert("打开文件夹");
			var cmdName = "openfolder";
			
			if (null !== _this._downloadbar._clickCommandListener) {
				_this._downloadbar._clickCommandListener.apply(this, [event, cmdName, _this.id]);
			}
			event.stopPropagation();
		};
		this._action.appendChild(this._complete);
	},
	
	remove : function() {
		this._element.parentElement.removeChild(this._element);
	},
	
	setProcess : function(newProcess) {
		var width = newProcess * 195;
		this._process.style.width = [width, "px"].join("");
		/*this._process.style.marginRight = ["-", width, "px"].join("");*/

	},
	
	setTitle : function(newTitle) {
		this._title.innerHTML = newTitle;/* 后台获得这个数据 */
	},
	
	setImage : function(newImage) {
		this._image.style.background = ["url(qqbrowser://skin/images/downloadbar/",newImage,") center center no-repeat"].join("");
	},
	
	setOuterImage : function(newImage) {
		this._image.style.background = ["url(" + newImage + ") center center no-repeat"].join("");
	},
	
	setIcon : function(newIcon) {
		this._icon.style.background = ["url(qqbrowser://skin/images/downloadbar/",newIcon,") no-repeat"].join("");
	},
	
	setAction : function(status,type) {
	    console.log(status,type);
		var actions = this._action.children,
		actionsLen = actions.length;
		this._status = status;
		
		// 让所有状态显示div隐藏
		for (var i = 0; i < actionsLen; i++) {
			actions[i].style.display = "none";
		}

		
		// 根据传入的状态决定显示哪一个
		if ((status === "download")&&(type==="new")) {
            //console.log("in");
			this._new.style.display = "-webkit-box";
            this.addClass("dlitem-downloading");
            this.addClass("dlitem-new");
        
		} else if(status === "download"){
			
           this._new.style.display = "-webkit-box";
            this.removeClass("dlitem-pause");
            this.addClass("dlitem-downloading");
        }else if (status === "pause") {
			this._pause.style.display = "-webkit-box";
            this.removeClass("dlitem-downloading");
             this.removeClass("dlitem-new");
            this.addClass("dlitem-pause");
		} else if (status === "fail") {
			this._fail.style.display = "-webkit-box";
            this.removeClass("dlitem-downloading");
            this.addClass("dlitem-fail");
		} else if (status === "complete") { 
			this._complete.style.display = "-webkit-box";
            this.removeClass("dlitem-downloading");
			this.removeClass("dlitem-pause");
            this.addClass("dlitem-complete");
		} else {
			
			this._new.style.display = "-webkit-box";
			this.removeClass("dlitem-pause");
            this.removeClass("dlitem-new");
			this.addClass("dlitem-downloading");
			
		}
			
	},
	
	setCurrentSize : function(newCurrentSize) {
		this._currentSize.innerText = newCurrentSize; 
	},
	
	setTotalSize : function(newTotalSize) {
		this._totalSize.innerText = newTotalSize;
	},
	
	setTimeRemain : function(newTimeRemain) {
		this._timeRemain.innerText = newTimeRemain;
	},
	
	setCompleteCommand : function(newCommand) {
		this._completeCommand.innerText = newCommand;
	},
	
	flashItem : function() {
        this._process.removeClass("dlitem-downloading");
		 this._process.addClass("dlitem-complete");

		/*var itemStyle = this._element.style;
		
		itemStyle.border = "2px solid hsl(45, 75%, 40%)";
		itemStyle.marginTop = "1px";
		itemStyle.marginLeft = "1px";
		itemStyle.marginRight = "1px";
//		
//	
		this._process.style.background = "-webkit-gradient(linear, left top, left bottom, from(hsla(210, 70%, 95%, 0)), to(hsla(210, 70%, 75%, 0)))";
		itemStyle.background = "-webkit-gradient(linear, 0% 0%,0% 100%, from(hsla(210,15%,100%,1)),to(hsla(210,15%,100%,0)))";
//		ac
//		// 下载完成的Item闪烁三次
		var speed = 200;
//		
		for (var i = 0; i < 7; i++) {
			if ((i%2) !== 0) {
				setTimeout(function() {
					itemStyle.opacity = 0.6;
				}, i * speed);
			} else {
				setTimeout(function() {
					itemStyle.opacity = 1;
				}, i * speed);
			}
		}
		itemStyle.webkitBoxShadow = "hsla(45, 100%, 30%, 0.5) 0px 0px 5px";*/
	},
	
	/*处理完下载任务后恢复样式*/
	recoverFromFlashItem : function() {
		/*var itemStyle = this._element.style;
		// 需要看下当前的样式
		itemStyle.border = "1px solid hsl(215, 80%, 40%)";
		itemStyle.marginLeft = "2px";
		itemStyle.marginRight = "2px";
		itemStyle.marginTop = "1px";
		itemStyle.height = "38px";*/
	},
	
	onItemClick : function(func) {
		this._itemClickListener = func;
	},
	
	onMenuButtonClick : function(func) {
		this._menuButtonClickListener = func;
	}
});

qqbrowser.js.widgets.downloadbar = qqbrowser.js.base.Class(qqbrowser.js.widgets.widget, {
	className: "qqbrowser.js.widgets.downloadbar",
	
	_downloadmsg : null,
	_downloaditems : null,
	_downloadright : null,
	_showEventListener: null,
	_hideEventListener: null,
	_showallEventListener: null,
	
	_clickCommandListener: null,
	
	initialize: function(id) {
		var _this = this;
		
		this._element = document.createElement("div");
		this.setClass("qqbrowser-widgets-downloadbar");
		
		this._downloadmsg = document.createElement("div");
		this._downloadmsg.setAttribute("class", "qqbrowser-widgets-downloadmsg");
		var nomsg = document.createElement("span");
			nomsg.innerText = "当前没有下载任务";
		this._downloadmsg.appendChild(nomsg);
		this._element.appendChild(this._downloadmsg);
		
		this._downloaditems = document.createElement("div");
		this._downloaditems.setAttribute("class", "qqbrowser-widgets-downloaditems");
		this._element.appendChild(this._downloaditems);
		
		this._downloadright = document.createElement("div");
		this._downloadright.setAttribute("class", "qqbrowser-widgets-downloadright");
		this._downloadright.innerHTML = ["<div class = 'qqbrowser-widgets-downloadbaricon' ></div>"].join("");
		this._element.appendChild(this._downloadright);
		
		var showall = document.createElement("span");
		showall.innerText = "显示所有下载";
		this._downloadright.appendChild(showall);
		
		showall.onclick = function() {
			if (_this._showallEventListener) {
				_this._showallEventListener.apply(this, []);
			}
		};
		
		var downloadbarCloseButton = new qqbrowser.js.widgets.button("downloadbar-close-button");
		downloadbarCloseButton.setClass("qqbrowser-widgets-downloadbar-close");
		downloadbarCloseButton.onclick(function() {
			_this.show(false);
            _this.callListener(false);
		});
		downloadbarCloseButton.insert(this._downloadright);
		
    	//this.addItem(1);
//		this.addItem(2);
//		this.show(false);
		this.setDownloadMsg(true);
		qqbrowser.js.widgets.widget.prototype.initialize.apply(this, [id]);
	},
	
	addItem: function(id) {
		var item = new qqbrowser.js.widgets.downloaditem("downloadItem" + id, this);
		this._downloaditems && this._downloaditems.insertBefore(item._element, this._downloaditems.firstChild);
		//item.insert(this._downloaditems);
		return item;
	},
	
	onShow: function(func) {
		this._showEventListener = func;
	},
	
	onHide: function(func) {
		this._hideEventListener = func;
	},
	
	onShowAll: function(func) {
		this._showallEventListener = func;
	},
	
	callListener: function (isShow) {
		if (isShow) {
			if (this._showEventListener) {
				this._showEventListener.call(this);
			}
		} else {
			if (this._hideEventListener) {
				this._hideEventListener.call(this);
			}
		}
	},
	
	onClickCommand : function(func) {
		this._clickCommandListener = func;
	},
	
	setDownloadMsg : function(visiable) {
		if (visiable) {
			this._downloadmsg.style.display = "-webkit-box";
		} else {
			this._downloadmsg.style.display = "none";
		}
	}
	
	
});