if (undefined === qqbrowser.js.widgets) {
	qqbrowser.js.widgets = {};
}

qqbrowser.js.widgets.widget = qqbrowser.js.base.Class({
	className: "qqbrowser.js.widgets.widget",
	
	id: null,
	
	// 对应的DOM元素
	_element: null,
	_this: this,
	_clickListener: null,
	_mousedownListener: null,
	_visible: null,
	
	initialize: function(id) {
		this.id = id;
		this._element.setAttribute("id", id);
		
		this._element.oncontextmenu = function() {
			return false;
		};
	},
	
	insert: function(parent) {
		parent.appendChild(this._element);
	},

//	setClass: function(newClass) {
//		this._element.setAttribute("class", newClass);
//	},
	

	/**
	 * Create a regular expression that will match a particular class name
	 * @param className
	 * @returns a regular expression for a particular class name
	 */
	regexForClassName: function(className){
		var fn = arguments.callee;
		if(!fn._lookup) {
			fn._lookup = {};
		}
		if(className in fn._lookup) {
			return fn._lookup[className];
		}
		
		return (fn._lookup[className] = new RegExp("(^|\\s)" + className + "(\\s|$)"));
	},
	
	/**
	 *  Determine whether an element has the specified class name
	 * @param className
	 * @returns bool
	 */
    hasClass: function(className) {
    	var elementClassName = this._element.className;
    	if(!elementClassName) {
    		return false;
    	}
    	if (elementClassName === className) {
    		return true;
    	}
    	
    	return this.regexForClassName(className).test(elementClassName);
    },
    
    /**
     * Add the specified class name to the element.
     * @param className
     */
    setClass: function(className) {
    	if(!className) {
    		return;
    	}
    	
    	if (this.hasClass(className)) {
    		return;
    	}
    	
    	this._element.className = className;
    },
	
    /**
     * Add the specified class name to the element.
     * @param className
     */
	addClass: function(className) {
		if(!className) {
			return;
		}
		
		if (this.hasClass(className)) {
			return;
		}
		
		this._element.className += " " + className;
	},
	/**
	 * Remove the specified class name from the element
	 * @param className
	 */
	removeClass: function(className) {
		if(!className) {
			return;
		}
		
		var regex = this.regexForClassName(className);
		this._element.className = this._element.className.replace(regex, " ").trim();
	},


	/**
	 * If the element has the class name, remove it, otherwise add it.
	 * @param className
	 */
    toggleClass: function(className) {
    	if(!className) {
    		return;
    	}
    	
    	var regex = this.regexForClassName(className);
    	var elementClassName = this._element.className;
    	
    	if(regex.test(elementClassName)) {
    		this._element.className = elementClassName.replace(regex, " ").trim();
    	} else {
    		this._element.className += " " + className;
    	}
    },
    
	setText: function(text) {
		this._element.innerText = text;
	},
	
	disable: function() {
		this.addClass("disabled");
		// 解决连续两次调用disable()方法将原有的listener清空的问题
		if (null !== this._element.onmousedown){
			this._mousedownListener = this._element.onmousedown;
			this._element.onmousedown = null;
		}
		if (null !== this._element.onclick) {
			this._clickListener = this._element.onclick;
	        this._element.onclick = null;
		}
	},
	
	enable: function() {
		this.removeClass("disabled");
		this._element.onclick = this._clickListener;
        this._element.onmousedown = this._mousedownListener;
	},
	
	show: function(visible , type) {
		if (visible === this._visible) {
			return;
		}
		this._visible = visible;
		
		if (visible) {
            if(type){
                this._element.style.display = type;
            } else {
                this._element.style.display = "-webkit-box";
            }

		} else {
			this._element.style.display = "none";
		}
	},

	setSize: function(width, height) {
		this._element.style.width = width + "px";
		this._element.style.height = height + "px";
	},
	
	click: function() {
		var event = document.createEvent("MouseEvents");
		event.initEvent("click", true, true);
		this._element.dispatchEvent(event);
	},
	
	mouseup: function() {
		var event = document.createEvent("MouseEvents");
		event.initEvent("mouseup", true, true);
		this._element.dispatchEvent(event);
	},
	
	onclick: function(func) {
		this._element.onclick = func;
	},
	
	onmousedown: function(func) {
		this._mousedownListener = func;
	},
	
	contextmenu: function() {
		var event = document.createEvent("MouseEvents");
		event.initEvent("contextmenu", true, true);
		this._element.dispatchEvent(event);
	},
	
	oncontextmenu: function(func) {
		this._element.oncontextmenu = func;
	}
});