qqbrowser.js.widgets.checkbox = qqbrowser.js.base.Class(qqbrowser.js.widgets.widget, {
	className: "qqbrowser.js.widgets.checkbox",
	
	_checkbox: null,
	_label: null,
	
	initialize: function(id) {
		var _this = this;
		
		this._element = document.createElement("div");
		this.setClass("qqbrowser-widgets-checkbox");
		
		this._checkbox = document.createElement("input");
		this._checkbox.setAttribute("type", "checkbox");
		this._checkbox.setAttribute("class", "qqbrowser-widgets-checkbox-checkbox");
		this._checkbox.setAttribute(id, id + "-checkbox");
		this._element.appendChild(this._checkbox);
		
		this._label = document.createElement("label");
		this._label.setAttribute("for", id + "-checkbox");
		this._element.appendChild(this._label);
		
		qqbrowser.js.widgets.widget.prototype.initialize.apply(this, [id]);
	},

	setText: function(newText) {
		this._label.innerText = newText;
	},
	
	setChecked: function(checked) {
		this._checkbox.checked = checked;
	},
	
	isChecked: function(checked) {
		return this._checkbox.checked;
	}
});