qqbrowser.js.widgets.cells = qqbrowser.js.base.Class(qqbrowser.js.widgets.widget, {
	className: "qqbrowser.js.widgets.cells",
	_cells:null,
	
	_counts: 0,
	_rowsCount: 0,//每排有多少个cell
	_rowNum: 0,   //共多少排
	
	_rowsDOM: null,
	
	/**
	 * 创建cells，构造函数完成数据定义
	 * @param id
	 * @param counts 总共需要有的cell数
	 * @param rowsCount   每排有多少个cell
	 */
	initialize: function(id , counts , rowsCount, cells) {
		this._element = document.createElement("div");
		this.setClass("qqbrowser-widgets-cells");
		
		this.setCounts(counts);
		this.setRowsCount(rowsCount);
		
		this._rowNum = (this._counts % this._rowsCount === 0)?(this._counts / this._rowsCount) : (this._counts / this._rowsCount)+1;
		
		(this._cells = cells) || this.createCells();		
		if(this._cells != null){
			this.fillData();
		}
		qqbrowser.js.widgets.widget.prototype.initialize.apply(this, [id]);
	},
	setCounts: function(counts){
		this._counts = counts || 0;
	},
	setRowsCount: function(rowsCount){
		this._rowsCount = rowsCount || 0;
	},
	setRowsDOM: function(){
		if(this._element && this._element.childNodes){
			for(var i=0; i<this._element.childNodes.length;i++){
				this._element.removeChild(this._element.childNodes[i]);
			}	
		}
		this._rowsDOM = new Array();
		for(var i = 0;i<this._rowNum;++i){
			this._rowsDOM[i] = document.createElement("div");
			this._rowsDOM[i].setAttribute("class","qqbrowser-widgets-cells-row");
			this._element.appendChild(this._rowsDOM[i]);
		}
	},
	/**
	 * 如果cells不符合当前状态，则根据counts来创建一些空的的cells控件
	 */
	createCells: function(){
		if(this._cells && this._cells.length === this._counts){
			return ;
		}
		this._cells = new Array();
		for(var i=0; i<this._counts;i++){			
			this._cells[i] = new qqbrowser.js.widgets.cell("cell"+i);
			this._cells[i].setClass("qqbrowser-widget-cells-cell");
			this._cells[i].addClass("empty");
		}
	},
	fillData: function(){
		if(!this._rowsDOM || this.rowsDOM.length !== this._rowNum){
			this.setRowsDOM();
		}
		var c = 0;
		for(var i=0 ;i<this._rowsDOM.length ; ++i){
			for(var j=0 ; j<this._rowsCount ; j++){
				this._rowsDOM[i].appendChild(this._cells[c++]._element);
				if(c >= this._counts){
					break;
				}					
			}
		}
	},
	swapCell:function(a,b){
		if(typeof a !== Number || typeof b !== Number){
			return;
		}
		var data = this._cells[a]._data;
		this._cells[a].setData(this._cells[b]._data);
		this._cells[b].setData(data);
	}
	
		
});