// cell.js
//对应九宫格的单个格子控件,考虑继承button控件

qqbrowser.js.widgets.cell = qqbrowser.js.base.Class(qqbrowser.js.widgets.widget, {
	className: "qqbrowser.js.widgets.cell",
	_bindSnapshotElement:null,
	
	
	_data:null,
	
	_edit:null,
	_snapshot:null,
	_cellTitle:null,
	_url:null,	
	
	_title:null,
	_icon:null,

	
	initialize: function( id , site ) {
		var _this = this;
		
		this._element = document.createElement("div");
		this.setClass("qqbrowser-widgets-cell");
		
		this.addEdit();
		this.addUrl();
		
		this.addSnapshot();
		this.addCellTitle();
		this.addIcon();
		this.addTitle();
		
		
		if(site && site.getSiteAsObject){
			this.setDate(site.getSiteAsObject());
		}
		
		if(this._snapshot){
			this._snapshot.onmouseover = function(event) {
				_this.addClass("mouseover");
				if (null !== _this._bindSnapshotElement) {
					_this._bindSnapshotElement.addClass("mouseover");
				}
				event.stopPropagation();
				return false;
			};
			
			this._snapshot.onmouseout = function(event) {
				_this.removeClass("mouseover");
				_this.removeClass("mousedown");
				
				if (null !== _this._bindSnapshotElement) {
					_this._bindSnapshotElement.removeClass("mouseover");
					_this._bindSnapshotElement.removeClass("mousedown");
				}
				event.stopPropagation();
				return false;
			};
			
			this._snapshot.onmousedown = function(event) {
				_this.removeClass("mouseover");
				_this.addClass("mousedown");
	
				if (_this._mousedownListener) {
					_this._mousedownListener.apply(this, [event]);
				}
				event.stopPropagation();
				return false;
			};
			
			this._snapshot.onmouseup = function(event) {
				_this.removeClass("mousedown");
				event.stopPropagation();
				return false;
			};
			
			this._snapshot.onclick = function(event) {
				
			};
			
			this._snapshot.ondblclick = function(event) {
				event.stopPropagation();
				return false;
			};
			
			this._snapshot.oncontextmenu = function() {
				event.stopPropagation();
				return false;
			};	
			this._edit.onclick = function(event){
				event.stopPropagation();
				return false;
			};
		}
		
		qqbrowser.js.widgets.widget.prototype.initialize.apply(this, [id]);
	},
	setData: function(data) {
		this._data = data;
		if(this._url && this._data.url ){
			this._url.setAttribute("href",this._data.url);
		}
		if(this._snapshot &&  this._data.image){
			this._snapshot.style.backgroundImage = "url('"+this._data.image.replace(/\\/g, '\/')+"')";
		}
		if(this._icon && this._data.icon){
			this._icon.setAttribute("src",this._data.icon.replace(/\\/g, '\/'));
		}
		if(this._title && this._data.title){
			this._title.innerText = this._data.title;
		}
	},
	addEdit:function(){
		if(!this._element){
			throw "has not initialized";
			return ;
		}
		if(!this._edit){	
			this._edit = document.createElement("div");
			this._edit.setAttribute("class","qqbrowser-widget-cell-edit");
		}
		this._element.appendChild(this._edit);
	},
	addUrl: function(){
		if(!this._element){
			throw "has not initialized";
			return ;
		}
			
		if(!this._url){	
			this._url = document.createElement("A");
			this._url.setAttribute("href","javascript:void(0)");
		}
		this._element.appendChild(this._url);
	},
	addSnapshot: function(){
		if(!this._url){
			return;
		}
		if(!this._snapshot){
			this._snapshot = document.createElement("div");
			this._snapshot.setAttribute("class","qqbrowser-widget-cell-snapshot");
		}
		this._url.appendChild(this._snapshot);		
	},
	addCellTitle: function(){
		if(!this._url){
			return;
		}
		if(!this._cellTitle){
			this._cellTitle = document.createElement("div");
			this._cellTitle .setAttribute("class","qqbrowser-widget-cell-cellTitle");
		}
		this._cellTitle.style.visibility = "visible";
		this._url.appendChild(this._cellTitle );		
	},
	addIcon:function (){
		if(!this._cellTitle){
			return ;
		}
		if(!this._icon){
			this._icon = document.createElement("img");
			this._icon.setAttribute("class","qqbrowser-widget-cell-icon");
		}
		this._cellTitle.appendChild(this._icon);
	},
	addTitle: function (){
		if(!this._cellTitle){
			return ;
		}
		if(!this._title){
			this._title = document.createElement("span");
		}
		this._cellTitle.appendChild(this._title);
	},
	removeEdit:function(){
		if(!this._element){
			throw "has not initialized";
			return ;
		}
		this._element.removeChild(this._edit);
	},
	removeUrl:function(){
		if(!this._element){
			throw "has not initialized";
			return ;
		}
		this._element.removeChild(this._snapshot);
	},
	removeSnapshot: function() {
		if(null !== this._url){
			this._url.removeChild(this._snapshot);
		}
	},
	removeCellTitle: function(){
//		if(null !== this._url){
//			this._url.removeChild(this._cellTitle);
//		}
		this._cellTitle.style.visibility = "hidden";
	},
	appendEdit:function(newElement) {
		if(!this._edit){
			return;
		}
		this._edit.appendChild(newElement);
	},
	appendSnapshot: function(newElement){
		if(!this._snapshot){
			return;
		}
		this._snapshot.appendChild(newElement);
	},
	appendCellTitle: function(newElement){
		if(!this._cellTitle){
			return;
		}
		this._cellTitle.appendChild(newElement);
	}
});