/**
 * @author peakgao
 */
qqbrowser.js.widgets.bookmarkTree = qqbrowser.js.base.Class(qqbrowser.js.widgets.widget, {
	className: "qqbrowser.js.widgets.bookmarkItem",
	_bindSnapshotElement:null,
	
	rootdata:null,
	root:null,
	
	folderFactory:null,
	urlFactory:null,
	
	initialize:function(id,data,folder,url){
		this.rootdata = data;
		this.folderFactory = folder || new folderFactory();
		this.urlFactory = url || new urlFactory();
		
		this._element = document.createElement("div");
		this.setClass("favtree");
		
		try {
			this._element.appendChild(this.buildTree()._element);
		}catch(e){
			console.log(e);
		}
		qqbrowser.js.widgets.widget.prototype.initialize.apply(this, [id]);
	},
	buildSubTree:function(root,data){
		if(!data.children()){
			return null;
		}

		var children = new Array();
		var layerData = data.children();

		if(layerData[0].getObj().type === "folder"){
			children[0] = new qqbrowser.js.widgets.bookmarkItem("",this.folderFactory);;
		}else if(layerData[0].getObj().type === "url"){
			children[0] = new qqbrowser.js.widgets.bookmarkItem("",this.urlFactory);;
		}
		//console.log();
		//children[0].data = layerData[0].getObj();
		//children[0].fillData(layerData[0].getObj());
		//this._element.appendChild(children[0]._element);
		
		children[0].parent = root;
		children[0].depth = root.depth+1;
		children[0].data = layerData[0].getObj();
		
		if(layerData[0].children){
			children[0].children = this.buildSubTree(children[0],layerData[0]);
		}
		for(var i=1;i<layerData.length;i++){
			var child = new treeItem();
			if(layerData[i].getObj().type === "folder"){
				child = new qqbrowser.js.widgets.bookmarkItem("",this.folderFactory);;
			}else{
				child = new qqbrowser.js.widgets.bookmarkItem("",this.urlFactory);;
			}
			child.parent = root;
			child.depth = root.depth + 1;
			child.data = layerData[i].getObj();
			
			if(layerData[i].children){
				child.children = this.buildSubTree(child,layerData[i]);
			}
			children[i] = child;
			children[i-1].next = child;
			child.prev = children[i-1];
			
			//this._element.appendChild(children[i]._element);
		}
		return children;
	},
	buildTree:function(){
		if(!this.rootdata){
			return false;
		}
		var root = this.root;
		try {
			root = new qqbrowser.js.widgets.bookmarkItem("bookmarktree",this.folderFactory);
			
			root.data = this.rootdata.getObj();
			
			if(this.rootdata && this.rootdata.children()){
				root.children = this.buildSubTree(root,this.rootdata);
			}
		} catch (e) {
			console.log(e);
		}
		this.root = root;
		return root;	
	},
	/**
	 * 先根遍历子树
	 * @param {Object} subTreeRoot 子树根节点
	 * @param {Object} func    操作
	 */
	travelTree:function(root,func){
		func.call(root);
		if(root.children){
			this.travelTree(root.children[0],func)			
		}
		if(root.next){
			this.travelTree(root.next,func)
		}
	}
});