/**
 * @author peakgao
 */
qqbrowser.js.widgets.bookmarkItem = qqbrowser.js.base.Class(qqbrowser.js.widgets.widget, {
	className: "qqbrowser.js.widgets.bookmarkItem",
	_bindSnapshotElement:null,
	
	data:null,
	itemsFactory:null,
	
	row:null,
	label:null,
	favIcon:null,
	
	depth:0,
	
	children:null,
	next:null,
	prev:null,
	parent:null,
	
	initialize:function(id,factory){
		var _this = this;

		this._element = document.createElement("div");
		this.setClass("qqbrowser-bookmarkItem");
		
		this.itemsFactory = factory;
		
		factory.createDOM.call(this);
		factory.bindEvent.call(this);
		factory.itemEdit.call(this);
		
		this._element.addEventListener("click",function(){
			_this.handleClick();
			this.addClass("selected");
		},false);
		
		this._element.addEventListener("mouseover",function(){
			_this.handleMouseover();
			this.addClass("hover");
		},false);
		this._element.addEventListener("mouseout",function(){
			_this.handleMouseout();
			this.removeClass("hover");
		},false);
		this._element.addEventListener("mouseup",function(event){
			if(event.button === 2){
				_this.handleRightClick();
			}
		},false);
		this._element.addEventListener("contextmenu", function() {
			// 禁止menuItem的contextmenu事件
			_this.handleContextMenu();
			
			event.preventDefault();
			event.stopPropagation();
		}, false);
		//this._element.addEventListener("");
				
		qqbrowser.js.widgets.widget.prototype.initialize.apply(this, [id]);
	},
	
	fillData:function(){
		var obj = this.data;
		this.label.innerText = obj.title;
		if(!!this.itemsFactory){			
			this.itemsFactory.fillData.call(this);
		}
	},
	hasChild: function(){
		return !!this.children;
	},
	insert: function(){
		
	},
	handleClick:function(){
		
	},
	handleMouseover:function(){
		
	},
	handleRightClick:function(){
		
	},
	handleMouseout:function(){
		
	},
	handleContextMenu:function(){
		
	},
	removeItem: function(){
		
	}
});