/*
 * Date: 2011-06-21
 * Author: jingleyang 
 * */

qqbrowser.js.widgets.appboxButton = qqbrowser.js.base.Class(qqbrowser.js.widgets.button,{
	className:"qqbrowser.js.widgets.appboxButton",
    initialize:function(id) {
        var _this = this;
        var element = document.createElement("div");
        element.addClass("sidebar-feed-float");
        element.setAttribute("id","sideBar-feed");
        qqbrowser.js.widgets.button.prototype.initialize.apply(this, [id]);
        _this._element.appendChild(element);
        appboxButton.init(_this,element);
    }
});
var appboxButton = {
	ptr:null,
    sideBarFeed:null,
	isOpen:null,
	init:function(_ptr,_feed){
		appboxButton.ptr = _ptr;
        appboxButton.sideBarFeed = _feed;
        qqbrowser.extension.builtin.config.get(["sidebarDockShow"], function(retval) {
        appboxButton.getConfigDockShowCallback(retval);});
		appboxButton.regHandler();
		_ptr.open = function() {
			if(appboxButton.isOpen) {
				return;
			}
			
			// 开启侧边栏
			appboxButton.clickHandler();
		};
	},
	regHandler:function(){
		appboxButton.ptr.onclick(appboxButton.clickHandler);
	},
	clickHandler:function(){

		if (appboxButton.isOpen){ //close
			appboxButton.isOpen = false;
			appboxButton.ptr.removeClass("open");

			qqbrowser.layout.appbox._element.style.display = "none";
			qqbrowser.js.logic.layoutManager.resize();
            appboxButton.setConfig(appboxButton.isOpen);
            appboxDock.initDock();

            qqbrowser.extension.builtin.statistics.increase(STATIS_CMD_SIDEBAR_CLOSE_BUTTON_CLICKED);
		}else{ // open

			appboxButton.isOpen = true;
			appboxButton.ptr.addClass("open");
			appboxButton.ptr.removeClass("pressed");
            appboxButton.sideBarFeed.removeClass("show");
			qqbrowser.layout.appbox._element.style.display = "-webkit-box";
			qqbrowser.js.logic.layoutManager.resize();
            appboxButton.setConfig(appboxButton.isOpen);
		    qqbrowser.extension.builtin.statistics.increase(STATIS_CMD_SIDEBAR_OPEN_BUTTON_CLICKED);
        }			
	},
    setConfig: function(isOpen){
        var config = {};
        config.sidebarDockShow = isOpen;
        localStorage.setItem("sidebarDockShow", isOpen);
        qqbrowser.extension.builtin.config.set(config, function(i) {
            if(!appboxButton.isOpen){
                qqbrowser.sidebar.destroy && qqbrowser.sidebar.destroy();
            }
        });
    },
    getConfigDockShowCallback: function(results) {
        var config = JSON.parse(results)[0];
        var configName = "sidebarDockShow";
        var configValue = config[configName];
        appboxButton.appBoxDockShow(configValue);
    },
	appBoxDockShow: function(isShow) {
		if(isShow) {
            appboxButton.isOpen = true;
	        appboxButton.ptr.addClass("open");
            appboxButton.sideBarFeed.removeClass("show");
            qqbrowser.layout.appbox._element.style.display = "-webkit-box";
            qqbrowser.js.logic.layoutManager.resize();
            //qqbrowser.extension.builtin.statistics.increase(STATIS_CMD_SIDEBAR_DOCK_BUTTON_OPEN_CLICKED); 
        } else {
            appboxButton.isOpen = false;
	        appboxButton.ptr.removeClass("open");
            qqbrowser.js.logic.layoutManager.resize();
            qqbrowser.layout.appbox._element.style.display = "none";
           // qqbrowser.extension.builtin.statistics.increase(STATIS_CMD_SIDEBAR_DOCK_BUTTON_CLOSE_CLICKED);
        }
	}
};
