//appbox.js
/**addby crisweng，将appbox dock面板加入皮肤中
 *
 */
qqbrowser.js.widgets.appbox = qqbrowser.js.base.Class(qqbrowser.js.widgets.widget, {
	className: "qqbrowser.js.widgets.appbox",
    _resizeBar:null,
    _pageBox:null,
    currentAppBtn:null,
    totMoveCnt:0,
	totDoCnt:0,
    cache:{},
    timer:null,
	freq:8,
	cancleCnt:0,
	maxCancleCnt:10,
    canDrag:true,
    oldPos:{},
    currWidth:0,
    oldWidth:'315px',
    oldAppWidth:"315",
    totOpen:0,
    firstNavigate:true,
    restWidth:10,
    initWidth:"315",
  

	initialize: function(id) {
		var _this = this;

		_this._element = document.createElement("div");

		_this._resizeBar = document.createElement("div");
        _this._pageBox = document.createElement("div");
		_this._resizeBar.setAttribute("id","resize-temp");
        _this._pageBox.setAttribute("id","appBoxPage");
		_this._element.appendChild(_this._resizeBar);
        _this._element.appendChild(_this._pageBox);
		_this._element.setClass("qqbrowser-widgets-appbox");
        _this._element.appendChild(appboxDock.initialize());
        document.addEventListener("DOMContentLoaded",function(){
            appboxDock.addDockButtonEvent();
        },false);
		_this.show(false);
		qqbrowser.js.widgets.widget.prototype.initialize.apply(_this, [id]);
		_this.regHandler();
	},
    /*拖动侧边栏操作*/
    regHandler: function(){

		this.dragHandler();
		this.dockToggleHandler();
	},
    dragHandler: function(){
        var _this = this;
        _this._resizeBar.onmousedown = function(){
			_this.totDoCnt=0;
			_this.totMoveCnt=0;
			_this.canDrag = true;
			_this.cache.onmouseup = window.onmouseup;
			_this.cache.onmousemove = window.onmousemove;
			window.onmouseup = function(){
				_this.canDrag = false;
				window.onmousemove = _this.cache.onmousemove;
				window.onmouseup = _this.cache.onmouseup;
				qqbrowser.js.logic.layoutManager.appboxResize();
			};
			window.onmousemove = function(){
				if (_this.canDrag){
					_this.totMoveCnt++;
					var detax =  _this.oldPos.x - event.pageX;
					var currwidth = _this.oldPos.width+detax;
					// 限制最小的宽度,和最大宽度
					if (currwidth<315 || currwidth>600 || currwidth> (document.body.clientWidth-20) ){
						return;
					}
					_this.oldPos.x = event.pageX;
					_this.oldPos.y = event.pageY;
					_this.oldPos.width = currwidth;
                    _this.oldAppWidth = currwidth;
					_this.currWidth = currwidth;
					if (_this.cancleCnt<_this.maxCancleCnt && null!=_this.timer){
						clearTimeout(_this.timer);
						_this.cancleCnt++;
					}
					//must to do
					_this.timer = setTimeout(_this.doresize(_this),_this.freq);
					_this.cancleCnt=0;

				}
			};
			//console.info("drag start");
			_this.oldPos.x = event.pageX;
			_this.oldPos.y = event.pageY;
			_this.oldPos.width = _this._element.clientWidth;
		};
    },

    doresize:function(_this){
		_this.totDoCnt++;
		_this._element.style.width = _this.currWidth+"px";
		qqbrowser.js.logic.layoutManager.appboxResize();
	},
    dockToggleHandler:function(){
        var _this = this;
		if (qqbrowser.skin.sidebarNotify){
		     // 侧边栏发送过来消息
	        qqbrowser.skin.sidebarNotify.addListener(function(reply){
                if(reply == "selectApp"){ //_this.currentAppBtn 此处无值，待修改 leeozeng 
                    qqbrowser.sidebar.selectApp && qqbrowser.sidebar.selectApp(
                    _this.currentAppBtn);
                }else if(reply == "closeApp"){
                    var selectedBtn = document.querySelector("#app-dock > .select");
                    selectedBtn.setAttribute("open","false");
                    selectedBtn.removeClass("select");
                   // alert("ok");
                    qqbrowser.sidebar.close();
                    appboxDock.hideAppArrow(selectedBtn);
                    _this.pageHide();
                    qqbrowser.extension.builtin.statistics.increase(STATIS_CMD_SIDEBAR_X_BUTTON_TOTAL_CLICKED);
                }else if(reply == "destroySidebar"){ //临时添加，待修改 leeozeng 
                    var selectedBtn = document.querySelector("#app-dock > .select");
                    selectedBtn.setAttribute("open","false");
                    selectedBtn.removeClass("select");
                    _this.pageHide();
					qqbrowser.sidebar.destroy && qqbrowser.sidebar.destroy();
                }else if(reply == "refreshApp"){
                    qqbrowser.extension.builtin.statistics.increase(STATIS_CMD_SIDEBAR_REFRESH_BUTTON_TOTAL_CLICKED);//为刷新按钮添加数据上报
                }
            });
		}
	},
   pageShow:function(){
       //判断是否会超出整个window的宽度
       var windowWidth = window.outerWidth;

       var pageWidth = page.offsetWidth;
       console.log(windowWidth +" "+pageWidth+" "+this.oldAppWidth);
       if(windowWidth - parseInt(this.oldAppWidth,10) < this.restWidth){
           console.log(windowWidth +" "+pageWidth+" "+this.oldAppWidth);
            this.oldAppWidth = this.initWidth;
       }
		this._element.style.width = [this.oldAppWidth,"px"].join("");
		this.show(true);
		qqbrowser.js.logic.layoutManager.appboxResize();
	},
	pageHide:function(){
		this.oldAppWidth = this._element.offsetWidth;
		this._element.style.width = '39px';
		this.show(false);
        qqbrowser.sidebar.close();
		qqbrowser.js.logic.layoutManager.appboxResize();
	},
	show: function(visible) {
		if (visible) {
			this._resizeBar.style.display = "-webkit-box";
            this._pageBox.style.display = "-webkit-box";
		} else {
			this._resizeBar.style.display = "none";
            this._pageBox.style.display = "none";
		}
	}
});
/*dock栏的初始化*/
var appboxDock = {
    _appDock:null,
    _currentAppButton:null,
    initialize: function(){
        var sideBarButtons = [
			'sidebar-qzone-button',
			'sidebar-weibo-button',
			'sidebar-pengyou-button',
			'sidebar-caibei-button',
			'sidebar-qzone-appstore-button',
			'sidebar-stock-button',
			'sidebar-doubanfm-button',
			'sidebar-note-button',
			'sidebar-webgame-button',
			'sidebar-chongzhi-button'
		];

        var _this = this;
        _this._appDock = document.createElement("div");
        _this._appDock.setAttribute("id","app-dock");
        var frag = document.createDocumentFragment();
        var tmp;
        for(var i=0;i<sideBarButtons.length;i++){
            tmp = document.createElement("div");
            tmp.setAttribute("id",sideBarButtons[i]);
            tmp.setClass("appbox-dockbtn");
            if (sideBarButtons[i] == "sidebar-weibo-button" ||sideBarButtons[i] == "sidebar-qzone-button") {
                tmp.innerHTML = "<div class=\"sidebar-feed-float\"></div><div class=\"app-arrow\"></div>";
            } else {
                tmp.innerHTML = "<div class=\"app-arrow\"></div>";
            }

            frag.appendChild(tmp);

        }
        _this._appDock.appendChild(frag);

        return _this._appDock;
    },
    initDock: function(){
        var _this = this;
        var element = _this._appDock;
        var node = element.firstChild;
        while (node) {
            node.setAttribute("open","false");
            node.removeClass("select");
            node = node.nextSibling;
        }
        qqbrowser.layout.appbox.oldAppWidth = "315";
		qqbrowser.layout.appbox._element.style.width = '39px';
		qqbrowser.layout.appbox.show(false);
        qqbrowser.layout.appbox.firstNavigate = true;
		qqbrowser.js.logic.layoutManager.appboxResize();
        _this.hideAppArrow();
    },
    addDockButtonEvent: function(){
        var _this = this;
        var element = document.getElementById("app-dock");
        var node = element.firstChild;
        while (node) {
            node.addEventListener("click", function( event ){
                _this.dockButtonAction( this );
                 event.stopPropagation();
                 event.preventDefault();
            }, false );
         	node = node.nextSibling;
       }
            /* button.addEventListener("click",function(e){
                e.stopPropagation();

                _this.dockButtonAction(button);
            },false);*/
    },
    /**
     * 
     * @param {HTMLDivElement} target 绑定点击事件的HTML元素
     */
    dockButtonAction: function( target ){
        var tmp= target;
        var isSelected = false;//是否是第一次点击button，决定要不要调用sidebar的open API
        var _this = qqbrowser.layout.appbox;
        _this.currentAppBtn = tmp.id;

        if(tmp.hasClass("select")){
            _this.pageHide();
            tmp.removeClass("select");
            qqbrowser.sidebar.close();
            this.hideAppArrow(target);
            this.btCloseReport(tmp.id);
        }else{
            if(tmp.id =="sidebar-weibo-button" || tmp.id == "sidebar-qzone-button"){
                document.querySelector("#"+tmp.id+" .sidebar-feed-float").removeClass("show");
            }
            var element = document.getElementById("app-dock");
            var node = element.firstChild;
            while(node){
                if(node.hasClass("select")){
                    node.removeClass("select");
                    isSelected = true;
                }
                node = node.nextSibling;
            }
            tmp.setAttribute("open","true");
            if(_this.firstNavigate){
                _this.pageShow();
                this.openSideBar();


                _this.firstNavigate = false;
            } else if(!isSelected){
                 _this.pageShow();
                this.openSideBar();


                qqbrowser.sidebar.selectApp && qqbrowser.sidebar.selectApp(_this.currentAppBtn);
            }else{
                //this.openSideBar();
                 _this.pageShow();
               // alert("selected");
                qqbrowser.sidebar.selectApp && qqbrowser.sidebar.selectApp(_this.currentAppBtn); //_this.currentAppBtn 此处无值，待修改 leeozeng 
            }
            tmp.addClass("select");
            this.showAppArrow(target);
            this.btOpenReport(tmp.id);
        }

    },
    openSideBar: function() {
        var viewManager = qqbrowser.js.logic.viewManager;
        var appBox = document.getElementById('appbox');
        var resize = document.getElementById('resize-temp');
        var appBoxPage = document.getElementById("appBoxPage");
        var appBoxDock = document.getElementById("app-dock");
        var resizeMargin = viewManager.getMargin(resize);
        var resizeBorder = viewManager.getBorderWidth(resize);
        var dockMargin = viewManager.getMargin(appBoxDock);
        var dockBorder = viewManager.getBorderWidth(appBoxDock);
        var sleft = appBox.offsetLeft + resize.offsetWidth + resizeMargin.left + resizeMargin.right
            + resizeBorder.left + resizeBorder.right;
        var stop = appBox.offsetTop;
        var swidth = appBox.offsetWidth - resize.offsetWidth - (resizeMargin.left + resizeMargin.right
            + resizeBorder.left + resizeBorder.right) - appBoxDock.offsetWidth -
            (dockMargin.left + dockMargin.right + dockBorder.left + dockBorder.right);
        var sheight = appBox.offsetHeight;
        var page = document.getElementById('page');
        var pleft = page.offsetLeft;
        var ptop = page.offsetTop;
        var pwidth = page.offsetWidth;
        var pheight = page.offsetHeight;
        //qqbrowser.js.logic.layoutManager.resize();
        console.log(sleft, stop, swidth, sheight ,pleft, ptop, pwidth, pheight);
        qqbrowser.sidebar.open([sleft, stop, swidth, sheight ,pleft, ptop, pwidth, pheight ]);
    },
    showAppArrow: function(target){
        document.querySelector('.app-arrow.show')&&document.querySelector('.app-arrow.show').removeClass('show'); // 隐藏之前的arrow
	    var div = '#'+target.id+' .app-arrow';
        document.querySelector(div).addClass('show');
    },
    hideAppArrow: function(target){
        if(target){
            var div = '#'+target.id+' .app-arrow';
        } else{
            div = ".app-arrow.show";
        }
        document.querySelector(div)&&document.querySelector(div).removeClass('show');
    },
	_dataReport: {
		'sidebar-qzone-button': [STATIS_CMD_SIDEBAR_QZONE_BUTTON_OPEN_CLICKED, STATIS_CMD_SIDEBAR_QZONE_BUTTON_CLOSE_CLICKED],
		'sidebar-weibo-button': [STATIS_CMD_SIDEBAR_WEIBO_BUTTON_OPEN_CLICKED, STATIS_CMD_SIDEBAR_WEIBO_BUTTON_CLOSE_CLICKED],
		'sidebar-pengyou-button': [STATIS_CMD_SIDEBAR_FRIEND_BUTTON_OPEN_CLICKED, STATIS_CMD_SIDEBAR_FRIEND_BUTTON_CLOSE_CLICKED],
		'sidebar-caibei-button': [STATIS_CMD_SIDEBAR_CAIBEI_BUTTON_OPEN_CLICKED, STATIS_CMD_SIDEBAR_CAIBEI_BUTTON_CLOSE_CLICKED],
		'sidebar-qzone-appstore-button': [STATIS_CMD_SIDEBAR_APP_BUTTON_OPEN_CLICKED, STATIS_CMD_SIDEBAR_APP_BUTTON_CLOSE_CLICKED],
		'sidebar-stock-button': [STATIS_CMD_SIDEBAR_STOCK_BUTTON_OPEN_CLICKED, STATIS_CMD_SIDEBAR_STOCK_BUTTON_CLOSE_CLICKED],
		'sidebar-doubanfm-button': [STATIS_CMD_SIDEBAR_DOUBAN_BUTTON_OPEN_CLICKED, STATIS_CMD_SIDEBAR_DOUBAN_BUTTON_CLOSE_CLICKED],
		'sidebar-note-button': [STATIS_CMD_SIDEBAR_NOTE_BUTTON_OPEN_CLICKED, STATIS_CMD_SIDEBAR_NOTE_BUTTON_CLOSE_CLICKED],
		'sidebar-webgame-button': [STATIS_CMD_SIDEBAR_WEBGAME_BUTTON_OPEN_CLICKED, STATIS_CMD_SIDEBAR_WEBGAME_BUTTON_CLOSE_CLICKED],
		'sidebar-chongzhi-button': [STATIS_CMD_SIDEBAR_FILBMP_BUTTON_OPEN_CLICKED, STATIS_CMD_SIDEBAR_FILBMP_BUTTON_CLOSE_CLICKED]
	},
    /*
    统计dock栏中各个button展开侧边栏时数据统计
     */
    btOpenReport: function(id) {
        qqbrowser.extension.builtin.statistics.increase(this._dataReport[id][0]);
    },
    /*
    统计dock栏中各个button收起侧边栏时数据统计
     */
    btCloseReport: function(id) {
		qqbrowser.extension.builtin.statistics.increase(this._dataReport[id][1]);
    }
};