/*
 * @author jingleyang@tencent.com
 * @description 地址栏控件的封装
 * @data 2011-06-23
 */


/**
 * @class addressbar 会在layout.js 中new出来
 *
 */
qqbrowser.js.widgets.addressbar = qqbrowser.js.base.Class(qqbrowser.js.widgets.widget, {
	className: "qqbrowser.js.widgets.addressbar",
	timer: null,
	input: null,
	toolbar: null,

	initialize: function(id) {
		var _this = this;
		this._element = document.createElement("div");
		this._element.setAttribute("id", id);

		var process = document.createElement("div");
		process.setAttribute("id", "address-process");
		process.setAttribute("class", "address-process");
		this._element.appendChild(process);


		this.input = document.createElement("input");
		this.input.setAttribute("id", "address-input");
		this.input.setAttribute("type", "text");
		this._element.appendChild(this.input);

		var rightbutton = document.createElement("div");
		rightbutton.setAttribute("id", "address-input-right-button");
		this._element.appendChild(rightbutton);
		var butlist = [
			"address-go-button",
			"address-fav-button",
			"engine-ie-button",
			"engine-webkit-button",
			"address-list-button"
		];
		addButMgr.init(butlist);

		for (var i = 0, len = butlist.length; i < len; i++) {
			var tmpdom = document.createElement("div");
			tmpdom.setAttribute("id", butlist[i]);
			tmpdom.setAttribute("class", "address-button");
			rightbutton.appendChild(tmpdom);
			// reg listener
			if ("engine-ie-button" == butlist[i] || "engine-webkit-button" == butlist[i]) {
				tmpdom.addEventListener('click', function(event) {
					var tabData = Skin.app.TabBar.instance.activeTab.data;
					var coreTypeNotify = tabData.coreTypeNotify;
					// 当前URL在强名单内，并且当前内核和推荐内核一致
					if (coreTypeNotify && coreTypeNotify.listType == LIST_TYPE.COMPULSORY && coreTypeNotify.coreType == tabData.engine) {
						var id = coreTypeNotify.coreType == 0 ? 'engine-ie-button' : 'engine-webkit-button';
						NotificationManager.create(tmpdom, 'ENGINE.COMPULSORY_CORE_TYPE', {pageId: Skin.app.TabBar.instance.activeTab.data.pageId});

						// 阻止其他的click事件（tipManager中click出现的Tooltip）的执行
						event.stopImmediatePropagation();
						// return false; // 无法阻止其他的click事件
						
						// 当前URL不在强名单内，或者当前内核和推荐内核不一致（当然允许用户直接切换回推荐内核了，因此不需要弹出通知）
					} else {
						// 隐藏任何内核切换通知（Notification）
						NotificationManager.destroyByGroup('ENGINE');
						addButMgr.coreSwitch();
						browser.extension.builtin.statistics.increase(STATIS_CMD_NAVBAR_BTN_CORE_SWITCH_CLICKED);
					}
				}, false);
			} else if ("address-go-button" == butlist[i]) {
				tmpdom.onclick = function() {
					addressbar.openUrl();
					addButMgr.hideAll();
					browser.extension.builtin.statistics.increase(STATIS_CMD_NAVBAR_BTN_GOTO_CLICKED);

				};
			} else if ("address-fav-button" == butlist[i]) {
				tmpdom.onclick = function() {
					qqbrowser.bookmark.getSyncState(function(syncStateId) {
						try {
							var temp = JSON.parse(syncStateId);
							var statID = temp[0];
							var cmd = {};
							var extIdBookmark;
							if (2 === statID) { // download err
								extIdBookmark = "{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}";
								cmd = {};
								cmd.command = "showNotify";
								cmd.status = "downloadTip";
								qqbrowser.extension.sendRequest(extIdBookmark, cmd, function() {});
							} else if (1 == statID) { // downloading
								extIdBookmark = "{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}";
								cmd = {};
								cmd.command = "showNotify";
								cmd.status = "downloadEdit";
								qqbrowser.extension.sendRequest(extIdBookmark, cmd, function() {});
							} else {
								if (window.loginState == 3) {
									qqbrowser.extension.sendRequest('{80944EE7-D5ED-46f6-86DF-53FCE8B945AB}', {
										command: 'BOOKMARK_READONLY_NOTIFICATION'
									}, function() {});
								} else {
									extIdBookmark = "{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}";
									cmd = {};
									cmd.command = "showAddFav";
									cmd.favID = -1;
									// 能够收藏时马上调整该按钮的样式
									tmpdom.setAttribute("fav", "");
									// TODO
									var favButton = document.getElementById("address-fav-button");
									var left = favButton.getBoundingClientRect().left + parseInt(favButton.offsetWidth / 2, 10);
									var top = favButton.getBoundingClientRect().bottom;
									var arrowRightDistance = qqbrowser.layout.addressbar._element.offsetWidth - favButton.offsetLeft - parseInt(favButton.offsetWidth / 2, 10) - 2;
									var tabData = Skin.app.TabBar.instance.activeTab.data;
									var url = ( !tabData.url || (tabData.url && tabData.url == '') ) ? qqbrowser.layout.addressbar.getAddress().url : tabData.url;
									var title = ( !tabData.title || (tabData.title && tabData.title == '') ) ? '新收藏' : tabData.title;
									qqbrowser.nativeBubble.bookmark.show(left, top, arrowRightDistance, tabData.isBookmarked, url, title);
								}
							}
						} catch (err) {
							qqbrowser.js.logic.utils.log("unpack err :[ " + err.message + " ]: " + syncStateId);
						}
					});
					browser.extension.builtin.statistics.increase(910901); //上报 收藏栏上的添加收藏按钮点击次数
				};
			} else if ("address-list-button" == butlist[i]) {
				tmpdom.onclick = function() {
					// tipManager
					if (!addressbar.isListShown()) {
						addressbar.showAddresslist();
						// statistics
					}
					addressbar.setFocus();
					browser.extension.builtin.statistics.increase(STATIS_CMD_NAVBAR_BTN_ADDR_LIST_CLICKED);

				};
			}
		}
		addressbar.init(this.input);
		addresslist.init();
		qqbrowser.js.widgets.widget.prototype.initialize.apply(this, [id]);
	},
	setAddress: function(para) {
		addressbar.setAddress(para.url);
		addressbar.setSelect(para);
	},
	getAddress: function() {
		return addressbar.getAddress();
	},
	setEngine: function(type) {
		addButMgr.setEngine(type);
	},
	setFavStatus: function(type) {
		var favStatusButton = document.getElementById('address-fav-button');
		if (type) {
			favStatusButton.setAttribute("fav", "");
		} else {
			favStatusButton.removeAttribute("fav");
		}
	},
	setEngineVisable: function(vis) {
		addButMgr.setEngineVisable(vis);
	}
});
/*
 * @class addressbar 是一个helper 类，控制了addressbar 的操作
 * */
var addressbar = {};

addressbar._isAddressbarActive = false; // 地址栏下拉需要的相关状态

addressbar._isAddressinputFocus = false; // 是否激活的状态

addressbar._selectionStart = 0;
addressbar._selectionEnd = 0;

addressbar._lastSelectedText = '';
addressbar._lastSelectedText = ''; // 上一次选中的内容

addressbar.timer = null;
addressbar.chsInput = true; //一开始默认处在中文输入状态下
addressbar._inputStatus = {search: false, text: '', url: '', lastInput: '', firstUrl: '', enter: false, needSetAddress: true};

addressbar._cleared = false;	//是否已经清理选中状态了。C++判断到皮肤失去焦点时，会通过CallBack回调到ClearSelectInfo;由于时序问题，可能addressinput的blur会在这之后调到，这次blur不应该改变选中状态

//added by yinzhou
//地址栏下拉提示页面只需获取一次，保存住，提高效率
var addressListPage = null;
addressbar.getAddressListPage = function() {
	if (addressListPage != null) {
		return addressListPage;
	}

	try {
		var pageList = qqbrowser.extension.getPages(qqbrowser.window.currentId(), ["addressbar"]);
		addressListPage = pageList[0];
	} catch (e) {
	}

	return addressListPage;
};
addressbar.isAddressInputLocked = false;
addressbar.pendingAddressInput = "";
addressbar.lock = function(isLock, addressInfo) {
	if (!isLock) {
		document.getElementById("address-input").value = addressbar.pendingAddressInput;
	} else {
		addressbar.pendingAddressInput = addressInfo ? addressInfo : document.getElementById("address-input").value;
		document.getElementById("address-input").value = "";
	}

	addressbar.isAddressInputLocked = isLock;
};
addressbar.setSelect = function(para) {
	$("#address-input").get(0).setSelectionRange(para.select_start, para.select_end);
};

/**
 * 初始化地址栏并响应键盘输入
 */
addressbar.setFocus = function() {
	$("#address-input").focus();
};
addressbar.init = function(input) {

	// added by yinzhou
	// 初始化作短暂延时后拿到地址栏下拉页面提高效率
	setTimeout("addressbar.getAddressListPage()", 300);

	var addressInput = $(input);


	addressInput.bind('focus', function() {
		// 如果地址栏已经focus，那么阻止重复选中的情况
		if (addressbar.isFocus()) {
			return;
		}
		addressbar._cleared = false;
		addressbar._isAddressinputFocus = true;
		addressbar._lastSelectedText = window.getSelection().toString();
		if (qqbrowser.layout.findbar.relAddressFocusFlag) { // 选中findbar之后再选中地址栏需要全选
			var inputValue = document.getElementById("address-input").value;
			addressInput.get(0).setSelectionRange(0, inputValue.length);
			qqbrowser.layout.findbar.relAddressFocusFlag = false;
		} else { // 维护原有的选中逻辑
			addressInput.get(0).setSelectionRange(addressbar._selectionStart, addressbar._selectionEnd);
		}

		/* 这是个疑问*/
		addressInput.one('mouseup', function(event) {
			event.preventDefault();
		});
	});

	addressInput.bind('keyup', function() {
		var chsInput = addressbar.chsInput;
		addressbar.chsInput = true;
		var enter = addressbar._inputStatus.enter;
		addressbar._inputStatus.enter = false;
		var search = addressbar._inputStatus.search;
		addressbar._inputStatus.search = false;

		// 上下键，改变default事件
		if (event.keyCode == 38 || event.keyCode == 40) {
			return false;
		}

		// 左右键不处理
		if (event.keyCode == 37 || event.keyCode == 39) {
			return;
		}

		// ESC键不处理
		if (event.keyCode == 27) {
			return;
		}

		if (($.trim(addressInput.val())) !== '') { // 输入不为空时

			url = addressInput.val();

			var text = url.replace(window.getSelection(), ''); // 这是真正输入的文本，url有可能是补全的结果

			var randomId = qqbrowser.js.logic.utils.randomInt(4); // 四位随机数，将被地址栏下拉菜单传回来进行比对

			// backspace&delete键，删除一个字符，并且调用inputchange
			if (event.keyCode == 8 || event.keyCode == 46) {
				if (text.length != url.length) { // 当没有选中任何文字时删除，不改变输入框内容
					addressInput.val(text);
				}

				randomId = 10000; // 传递给下层，下层返回结果时根据此不自动补全
			}

			if (event.keyCode == 13 && enter) { // 必须在地址栏一次完整的Enter down-up事件才导航


				// 选择addressList的选项时，在真正回车时进行数据上报
				if (addressbar.listIndex) {
					var index = 1010101 + parseInt(addressbar.listIndex, 10);
					browser.extension.builtin.statistics.increase(index);
					delete addressbar.listIndex;
				}

				browser.extension.builtin.statistics.increase(STATIS_ADDRBAR_RECOM_ENTER);
				// 如果search标志为真，调用搜索接口
				if (search) {
					addressbar.openUrl(url, 1, 1); // 1标识进行搜索
				}
				// 如果匹配结果第一项存在且涵盖当前的url，根据第一项结果导航
				else if (addressbar._inputStatus.firstUrl != '' && addressbar._inputStatus.firstUrl.indexOf(url) > -1) {
					addressbar.openUrl(addressbar._inputStatus.firstUrl);
				}
				// 打开网址
				else {
					addressbar.openUrl();
				}
				return;
			}

			// 输入没发生变化时无需匹配--yinzhou
			var currentInput = addressInput.val();
			if (currentInput == addressbar._inputStatus.lastInput) {
				return;
			}
			addressbar._inputStatus.lastInput = currentInput;

			addressbar.showGoButton(true); // 显示addressgo

			// modified by yinzhou
			// 延时100ms触发智能匹配，提高响应速度
			if (addressbar.timer != null) {
				clearTimeout(addressbar.timer);
			}
			
			text  = text.replace(/'/g,"\\'");
			text  = text.replace(/"/g,'\\"');
			addressbar.timer = setTimeout("addressbar.triggerInputChange('" + text + "'," + randomId.toString() + "," + chsInput + ")", 100);

		} else {
			$('#address').removeClass('dropdown');

			if (addressbar.timer != null) {
				clearTimeout(addressbar.timer);
			}

			if (addressbar._inputStatus.lastInput == '') {
				return;
			}
			addressbar._inputStatus.lastInput = '';

			addressbar.showGoButton(false);

			// modified by yinzhou
			// 隐藏下拉列表
			browser.skin.addressbar.adjustHeight(0);

		}

	});


	addressInput.bind('keydown', function() {

		var url = addressInput.val();
		var text = url.replace(window.getSelection(), '');

		// added by yinzhou
		// 所有的组合快捷键都在keydown里处理的，所有浏览器都如此，否则会有问题, 当前有：
		// ctrl + enter: 不全网址打开
		// alt + enter: 新窗口打开
		// shift + enter: 搜索关键词

		// ctrl + enter组合键补全网址并直接打开
		if (event.ctrlKey && event.keyCode == 13) {
			var url = "http://www." + $.trim(text) + ".com";
			addressInput.val(url);
			addressbar._inputStatus.lastInput = url;
			addressbar.openUrl(url);
			return false;
		}

		// alt + enter，新窗口打开
		if (event.altKey && event.keyCode == 13) {
			// 如果匹配结果第一项存在且涵盖当前的url，根据第一项结果导航
			if (addressbar._inputStatus.firstUrl != '' && addressbar._inputStatus.firstUrl.indexOf(url) > -1) {
				addressbar.openUrl(addressbar._inputStatus.firstUrl, 0);
			} else {
				addressbar.openUrl(url, 0);
			}
			return false;
		}

		// shift + enter，搜索关键词
		if (event.shiftKey && event.keyCode == 13) {
			addressbar.openUrl(text, 1, 1); // 1标识强制搜索
			return false;
		}

		if (event.keyCode === 9) { // 地址栏中按下Tab键后，将焦点设置给页面窗口并且清除选中状态
			qqbrowser.js.logic.viewManager.setFocus2Web();
			addressbar.cancelSelectedInput();
			event.preventDefault();
			return;
		}

		if (event.keyCode == 13) {
			addressbar._inputStatus.enter = true;
			// edit by littleli
			// 快速隐藏地址栏
			browser.skin.addressbar.adjustHeight(0);
		}

		// 当按下esc键时，将地址设为当前页面的地址并隐藏下拉列表
		if (event.keyCode == 27) {
			var tab = Skin.app.TabBar.instance.activeTab;

			var url = tab.data.url;
			addressbar.setAddress(url);
			addressbar.selectAllInput();
			browser.skin.addressbar.adjustHeight(0);
			if (url != '') {
				addButMgr.setEngineVisable(true);
			}
			return false;
		}

		if (addressbar.isListShown()) {
			// 上键
			if (event.keyCode == 38) {
				addressbar.selectUp();
				return false;
			}
			// 下键
			if (event.keyCode == 40) {
				addressbar.selectDown();
				return false;
			}
		}

		// added by yinzhou
		// 下拉列表没显示，用户按上下键时需显示下拉列表
		if (!addressbar.isListShown() && ((event.keyCode == 38) || (event.keyCode == 40))) {
			var url = addressInput.val();
			var text = url.replace(window.getSelection(), '');
			if (text != '') {
				addressbar.triggerInputChange(text, 0/*inputId*/, false); // 目前inputId没意义
			}
			else {
				addressbar.showAddresslist();
			}
		}
	});

	// 解决输入后每次匹配内容闪烁的问题
	addressInput.bind('keypress', function() {
		addressbar.chsInput = false;  //接收到此事件表明非中文输入
		var addressInput = $('#address-input');
		var inputChar = String.fromCharCode(event.keyCode);

		var currentSelectedText = window.getSelection().toString();
		var currentInputText = addressInput.val();

		var tobeSelectedIndex = currentInputText.length - currentSelectedText.length + 1;

		// 如果输入的为选中的第一个字符，改变选中状态，不进行下面的处理
		if (currentSelectedText.indexOf(inputChar) == 0) {
			addressInput.get(0).setSelectionRange(tobeSelectedIndex, tobeSelectedIndex + currentSelectedText.length);

			//added by yinzhou
			//输入新的字符必须触发新的匹配，只是此时地址栏内容不需要刷新
			addressbar._inputStatus.needSetAddress = false;

			// modified by yinzhou
			// 延时100ms触发智能匹配，提高响应速度
			if (addressbar.timer != null) {
				clearTimeout(addressbar.timer);
			}
			var text = currentInputText.substring(0, tobeSelectedIndex);
			var inputId = qqbrowser.js.logic.utils.randomInt(4);
			text  = text.replace(/'/g,"\\'");
			text  = text.replace(/"/g,'\\"');
			addressbar.timer = setTimeout("addressbar.triggerInputChange('" + text + "'," + inputId.toString() + "," + addressbar.chsInput + ")", 100);

			return false;
		}
	});

	addressInput.bind('mousedown', function() {
		event.stopPropagation();
	});

	addressInput.blur(function() {
		addressbar._isAddressbarActive = false;
		addressbar._isAddressinputFocus = false;


		if (!addressbar._cleared) {
			addressbar._selectionStart = addressInput.get(0).selectionStart;
			addressbar._selectionEnd = addressInput.get(0).selectionEnd;
		}
		// 会取消选中状态，但是会将焦点设置回地址栏（副作用）
		// 如果不注掉的话,搜索框会把焦点抢走导致没办法输入;
		addressbar.cancelSelectedInput();
	});
};


addressbar.popup = function() {
	var addressInput = $('#address');

	// 触发地址栏下拉列表事件
	var tmp_input = addressInput;
	var tmp_offset = tmp_input.offset();
	var addressListLeft = tmp_offset.left;
	var addressListTop = tmp_offset.top + tmp_input.outerHeight() + 1;
	var addressListWidth = qqbrowser.layout.addressbar._element.clientWidth + 3;
	browser.skin.addressbar.pop(addressListLeft, addressListTop, addressListWidth, 0); // 下拉条/triggerInputBegin时
};

addressbar.triggerInputChange = function(text, inputId, chsInput) {
	if (!addressbar.isListShown()) {
		addressbar.popup();
		browser.skin.addressbar.triggerInputBegin();
	}
	browser.skin.addressbar.triggerInputChange(text, inputId, chsInput);
};

addressbar.isFocus = function() {
	return addressbar._isAddressinputFocus;
};

addressbar.focus = function() {
	$('#address-input').focus();
};

addressbar.blur = function() {
	$('#address-input').blur();
};

addressbar.clearSelectionInfo = function() {
	addressbar._cleared = true;
	var url = $('#address-input').val();
	addressbar._selectionStart = url.length;
	addressbar._selectionEnd = url.length;
};


// 点击address list button时显示address list
addressbar.showAddresslist = function() {
	addressbar.popup();
	browser.skin.addressbar.triggerDroplistShowByClick(); // 另外一个接口
};

/**
 * 按上键，选择addresslist里的上一项
 */
addressbar.selectUp = function() {
	try {
		addressbar.getAddressListPage().executeScript("", "addressList.selectUp()");
	} catch (e) {
		//
	}
};

/**
 * 按下键，选择addresslist里的下一项
 */
addressbar.selectDown = function() {
	try {
		addressbar.getAddressListPage().executeScript("", "addressList.selectDown('select')");
	} catch (e) {

	}
};

/**
 * open a link when address input done
 */
addressbar.openUrl = function(url, type, search) {
	url = url ? unescape(url) : $.trim($('#address-input').val());
	type = (typeof type != 'undefined') ? type : 1;
	search = search ? search : 0;

	if (url && (url != '')) {
		browser.skin.addressbar.triggerInputAccept(url); // 下拉窗口消失
		browser.tabs.create(url, type, search); // call browser api
	}
};

/**
 * set url of addressbar
 */
addressbar.setAddress = function(url) {
	if (addressbar.isAddressInputLocked) {
		if (url != DEFAULT_SITE_URL && url != "") {
			addressbar.pendingAddressInput = url;
		} else {
			addressbar.pendingAddressInput = "";
		}
	} else {
		if (url == DEFAULT_SITE_URL) { // qb:home不显示
			url = '';
		}
		if (url == '') { // 切换tab时也需要判断是否显示text placeholder
			addressbar.showGoButton(false);
		}

		$('#address-input').val(decodeURI(url));
		addressbar._inputStatus.lastInput = url;
	}

};
addressbar.getAddress = function() {
	var tmp_input = $('#address-input');
	var ret = {
		url: tmp_input.val(),
		select_start: tmp_input[0].selectionStart,
		select_end: tmp_input[0].selectionEnd
	};
	return ret;
};
/**
 * 地址栏补全逻辑，地址栏下拉列表调用
 */
addressbar.fillAddress = function(url, type, firstUrl, index) {

	if (index != "NaN") {
		addressbar.listIndex = index;
	} else {
		if (addressbar.listIndex) {
			delete addressbar.listIndex;
		}
	}

	url = url ? unescape(url) : '';

	var addressInput = $('#address-input');

	if (url == 'qqbrowser:search') { // 判断是否选中下拉里的搜索项，置位
		addressbar._inputStatus.search = true;
		addressbar.setAddress(addressbar._inputStatus.text);
		return;
	} else {
		addressbar._inputStatus.search = false;
	}

	addressbar._inputStatus.firstUrl = firstUrl;

	// 拿到地址栏输入
	var text = ($.trim(addressInput.val())).replace(window.getSelection(), '');

	if (type == 'select') { // type为select时，地址栏value为传进来的url，并选择全部
		addressbar.setAddress(url);
		addressInput.get(0).setSelectionRange(0, url.length);
	} else if (type == 'input') { // 回到输入状态
		addressbar.setAddress(addressbar._inputStatus.url);
		addressInput.get(0).setSelectionRange(addressbar._inputStatus.text.length, addressbar._inputStatus.url.length);

	} else if (type == 'nomatch') {
		// 存储当前状态
		addressbar._inputStatus.text = text;
		addressbar._inputStatus.url = text;
	} else { // 否则，补全并选择后面的部分

		if (addressbar._inputStatus.needSetAddress) {
			var inputIndex = url.indexOf(text);
			if (inputIndex == 0) { // 当url以用户输入的text开头时，截取对应字符串，并设置高亮提示区
				addressbar.setAddress(url);
				addressInput.get(0).setSelectionRange(text.length, url.length);
			}
		}

		// 存储当前状态
		addressbar._inputStatus.text = text;
		addressbar._inputStatus.url = url;
	}

	addressbar._inputStatus.needSetAddress = true;
};

/**
 * 选择全部文字
 */
addressbar.selectAllInput = function() {
	var url = $('#address-input').val();
	//browser.log("selectAllInput url:" + url, "selectAllInput");
	$('#address-input').get(0).setSelectionRange(0, url.length);
	//browser.log("selectAllInput urllength:" + url.length, "selectAllInput");
	addressbar._selectionStart = 0;
	addressbar._selectionEnd = url.length;
};

/**
 * 不选择文字
 */
addressbar.cancelSelectedInput = function() {
	var url = $('#address-input').val();
	document.getElementById("address-input").value = url;
};

/**
 * 删除选中的文字
 */
addressbar.deleteSelectedInput = function() {
	// TODO 解决闪烁的问题
	var url = $('#address-input').val();
	var start = $('#address-input')[0].selectionStart;  // 选择范围的起始 index
	var end = $('#address-input')[0].selectionEnd;    // 选择范围的终止 index

	// 通过把被删除文字左边的子字符串和右边的子字符串拼接起来形成新的 URL
	url = url.slice(0, start) + url.slice(end);

	// 让地址栏显示新的 URL
	$('#address-input').val(url);

	// 设置新的选择范围
	$('#address-input')[0].setSelectionRange(start, start);
};

/**
 * 设置地址栏GO按钮
 * GO按钮和address-placeholder应该是互斥的两个button
 */
addressbar.showGoButton = function(isVisible, isViewSource) {
	if (isViewSource) { // 如果是查看源代码页面，不显示GoButton也不显示placeHolder
		$("#address-go-button").hide();
		return;
	}

	if (isVisible) {
		$("#address-go-button").show();
	} else {
		$("#address-go-button").hide();
	}
};


/**
 * 设置地址栏引擎按钮
 */
addressbar.showEngineButton = function(showButtonId) {
	var engineIEId = 'engine-ie-button';
	var engineWebkitId = 'engine-webkit-button';

	// hide all buttons
	$('#' + engineIEId).hide();
	$('#' + engineWebkitId).hide();

	$('#' + showButtonId).show();
};

// 地址栏下拉是否显示
addressbar._isListShown = false;

addressbar.setIsListShown = function(isListShown) {
	addressbar._isListShown = isListShown;

	// 地址栏边框的样式需要根据地址栏下拉是否显示决定
	if (isListShown) {
		$('#address').addClass('dropdown');
	} else {
		$('#address').removeClass('dropdown');
	}
};

// 当前一个状态是true，后一个状态是false时（由点击地址栏下拉按钮触发），认为地址栏下拉是显示状态
addressbar.isListShown = function() {
	return addressbar._isListShown;
};


// addresslist is a proxy in skin 
var addresslist = {
	listPage: null,
	init: function() {
		addresslist.getAddressListPage();
	},
	getAddressListPage: function() {
		var arr = qqbrowser.extension.getPages(qqbrowser.window.currentId(), ["addressbar"]);
		if (arr && arr.length > 0) {
			addresslist.listPage = arr[0];
		} else {
			console.info("get addressbar page failed");
		}
	}
};
var placeholder = {
	elem: null,
	init: function(_elem) {
		placeholder.elem = _elem;
	},
	hide: function() {
		$(placeholder.elem).hide();
	},
	show: function() {
		$(placeholder.elem).show();
	}
};
/*
 * @class addButMgr 是管理 内核图标等button的helper类
 * */
var addButMgr = {
	butlist: null,
	engineType: 0,
	init: function(_butlist) {
		addButMgr.butlist = _butlist;
	},
	hideAll: function() {
		$("#engine-ie-button, #engine-webkit-button, #address-go-button").hide();
	},
	onlyShow: function(strid) {
		addButMgr.hideAll();
		$("#" + strid).show();
	},
	setEngine: function(type) {
		addButMgr.engineType = type;
	},
	setEngineVisable: function(vis) {
		// type 0: IE, 1: Webkit, 2: hide for internal page
		var ie = $("#engine-ie-button");
		var webkit = $("#engine-webkit-button");
		var url = addressbar.getAddress().url;
		if ("" !== url) {
			addressbar.showGoButton(true);
		} else {
			addressbar.showGoButton(false);
		}
		//console.log(addressbar.getAddress().url);
		var reg = new RegExp("view-source:");//如果是查看源代码的页面直接不显示
		if (reg.exec(url)) {
			addressbar.showEngineButton();
			addressbar.showGoButton(false, true);
			return;
		}
		if (addButMgr.engineType <= 2) {
			ie.hide();
			webkit.hide();
			if (vis) {
				if (0 == addButMgr.engineType) {
					addressbar.showEngineButton("engine-ie-button");
				} else if (1 == addButMgr.engineType) {
					addressbar.showEngineButton("engine-webkit-button");
				}
			}
		}

	},
	coreSwitch: function() {
		browser.tabs.coreSwitch();
	}
};
