 	/*if( typeof(browser) != "undefined"){
    browser.log("littlestart+Utils+top");
  }*/
//browser.log("littlestart+utils");
qqbrowser.js = qqbrowser.js || {};
qqbrowser.js.tools = qqbrowser.js.tools || {};
qqbrowser.js.tools.utils = qqbrowser.js.tools.utils || {};

/**
 * 对html字符进行实体转义
 */
qqbrowser.js.tools.utils.encodeHtml = function(text) {
	/*
	 * modified by littleli
	 * 解决$符号encode的问题，应该不需要对&符号进行转义的
	 */
	return text ? text.replace(/\</ig, "&lt;").replace(/\>/ig, "&gt;") : '';
};

/**
 * 从url中解析参数
 */
qqbrowser.js.tools.utils.parseUrl = function() {
	var url = location.href;
	var item = [];
	var result = {};
	var query = url.substr(url.indexOf("?") + 1);
	var tmp = query.split("&");
	
	for (var i = 0; i < tmp.length; i++) {
		item = tmp[i].split("=");
		result[item[0]] = item[1];
	}
	return result;
};

/**
 * 从css的px值中得到数字
 */
qqbrowser.js.tools.utils.fromPx2Int = function(text) {
	if (!text) {
		return 0;
	}
		
	return parseInt(text.replace("px", ""));
};

/**
 * 得到随机的需要长度的数字
 */
qqbrowser.js.tools.utils.randomInt = function(length) {
	if (length <= 0) {
		return;
	}
	
	var number = 0;
	while (number < Math.pow(10, length - 1)) {
		number = Math.floor(Math.random() * Math.pow(10, length));
	}
	return number;
};

String.prototype.replaceAll = function(AFindText, ARepText) {
	return this.replace(new RegExp(AFindText, "gm"), ARepText);
};

qqbrowser.js.tools.utils.log = function(msg){
	try{
		qqbrowser.log.info(msg);
	}catch(err){
	}finally{
		console.info("utils_log: "+msg);
	}
};

// get qqbrowser api return string , return a array 
qqbrowser.js.tools.utils.unpack = function(jsonstr){
	var ret={};
	try{
		 ret = JSON.parse(jsonstr);
	}catch(err){
		qqbrowser.js.tools.utils.log("unpack err :[ "+err.message+" ]: "+jsonstr);
	}
	return ret;
};

/** 
 * JSON.parse 函数用来对字符串进行反转义的回调函数。
 * 浏览器内部使用了 KVData 类型来存储数据，qqbrowser api 回调前端 js 函数时，
 * 传入的参数是一个 json 字符串，该字符串表示一个只有一个元素的数组，而数组元素
 * 是一个对象，对象的字符串类型的属性的值都被进行了转义，所以在把该 json 字符串
 * 转换为我们需要的对象时，需要对其进行反转义。
 * json 字符串的示例如下：
 * [{"type":"file","path":"C:%5CProgram%20Files%5Cabc.txt"}]
 * @param {string} key 对象的属性
 * @param value 对应属性的值
 * @returns {string} 反转义后的字符串值
 */
qqbrowser.js.tools.utils.jsonParseFilter = function(key, value) {
    if (typeof value == "string") {
        return unescape(value);
    } else {
        return value;
    }
};

/**
 * 为dom元素设置class
 */
qqbrowser.js.tools.utils.setClass = function(elementName, newClass) {
	var element = (typeof(elementName) === "string") ? document.getElementById(elementName) : elementName;
	element.setAttribute("class", newClass);
};

/**
 * 为dom元素添加class
 */
qqbrowser.js.tools.utils.addClass = function(elementName, newClass) {
	var element = (typeof(elementName) === "string") ? document.getElementById(elementName) : elementName;
	var oldClass = element.getAttribute("class");
	if (null !== oldClass) { 
		var oldClassArray = oldClass.split(" ");
		for (var i = 0; i < oldClassArray.length; i++) {
			if ( newClass === oldClassArray[i]) {
				return;
			}
		}
		element.setAttribute("class", element.getAttribute("class") + " "  + newClass);
	} else {
		element.setAttribute("class", newClass);
	}
};


/**
 * 为dom元素删除class
 */
qqbrowser.js.tools.utils.removeClass = function(elementName, classToRemove) {
		var element = (typeof(elementName) === "string") ? document.getElementById(elementName) : elementName;
		var attrClass = element.getAttribute("class");
		var classes = attrClass.split(" ");
        var len = classes.length;
		for (var i = 0; i < len; i++) {
			if (classes[i] === classToRemove || classes[i] === "") {
				delete classes[i];
                len--;
			}
		}
        len = len>0?len:0;
        classes.length = len;
		element.setAttribute("class", classes.join(" "));
};

/**
 * 判断dom元素是否拥有某个style属性
 */
qqbrowser.js.tools.utils.hasClass = function(elementName, className) {
	var element = (typeof(elementName) === "string") ? document.getElementById(elementName) : elementName;
    var totalClassName = element.getAttribute("class");
    if (totalClassName) {
        totalClassNameArray = totalClassName.split(" ");
        for (var i = 0; i < totalClassNameArray.length; i++) {
            if (totalClassNameArray[i] === className) {
                return true;
            }
        }
    }
    return false;
};

