qqbrowser.js = qqbrowser.js || {};
qqbrowser.js.logic = qqbrowser.js.logic || {};
qqbrowser.js.logic.viewManager = qqbrowser.js.logic.viewManager || {};
 /*	if( typeof(browser) != "undefined"){
    browser.log("littlestart+viewManager+top");
  }*/
//browser.log("littlestart+viewManager");
/**
 * 获取元素的ComputedStyle
 */
qqbrowser.js.logic.viewManager.getElementCssStyle = function(elementName, attr) {
    // 判断是元素的id还是元素本身并返回元素
    var element = (typeof elementName === "string") ? document
            .getElementById(elementName) : elementName;
    var elementStyle = document.defaultView.getComputedStyle(element, null);

    return elementStyle.getPropertyValue(attr);
};

/**
 * 获取元素的borderwidth
 */
qqbrowser.js.logic.viewManager.getBorderWidth = function(elementName) {

    var utils = qqbrowser.js.logic.utils;
    // 直接传递DOM元素或者元素名
    var element = (typeof(elementName) === "string") ? document
            .getElementById(elementName) : elementName;

    // 获取元素的四个边框宽度
    var borderLeft = utils.fromPx2Int(this.getElementCssStyle(element,
            "border-left-width"));
    var borderTop = utils.fromPx2Int(this.getElementCssStyle(element,
            "border-top-width"));
    var borderBottom = utils.fromPx2Int(this.getElementCssStyle(element,
            "border-bottom-width"));
    var borderRight = utils.fromPx2Int(this.getElementCssStyle(element,
            "border-right-width"));

    return {
        "left" : borderLeft,
        "top" : borderTop,
        "bottom" : borderBottom,
        "right" : borderRight
    };
};

/**
 * 获取元素的margin
 */
qqbrowser.js.logic.viewManager.getMargin = function(elementName) {

    var utils = qqbrowser.js.logic.utils;
    // 直接传递DOM元素或者元素名
    var element = (typeof(elementName) === "string") ? document
            .getElementById(elementName) : elementName;

    // 获取元素的四个margin
    var marginLeft = utils.fromPx2Int(this.getElementCssStyle(element,
            "margin-left"));
    var marginTop = utils.fromPx2Int(this.getElementCssStyle(element,
            "margin-top"));
    var marginBottom = utils.fromPx2Int(this.getElementCssStyle(element,
            "margin-bottom"));
    var marginRight = utils.fromPx2Int(this.getElementCssStyle(element,
            "margin-right"));

    return {
        "left" : marginLeft,
        "top" : marginTop,
        "bottom" : marginBottom,
        "right" : marginRight
    };
};

/**
 * 获取元素的padding
 */
qqbrowser.js.logic.viewManager.getPadding = function(elementName) {

    var utils = qqbrowser.js.logic.utils;
    // 直接传递DOM元素或者元素名
    var element = (typeof(elementName) === "string") ? document
            .getElementById(elementName) : elementName;

    // 获取元素的四个margin
    var paddingLeft = utils.fromPx2Int(this.getElementCssStyle(element,
            "padding-left"));
    var paddingTop = utils.fromPx2Int(this.getElementCssStyle(element,
            "padding-top"));
    var paddingBottom = utils.fromPx2Int(this.getElementCssStyle(element,
            "padding-bottom"));
    var paddingRight = utils.fromPx2Int(this.getElementCssStyle(element,
            "padding-right"));

    return {
        "left" : paddingLeft,
        "top" : paddingTop,
        "bottom" : paddingBottom,
        "right" : paddingRight
    };
};

/**
 * 去掉border的offset
 */
qqbrowser.js.logic.viewManager.getInnerOffset = function(elementName) {

    // 直接传递DOM元素或者元素名
    var element = (typeof(elementName) === "string") ? document
            .getElementById(elementName) : elementName;

    var offsetLeft = element.offsetLeft;
    var offsetTop = element.offsetTop;

    var borderWidth = qqbrowser.js.logic.viewManager
            .getBorderWidth(elementName);
    var borderLeft = borderWidth.left;
    var borderTop = borderWidth.top;

    return {
        "left" : offsetLeft + borderLeft,
        "top" : offsetTop + borderTop
    };
    // 计算box shadow的高度
};

/**
 * 获得button左下角坐标
 */
qqbrowser.js.logic.viewManager.getMenuLeftBottom = function(button) {
    var buttonLeft = button.offsetLeft;
    var buttonBottom = button.offsetTop + button.offsetHeight;

    return {
        left : buttonLeft,
        top : buttonBottom
    };
};

qqbrowser.js.logic.viewManager.getSkinBorderWidth = function() {
    // border以main-pagebar的两边为准
    var pagebar = qqbrowser.layout.basic.pagebar;
    return pagebar.offsetLeft;
};

/**
 * 针对 border + box shadow 提供统一解决方案
 */
qqbrowser.js.logic.viewManager.getSize = function(elementName) {
    var element = typeof elementName == 'string' ? $('#' + elementName) : elementName; // 可以直接传递 jQuery 对象
    var innerHeight = element.outerHeight();
    var innerWidth = element.outerWidth();

    // 计算 box shadow 的高度
    var elementShadow = element.css('-webkit-box-shadow');
    var regex = /(\dpx)\s(\dpx)\s(\dpx)/;

    var elementShadowOffsetX = elementShadowOffsetY = elementSize = 0;

    if (regex.test(elementShadow)) {
        elementShadowOffsetX = qqbrowser.js.logic.utils.fromPx2Int(RegExp["$1"]);
        elementShadowOffsetY = qqbrowser.js.logic.utils.fromPx2Int(RegExp["$2"]);
        elementSize = qqbrowser.js.logic.utils.fromPx2Int(RegExp["$3"]);
    }

    return {
        width:  innerWidth  + elementShadowOffsetX + elementSize,
        height: innerHeight + elementShadowOffsetY + elementSize
    };
};

/**
 * 根据当前tab状态切换go、forward表现 如果可用，setButtonPressed；不可用，取消button pressed事件
 */
qqbrowser.js.logic.viewManager.setBackAndForwardButtonStatus = function(pageId) {
	var tabBar = Skin.app.TabBar.instance,
			tab = tabBar.getTabByData( 'pageId', pageId ) || {},
			tabData = tab.data || {};

    // 如果当前按钮可以后退，设置样式和事件
    if (tabData.back === true) {
        qqbrowser.layout.backButton.enable();
        qqbrowser.js.logic.eventManager.bindBackButton();

    } else {
        qqbrowser.layout.backButton.disable();
    }

    // 如果当前按钮可以前进，设置样式和事件
    if ( tabData.forward === true) {
        qqbrowser.layout.forwardButton.enable();
        qqbrowser.js.logic.eventManager.bindForwardButton();
    } else {
        qqbrowser.layout.forwardButton.disable();
    }
};

/**
 * 设置状态栏显示页面状态
 */
qqbrowser.js.logic.viewManager.setPageStatus = function(pageId, status, url) {
   	var tab = Skin.app.TabBar.instance.getTabByData('pageId', pageId), tabData;

	if ( tab ) {
		tabData = tab.data;
	} else {
		return;
	}

	tabData.status = status;

    if (typeof(url) !== "undefined" && url !== "") {
		tabData.url = url;
    }

    if ( tabData.isActive ) { // 如果是当前tab，直接显示
        qqbrowser.js.logic.viewManager.showPageStatus(pageId);
    }
};
/**
 * 显示状态栏状态
 */
qqbrowser.js.logic.viewManager.showPageStatus = function(pageId) {
	var tabData = Skin.app.TabBar.instance.getTabByData( 'pageId', pageId ).data,
		status = tabData.status,
		url = tabData.url;


    if (url.length >= 26) { // 只取前26位的字符
        url = url.substr(0, 26) + '...';
    }

    if (status) {
        var statusMap = {
            "loadbefore" : "正在发送请求",
            "loading" : "正在等待%host%返回数据",
            "loaderror" : "网页有错误",
            "loadend" : "完成"
        };
        
        var statusbarStatusImage = document.getElementById("statusbar-status-image");
        statusbarStatusImage.setClass(status);
        
        var text = statusMap[status];
        if (status === "loading") {
            text = text.replace('%host%', url);
        }

        if ( tabData.isActive ) {
    		if (tabData.error) {
    			statusbarStatusImage.setClass("loaderror");
    		}
           
            if (tabData.scripterror) {
        	    statusbarStatusImage.setClass("scripterror");
            }
            if (text !== undefined) {
                if (tabData.url.indexOf("qzone")> -1){
                    text = text + " - 已加速";
                }
        	   qqbrowser.js.logic.viewManager.setStatusText(text);
            }
        }
    }
};

qqbrowser.js.logic.viewManager.setStatusUrl = function(url) {
    // var statusbarStatusImage = $('#statusbar-status-image');
    // if(statusbarStatusImage.is('.updating') ||
    // statusbarStatusImage.is('.updateerror')) { // 正在升级时不显示
    // return;
    // }
	//browser.log("setStatusUrl", "url:" + url);
    qqbrowser.js.logic.viewManager.setStatusText(url);
};

/**
 * 设置状态栏显示文字
 */
qqbrowser.js.logic.isStatusTextLocked = false;
qqbrowser.js.logic.pendingStatusText = "";
qqbrowser.js.logic.viewManager.setStatusText = function(text) {
    if(qqbrowser.js.logic.isStatusTextLocked) {
        qqbrowser.js.logic.pendingStatusText = text;
    } else {
        document.getElementById("statusbar-status-text").innerText = text;
    }
};

qqbrowser.js.logic.viewManager.lock = function(lockOrUnlock) {
    // true: lock, false: unlock
    if(!lockOrUnlock) {
        document.getElementById("statusbar-status-text").innerText = qqbrowser.js.logic.pendingStatusText;
    } else {
        qqbrowser.js.logic.pendingStatusText = document.getElementById("statusbar-status-text").innerText;
        document.getElementById("statusbar-status-text").innerText = "";
    }

    qqbrowser.js.logic.isStatusTextLocked = lockOrUnlock;
};
/*
1 lock
2 timer: 200ms 100ms
3 timer - has tab - set timer
4 unlock*/

/**
 * 设置最大化/还原时的页面布局
 */
qqbrowser.js.logic.viewManager.toggleMaxAndRestoreView = function(isMaximized) {
    // 若状态未改变，则直接返回
    if (this.isMaximized === isMaximized) {
        return;
    }

    this.isMaximized = isMaximized;
    
    var mainElement = document.getElementById("main");
 
    if (isMaximized ) {
    	mainElement.addClass("maximized");
    	
        if (qqbrowser.window && qqbrowser.window.multiAccount(browser.window.currentId())) {
        	qqbrowser.layout.basic.tabbar.addClass("multiAccount");
        }
    } else {
    	mainElement.removeClass("maximized");
    }
    qqbrowser.js.logic.layoutManager.resize();
   
};

/* 登录动画相关的代码 */
qqbrowser.js.logic.viewManager.loadIntervalId = -1;
qqbrowser.js.logic.viewManager.startLoginAnimation = function() {
    if (this.loadIntervalId != -1) {
        clearInterval(this.loadIntervalId);
        this.loadIntervalId = -1;
    }

    var imageIndex = 0;
    this.loadIntervalId = setInterval(function() {
        var logoButton = qqbrowser.layout.logoButton._element;
        var imageDir = "images/logo-button/";
        var filename = "login_loading_48.png";

        logoButton.style.backgroundImage = "url(" + imageDir + filename + ")";
        logoButton.style.backgroundSize = "auto";
		logoButton.style.backgroundPosition = ["0px",imageIndex*(-48)+"px"].join(" ");
        imageIndex = (imageIndex + 1) % 69;
        // console.info("正在登录 " + imageIndex + "...");
    }, 30);
};

qqbrowser.js.logic.viewManager.stopLoginAnimation = function() {
    clearInterval(this.loadIntervalId);
    this.loadIntervalId = -1;
};

qqbrowser.js.logic.viewManager.setFocus = function(url, type){
	if(url === DEFAULT_SITE_URL || url === BLANK_PAGE_URL || url === "") {
		if (addressbar.isFocus() && qqbrowser.js.logic.skinActivated) {
			if(url === BLANK_PAGE_URL) {
				addressbar.selectAllInput();
			}
		}

		qqbrowser.js.logic.viewManager.setFocus2Skin();
		addressbar.selectAllInput();
	} else {
		qqbrowser.js.logic.viewManager.setFocus2Web();	
	}
};

qqbrowser.js.logic.viewManager.currentFocus = null;

qqbrowser.js.logic.viewManager.setFocus2Skin = function(element) {
	this.currentFocus = "skin";
	browser.skin.window.setFocus();
 
	// 默认将焦点地址栏
	if (element !== undefined) {
		
		element.focus();
	} else {
		// 模拟一个mouseup事件，以解决地址栏光标不闪烁的问题
		$("#address-input").mouseup();	
		addressbar.focus();
		
	}
};

qqbrowser.js.logic.viewManager.setFocus2Web = function() {
	qqbrowser.js.logic.viewManager.currentFocus = "page";
	// console.info("setFocus2Web");
	browser.skin.window.setFocusToWeb();
};


/**
 * 判断是否aero，设置背景
 */
qqbrowser.js.logic.viewManager.setAero = function(isAero) {
	var mainElement = document.getElementById("main");
    var body = document.body;
	if(isAero) { // aero
		mainElement.addClass("aero");
        body.addClass("setAero");
		qqbrowser.js.logic.viewManager.setTabAero(isAero);
	} else {
		if (mainElement.hasClass("aero")) {
			mainElement.removeClass("aero");
		}
        if(body.hasClass("setAero")){
            body.removeClass("setAero");
        }
		qqbrowser.js.logic.viewManager.setTabAero(isAero);
	}
};

/**
 * 统一设置tab的aero效果
 */
qqbrowser.js.logic.viewManager.setTabAero = function(isAero) {
	var tabBar = Skin.app.TabBar.instance,
		addTabButton = tabBar.addTabButton,
		i, len = tabBar.length;
	
	if (isAero) {
		for ( i = 0; i < len; i++) {
			tabBar[ i ].element.addClass("aero");
		}
		addTabButton.addClass("aero");
	} else {
		for ( i = 0; i < len; i++) {
			tabBar[ i ].element.removeClass("aero");
		}
		if (addTabButton.hasClass("aero")) {
			addTabButton.removeClass("aero");
		}
	}
};
