/**
 * tip manager
 * @author sunnyjiang
 * @version 1.0
 */
qqbrowser.js.logic.tipManager = {};
/*if( typeof(browser) != "undefined"){
 browser.log("littlestart+tipManager+top");
 }*/
qqbrowser.js.logic.tipManager.tooltipId = null;
qqbrowser.js.logic.tipManager.enabled = true;

qqbrowser.js.logic.tipManager.init = function() {
	/*  	if( typeof(browser) != "undefined"){
	 browser.log("littlestart+tipManager+begin");
	 }*/
	qqbrowser.js.logic.tipManager.bindMouseOver();

	qqbrowser.js.logic.tipManager.bindClick();
	/*  	if( typeof(browser) != "undefined"){
	 browser.log("littlestart+tipManager+end");
	 }*/
};

qqbrowser.js.logic.tipManager.timer = null;

// 事件绑定
qqbrowser.js.logic.tipManager.bind = function(elementId, eventType) {

	var element = $('#' + elementId);
	element.bind(eventType, function() {
		// 清除之前的tips显示
		clearTimeout(qqbrowser.js.logic.tipManager.timer);

		if (eventType == 'mouseover') {
			// 延时显示tips
			qqbrowser.js.logic.tipManager.timer = setTimeout('qqbrowser.js.logic.tipManager.showTip("' + elementId + '", "' + eventType + '")', 500);
		} else {
			qqbrowser.js.logic.tipManager.showTip(elementId, eventType);
		}
	});
};

// TODO refactoring
// 控制tooltip显示
qqbrowser.js.logic.tipManager.showTip = function(elementId, eventType, tooltipType, tabTitle, pageX, pageY, elementWidth, elementHeight) {
	try {
		var element;
		// 兼容新版tabBar
		if ( elementId && elementId.nodeType ) {
			element = $( elementId );
			elementId = element.attr('id') || element.attr('class') || '';
		} else {
			element = $('#' + elementId).length > 0 ? $('#' + elementId) : $('.' + elementId);
		}

		var tipsOffset = 4;
		var offset = {};
		var height = 0;
		var width = 0;

		var title = '';
		var content = '';
		var type = '';
		var url = '';

		var trackRect = {};
		var popRect = {};

		var tabBar = Skin.app.TabBar.instance, tab;

		if (tooltipType == 'closeTabButtonTooltip') { // tab close button
			var activeTab = tabBar.activeTab;

			title = activeTab.element[0] === element[0] ? "关闭当前页" : "关闭";
			offset = element.offset();
			height = element.outerHeight();
			width = element.outerWidth();
			tipsOffset = 5;
			trackRect = {topLeftX: offset.left, topLeftY: offset.top, bottomRightX: offset.left + width, bottomRightY: offset.top + height};
			popRect = {'topLeftX': offset.left + tipsOffset, 'topLeftY': offset.top - tipsOffset, 'bottomRightX': offset.left + width + tipsOffset, 'bottomRightY': offset.top + height + tipsOffset};
		} else if (tooltipType == 'tabTooltip') { // tab上显示title时
			tipsOffset = 5;
			var titleElement = element.find('.title');
			if (titleElement.width() == titleElement.get(0).scrollWidth) { // 未压缩时不显示tooltip
				return;
			}
			content = tabTitle;

			height = 24;
			width = 24;
			offset = {left: pageX - tipsOffset, top: pageY - tipsOffset};

			// 鼠标在此范围内，tooltip弹出，鼠标在此范围之内，tooltip不消失
			// 控制是否弹出
			trackRect = {topLeftX: element.offset().left, topLeftY: element.offset().top, bottomRightX: element.offset().left + element.width(), bottomRightY: element.offset().top + element.height()};
		} else if (tooltipType == 'favTooltip') {
			content = tabTitle;
			url = element.attr('url');

			height = 24;
			width = 24;
			offset = {left: pageX - tipsOffset, top: pageY - tipsOffset};

			trackRect = {topLeftX: element.offset().left, topLeftY: element.offset().top, bottomRightX: element.offset().left + element.width(), bottomRightY: element.offset().top + element.height()};
		} else if (tooltipType === "qzoneButtonTooltip") {
			var friendCount = qqbrowser.js.logic.tipManager.friendCount,
					qzoneCount = qqbrowser.js.logic.tipManager.qzoneCount;
			if (friendCount + qzoneCount > 0) {
				title = "QQ空间信息中心";

				if (friendCount > 10) {
					url = "好友动态(" + 10 + "+" + ")";
				} else if (friendCount > 0) {
					url = "好友动态(" + friendCount + ")";
				}
				if (qzoneCount > 10) {
					content = "我的空间动态(" + 10 + "+" + ")";
				} else if (qzoneCount > 0) {
					content = "我的空间动态(" + qzoneCount + ")";
				}
			} else {
				content = tabTitle;
			}

			height = element.outerHeight();
			width = element.outerWidth();

			offset = element.offset();

			//trackRect = {topLeftX: element.offset().left, topLeftY: element.offset().top, bottomRightX: element.offset().left + element.width(), bottomRightY: element.offset().top + element.height()};
			trackRect = {topLeftX: offset.left, topLeftY: offset.top, bottomRightX: offset.left + width, bottomRightY: offset.top + height};
			popRect = {'topLeftX': offset.left + tipsOffset, 'topLeftY': offset.top - tipsOffset, 'bottomRightX': offset.left + width + tipsOffset, 'bottomRightY': offset.top + height + tipsOffset};
		} else if (tooltipType === "downloadButtonTooltip") {

			title = tabTitle;
			if (qqbrowser.js.logic.downloadManager && qqbrowser.js.logic.downloadManager.downloadingTaskCount > 0) {
				url = qqbrowser.js.logic.downloadManager.downloadingTaskCount + '个任务正在下载';
			}

			offset = element.offset();
			height = element.outerHeight();
			width = element.outerWidth();
			trackRect = {topLeftX: offset.left, topLeftY: offset.top, bottomRightX: offset.left + width, bottomRightY: offset.top + height};
			popRect = {'topLeftX': offset.left + tipsOffset, 'topLeftY': offset.top - tipsOffset, 'bottomRightX': offset.left + width + tipsOffset, 'bottomRightY': offset.top + height + tipsOffset};
		} else if (tooltipType === "soundControlButtonTooltip") {
			title = tabTitle;
			offset = element.offset();
			height = element.outerHeight();
			width = element.outerWidth();
			trackRect = {topLeftX: offset.left, topLeftY: offset.top, bottomRightX: offset.left + width, bottomRightY: offset.top + height};
			popRect = {'topLeftX': offset.left + tipsOffset, 'topLeftY': offset.top - tipsOffset, 'bottomRightX': offset.left + width + tipsOffset, 'bottomRightY': offset.top + height + tipsOffset};
		} else if (tooltipType === "addressFavButtonTooltip") {
			title = tabTitle;
			offset = element.offset();
			height = element.outerHeight();
			width = element.outerWidth();
			trackRect = {topLeftX: offset.left, topLeftY: offset.top, bottomRightX: offset.left + width, bottomRightY: offset.top + height};
			popRect = {'topLeftX': offset.left + tipsOffset, 'topLeftY': offset.top - tipsOffset, 'bottomRightX': offset.left + width + tipsOffset, 'bottomRightY': offset.top + height + tipsOffset};
		/*
		} else if (tooltipType === 'login') {
			title = '登录QQ账号';
			
			offset = element.offset();
			height = element.outerHeight();
			width = element.outerWidth();
			trackRect = {topLeftX: offset.left, topLeftY: offset.top, bottomRightX: offset.left + width, bottomRightY: offset.top + height};
			popRect = {'topLeftX': offset.left + tipsOffset, 'topLeftY': offset.top - tipsOffset, 'bottomRightX': offset.left + width + tipsOffset, 'bottomRightY': offset.top + height + tipsOffset};
		*/
		} else {
			var tipsData = qqbrowser.js.logic.tipManager.data[elementId][eventType];

			title = tipsData.constructor == window.Array ? tipsData[0] : '';
			content = tipsData.constructor == window.Array ? tipsData[1] : tipsData;

			type = tipsData.constructor == window.Array ? (tipsData[2] ? tipsData[2] : '') : ''; // 区分两种tooltip类型

			offset = element.offset();
			height = element.outerHeight();
			width = element.outerWidth();

			trackRect = {topLeftX: offset.left, topLeftY: offset.top, bottomRightX: offset.left + width, bottomRightY: offset.top + height};
			popRect = {'topLeftX': offset.left + tipsOffset, 'topLeftY': offset.top - tipsOffset, 'bottomRightX': offset.left + width + tipsOffset, 'bottomRightY': offset.top + height + tipsOffset};
		}
		// 对content进行HTML实体转义
		//var entityTransfer = document.createElement("div");
		//entityTransfer.innerHTML = content;
		//content = entityTransfer.innerText;
		var params = {'title': title, 'content': content, 'type': type, 'url': url};
		// 控制tooltip弹出位置，tooltip会在此区域外弹出
		// 控制弹出的位置

		// TODO 应该修改engine button的实现逻辑，统一为一个按钮
		if (eventType == 'click') { // 防止另外按钮的mouseover盖住click的tips，取消绑定，下面会重新绑定
			qqbrowser.js.logic.tipManager.unbindEngineMouseOver();
		}
		
		// 要enabled时才能弹出
		if (qqbrowser.js.logic.tipManager.enabled) { 
			qqbrowser.js.logic.tipManager.tooltipId = qqbrowser.tooltip.create(qqbrowser.window.currentId(), popRect, trackRect, params, function() {
			});
		}
	

		// 如果没有click tips, click时应该让tips消失
		if (eventType != 'click' && qqbrowser.js.logic.tipManager.data.hasOwnProperty(elementId) && !qqbrowser.js.logic.tipManager.data[elementId]['click']) {
			$(this).one('click', function() {
				qqbrowser.tooltip.destroy(qqbrowser.js.logic.tipManager.tooltipId);
			});
		}

		if (eventType == 'click') {
			setTimeout("qqbrowser.tooltip.destroy(" + qqbrowser.js.logic.tipManager.tooltipId + "); qqbrowser.js.logic.tipManager.bindEngineMouseOver()", 5000);
		}

	}
	catch (e) {
		console.log(e.stack);
	}
};

qqbrowser.js.logic.tipManager.data = {
	'sysmenu-skinbutton': {
		'mouseover': '更换主题'
	},
	'sysmenu-supportbutton': {
		'mouseover': '反馈建议'
	},
	'sysmenu-mainbutton': {
		'mouseover': '主菜单'
	},
	'sysmenu-minimizebutton': {
		'mouseover': '最小化'
	},
	'sysmenu-maximizebutton': {
		'mouseover': '最大化'
	},
	'sysmenu-restorebutton': {
		'mouseover': '还原'
	},
	'sysmenu-closebutton': {
		'mouseover': '关闭'
	},
	'back-button': {
		'mouseover': '后退'
	},
	'forward-button': {
		'mouseover': '前进'
	},
	'undo-button': {
		'mouseover': '恢复最近关闭页面'
	},
	'undolist-button': {
		'mouseover': '恢复最近关闭页面'
	},
	'home-button': {
		'mouseover': '主页'
	},
	'fav-button': {
		'mouseover': '收藏'
	},
	'refresh-button': {
		'mouseover': '刷新'
	},
	'toolbar-stop-load-button': {
		'mouseover': '停止加载'
	},
	'address-go-button': {
		'mouseover': '转到'
	},
	'engine-ie-button': {
		'click': ['', '已切换至极速模式，如浏览过程出现异常，尝试<br />恢复兼容模式', 'l'], // l表示为large格式
		'mouseover': ['', '当前为：<strong>兼容模式</strong><br>对网银等只支持IE的网站，兼容性更好', 'l']//这些后期还得改回来
	},
	'engine-webkit-button': {
		'click': ['', '已切换至兼容模式', 'l'],
		'mouseover': ['', '当前为：<strong>极速模式</strong><br>访问网站速度更快', 'l']
	},
	'clean-button': {
		'mouseover': '清理浏览痕迹'
	},
	'printscreen-button': {
		'mouseover': '网页截屏，分享图片到空间'
	},
	'usefulmenu-button': {
		'mouseover': '常用菜单'
	},
	'appbox-button': {
		'mouseover': '上空间，玩微博，看股票...'
	},
	/*'sidebar-hide-button': {
	 'mouseover': '侧边栏收起'
	 },*/
	'statusbar-zoom-button-container': {
		'mouseover': '网页缩放'
	},
	'statusbar-popup-block-button': {
		'mouseover': '弹窗拦截'
	},
	'address-list-button': {
		'mouseover': '存放已经打开过的网址列表，点击后可以直接打开网址无需输入。'
	},
	'add-tab-button':{
		'mouseover': '新标签页'
	},
	'statusbar-foreground-button':{
		'mouseover': '新链接在前台打开'
	},
	'statusbar-background-button':{
		'mouseover': '新链接在后台打开'
	},
	"statusbar-farmAlarm-button": {
		"mouseover": "定时收菜提醒，不怕菜被偷"
	},
	"statusbar-safeTip-button": {
		"mouseover": "安全提示"
	},
	"statusbar-cloud-dict": {
		'mouseover': "快速翻译英文"
	},
	'sidebar-qzone-button':{
		'mouseover': 'QQ空间'
	},
	'sidebar-stock-button':{
		'mouseover': '股票行情'
	},
	'sidebar-weibo-button':{
		'mouseover': '腾讯微博'
	},
	'sidebar-doubanfm-button':{
		'mouseover': '豆瓣电台'
	},
	'sidebar-pengyou-button':{
		'mouseover': '朋友网'
	},
	'sidebar-qzone-appstore-button':{
		'mouseover': '应用中心'
	},
	'sidebar-note-button':{
		'mouseover': '记事本'
	},
	'sidebar-caibei-button':{
		'mouseover': 'QQ彩贝'
	},
	'sidebar-webgame-button':{
		'mouseover': '网页游戏'
	},
    'sidebar-chongzhi-button':{
    	'mouseover': '充值中心'
    },
	"share-button":{
		"mouseover":"分享"
	}
	/*,
	 'mask-main-headbar-logo':{
	 'mouseover': '登录'
	 }*/
};

qqbrowser.js.logic.tipManager.bindMouseOver = function() {
	qqbrowser.js.logic.tipManager.bindEvent('mouseover');
};

qqbrowser.js.logic.tipManager.unbindMouseOver = function() {
	qqbrowser.js.logic.tipManager.unbindEvent('mouseover');
};

qqbrowser.js.logic.tipManager.bindEngineMouseOver = function() {
	qqbrowser.js.logic.tipManager.bind('engine-ie-button', 'mouseover');
	qqbrowser.js.logic.tipManager.bind('engine-webkit-button', 'mouseover');
};

qqbrowser.js.logic.tipManager.unbindEngineMouseOver = function() {
	$('#engine-ie-button').unbind('mouseover');
	$('#engine-webkit-button').unbind('mouseover');
};

qqbrowser.js.logic.tipManager.bindClick = function() {
	qqbrowser.js.logic.tipManager.bindEvent('click');
};

qqbrowser.js.logic.tipManager.unbindEvent = function(eventType) {
	qqbrowser.js.logic.tipManager.toggleEvent(eventType, 'unbind');
};

qqbrowser.js.logic.tipManager.bindEvent = function(eventType) {
	qqbrowser.js.logic.tipManager.toggleEvent(eventType, 'bind');
};

// eventType: mouseover, click...
// toggleType: bind, unbind
qqbrowser.js.logic.tipManager.toggleEvent = function(eventType, toggleType) {
	for (var elementId in qqbrowser.js.logic.tipManager.data) {
		if (qqbrowser.js.logic.tipManager.data[elementId][eventType]) {
			if (toggleType == 'unbind') {
				$('#' + elementId).unbind(eventType);
			} else {
				qqbrowser.js.logic.tipManager.bind(elementId, eventType);
			}
		}
	}
};

qqbrowser.js.logic.tipManager.hideTooltip = function() {
	clearTimeout(qqbrowser.js.logic.tipManager.timer);

	qqbrowser.tooltip.destroy(qqbrowser.js.logic.tipManager.tooltipId);
};

// 显示标签tab的tooltip
qqbrowser.js.logic.tipManager.showTabTip = function( tab, event ) {
	clearTimeout(qqbrowser.js.logic.tipManager.timer);
	qqbrowser.js.logic.tipManager.timer = setTimeout(qqbrowser.js.logic.tipManager.showTip.bind(this.showTip,
				tab.element[0], "mouseover", "tabTooltip", tab.data.title, event.pageX, event.pageY ), 500);
};

qqbrowser.js.logic.tipManager.showCloseTabTip = function( tab ) {
	clearTimeout(qqbrowser.js.logic.tipManager.timer);
	var closeButtonElem = tab.closeButton[0];
	qqbrowser.js.logic.tipManager.timer = setTimeout(qqbrowser.js.logic.tipManager.showTip.bind(this.showTip,
        closeButtonElem, "mouseover", "closeTabButtonTooltip", "关闭", closeButtonElem.offsetLeft, closeButtonElem.offsetTop), 500);
};

qqbrowser.js.logic.tipManager.showFavbarTip = function(favItem, event) {
	clearTimeout(qqbrowser.js.logic.tipManager.timer);

	var favId = favItem.attr('id');
	// 更新fav-item结构后的tooltip调整
	var favTitle = Cube.String.htmlEncode($('div', favItem)[1].innerText);
	qqbrowser.js.logic.tipManager.timer = setTimeout('qqbrowser.js.logic.tipManager.showTip("'
			+ favId + '", "mouseover", "favTooltip", "'
			+ favTitle + '",'
			+ event.pageX + ','
			+ event.pageY + ')', 500);
};

qqbrowser.js.logic.tipManager.showQzoneTip = function() {
	//qqbrowser.js.logic.tipManager.qzoneCount = curdata.initnum;
	//qqbrowser.js.logic.tipManager.friendCount = curdata.passivenum;

	clearTimeout(qqbrowser.js.logic.tipManager.timer);
	var qzoneButton = document.getElementById("qzone-button");
	var qzoneId = "qzone-button";

	qqbrowser.js.logic.tipManager.timer = setTimeout('qqbrowser.js.logic.tipManager.showTip("'
			+ qzoneId + '", "mouseover", "qzoneButtonTooltip", "QQ空间", '
			+ qzoneButton.offsetLeft + ','
			+ qzoneButton.offsetTop + ')', 500);
};

qqbrowser.js.logic.tipManager.showDownloadTip = function() {
	clearTimeout(qqbrowser.js.logic.tipManager.timer);
	var downloadId = "statusbar-download-button";
	var downloadButton = document.getElementById(downloadId);

	qqbrowser.js.logic.tipManager.timer = setTimeout('qqbrowser.js.logic.tipManager.showTip("'
			+ downloadId + '", "mouseover", "downloadButtonTooltip", "下载管理器", '
			+ downloadButton.offsetLeft + ','
			+ downloadButton.offsetTop + ')', 500);
};


qqbrowser.js.logic.tipManager.showAddressFavTip = function() {
	clearTimeout(qqbrowser.js.logic.tipManager.timer);
	var addressFavButton = document.getElementById("address-fav-button");
	var Id = "address-fav-button";

	var wording = addressFavButton.hasAttribute('fav') ? "编辑此收藏" : "收藏此网页";
	//alert(qzoneId);
	qqbrowser.js.logic.tipManager.timer = setTimeout('qqbrowser.js.logic.tipManager.showTip("'
			+ Id + '", "mouseover", "addressFavButtonTooltip", "' + wording + '", '
			+ addressFavButton.offsetLeft + ','
			+ addressFavButton.offsetTop + ')', 500);
};

qqbrowser.js.logic.tipManager.showSoundControlTip = function(flag) {
	clearTimeout(qqbrowser.js.logic.tipManager.timer);
	var soundControlButton = document.getElementById('statusbar-soundControl-button'),text = "";
	var BtnId = "statusbar-soundControl-button";
	if (flag === "close") {
		text = "当前状态：静音（点击切换为有声）";
	} else {
		text = "当前状态：有声音（点击切换为静音）";
	}
	qqbrowser.js.logic.tipManager.timer = setTimeout('qqbrowser.js.logic.tipManager.showTip("'
			+ BtnId + '", "mouseover", "soundControlButtonTooltip", "' + text + '", '
			+ soundControlButton.offsetLeft + ','
			+ soundControlButton.offsetTop + ')', 500);
};

qqbrowser.js.logic.tipManager.enableTooltip = function(enabled) {
	if (enabled) {
		qqbrowser.js.logic.tipManager.enabled = true;
	} else {
		qqbrowser.js.logic.tipManager.enabled = false;
	}
};
