/**
 * infobar manager
 * 
 * @author littleli
 */
/*
 * if( typeof(browser) != "undefined"){
 * browser.log("littlestart+infobarManager+top"); }
 */
if (undefined === qqbrowser.js.logic) {
	qqbrowser.js.logic = {};
}

qqbrowser.js.logic.infobarManager = {};

qqbrowser.js.logic.infobarManager.caibeiType = 0;

qqbrowser.js.logic.infobarManager.init = function() {
	// 需要代码结构的优化
	/* Infobar的初始化 */
	if (qqbrowser.layout.pageInfobar === undefined) {
		qqbrowser.layout.pageInfobar = new qqbrowser.js.widgets.infobar(
				"pageInfobar");
		this.pageInfobarBind();
	}

	if (qqbrowser.layout.savePWinfobar === undefined) {
		qqbrowser.layout.savePWinfobar = new qqbrowser.js.widgets.infobar(
				"savePWinfobar");
		this.savePWInfobarBind();
	}

	// 添加彩贝相关的infobar
	if (qqbrowser.layout.caibeiInfobar === undefined) {
		qqbrowser.layout.caibeiInfobar = new qqbrowser.js.widgets.infobar(
				"caibeiInfobar");
		this.caibeiInfobarBind();
	}
	
	// 由littleli于2012.12.27注释，屏蔽默认浏览器提示条的入口，改为对话框的实现
	// 加入默认浏览器的infobar
    // setTimeout(this.checkDefaultBrowser,300);


};

/*
 * 完成页面崩溃infobar的逻辑功能绑定
 */
qqbrowser.js.logic.infobarManager.pageInfobarBind = function() {

	/* Infobar的初始化及插入到相应的dom元素 */
	qqbrowser.layout.pageInfobar.addClass("common");
	var pageInfobar = qqbrowser.layout.pageInfobar;
	// 之后放到eventManager中
	qqbrowser.layout.pageInfobar.onShow(function() {
		qqbrowser.skin.window.popAboveWeb();
		qqbrowser.js.logic.layoutManager.resize();
	});
	qqbrowser.layout.pageInfobar.onHide(function() {
		qqbrowser.js.logic.layoutManager.resize();
	});
	qqbrowser.layout.pageInfobar.crashFirstTimeText = "网页发生错误，QQ浏览器已帮您自动恢复。 ";
	qqbrowser.layout.pageInfobar.crashText = "网页多次出错，您可以刷新或关闭此网页。";
	qqbrowser.layout.pageInfobar.zombieText = "网页失去响应，您可以刷新或关闭此网页。";

	qqbrowser.layout.pageInfobar
			.setText(qqbrowser.layout.pageInfobar.crashText);
	
	qqbrowser.layout.pageInfobar.refreshButton = new qqbrowser.js.widgets.button(
			"infobar-refreshbutton");
	qqbrowser.layout.pageInfobar.refreshButton.setText("刷新");
	qqbrowser.layout.pageInfobar
			.addAction(qqbrowser.layout.pageInfobar.refreshButton);
	

	qqbrowser.layout.pageInfobar.closeButton = new qqbrowser.js.widgets.button(
	"infobar-closebutton");
	qqbrowser.layout.pageInfobar.closeButton.setText("关闭网页");
	qqbrowser.layout.pageInfobar
	.addAction(qqbrowser.layout.pageInfobar.closeButton);
	qqbrowser.layout.pageInfobar.closeButton.show(false);
	

	// 之后放到eventManager中,先测试功能
	qqbrowser.layout.pageInfobar.refreshButton.onclick(function(event) {
		browser.page.reload(browser.getCurrentPageId());
		qqbrowser.layout.pageInfobar.show(false);
		var statMap = {
			0 : 0,
			1 : STATIS_TIPBAR_WEBERROR_ITEM_REFRESH_CLICKED,
			2 : STATIS_TIPBAR_LOSERESPOND_ITEM_REFRESH_CLICKED
		};
		
		browser.extension.builtin.statistics.increase(statMap[pageInfobar.type]);
	});
	
	// 之后放到eventManager中,先测试功能
	qqbrowser.layout.pageInfobar.closeButton.onclick(function(event) {
		browser.tabs.remove(browser.getCurrentPageId());
		qqbrowser.layout.pageInfobar.show(false);
		var statMap = {
				0 : 0,
				1 : STATIS_TIPBAR_WEBERROR_ITEM_CLOSE_CLICKED,
				2 : STATIS_TIPBAR_LOSERESPOND_ITEM_CLOSE_CLICKED
			};
			
		browser.extension.builtin.statistics.increase(statMap[pageInfobar.type]);
	});
	
	qqbrowser.layout.pageInfobar._close.onclick(function(event) {
		qqbrowser.layout.pageInfobar.show(false);
		
		var statMap = {
				0 : STATIS_TIPBAR_RECOVERYFAULT_ITEM_XBTN_CLICKED,
				1 : STATIS_TIPBAR_WEBERROR_ITEM_XBTN_CLICKED,
				2 : STATIS_TIPBAR_LOSERESPOND_ITEM_XBTN_CLICKED
			};
			
		browser.extension.builtin.statistics.increase(statMap[pageInfobar.type]);
	});

	qqbrowser.layout.pageInfobar
			.insert(document.getElementById("main-infobar"));
};

/*
 * 完成“密码保存”infobar的逻辑功能绑定
 */
qqbrowser.js.logic.infobarManager.savePWInfobarBind = function() {
	// 记录当前infobar所显示的页面id
	qqbrowser.layout.savePWinfobar.currentPageId = -1;
	// 用于管理当前密码保存infobar对应的tab
	// qqbrowser.layout.savePWinfobar.tabInfo = {};
	qqbrowser.layout.savePWinfobar.addClass("common");
	qqbrowser.layout.savePWinfobar.onShow(function() {
		qqbrowser.js.logic.layoutManager.resize();
	});
	qqbrowser.layout.savePWinfobar.onHide(function() {
		var currentPageId = qqbrowser.layout.savePWinfobar.currentPageId;
		qqbrowser.layout.savePWinfobar.currentPageId = -1;
		qqbrowser.js.logic.layoutManager.resize();
	});

	qqbrowser.layout.savePWinfobar.text = "需要记住此网站的密码吗？";

	qqbrowser.layout.savePWinfobar.setHtml(qqbrowser.layout.savePWinfobar.text);
	qqbrowser.layout.savePWinfobar.setIcon("key.png");

	// 记住按钮
	qqbrowser.layout.savePWinfobar.rememberButton = new qqbrowser.js.widgets.button(
			"savePWinfobar-rememberButton");
	qqbrowser.layout.savePWinfobar.rememberButton.setText("确定");
	qqbrowser.layout.savePWinfobar.rememberButton.addClass("callTo");
	// 不记住按钮
	qqbrowser.layout.savePWinfobar.norememberButton = new qqbrowser.js.widgets.button(
			"savePWinfobar-norememberButton");
	qqbrowser.layout.savePWinfobar.norememberButton.setText("取消");
	// 了解此功能按钮
	//qqbrowser.layout.savePWinfobar.refButton = new qqbrowser.js.widgets.button(
	//		"savePWinfobar-refButton");
	//qqbrowser.layout.savePWinfobar.refButton.setText("了解此功能");
	// 中间的弹性元素
	var flexElement = document.createElement("div");
	flexElement.setAttribute("id", "flex");
	// 不再提醒此网站按钮
	qqbrowser.layout.savePWinfobar.neverButton = new qqbrowser.js.widgets.button(
			"savePWinfobar-neverButton");
	qqbrowser.layout.savePWinfobar.neverButton.setText("不再提示");

	// 注册各个按钮行为
	qqbrowser.layout.savePWinfobar
			.addAction(qqbrowser.layout.savePWinfobar.rememberButton);
	qqbrowser.layout.savePWinfobar
			.addAction(qqbrowser.layout.savePWinfobar.norememberButton);
	qqbrowser.layout.savePWinfobar.addAction(flexElement);
	//qqbrowser.layout.savePWinfobar.addAction(qqbrowser.layout.savePWinfobar.refButton);
	qqbrowser.layout.savePWinfobar
			.addAction(qqbrowser.layout.savePWinfobar.neverButton);

	// 重新设置"了解此功能"的样式
	//qqbrowser.layout.savePWinfobar.refButton.setClass("savePWinfobar-refButton");

	// 绑定按钮的事件处理程序
	qqbrowser.layout.savePWinfobar.rememberButton.onclick(function(event) {
		// 调用后台api的接口
		var extId = "{75A78384-8765-4852-ABB7-8D5FA8BF48E2}";
		var cmd = {};
		cmd.command = "savePwd";
		cmd.pageId = qqbrowser.layout.savePWinfobar.currentPageId;
		// cmd.title=savePWinfobar.webpageText;
		browser.extension.sendRequest(extId, cmd, function() {
		});
		delete Skin.app.TabBar.instance.getTabByData('pageId', cmd.pageId).data.savePW;
		qqbrowser.layout.savePWinfobar.show(false);
		browser.extension.builtin.statistics.increase(STATIS_TIPBAR_CODESAVE_ITEM_OK_CLICKED);
	});
	qqbrowser.layout.savePWinfobar.norememberButton.onclick(function(event) {
		// 调用后台api的接口
		var extId = "{75A78384-8765-4852-ABB7-8D5FA8BF48E2}";
		var cmd = {};
		cmd.command = "noSavePwd";
		cmd.pageId = qqbrowser.layout.savePWinfobar.currentPageId;
		browser.extension.sendRequest(extId, cmd, function() {
		});
		delete Skin.app.TabBar.instance.getTabByData('pageId', cmd.pageId).data.savePW;
		qqbrowser.layout.savePWinfobar.show(false);
		browser.extension.builtin.statistics.increase(STATIS_TIPBAR_CODESAVE_ITEM_CANCEL_CLICKED);
	});
	qqbrowser.layout.savePWinfobar._close.onclick(function(event) {
		// 调用后台api的接口
		var extId = "{75A78384-8765-4852-ABB7-8D5FA8BF48E2}";
		var cmd = {};
		cmd.command = "noSavePwd";
		cmd.pageId = qqbrowser.layout.savePWinfobar.currentPageId;
		browser.extension.sendRequest(extId, cmd, function() {
		});
		delete Skin.app.TabBar.instance.getTabByData('pageId', cmd.pageId).data.savePW;
		qqbrowser.layout.savePWinfobar.show(false);
		browser.extension.builtin.statistics.increase(STATIS_TIPBAR_CODESAVE_ITEM_XBTN_CLICKED);
	});

//	qqbrowser.layout.savePWinfobar.refButton.onclick(function(event) {
//		// 打开相应的网页
//		browser.tabs.create("http://browser.qq.com/help/gnjs.html#password", 0);
//	});

	qqbrowser.layout.savePWinfobar.neverButton.onclick(function(event) {
		// 调用后台api的接口
		var obj = {};
		obj.autoFillTip = 0;
		try {
			qqbrowser.extension.builtin.config.set(obj, function() {
			});
		} catch (err) {
		}
		var extId = "{75A78384-8765-4852-ABB7-8D5FA8BF48E2}";
		var cmd = {};
		cmd.command = "noSavePwd";
		cmd.pageId = qqbrowser.layout.savePWinfobar.currentPageId;
		browser.extension.sendRequest(extId, cmd, function() {
		});
		delete Skin.app.TabBar.instance.getTabByData('pageId', cmd.pageId).data.savePW;
		qqbrowser.layout.savePWinfobar.show(false);
		browser.extension.builtin.statistics.increase(STATIS_TIPBAR_CODESAVE_ITEM_NOTIP_CLICKED);
	});

	qqbrowser.layout.savePWinfobar.insert(document
			.getElementById("main-infobar"));

};

qqbrowser.js.logic.infobarManager.caibeiInfobarLogic = function(domain, pageId) {
	var	caibeiHintTimes = qqbrowser.js.logic.caibeiHintTimes,
		caibeiBindTimes = qqbrowser.js.logic.caibeiBindTimes,
		caibeiHintConfirm = qqbrowser.js.logic.caibeiHintConfirm,
		caibeiBindConfirm = qqbrowser.js.logic.caibeiBindConfirm,
		caibeiOptionModified = qqbrowser.js.logic.caibeiOptionModified;
		
	if (caibeiOptionModified == "true") { // 如果操作过选项页面中关于彩贝绑定的操作，那么不弹出相应的infobar
		return;
	}
	
	
	if (true === qqbrowser.layout.caibeiInfobar.isShow && qqbrowser.layout.caibeiInfobar.currentPageId !== pageId) { // 如果已经有caibeiinfobar显示，那么不再显示其他infobar
		return;
	}

	var tabBar = Skin.app.TabBar.instance, tab = tabBar.getTabByData( 'pageId', pageId ),
		tabData = tab.data,
		caibeiInfobar = qqbrowser.layout.caibeiInfobar,
		conf = qqbrowser.js.logic.caibeiInfo["conf"],
		info = qqbrowser.js.logic.caibeiInfo["info"];

	if (typeof(conf) === "undefined" || typeof(info)==="undefined") {
		return;
	}
	
	var nowTime = parseInt((new Date().getTime() / 1000), 10);

	//判断地址栏url是否在 白名单内 
	if (conf[domain] !== undefined) {
		var id = conf[domain];
		var caibeiInfo = info[id];
		
		caibeiInfobar.showMsg = unescape(caibeiInfo["show_msg"]) + '<div id="caibeiRef">详情</div>';
		caibeiInfobar.url = unescape(caibeiInfo["login_url"]);
		caibeiInfobar.pageId = pageId;
		
		caibeiInfobar.name = caibeiInfo["name"];
		caibeiInfobar.discount = caibeiInfo["discount"];
		
		//新的弹条判断逻辑 
		if(caibeiBindTimes == 2 || caibeiBindConfirm == true){
			return;
		}else if(caibeiHintTimes == 0 && caibeiBindTimes == 0){
			showInfobar(1, 1); 
			tabData.caibei = true;
		}else if(caibeiHintTimes == 1 && caibeiBindTimes == 0 && caibeiHintConfirm == true ){
			if (nowTime - qqbrowser.js.logic.caibeiHintBindTime > caibeiHBTimeLength) {
				showInfobar(2, 1); 
				tabData.caibei = true;
			}
		}else if(caibeiHintTimes == 1 && caibeiBindTimes == 0 && caibeiHintConfirm == false){
			if( nowTime - qqbrowser.js.logic.caibeiPopupTime > caibeiTimeLength){
				showInfobar(1, 2);
				tabData.caibei = true;
			}
		}else if(caibeiHintTimes == 1 && caibeiBindTimes == 1 && caibeiBindConfirm == false){
			if( nowTime - qqbrowser.js.logic.caibeiPopupTime > caibeiTimeLength){
				showInfobar(2, 2);
				tabData.caibei = true;
			}
		}else if(caibeiHintTimes == 2 && caibeiBindTimes == 0 && caibeiHintConfirm == false){
			return;
		}else if(caibeiHintTimes == 2 && caibeiBindTimes == 0 && caibeiHintConfirm == true){
			if (nowTime - qqbrowser.js.logic.caibeiHintBindTime > caibeiHBTimeLength) {
				showInfobar(2, 1); 
				tabData.caibei = true;
			}
		}else if(caibeiHintTimes == 2 && caibeiBindTimes == 1 && caibeiBindConfirm == false){
			if( nowTime - qqbrowser.js.logic.caibeiPopupTime > caibeiTimeLength){
			    showInfobar(2, 2);
			    tabData.caibei = true;
			}
		}
		   
	} else {
		// 地址栏内容改变时，如果此时该url不在商户列表中那么关闭提示条，并清空标识位
		if ( tabData.caibei) {
			qqbrowser.layout.caibeiInfobar.show(false);
			qqbrowser.layout.caibeiInfobar.isShow = false;
			qqbrowser.layout.caibeiInfobar.currentPageId = -1;
			delete tabData.caibei;
		}
	}
	
	var caibeiRef = document.getElementById("caibeiRef");
	if (caibeiRef) {
		caibeiRef.onclick = function(event) {
			
			browser.tabs.create("http://cb.qq.com", 0);
			
			event.stopPropagation();
		};
	}

	
	function showInfobar(type, times) {
		if (1 === type) { // 显示体验infobar
			qqbrowser.js.logic.infobarManager.caibeiType = 1;
			
			caibeiInfobar.caibeiButton.show(true);
			caibeiInfobar.caibeiBindButton.show(false);
			//caibeiInfobar.setHtml(caibeiInfobar.showMsg);
			
			// 设置相应的显示文字
			var finalText = [caibeiInfobar.name, caibeiInfobar.firstText, caibeiInfobar.thirdText, caibeiInfobar.discount, caibeiInfobar.lastText].join("");
			finalText = finalText + '<div id="caibeiRef">详情</div>';
			caibeiInfobar.setHtml(finalText);
			
			caibeiInfobar.show(true);
			browser.extension.builtin.statistics.increase(STATIS_CMD_INFOBAR_CAIBEI_POPED);
		} else if (2 === type){ // 显示绑定功能infobar
			
			qqbrowser.js.logic.infobarManager.caibeiType = 2;
			caibeiInfobar.caibeiButton.show(false);
			caibeiInfobar.caibeiBindButton.show(true);
			//caibeiInfobar.setHtml(caibeiInfobar.showMsg);
			
			// 设置相应的显示文字
			var finalText = [caibeiInfobar.name, caibeiInfobar.firstText, caibeiInfobar.secondText, caibeiInfobar.thirdText, caibeiInfobar.discount, caibeiInfobar.lastText].join("");
			finalText = finalText + '<div id="caibeiRef">详情</div>';
			caibeiInfobar.setHtml(finalText);
			//caibeiInfobar.setText(finalText);
			
			caibeiInfobar.show(true);
			browser.extension.builtin.statistics.increase(STATIS_CMD_INFOBAR_CAIBEI_BINDING_POPED);
		} else {	
			caibeiInfobar.show(false);
		}
		
		// 一旦显示过caibeiInfobar，那么记录一下，以供切换tab时使用
		tabData.caibei = true;
		tabData.caibeiName = caibeiInfobar.name;
		tabData.caibeiDiscount = caibeiInfobar.discount;
		tabData.caibeiType = type;

		caibeiInfobar.currentPageId = pageId;
	};

};

qqbrowser.js.logic.infobarManager.setCaibeiTime = function(type, times) {
	if (type === "hint") {
		qqbrowser.js.logic.caibeiHintTimes = times;
		
		var obj={};
		obj.caibeiHintTimes = times;
		qqbrowser.extension.builtin.config.set(obj, function(results){});
	} else if (type === "bind") {
		qqbrowser.js.logic.caibeiBindTimes = times;
		
		var obj={};
		obj.caibeiBindTimes = times;
		qqbrowser.extension.builtin.config.set(obj, function(results){});
	} else {
		return;
	}
};


/*
 * 完成“彩贝合作”infobar的逻辑功能绑定
 */
qqbrowser.js.logic.infobarManager.caibeiInfobarBind = function() {
	var caibeiInfobar = qqbrowser.layout.caibeiInfobar;

	// 记录当前infobar所显示的页面id
	caibeiInfobar.currentPageId = -1;
	// 用于管理当前密码保存infobar对应的tab
	caibeiInfobar.addClass("custom");

	caibeiInfobar.onShow(function() {
		caibeiInfobar.isShow = true;
		qqbrowser.js.logic.layoutManager.resize();
	});

	caibeiInfobar.onHide(function() {
		qqbrowser.js.logic.layoutManager.resize();
	});
	
	
	caibeiInfobar.firstText = "是  QQ彩贝  联盟商户，";
	caibeiInfobar.secondText = "使用彩贝特权，";
	caibeiInfobar.thirdText = "购物可返最高";
	caibeiInfobar.lastText = "彩贝积分!";
	
	
	caibeiInfobar.caibeiButton = new qqbrowser.js.widgets.button(
	"caibeiInfobar-caibeiButton");
	caibeiInfobar.cancelButton = new qqbrowser.js.widgets.button(
	"caibeirInfobar-cancelbutton");
	caibeiInfobar.caibeiBindButton = new qqbrowser.js.widgets.button(
	"caibeiInfobar-caibeiBindButton");
	
	caibeiInfobar.caibeiButton.setText("体验一下");
	caibeiInfobar.caibeiButton.addClass("callTo");
	caibeiInfobar.addAction(caibeiInfobar.caibeiButton);
	caibeiInfobar.caibeiButton.show(true);
	
	caibeiInfobar.caibeiBindButton.setText("开启彩贝特权 ");
	caibeiInfobar.caibeiBindButton.addClass("callTo");
	caibeiInfobar.addAction(caibeiInfobar.caibeiBindButton);
	caibeiInfobar.caibeiBindButton.show(true);
	
	caibeiInfobar.cancelButton.setText("以后再说");
	caibeiInfobar.addAction(caibeiInfobar.cancelButton);
	caibeiInfobar.cancelButton.show(true);
	
	caibeiInfobar.caibeiButton.onclick(function() {
		var nowTime = parseInt((new Date().getTime() / 1000), 10);
		
		qqbrowser.page.navigate(caibeiInfobar.pageId, caibeiInfobar.url, 0);
		
		qqbrowser.js.logic.caibeiHintConfirm = true;
		
		caibeiInfobar.show(false);
		caibeiInfobar.isShow = false;
		
		var pageId = qqbrowser.layout.caibeiInfobar.currentPageId;
		delete Skin.app.TabBar.instance.getTabByData('pageId', pageId ).data.caibei;
		
		var obj={};
		obj.caibeiHintConfirm = true;
		qqbrowser.extension.builtin.config.set(obj, function(results){});
		
		// 解决弹出第一个条后，需要过1个小时之后才能弹出第2个条的问题
		qqbrowser.js.logic.caibeiHintBindTime = nowTime;
		
		var obj1 = {};
		obj1.caibeiHintBindTime = nowTime;
		qqbrowser.extension.builtin.config.set(obj1, function(results){});
		
		qqbrowser.js.logic.infobarManager.setCaibeiTime("hint", ++qqbrowser.js.logic.caibeiHintTimes);
		
		qqbrowser.extension.builtin.statistics.increase(STATIS_CMD_INFOBAR_CAIBEI_TRY_CLICK_TRY);
		
		event.stopPropagation();
	});
	
	caibeiInfobar.caibeiBindButton.onclick(function() {
		caibeiInfobar.finishBind = true;
		caibeiInfobar.setText("成功开启彩贝特权！您可以在浏览器选项 - 高级设置中管理彩贝业务。 ");
		qqbrowser.js.logic.infobarManager.caibeiType = 3;
		
		//browser.tabs.create(caibeiInfobar.url, 0);
		qqbrowser.page.navigate(caibeiInfobar.pageId, caibeiInfobar.url, 0);
		
		qqbrowser.js.logic.caibeiBindConfirm = true;
		
		caibeiInfobar.caibeiBindButton.show(false);
        caibeiInfobar.cancelButton.show(false);
		
		
		var obj={};
		obj.caibeiBindConfirm = true;
		qqbrowser.extension.builtin.config.set(obj, function(results){});
		
		qqbrowser.js.logic.infobarManager.setCaibeiTime("bind", ++qqbrowser.js.logic.caibeiBindTimes);
		
		qqbrowser.extension.builtin.statistics.increase(STATIS_CMD_INFOBAR_CAIBEI_BINDING_CLICK_BIND);
		qqbrowser.extension.builtin.statistics.increase(STATIS_TIPBAR_CAIBEI_SUCCESS_POPED);
		event.stopPropagation();
	});
	
	
	
	caibeiInfobar.cancelButton.onclick(function() {
	
		var nowTime = parseInt((new Date().getTime() / 1000), 10);
		
		qqbrowser.layout.caibeiInfobar.show(false);
		caibeiInfobar.isShow = false;
		
		var pageId = qqbrowser.layout.caibeiInfobar.currentPageId;
		delete Skin.app.TabBar.instance.getTabByData('pageId', pageId ).data.caibei;
		
		qqbrowser.js.logic.caibeiPopupTime = nowTime;
		
		var obj={};
		obj.caibeiPopupTime = nowTime;
		qqbrowser.extension.builtin.config.set(obj, function(results){});//把此时的时间存入config
		
		if(qqbrowser.js.logic.infobarManager.caibeiType == 1){
		    qqbrowser.extension.builtin.statistics.increase(STATIS_CMD_INFOBAR_CAIBEI_TRY_CLICK_LATER);
		    qqbrowser.js.logic.infobarManager.setCaibeiTime("hint", ++qqbrowser.js.logic.caibeiHintTimes);
        } else {
        	qqbrowser.extension.builtin.statistics.increase(STATIS_CMD_INFOBAR_CAIBEI_BINDING_CLICK_LATER);
        	qqbrowser.js.logic.infobarManager.setCaibeiTime("bind", ++qqbrowser.js.logic.caibeiBindTimes);
        }
		
		event.stopPropagation();
	});
	

	//caibeiInfobar.setHtml(caibeiInfobar.finalText);
	
	caibeiInfobar.setIcon("caibei28_28.png");

	caibeiInfobar._close.onclick(function(event) {

		var nowTime = parseInt((new Date().getTime() / 1000), 10);
		
		qqbrowser.layout.caibeiInfobar.show(false);
		caibeiInfobar.isShow = false;
		
		qqbrowser.js.logic.caibeiPopupTime = nowTime;
		
		var obj={};
		obj.caibeiPopupTime = nowTime;
		qqbrowser.extension.builtin.config.set(obj, function(results){});//把此时的时间存入config
		
		var pageId = qqbrowser.layout.caibeiInfobar.currentPageId;
		delete Skin.app.TabBar.instance.getTabByData('pageId', pageId ).data.caibei;
		
		if(qqbrowser.js.logic.infobarManager.caibeiType == 1){
		    qqbrowser.extension.builtin.statistics.increase(STATIS_CMD_INFOBAR_CAIBEI_TRY_CLICK_CLOSE);
		    qqbrowser.js.logic.infobarManager.setCaibeiTime("hint", ++qqbrowser.js.logic.caibeiHintTimes);
        } else if (qqbrowser.js.logic.infobarManager.caibeiType == 2){
        	qqbrowser.extension.builtin.statistics.increase(STATIS_CMD_INFOBAR_CAIBEI_BINDING_CLICK_CLOSE);
        	qqbrowser.js.logic.infobarManager.setCaibeiTime("bind", ++qqbrowser.js.logic.caibeiBindTimes);
        } else {
        	qqbrowser.extension.builtin.statistics.increase(STATIS_TIPBAR_CAIBEI_SUCCESS_ITEM_XBTN_CLICKED);
        }
		
		event.stopPropagation();
	});

	caibeiInfobar.insert(document
			.getElementById("main-infobar"));

};


qqbrowser.js.logic.infobarManager.checkDefaultBrowser = function() {
	// 如果启动时存在页面恢复infobar，那么此时不生成也不显示默认浏览器的infobar
	if (qqbrowser.layout.recoverInfobar
			&& qqbrowser.layout.recoverInfobar.isVisible()) {
		return;
	}
	var option = [ "checkDefaultBrowser" ];
	var retryCount = 0;
	
	// 先读配置
	qqbrowser.extension.builtin.config.get(option, function(results) {
		var res = JSON.parse(results)[0];
		// console.info(res);
		var option = res.checkDefaultBrowser;
		if (option) {
			var obj = {};
			obj.command = "OnQueryDefaultBrowser";
			// 在配置回调中主动发请求询问默认浏览器的状态
			try {
				qqbrowser.extension.sendRequest(
						"{42C8559E-A311-45f2-A2A1-F00B056D256C}", obj,
						function(reply) {
							var result = JSON.parse(reply)[0].result;
							// console.info(result);
							// 如果不为默认浏览器那么弹出“默认浏览器”的infobar
							if (result === "0") {
								qqbrowser.js.logic.infobarManager
										.buildDefaultBrowserInfobar();
							} else {
								return;
							}

						}, function(reply) {
							//console.info("sendRequest error reply");
							// 400毫秒后重新发送请求至扩展
							setTimeout(sendDefaultExt,400);
						}, function(reply) {
						}, -1);
			} catch (e) {
				console.info("SendRequest Error");
			}
		} else {
			return;
		}
	});
	
	function sendDefaultExt() {
		try {
				if (retryCount >= 10) { // 错误后最多发送10次
					return;
				}
				++retryCount;
				var obj = {};
				obj.command = "OnQueryDefaultBrowser";
				qqbrowser.extension.sendRequest(
						"{42C8559E-A311-45f2-A2A1-F00B056D256C}", obj,
						function(reply) {
							var result = JSON.parse(reply)[0].result;
							// console.info(result);
							// 如果不为默认浏览器那么弹出“默认浏览器”的infobar
							if (result === "0") {
								qqbrowser.js.logic.infobarManager
										.buildDefaultBrowserInfobar();
							}
							return;
						}, function(reply) {
							//console.info("sendRequest error reply");
							// 400毫秒后重新发送请求至扩展
							setTimeout(sendDefaultExt, 400);
						}, function(reply) {
						}, -1);
			} catch (e) {
				console.info("SendRequest Error");
			}
	}
};

qqbrowser.js.logic.infobarManager.buildDefaultBrowserInfobar = function() {

	// 创建“默认浏览器”infobar
	if (qqbrowser.layout.defaultBrowserInfobar !== undefined) {
        return;

	}
    qqbrowser.layout.defaultBrowserInfobar = new qqbrowser.js.widgets.infobar(
				"defaultBrowserInfobar");
	qqbrowser.layout.defaultBrowserInfobar.canShow = true;

	var defaultBrowserInfobar = qqbrowser.layout.defaultBrowserInfobar;
	defaultBrowserInfobar.addClass("common");

	defaultBrowserInfobar.onShow(function() {
		qqbrowser.js.logic.layoutManager.resize();
	});

	defaultBrowserInfobar.onHide(function() {
		qqbrowser.js.logic.layoutManager.resize();
	});

	defaultBrowserInfobar.setIcon("browser-icon.png");

	defaultBrowserInfobar.defaultText = "将QQ浏览器设为默认浏览器，体验更优质的腾讯服务。";
	defaultBrowserInfobar.setDefaultButton = new qqbrowser.js.widgets.button(
			"defaultBrowserInfobar-setDefaultButton");
	defaultBrowserInfobar.cancelButton = new qqbrowser.js.widgets.button(
			"defaultBrowserInfobar-cancelbutton");
	defaultBrowserInfobar.nomoreButton = new qqbrowser.js.widgets.button(
	"defaultBrowserInfobar-nomorebutton");


	defaultBrowserInfobar.setDefaultButton.addClass("callTo");
	defaultBrowserInfobar.setDefaultButton.setText("设为默认");
	defaultBrowserInfobar.addAction(defaultBrowserInfobar.setDefaultButton);
	
	defaultBrowserInfobar.setDefaultButton.show(true);
	defaultBrowserInfobar.cancelButton.setText("取消");
	defaultBrowserInfobar.addAction(defaultBrowserInfobar.cancelButton);
	
	defaultBrowserInfobar.cancelButton.show(true);
	
	var flexElement = document.createElement("div");
	flexElement.setAttribute("id", "flex");
	defaultBrowserInfobar.addAction(flexElement);
	
	
	defaultBrowserInfobar.nomoreButton.setText("不再提示");
	defaultBrowserInfobar.addAction(defaultBrowserInfobar.nomoreButton);
	defaultBrowserInfobar.nomoreButton.show(true);
	
	

	defaultBrowserInfobar.showClose(true);
	defaultBrowserInfobar.setText(defaultBrowserInfobar.defaultText);
	defaultBrowserInfobar.insert(document.getElementById("main-infobar"));

	defaultBrowserInfobar.show(true);
	browser.extension.builtin.statistics.increase(STATIS_DEFAULTBROWSER_TIP_SHOW_REAL);

	defaultBrowserInfobar.setDefaultButton.onclick(function(event) {
		// 做相应的事件处理
		var obj = {};
		obj.paramone = '1';
		obj.command = "OnSetDefaultBrowser";
		try {
			qqbrowser.extension.sendRequest(
					"{42C8559E-A311-45f2-A2A1-F00B056D256C}", obj, function(
							reply) {
						var result = JSON.parse(reply);
						var a = result[0].result;

						// document.getElementById("defaultBrowser").setAttribute("param",
						// a );
						// refreshdefaultbrowserinfo();
						// 如果需要给config扩展发消息改变对应按钮的状态
					}, function(reply) {
					}, function(reply) {
					}, -1);

			// qqbrowser.extension.builtin.statistics.increase(STATIS_CMD_CONFIG_DEFAULTQQBROWSER_CLICKED);
		} catch (err) {
		}
		qqbrowser.layout.defaultBrowserInfobar.canShow = false;
		defaultBrowserInfobar.show(false);
		browser.extension.builtin.statistics.increase(STATIS_DEFAULTBROWSER_TIP_SET);
		event.stopPropagation();
	});

	defaultBrowserInfobar.cancelButton.onclick(function(event) {
		defaultBrowserInfobar.show(false);
		qqbrowser.layout.defaultBrowserInfobar.canShow = false;
		browser.extension.builtin.statistics.increase(STATIS_DEFAULTBROWSER_TIP_CANCEL);
	});
	
	defaultBrowserInfobar.nomoreButton.onclick(function(event) {
		var obj = {};
		obj.checkDefaultBrowser = false;
		qqbrowser.extension.builtin.config.set(obj, function() {
		});
		defaultBrowserInfobar.show(false);
		qqbrowser.layout.defaultBrowserInfobar.canShow = false;
		browser.extension.builtin.statistics.increase(STATIS_DEFAULTBROWSER_TIP_DONTASK);
		event.stopPropagation();
	});

	defaultBrowserInfobar._close.onclick(function(event) {
		// 调用后台api的接口
		defaultBrowserInfobar.show(false);
		qqbrowser.layout.defaultBrowserInfobar.canShow = false;
		browser.extension.builtin.statistics.increase(STATIS_DEFAULTBROWSER_TIP_CLOSE);
	});
};

qqbrowser.js.logic.infobarManager.showLogic = function(pageId) {
	
	var	pageInfobar = qqbrowser.layout.pageInfobar,
		savePWinfobar = qqbrowser.layout.savePWinfobar;

	var tabData = Skin.app.TabBar.instance.getTabByData('pageId', pageId ).data;
	
	// 更新密码保存infobar的信息
	if (tabData.savePW) {
		savePWinfobar.showClose(true);
		savePWinfobar.currentPageId = pageId;
		savePWinfobar.show(true);
	} else {
		savePWinfobar.show(false);
	}
	
	// 更新页面崩溃infobar的信息
	if (tabData.tabState === 1) {
		browser.page.reload(browser.getCurrentPageId());
	} else if (tabData.tabState === 2) {
		pageInfobar.setText(pageInfobar.zombieText);
		pageInfobar.showClose(true);
		pageInfobar.refreshButton.show(true);
		pageInfobar.show(true);
	} else {
		pageInfobar.show(false);
	}

	if (qqbrowser.layout.defaultBrowserInfobar) {
		// 仅有首个tab有可能显示默认浏览器infobar
		if (pageId !== 1) {
			qqbrowser.layout.defaultBrowserInfobar.show(false);
		} else if (pageId === 1 && qqbrowser.layout.defaultBrowserInfobar.canShow) {
			qqbrowser.layout.defaultBrowserInfobar.show(true);
		}
	}
};
