/**
 * findbar manager
 *
 * @author littleli
 *
 */
/* if( typeof(browser) != "undefined"){
 browser.log("littlestart+findbarManager+top");
 }*/
if (undefined === qqbrowser.js.logic.findbarManager) {
	qqbrowser.js.logic.findbarManager = {};
}

/**
 * 杩欓噷鍙彁渚涘熀鏈殑鍔熻兘
 */
qqbrowser.js.logic.findbarManager.lastKeyWord = null;
qqbrowser.js.logic.findbarManager.currentKeyWord = null;
qqbrowser.js.logic.findbarManager.findNextFlag = null;
qqbrowser.js.logic.findbarManager.undoStack = [];

qqbrowser.js.logic.findbarManager.init = function () {
	var layoutManager = qqbrowser.js.logic.layoutManager;
	var findbar = qqbrowser.layout.findbar;
	var _this = this;

	// 寤虹珛瀹屾垚鎾ゆ秷鍔熻兘鐨勬爤
	var undoStack = qqbrowser.js.logic.findbarManager.undoStack;

	findbar.onInputEvent(function (event) {
		var TabBar = Skin.app.TabBar, tabBar = TabBar.instance,
			activeTab = tabBar.activeTab, tabData = activeTab.data;

		var type = event.type;
		switch (type) {
			case "click":
			{
				break;
			}
			case "focus":
			{
				findbar.showPlaceholder(false);
				findbar._isFocus = true;

				// 鏍囪瘑褰撳墠鐒︾偣涓烘煡鎵炬爮锛岃?鐐瑰嚮鍦板潃鏍忎箣鍚庡湴鍧?爮鍏ㄩ?鈥斺?鏍囪瘑浣?
				findbar.relAddressFocusFlag = true;
				break;
			}
			case "blur":
			{
				// if (qqbrowser.js.logic.focus) {
				// qqbrowser.js.logic.focus = "findbar";
				// }
				if (findbar.getInputContent() === "") {
					findbar.showPlaceholder(true);
				}
				findbar._isFocus = false;

				// blur鏃讹紝娓呴櫎鎺夐?涓殑鐘舵?
				var text = qqbrowser.layout.findbar._inputSpace.value;
				qqbrowser.layout.findbar._inputSpace.value = text;

				break;
			}
			case "keydown":
			{
				var input = event.target;
				var len = undoStack.length;

				var undoInfo = {
					value:input.value,
					start:input.selectionStart,
					end:input.selectionEnd
				};

				var recentInfo = undoStack[len - 1];

				if (recentInfo && recentInfo.value == undoInfo.value && recentInfo.start == undoInfo.start && recentInfo.end == undoInfo.end) {
					return;
				} else {
					undoStack.push(undoInfo);
				}
			}
			case "keyup":
			{

				// 涓婁笅閿紝鏀瑰彉default浜嬩欢
				if (event.keyCode == 38 || event.keyCode == 40) {

					return false;
				}

				// 宸﹀彸閿笉澶勭悊
				if (event.keyCode == 37 || event.keyCode == 39) {
					return;
				}

				// ESC閿仠姝㈡煡鎵惧苟闅愯棌
				if (event.keyCode == 27) {
					if (tabData.findInfo) {
						tabData.findInfo.isShow = false;
					}
					browser.tabs.stopFinding(true);
					findbar.show(false);
					qqbrowser.js.logic.viewManager.setFocus2Web();
				}


				if ((findbar.getInputContent() !== _this.currentKeyWord) || event.keyCode == 13) {
					_this.currentKeyWord = findbar.getInputContent();
					_this.findNextFlag = false;

					if (_this.currentKeyWord === _this.lastKeyWord) {
						_this.findNextFlag = true;
					} else {
						_this.findNextFlag = false;
						_this.lastKeyWord = _this.currentKeyWord;
					}

					if (_this.currentKeyWord !== "") {
						browser.tabs.findText(_this.currentKeyWord, true,
								false, _this.findNextFlag);
					} else {
						tabData.findInfo.count = undefined;
						tabData.findInfo.index = undefined;
						findbar.setCurrentCount(0);
						findbar.setTotalCount(0);
						findbar.showFindCount(false);
						browser.tabs.stopFinding(true);
					}
				}


				break;
			}
		}
	});

	findbar.onFindButtonClickEvent(function (event) {
		var TabBar = Skin.app.TabBar, tabBar = TabBar.instance,
			activeTab = tabBar.activeTab, tabData = activeTab.data;

		// 鐐瑰嚮榧犳爣宸﹂敭鎵嶆墽琛岀浉搴旂殑鍔熻兘
		if (event.button === 0) {
			_this.currentKeyWord = findbar.getInputContent();
			_this.findNextFlag = false;

			if (_this.currentKeyWord === _this.lastKeyWord) {
				_this.findNextFlag = true;
			} else {
				_this.findNextFlag = false;
				_this.lastKeyWord = _this.currentKeyWord;
			}

			if (_this.currentKeyWord !== "") {
				browser.tabs.findText(_this.currentKeyWord, true, false,
						_this.findNextFlag);
			} else {
				tabData.findInfo.count = undefined;
				tabData.findInfo.index = undefined;
				findbar.setCurrentCount(0);
				findbar.setTotalCount(0);
				findbar.showFindCount(false);
				browser.tabs.stopFinding(true);
			}
		}
	});

	findbar.onNextButtonClickEvent(function (event) {
		var TabBar = Skin.app.TabBar, tabBar = TabBar.instance,
			activeTab = tabBar.activeTab, tabData = activeTab.data;

		// 鐐瑰嚮榧犳爣宸﹂敭鎵嶆墽琛岀浉搴旂殑鍔熻兘
		if (event.button === 0) {
			_this.currentKeyWord = findbar.getInputContent();
			_this.findNextFlag = false;

			if (_this.currentKeyWord === _this.lastKeyWord) {
				_this.findNextFlag = true;
			} else {
				_this.findNextFlag = false;
				_this.lastKeyWord = _this.currentKeyWord;
			}

			if (_this.currentKeyWord !== "") {
				browser.tabs.findText(_this.currentKeyWord, true, false,
						_this.findNextFlag);
			} else {
				tabData.findInfo.count = undefined;
				tabData.findInfo.index = undefined;
				findbar.setCurrentCount(0);
				findbar.setTotalCount(0);
				findbar.showFindCount(false);
				browser.tabs.stopFinding(true);
			}
		}
	});

	findbar.onPreviousButtonClickEvent(function (event) {
		var TabBar = Skin.app.TabBar, tabBar = TabBar.instance,
			activeTab = tabBar.activeTab, tabData = activeTab.data;

		// 鐐瑰嚮榧犳爣宸﹂敭鎵嶆墽琛岀浉搴旂殑鍔熻兘
		if (event.button === 0) {
			_this.currentKeyWord = findbar.getInputContent();
			_this.findNextFlag = false;
			if (_this.currentKeyWord === _this.lastKeyWord) {
				_this.findNextFlag = true;
			} else {
				_this.findNextFlag = false;
				_this.lastKeyWord = _this.currentKeyWord;
			}

			if (_this.currentKeyWord !== "") {
				browser.tabs.findText(_this.currentKeyWord, false, false,
						_this.findNextFlag);
			} else {
				tabData.findInfo.count = undefined;
				tabData.findInfo.index = undefined;
				findbar.setCurrentCount(0);
				findbar.setTotalCount(0);
				findbar.showFindCount(false);
				browser.tabs.stopFinding(true);
			}
		}
	});

	findbar.onShowListener(function (event) {
		layoutManager.resize();
	});

	findbar.onHideListener(function (event) {
		// 鍋滄鏌ユ壘

		_this.lastKeyWord = null;
		_this.currentKeyWord = null;
		_this.findNextFlag = null;
		layoutManager.resize();
	});

	findbar.onCloseButtonClickEvent(function (event) {
		var TabBar = Skin.app.TabBar, tabBar = TabBar.instance,
			activeTab = tabBar.activeTab, tabData = activeTab.data;

		// 璁板綍褰撳墠椤甸潰鐨刦indbar鏄剧ず鐘跺喌
		if (tabData.findInfo) {
			tabData.findInfo.isShow = false;
		}
		browser.tabs.stopFinding(true);
		findbar.show(false);
		qqbrowser.js.logic.viewManager.setFocus2Web();
	});

	// C++鍙抽敭鑿滃崟鐨勪簨浠跺洖璋?
	qqbrowser.findbar.onUndo.addListener(function () {
		//document.execCommand("undo");
		var findbar = qqbrowser.layout.findbar;
		var findbarInput = qqbrowser.layout.findbar._inputSpace;
		var undoStack = qqbrowser.js.logic.findbarManager.undoStack;

		if (undoStack.length > 0) {
			var undoInfo = undoStack.pop();

			setTimeout(function () {
				findbarInput.value = undoInfo.value;
				findbarInput.setSelectionRange(undoInfo.start, undoInfo.end);
			}, 0);
		}
	});

	qqbrowser.findbar.onPaste.addListener(function (content) {
		var findbar = qqbrowser.layout.findbar;
		var findbarInput = qqbrowser.layout.findbar._inputSpace;
		var undoStack = qqbrowser.js.logic.findbarManager.undoStack;
		var recentInfo = undoStack[undoStack.length - 1];

		var contents = content.split('\n');
		content = contents.join('');

		if (typeof findbar.selectionInfo !== 'undefined') {
			var text = findbarInput.value,
					start = findbar.selectionInfo.selectionStart,
					end = findbar.selectionInfo.selectionEnd;

			var undoInfo = {
				value:text,
				start:start,
				end:end
			};

			if (recentInfo && recentInfo.value == undoInfo.value && recentInfo.start == undoInfo.start && recentInfo.end == undoInfo.end) {
			} else {
				undoStack.push(undoInfo);
			}

			//var newText = text.slice(0, start) + text.slice(end);
			var newText = text.substring(0, start) + content + text.substring(end);
			var position = end + content.length;

			delete findbar.selectionInfo;

			setTimeout(function () {
				findbarInput.value = newText;
				findbarInput.setSelectionRange(position, position);
			}, 0);
		}

	});


	qqbrowser.findbar.onDelete.addListener(function () {
		var findbar = qqbrowser.layout.findbar;
		var findbarInput = qqbrowser.layout.findbar._inputSpace;
		var undoStack = qqbrowser.js.logic.findbarManager.undoStack;
		var recentInfo = undoStack[undoStack.length - 1];

		if (typeof findbar.selectionInfo !== 'undefined') {
			var text = findbarInput.value,
					start = findbar.selectionInfo.selectionStart,
					end = findbar.selectionInfo.selectionEnd;

			var undoInfo = {
				value:text,
				start:start,
				end:end
			};

			if (recentInfo && recentInfo.value == undoInfo.value && recentInfo.start == undoInfo.start && recentInfo.end == undoInfo.end) {
			} else {
				undoStack.push(undoInfo);
			}

			var newText = text.slice(0, start) + text.slice(end);

			delete findbar.selectionInfo;

			setTimeout(function () {
				findbarInput.value = newText;
				findbarInput.setSelectionRange(start, start);
			}, 0);
		}

	});

	qqbrowser.findbar.onSelectAll.addListener(function () {
		var findbarInput = qqbrowser.layout.findbar._inputSpace;

		// 婵?椿鐨偆绐楀彛
		qqbrowser.js.logic.viewManager.setFocus2Skin();

		setTimeout(function () {
			findbarInput.select();
		}, 0);
	});
};

qqbrowser.js.logic.findbarManager.isFindBarShow = function () {
	var TabBar = Skin.app.TabBar, tabBar = TabBar.instance,
		tabCount = tabBar.length, tab, i, findInfo;

	for ( i = 0; i < tabCount; i++ ) {
		findInfo = tabBar[ i ].data.findInfo;
		if (findInfo) {
			if (findInfo.isShow) {
				return true;
			}
		}
	}

	return false;

};
