/**
 * Created by .
 * User: crisweng
 * Date: 11-8-2
 * Time: 上午11:16
 * favbarManager
 */
if (undefined === qqbrowser.js.logic.favbarManager) {
	qqbrowser.js.logic.favbarManager = {};
}

qqbrowser.js.logic.favbarManager.openArray = [];

// 标识菜单打开的标识位
qqbrowser.js.logic.favbarManager.menuOpen = 1;

qqbrowser.js.logic.favbarManager.init = function() {
	var favbar = qqbrowser.layout.favbar;
    var layoutManager = qqbrowser.js.logic.layoutManager;
	var _this = this;

	// 真正打开菜单时记录一个标识位，
	// 主要用于content api升级时的菜单调整
	favbar.createMenu = function() {
		qqbrowser.js.logic.favbarManager.menuOpen = 0;
	},
	
	favbar.destroyMenu = function() {
		var currentElement;
		qqbrowser.js.logic.favbarManager.menuOpen = 1;
		//console.info('favbarManager-destroyMenu openArray.length:', qqbrowser.js.logic.favbarManager.openArray.length);
		
		if (qqbrowser.js.logic.favbarManager.openArray.length > 0) {	
			currentElement = qqbrowser.js.logic.favbarManager.openArray.shift();
		}
		
		// console.info('favbarManager-destroyMenu cureentElement:', currentElement);
		
		if (currentElement) {
			currentElement.removeClass('open');
			MenuFactory.favbarFolderOpen = 2;
			(qqbrowser.layout.favbar.activeFolder && (qqbrowser.layout.favbar.activeFolder = undefined));
		}
		
		dnd && dnd.clearFolderTimer();
	};
	
    favbar.onAddFavButtonClick(function(event){
		qqbrowser.account.getLoginState(function(state) {
			// 1 未登录
			// 2 登录
			// 3 离线状态—伪登陆状态
			state = JSON.parse(state)[0];
			
			// 离线状态
			if (state == 3) {
				qqbrowser.extension.sendRequest('{80944EE7-D5ED-46f6-86DF-53FCE8B945AB}', {
					command: 'BOOKMARK_READONLY_NOTIFICATION'
				}, function() {});
				return;
			}
			
			qqbrowser.bookmark.getSyncState(function(syncStateId) {
				try{
					var temp = JSON.parse(syncStateId);
					var statID = temp[0];
					var cmd = {};
					var extIdBookmark;
					if( 2 === statID) { // download err
						extIdBookmark ="{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}";
						cmd = {};
						cmd.command = "showNotify";
						cmd.status="downloadTip";
						qqbrowser.extension.sendRequest(extIdBookmark, cmd, function() {});
					}else if(1==statID){ // downloading
						extIdBookmark ="{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}";
						cmd = {};
						cmd.command = "showNotify";
						cmd.status="downloadEdit";
						qqbrowser.extension.sendRequest(extIdBookmark, cmd, function() {});
					}else{
						extIdBookmark ="{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}";
						cmd = {};
						cmd.command = "showAddFav";
						cmd.favID = -1;
						qqbrowser.extension.sendRequest(extIdBookmark, cmd, function() {});
						//browser.extension.builtin.statistics.increase(STATIS_CMD_FAV_FUNC_FAVBAR_ADD_FAV_CLICKED);	//上报 收藏栏上的添加收藏按钮点击次数
						browser.extension.builtin.statistics.increase(STATIS_FAV_FAVBAR_ADD);	//上报 收藏栏上的添加收藏按钮点击次数
					}
				} catch(err){
					qqbrowser.js.logic.utils.log("unpack err :[ "+err.message+" ]: "+syncStateId);
				}
			});
		});
    });
    
    favbar._addFavMenuButton._element.addEventListener('mousedown', function(event) {
    	if (favbar._addFavMenuButton.isEnable) {
        	var button = document.getElementById('qqbrowser-widgets-favbar-addfav');
    		browser.skin.buttonClicked('{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}', button, 2);
    	}
		
		event.stopPropagation();
    }, false);
    
    favbar.onFavMoreClick(function(event){
    	var favbarManager = qqbrowser.js.logic.favbarManager;
    	
        var ind = favbar.lastShowFav();
        
	    if (null === favbar._rootId){
		    favbar._rootId = 1;
	    }
        if(favbar._favMore.style.opacity === "0"){
            return;
        }
	    var fid = favbar._rootId;
		
		//console.info("onFavMoreClick ind:", ind);
    	
    	switch(event.type) {
    		case 'mousedown': {
                // TODO 解耦合
                MenuFactory.favbarFolderOpen = 1;
                return;
    		} 
    		case 'mouseup' : {
    			qqbrowser.js.logic.tipManager.hideTooltip();//左键点击文件夹隐藏toolTip
    		    if (MenuFactory.favbarFolderOpen == 1 && qqbrowser.js.logic.favbarManager.menuOpen == 1) {
    		    	qqbrowser.js.logic.favbarManager.openArray.push(this);
			        dnd.currentMenuId = MenuFactory.createBookmarkMenu(MENU_TYPE.BOOKMARKBAR_MORE, fid,
    			    		{element: this, fromIndex: ind,
						        onCreate:favbar.createMenu, onDestroy: favbar.destroyMenu, hasOffline: qqbrowser.layout.favbar.isOffline});
    		    } else {
			        qqbrowser.skin.menu.hideAll(dnd.currentMenuId);
		        }
    		    return;
    		}
    		case 'mouseover' : {
				if (favbarManager.openArray.length > 0 && (favbarManager.openArray.indexOf(this) == -1)) {
					qqbrowser.js.logic.favbarManager.openArray.push(this);
					dnd.currentMenuId = MenuFactory.createBookmarkMenu(MENU_TYPE.BOOKMARKBAR_MORE, fid,
	    			    		{element: this, fromIndex: ind,
							        onCreate:favbar.createMenu, onDestroy: favbar.destroyMenu, hasOffline: qqbrowser.layout.favbar.isOffline});
				}
    		}
    	}
    });

    favbar.onFavHolderMenuClick(function(event){
        var div = event.target;
        qqbrowser.js.logic.tipManager.hideTooltip();//左键点击文件和文件夹时隐藏toolTip
		if(div.getAttribute("id") === 'favholder') { // favbar右键菜单
			//qqbrowser.js.logic.menuManager.showMenu('favCtxMenu',{favType:'bar'});
			try {
			MenuFactory.createCommonMenu(MENU_TYPE.BOOKMARKBAR_BLANK_CONTEXT, {coordinate: {x: event.pageX, y: event.pageY}});
			} catch(e) {
				alert(e.message);
			}
		} else { // fav item右键菜单
			var maxcnt = 10;
			var cnt=0;
			while(div.getAttribute("class") !== "fav-item"
                   && !div.hasClass("fav-folder")
                     && div.getAttribute('tagName')!='BODY') {
				div= div.parentNode;
				cnt++;
				if (cnt>maxcnt){
					// 防止死循环
					break;
				}
			}
			if ( div.getAttribute('tagName')!='BODY'){
				//qqbrowser.log.info(element.html());
				var favId = unescape(div.getAttribute('id'));
				if ('undefined' === typeof(favId)){
					return;
				}
				var favType = div.getAttribute("class") === "fav-item" ? 'url' : 'folder';
				var itemUrl = div.getAttribute("url");
				var title = $(div).find("div:eq(1)").text();
				
				// 本地未备份收藏夹无右键菜单
				if (div.id === 'fav-offline') {
					return;
				}
				
				var menuParams = {favId: favId, favType: favType, url:itemUrl , "title": title};
				// qqbrowser.js.logic.menuManager.showMenu('favCtxMenu', menuParams);
				try {
				MenuFactory.createCommonMenu(favType === 'url' ? MENU_TYPE.BOOKMARK_URL_CONTEXT : MENU_TYPE.BOOKMARK_FOLDER_CONTEXT, {bookmark: {
					id: favId,
					index: Array.prototype.indexOf.call($('#favholder > div'), div),/*在父文件夹中的索引*/
					type: favType,
					url: itemUrl,
					parentId: qqbrowser.layout.favbar._rootId,
					title: title
				}, coordinate: {x: event.pageX, y: event.pageY}});
				}catch(e) {alert(e.message);}
			}
		}
	});

    favbar.onFavItemClick(function(event){
//        if(favbar._isDrag) {
//        // 此时是拖拽行为
//		    return;
//	    }
        //判断mousedown 和mouseup坐标是否一样，仿照click事件
        if(favbar._mouseX !== event.clientX || favbar._mouseY !==event.clientY){
            return;
        }
        
        console.info("fav-mouseup menuOpen:",  qqbrowser.js.logic.favbarManager.menuOpen);
        
	    if (event.button === 0){ // left mouse
		    var div = event.target;
            var url,id;
            // 找到fav-item
		    while(div != document.body) {
			    if (div.hasClass("fav-item")
                   || div.hasClass("fav-folder")){
				    break;
			    }
			    div = div.parentNode;
		    }

		     url = div.getAttribute('url');
		     id = div.getAttribute("id");
			 id = (id != 'fav-offline' ? id : -1);

		   // 如果有url，视为链接
		   if(url) {
			    try{
				    qqbrowser.bookmark.popupNavigate(parseInt(id));
			    }catch(err){
			    }
			    
			    browser.tabs.create(url, 2);
			    browser.extension.builtin.statistics.increase(STATIS_FAV_FAVBAR_CONTENT); //上报 收藏栏item点击访问次数（收藏栏上的）
		    } else if(!url && id ) {// 打开文件夹菜单
                qqbrowser.js.logic.tipManager.hideTooltip();//左键点击文件夹隐藏toolTip
			    try{
			    	console.info("fav-mouseup MenuFactory.favbarFolderOpen:",  MenuFactory.favbarFolderOpen);
			    	if ( MenuFactory.favbarFolderOpen == 1 && qqbrowser.js.logic.favbarManager.menuOpen == 1) {
			    		qqbrowser.js.logic.favbarManager.openArray.push(div);
						(id == -1 ? dnd.currentMenuId =  MenuFactory.createBookmarkMenu(MENU_TYPE.BOOKMARK_FOLDER, 0,
							{element: div, onDestroy: favbar.destroyMenu, isOffline: qqbrowser.layout.favbar.isOffline})
						 : dnd.currentMenuId = MenuFactory.createBookmarkMenu(MENU_TYPE.BOOKMARK_FOLDER, parseInt(id, 10),
							{element: div, onCreate: favbar.createMenu, onDestroy: favbar.destroyMenu}));
					    console.info("fav-mouseup dnd.currentMenuId:",  dnd.currentMenuId);
			    	} else {
					    console.info('dnd.currentMenuId', dnd.currentMenuId);
					    qqbrowser.skin.menu.hideAll(dnd.currentMenuId);
				    }
				   
			    }catch(err){
			    }
		    }
	    }
    });
    
    // hover展开的功能
    favbar.onFavHolderHover(function(event) {
    	var favbarManager = qqbrowser.js.logic.favbarManager;
    	var div = event.target;

        var url,id;
        
        if (div.getAttribute('id') === 'favholder') {
        	return;
        }
        
        // 找到fav-item
	    while(div != document.body) {
		    if (div.getAttribute("class") === "fav-item"
               || div.getAttribute("class") ==="fav-folder"){
			    break;
		    }
		    div = div.parentNode;
	    }
	    
	    url = div.getAttribute('url');
	    id = div.getAttribute("id");
		id = (id != 'fav-offline' ? id : -1);
		
    	if (url) {
    		return;
    	} else {
    		try {
    			if (id) {
    				if (favbarManager.openArray.length > 0 && (favbarManager.openArray.indexOf(this) == -1)) {
						qqbrowser.js.logic.tipManager.hideTooltip();
						qqbrowser.js.logic.favbarManager.openArray.push(div);
						
						(id == -1 ? dnd.currentMenuId =  MenuFactory.createBookmarkMenu(MENU_TYPE.BOOKMARK_FOLDER, 0,
							{element: div, onDestroy: favbar.destroyMenu, isOffline: qqbrowser.layout.favbar.isOffline})
						  : dnd.currentMenuId = MenuFactory.createBookmarkMenu(MENU_TYPE.BOOKMARK_FOLDER, parseInt(id, 10),
							{element: div, onCreate: favbar.createMenu, onDestroy: favbar.destroyMenu}));
					}
    			}

    		} catch(err) {
    		}
    	}
    });

//    favbar.onImportFavClick(function(event){
//         var extIdBookmark ="{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}";
//			var cmd = {};
//			cmd.command = "showImportFav";
//			qqbrowser.extension.sendRequest(extIdBookmark, cmd, function() {});
//    });

    favbar.onHide(function(event) {
		favbar.show(false);
		layoutManager.resize();
	});
    
    favbar.onShow(function(event){
        favbar.show(true);
		layoutManager.resize();
    });

   document.addEventListener("DOMContentLoaded",function(){
	   var TabBar = Skin.app.TabBar;
       qqbrowser.js.logic.favbarManager.reload();
        favbar.setMore();
        qqbrowser.bookmark.onBookmarkChanged.addListener(function(ret){
			if ("undefined" == typeof(ret)){
				qqbrowser.js.logic.favbarManager.getRootId(qqbrowser.js.logic.favbarManager.reload,-1);
			} else{
			    qqbrowser.js.logic.favbarManager.getRootId(qqbrowser.js.logic.favbarManager.reload,ret);
			}
			TabBar.setAddressFavStatus( TabBar.instance.activeTab );
	    },false);
    });


};
qqbrowser.js.logic.favbarManager.reload = function(){
    try{
        var favbar = qqbrowser.layout.favbar;
		// 判断是全部 还是 最常用
		    if (favbar._useFreq){
			     qqbrowser.bookmark.getFrequent(20,function(ret){
				     qqbrowser.js.logic.favbarManager.reloadex(ret);
			    });
		    }else{
                if(favbar._rootId === null){
                    favbar._rootId = 1;
                }
			    qqbrowser.bookmark.getChildren(favbar._rootId,50,qqbrowser.js.logic.favbarManager.reloadex);
		}
	    }catch(err){
		/*favbar.fill_data(null);	*/
	    }
};
qqbrowser.js.logic.favbarManager.reloadex = function(returnData){
        var favbar = qqbrowser.layout.favbar;

	    if (favbar._oldData !== returnData){
		    favbar._oldData = returnData;
        }
	    try{
		    var returnObject = JSON.parse(returnData);
		    var unescapedData = unescape(returnObject[0]);
		    favbar._isInit = returnObject[3];
		    var content = JSON.parse(unescapedData);
		    favbar.fillData(content);
			dnd && dnd.computeSpecialArea();
						
		// 重新填充数据后 重新计算more button
		    favbar._toterrcnt=0; // 错误计数 清空
	    }catch(err){
		//TODO 500ms 以后再 试一次,共4次
		    favbar._toterrcnt++;
		    if (this._toterrcnt<5){
			    setTimeout(function(){qqbrowser.js.logic.favbarManager.reload();},500);
		    }
        }
};

qqbrowser.js.logic.favbarManager.getRootId = function(callback,favShowType){
    var favbar = qqbrowser.layout.favbar;
	
	qqbrowser.bookmark.getChildren(0,50,function(returnData){
		try {
			var returnObject =JSON.parse(returnData);
			var unescapedData = unescape(returnObject[0]);
			favbar._isInit = returnObject[3];
			var content = JSON.parse(unescapedData);
			favbar.calcRootId(content);

			callback();
		} catch(err) {
		}
	});
		
	/*
    favbar._useFreq = false;
	
	if (-1 === favShowType){
		qqbrowser.bookmark.getChildren(0,50,function(returnData){
			try{
				var returnObject =JSON.parse(returnData);
				var unescapedData = unescape(returnObject[0]);
				favbar._isInit = returnObject[3];
				var content = JSON.parse(unescapedData);
				favbar.calcRootId(content);

				callback();
			}catch(err){
            }
		});
	// 6.12以前的版本的“显示指定收藏”的“最常访问的收藏”
	}else if (-2 === favShowType){ // frequency
		favbar._useFreq = true;
		favbar._rootId = -2;
		callback();
	// 6.12以前的版本的“显示指定收藏”的“指定文件夹的收藏”
	}else{ // diy favid
		// Modified by littleli ——  Remove the diy favId function
		favbar._rootId = favShowType;
		//favbar._rootId = 1;
		callback();
	}
	*/
};


qqbrowser.js.logic.favbarManager.setSortable = function() {
	// 初始化拖拽模块
	dnd && (dnd.init());
};
