/**
 * event manager
 * 
 * @author littleli
 */
/*if( typeof(browser) != "undefined"){
    browser.log("littlestart+download+top");
    }*/
if (undefined === qqbrowser.js.logic.downloadManager) {
	qqbrowser.js.logic.downloadManager = {};
}

qqbrowser.js.logic.downloadManager = {
	extID : "{7EDBEBE6-565F-4aa2-93A1-AD250445A5B6}",
	
	// 记录正在下载任务的个数，用于浏览器的关闭逻辑
	downloadingTaskCount: 0,
	newCompleteFlag: false,

	init : function() {
		
		this.regListener();

	},

	sendMsgToDownload : function(cmdName) {
		
		cmdList = { // 添加命令列表，便于以后的扩展
			downloadMgr : 'popupDlMgrDlg'
		};
		
		if ('downloadMgr' === cmdName) {
			this.newCompleteFlag = false;
		}
		
		var cmd = {
			command : cmdList[cmdName]
		};

		browser.extension.sendRequest(this.extID, cmd, function(reply) {
			console.info("replay:", reply);
		});

	},

	// 获取元素的绝对位置
	getPosition : function(element) {
		var left = 0;
		var top = 0;
		if (element.getBoundingClientRect) {
			var pos = element.getBoundingClientRect();
			left = pos.left + document.documentElement.scrollLeft;
			top = pos.top + document.documentElement.scrollTop;
			return {
				Left : left,
				Top : top
			};
		} else {
			while (element.offsetParent) {
				left += element.offsetLeft;
				top += element.offsetTop;
				element = element.offsetParent;
			}
			return {
				Left : left,
				Top : top
			};
		}
	},
	
	// 更新downloadButton的显示
	updateStatusBarIcon : function() {
		var downloadingFlag = 0;
		
		if (this.downloadingTaskCount > 0) {
			downloadingFlag = 1;
		}

		if (downloadingFlag === 1) {
			// TODO downloadButton的显示逻辑
			qqbrowser.layout.downloadButton.addClass("download");
		} else {
			qqbrowser.layout.downloadButton.removeClass("download");
            qqbrowser.layout.downloadButton.setState(false);
		}

		if (this.newCompleteFlag === true) {
			qqbrowser.layout.downloadButton.addClass("unhandled");
		} else {
			qqbrowser.layout.downloadButton.removeClass("unhandled");
		}
	},

	regListener : function() {
		browser.extension.onEvent.addListener(this.downHandler, {evtOwner : this.extID});
	},
	
	// 下载事件处理逻辑
	downHandler : function(evtName, evtParam) {

		var downloadManager = qqbrowser.js.logic.downloadManager;
		
		console.info("downHandler message receive ||||  evtName:", evtName);
		
		if ( typeof evtName !== 'undefined') { // 异常保护
			var para = null;
			para = eval("(" + evtParam + ")");
			
			console.info("downHandler message receive ||||  evtParam:", para);
			qqbrowser.extension.builtin.config.get(['statusbarDownload'], function( config ) {
				// 如果按钮隐藏，则不弹tip，by simons 2012-02-10 状态栏按钮自定义显示隐藏
				var config = JSON.parse(config)[0];
				if ( config.statusbarDownload ) {
					// 用户教育的事件及应用场景
					if ('tasks_mgr_dlg_closed' === evtName) {
						// 状态栏右侧现在一共有三个气泡———断点续传、下载用户教育以及弹窗拦截
						NotificationManager.create($('#statusbar-download-button')[0], 'STATUSBAR.DOWNLOAD_EDU');
						return;
					}


					// 断点续传的事件及应用场景
					if ('tasks_auto_continue' === evtName) {
						// 保存此时下载的任务数量
						if (para.hasOwnProperty('downloading_count')) {
							downloadManager.downloadingTaskCount = parseInt(para.downloading_count, 10);
						}
						// 状态栏右侧现在一共有三个气泡———断点续传、下载用户教育以及弹窗拦截
						NotificationManager.create($('#statusbar-download-button')[0], 'STATUSBAR.DONWLOAD_AUTO_CONTINUE');
					}
				}
			});
			
			
			// 下载任务数据改变及有新任务下载完成的事件
			if ('tasks_state_changed' === evtName) {
				
				// 保存此时下载的任务数量 
				if (para.hasOwnProperty('downloading_count')) {
					downloadManager.downloadingTaskCount = parseInt(para.downloading_count, 10);
				}
				
				// 若有新任务下载完成那么标记newCompleteFlag标志位
				if (para.hasOwnProperty('has_new_complete')) {
					downloadManager.newCompleteFlag = para.has_new_complete;
				}

			}
			
			downloadManager.updateStatusBarIcon();
		}
	}	
};