var dnd = {
	dragData: null,
	
	container: document.getElementById('favholder'),
	
	dropRatio: {
		'item': 0.5,
		'folder': 0.1
	},
	
	specialArea: [
		'favbar-drop-overlay',
		'favholder',
		'favbar',
		null
	],
	
	dragPrefix: 'x-qqbrowser-bookmarkId-',
	
	computeSpecialArea: function() {
		// 计算收藏栏不同区域拖拽时的显示
		var favCollections = document.getElementById('favholder').children;
		var length = favCollections.length;
		// var containerRect = document.getElementById('favholder').getBoundingClientRect();
		
		// this.yRange = [containerRect.top, containerRect.top + containerRect.height];
		this.xRange = [];
		
		var i = 0;
		
		for ( i = 0; i < length; ++i) {
		
			// 不用计算已经隐藏的收藏项
			if (favCollections[i].style.visibility == 'hidden' || favCollections[i].id == 'fav-offline') {
				break;
			}
				
			var rect = favCollections[i].getBoundingClientRect();
			
			// 最左边需要特殊处理
			// TODO 这里的计算应该更加智能
			if (i == 0) {
				
				this.xRange.push([rect.left - 8, rect.left + 2]);
			} else {
				this.xRange.push([rect.left - 4, rect.left + 2]);
			}
		
		}
		
		// 处理最后一个区域的边界情况
		if (length > 0 && i - 1 > 0) {
			var lastElement = favCollections[i - 1];
			var favMoreElement = document.getElementById('fav-more');
			
			var lastRect = lastElement.getBoundingClientRect();
			var favMoreRect = favMoreElement.getBoundingClientRect();
			
			this.xRange.push([lastRect.right, favMoreRect.left]);
		}
	},
	
	xRange: [],
	
	// 标识当前是否处于拖拽阶段，主要为了在拖拽结束时隐藏可能展开的菜单
	dragFlag: false,
	
	// hover时展开文件夹的时间长度，毫秒
	hoverOpenTime: 100,
	
	folderOpenTimer: null,
	
	currentMenuId: null,
	
	getFavElement: function(el) {
		
		// TODO 比较复杂的判断，之后好好优化
		while(el && el !== document && 
				(el.id !== 'fav-more' && el.getAttribute('folder') !== 'true' && el.className !== 'fav-item' 
					&& el.id !== 'favholder' && el.id !== 'favbar-drop-overlay' && el.id !== 'favbar')) {
			el = el.parentNode;
		}
		return el != document ? el : null ;	
	},
	
	checkEvery_: function(f, overFavNode, overElement) {	
		return f.call(this, overFavNode, overElement);
	},
	
	/**
	 * @return {boolean} Whether we are currently dragging fodlers
	 */
	isDraggingFolder: function() {
		return this.dragData.element.className === 'fav-foler';
	},
	
	/**
	 * This is a first pass whether we can drop the dragged items.
	 * 
	 */
	canDrop: function(dragId, overElement) {
		
		// 可以drop的判断，如果节点拖到自身上面那么返回false
		// 实际上另外一个重要判断是拖拽节点是不是drop节点的父节点 TODO
		if (overElement && overElement.id && overElement.id == dragId) {
			return false;
		}
		
		return true;
	},
	
	canDropAbove: function(dragId, overElement) {
		
		var previousElement = overElement.previousElementSibling;
		
		// We cannot drop above if the item below is already in the drag source.
		if (previousElement && previousElement.id == dragId) {
			return false;
		}
		
		return true;
	},
	
	canDropBelow: function(dragId, overElement) {
		
		
		// we cannot drop below if the item below is already in the drag source.
		var nextElement = overElement.nextElementSibling;
		
		if (nextElement &&
			nextElement.id == dragId) {
			return false;
		}
		
		
		return true;
	},
	
	/**
	 * Whether we can drop the dragged items on the drop target
	 * 
	 * @param overFavNode
	 * @param overElement
	 * @return {boolean}
	 */
	canDropOn: function(dragId, overElement) {
		if (overElement && overElement.getAttribute('url')) {
			return false;
		}
		
		return true;
	},
	
	/**
	 * 
	 * @param e
	 */
	handleDragStart: function(e) {
		var target = e.target;
		
		var dragElement = this.getFavElement(target);
		
		// 调整拖拽时被拖拽元素的样式
		dragElement.style.backgroundColor = 'white';
		dragElement.style.color = 'black';
		
		dragElement.removeClass('open');
		
		//console.info("dnd-handleDragStart dragElement:", dragElement);
		
		// 两种方式都使用，一种使用原生的html5拖拽时数据传递的方式 
		var dt = event.dataTransfer;
		dt.setData('text/plain', this.dragPrefix + dragElement.getAttribute('id'));
		// 如果拖拽的数据中包含url，那么将其数据写入dataTransfer中
		(dragElement.getAttribute('url') && dt.setData('text/uri-list', dragElement.getAttribute('url')));
		
		// if we are dragging a single link, we can do the *Link* effect
		dt.effectAllowed = 'move';
		
		// 打开拖拽的标识位
		this.dragFlag = true;
		
		this.dragData = {
			'dragElement': dragElement,
			'dragId': dragElement.getAttribute('id')
		};
		
		qqbrowser.js.logic.favbarManager.openArray = [];
		
		this.computeSpecialArea();
		
		//console.info("dnd-dragStart  xRange:", this.xRange);
	},
	
	handleDragEnter: function(e) {
		e.preventDefault();
	},
	
	/**
	 * Callback for the dragover event
	 */
	handleDragOver: function(e) {
		
		var favbarManager = qqbrowser.js.logic.favbarManager;
		
	    // Allow DND on text inputs.
	    if (e.target.tagName != 'INPUT') {
	      // The default operation is to allow dropping links etc to do navigation.
	      // We never want to do that for the bookmark manager.
	      e.preventDefault();

	      // Set to none. This will get set to something if we can do the drop.
	      e.dataTransfer.dropEffect = 'none';
	    }
		// id is the dragItem is
		var id = e.dataTransfer.getData('text/plain');
		
		// 现阶段外界拖入浏览器收藏栏的链接一律禁止
		if ( id.indexOf(this.dragPrefix) === -1)
			return;
		
		id = id.indexOf(this.dragPrefix) !== -1 ? id.replace(this.dragPrefix, '') : id;
		
		
		// console.info('id>>>>>>>>>>>>>>>> id:', id);
		
		if (!id) {
			return;
		}
			
		var overElement = this.getFavElement(e.target);
		var dropPos;
		// console.info("dnd-dragOver overElement:", overElement);
		
		// 如果出现了本地未收藏文件夹时禁止打开
		if (overElement && overElement.id == 'fav-offline') {
			e.dataTransfer.dropEffect = 'none';
			e.stopPropagation();
			return;
		}
		
		// 边界情况的特殊处理
		if ((overElement && this.specialArea.indexOf(overElement.id) != -1)) {
			var nX = e.clientX;
			// console.info('id>>>>>>>>>>>>>>>> id:', id);
			// console.info("dnd-dragOver-specialArea xRange:", this.xRange);
			// console.info("dnd-dragOver-specialArea nX:", nX);
			var length = this.xRange.length;
			var index;
			for (var i = length - 1; i >= 0; --i) {
				if (nX <= this.xRange[i][1] && nX >= this.xRange[i][0]) {
					index = i;	
					break;
				}
			}
			
			//console.info("dnd-dragOver-specialArea index:", index);
			
			if (index >= 0) {
							
				var overElement = index !== length - 1 ? document.getElementById('favholder').children[index] :
								document.getElementById('favholder').children[index - 1];
				var canDrop = this.canDrop(id, overElement);
				
				if (index < length - 1) { // 拖拽到收藏项与项之间边界时的情况
					
					var canDropAbove = this.canDropAbove(id, overElement);
					if (canDrop && canDropAbove) {
						dropPos = 'above';
						this.hideHoverFolder();
					} else {
						event.stopPropagation();
						return;
					}
				} else { // 拖拽到收藏项之后空白区域与Fav-more之间的情况
					if (canDrop) {
						dropPos = 'below';
						this.hideHoverFolder();
					} else {
						event.stopPropagation();
						return;
					}
				}
				
				e.dataTransfer.dropEffect = 'move';
				
				var rect = overElement.getBoundingClientRect();
				
				this.showDropOverlay_(rect, dropPos);
			
				this.dropDestination = {
					dropPos: dropPos,
					relatedElement: overElement
				};
			
			} 
			
			event.stopPropagation();
			
			return;
		}
		
		// hover到了fav-more之后的特殊处理
		if (overElement.id === 'fav-more') {
			dropPos = 'on';
			e.dataTransfer.dropEffect = 'move';
			
			// 展开与fav-more对应的菜单
			if (favbarManager.openArray.length > 0 && (favbarManager.openArray.indexOf(overElement) == -1)) {
				this.hideHoverFolder();
			}
			
			overElement && this.openHoverFolder(overElement);
			event.stopPropagation();
			
			return;
		}
		
		if (!this.canDrop(id, overElement)) 
			return;
		
		var canDropAbove = this.canDropAbove(id, overElement);
		var canDropBelow = this.canDropBelow(id, overElement);
		var canDropOn = this.canDropOn(id, overElement);
		
		//console.info("dnd-dragOver overElement:", overElement);
		
		if (!canDropAbove && !canDropBelow && !canDropOn) {
			return;
		}
		
		
		
		e.dataTransfer.dropEffect = 'move';
		
		var rect, type;
		rect = overElement.getBoundingClientRect();
		type = overElement.className == 'fav-item' ? 'item' : 'folder';
		
		// 这里写的是水平时的计算方法
		// 如果考虑通用性可以带上垂直时的计算方法
		var dx = e.clientX - rect.left;
		var xRatio = dx / rect.width; 
		var ratio = this.dropRatio[type];
		
		// above——left
		if (canDropAbove &&
				(xRatio <= ratio)) {
			dropPos = 'above';
			this.hideHoverFolder();
		// below——right
		} else if (canDropBelow &&
				(xRatio >= 1 - ratio )) {
			dropPos = 'below';
			this.hideHoverFolder();
		// on	
		} else if (canDropOn){
			dropPos = 'on';
			// TODO 添加文件夹hover展开的接口
			if (favbarManager.openArray.length > 0 && (favbarManager.openArray.indexOf(overElement) == -1)) {
				this.hideHoverFolder();
			}
			overElement && this.openHoverFolder(overElement);
		// none
		} else {
			// No drop can happen. Exit now
			e.dataTransfer.dropEffect = 'none';
			return;
		}
		
		this.showDropOverlay_(rect, dropPos);
		event.stopPropagation();
		
		this.dropDestination = {
			dropPos: dropPos,
			relatedElement: overElement
		};
	},
	
	/**
	 * Shows and positions the drop marker overlay.
	 * @param
	 * @param
	 * @private
	 */
	showDropOverlay_: function(targetRect, overlayType) {
		window.clearTimeout(this.hideDropOverlayTimer_);
		var overlay = document.getElementById('favbar-drop-overlay');
		
		if (overlayType === 'on') {
			overlay.style.display = 'none';
			overlay.style.top = targetRect.top + 'px';
		} else {
			overlay.style.display = 'block';
		}
		
		if (overlayType !== 'on') {
			if (overlayType === 'above') {
				overlay.style.left = targetRect.left - 3 + 'px';
			} else {
				overlay.style.left = targetRect.left + targetRect.width + 1 + 'px';
			}
		}
	},
	
	/**
	 * Hides the drop overlay element.
	 * @private
	 */
	hideDropOverlay_: function() {
		// Hide the overlay in a timeout to reduce flickering as we move between
		// valid drop targets.
		window.clearTimeout(this.hideDropOverlayTimer_);
		this.hideDropOverlayTimer_ = window.setTimeout(function() {
			document.getElementById('favbar-drop-overlay').style.display = '';
		}, 100);
	},
	
	/**
	 *  When hover on the fav-folder item for a long time,
	 *  the folder will open automatic
	 */
	openHoverFolder: function(overElement) {
		var favbarManager = qqbrowser.js.logic.favbarManager;
		
		if (!overElement) {
			return;
		}
		
		// 拖拽的时候找开的菜单次同时只能存在一个
		if (favbarManager.openArray.length <= 1 && favbarManager.openArray.indexOf(overElement) == -1) {
			// console.info("dnd-openHoverFolder favbarManager.openArray", favbarManager.openArray);
			// 调用qqbrowser.layout.favbar的接口，完成ind的计算
			var favbar = qqbrowser.layout.favbar,
				ind = qqbrowser.layout.favbar && qqbrowser.layout.favbar.lastShowFav();
				
				// 多验证一下菜单展开的效率问题，尽量提高展开的流畅性
			
				//this.folderOpenTimer = setTimeout(function() {
				favbarManager.openArray.push(overElement);
				// console.info("dnd-openHoverFolder open");
				//console.info("dnd-openHoverFolder open favbarManager.openArray:", favbarManager.openArray);
				//console.info("dnd-openHoverFolder open favbarManager.openArray.length:", favbarManager.openArray.length);
				
				// 打开菜单前提前关闭已有菜单
				this.hideHoverFolder();
				
				// 根据不同类的item展开不同类型的菜单
				(overElement.id == 'fav-more' ? 
					  dnd.currentMenuId = MenuFactory.createBookmarkMenu(MENU_TYPE.BOOKMARKBAR_MORE, null, 
			    			    		{element: overElement, fromIndex: ind, onDestroy: favbar.destroyMenu})
					: dnd.currentMenuId = MenuFactory.createBookmarkMenu(MENU_TYPE.BOOKMARK_FOLDER, 
							parseInt(overElement.id, 10), {element: overElement, onDestroy: favbar.destroyMenu}));
				
				//}, this.hoverOpenTime);
		} 
	},
	
	hideHoverFolder: function() {
		//this.clearFolderTimer();
		if (this.currentMenuId) {
			qqbrowser.skin.menu.hideAll(parseInt(this.currentMenuId));
			this.currentMenuId = null;
		}
	},
	
	clearFolderTimer: function() {
		window.clearTimeout(this.folderOpenTimer);
		this.folderOpenTimer = null;
	},
	
	handleDragLeave: function(e) {
		this.hideDropOverlay_();
	},
	
	handleDrop: function(e) {
		var id = e.dataTransfer.getData('text/plain');
		
		id = id.indexOf(this.dragPrefix) !== -1 ? id.replace(this.dragPrefix, '') : id;
		
		if (this.dropDestination && id) {
			var dropPos = this.dropDestination.dropPos;
			var relatedElement = this.dropDestination.relatedElement;
			var parentId = dropPos == 'on' ? relatedElement.getAttribute('id') : qqbrowser.layout.favbar._rootId;
			
			var favCollection = this.container.children;
			
			var selectTarget;
			var selectFavId;
			var index;
			var relatedIndex = Array.prototype.indexOf.call(favCollection, relatedElement);
			
			if (relatedElement.id == 'favholder') {	
				relatedIndex = favCollection.length - 1;
			}
			
			if ('above' === dropPos) {
				index = relatedIndex;
			} else if ('below' === dropPos) {
				index = relatedIndex + 1;
			} else { // dropOn的时候默认放到该文件夹的最后一个
				index = -1;
			}
			
			// Modified by littleli
			// 解决拖拽冲突时的woding显示问题
			var dragData = dnd.dragData;
			var type = (dragData && dragData.dragElement && !dragData.dragElement.getAttribute('folder')) ? '链接' : '文件夹';
			
			// console.info("dnd-handleDrop parentId:", parentId);
			// console.info("dnd-handleDrop index:", index);
			if (index != undefined && index != -1) { // 如果有index的话表示可以确定位置
				qqbrowser.bookmark.move(parseInt(id, 10), parseInt(parentId, 10), index, function(result) {
					var moveCode = JSON.parse(result)[0];
					
					if (moveCode === 1) {
						
					} else {
						alert("同名" + type + "已存在，操作失败");
					} 
				});
			} else { // 如果没有index的话那么表示
				qqbrowser.bookmark.move(parseInt(id, 10), parseInt(parentId, 10), -1, function(result) {
					var moveCode = JSON.parse(result)[0];
					
					if (moveCode === 1) {
						
					} else {
						alert("同名" + type + "已存在，操作失败");
					} 
				});
			}
			
			event.stopPropagation();
		}
		
		this.dragFlag = false;
		
		this.hideHoverFolder();
		this.dropDestination = null;
		this.hideDropOverlay_();
		
		$(document).one('mouseover', function() {
			return false;
		});
	},
	
	clearDragData: function() {
		this.dragData = null;
	},
	
	init: function() {
		document.ondragstart = null;
		var boundClearData = this.clearDragData.bind(this);
		
		// 拖拽完成，清理数据，并隐藏展开的菜单
		function deferredClearData() {
			if (dnd.dragFlag) {
				dnd.hideHoverFolder();
				dnd.dragFlag = false;
			} 
			
			// 此时清除被拖拽元素的特殊样式
			if (dnd.dragData && dnd.dragData.dragElement) {
				dnd.dragData.dragElement.style.backgroundColor = '';
				dnd.dragData.dragElement.style.color = '';
			}
			
			setTimeout(boundClearData);
		}
		
		favbar.addEventListener('dragstart', this.handleDragStart.bind(this));
		favbar.addEventListener('dragenter', this.handleDragEnter.bind(this));
		favbar.addEventListener('dragover', this.handleDragOver.bind(this));
		favbar.addEventListener('dragleave', this.handleDragLeave.bind(this));
		favbar.addEventListener('drop', this.handleDrop.bind(this));
		favbar.addEventListener('dragend', deferredClearData.bind(this));
		document.addEventListener('mouseup', deferredClearData.bind(this));
		
		// 禁止
		var addressInput = document.getElementById('address-input');
		//addressInput.addEventListener('dragover', ban);
		document.addEventListener('dragover', ban);
		document.addEventListener('dragenter', ban);
		
		function ban(e) {
			e.dataTransfer.effectAllowed = 'none';
			e.dataTransfer.dropEffect = 'none';
			e.preventDefault();
			e.stopPropagation();
			return false;
		}

	}
	
};