// Copyright (C) 2010-2011 Tencent Inc. All Rights Reserved.
// 版权所有 (C) 2010-2011 腾讯公司。保留所有权利。

/**
 * @fileOverview 配置管理。主要用来在浏览器打开新窗口（包括启动）时获取一些设置，
 * 然后初始化一些界面元素。
 * @author luangong@tencent.com
 * @version 1.1
 */
	/*if( typeof(browser) != "undefined"){
    browser.log("littlestart+configManager+top");
  }*/
qqbrowser.js = qqbrowser.js || {};
qqbrowser.js.logic = qqbrowser.js.logic || {};
qqbrowser.js.logic.configManager = qqbrowser.js.logic.configManager || {};

/**
 * 初始化，打开新窗口的时候读取配置，然后决定一些界面元素的显示与否。
 */

qqbrowser.js.logic.configManager.init = function() {
   /* 	if( typeof(browser) != "undefined"){
    browser.log("littlestart+configManager+init");
  }*/
    var request = [
		'favoritesDisplay',
		'qzoneDisplay',
		'screenshotDisplay',
		'clearButtonDisplay',
		'tagsTatus',
		'statusbarMute',
		'statusbarClock',
		'statusbarDict',
		'statusbarDownload',
		'statusbarTab',
		'statusbarBlock',
		'statusbarScale'
	];
    qqbrowser.extension.builtin.config.get(request, qqbrowser.js.logic.configManager.initCallback);
};

/**
 * {@code config.get} 的回调函数，用来设置界面元素的显示与否。
 * @fuction
 * @param {string} results 表示返回值的 JSON 字符串。
 */
qqbrowser.js.logic.configManager.initCallback = function(results) {
    var config = JSON.parse(results)[0];
    qqbrowser.js.logic.configManager.setView(config);
};

/**
 * 设置界面元素显示与否。
 * @param {Object} config 表示设置信息的 key/value 对。
 */
qqbrowser.js.logic.configManager.setView = function(config) {
    qqbrowser.js.logic.configManager.setForegroundButtonDisplay(config);
    qqbrowser.js.logic.configManager.setFavbarDisplay(config);
    qqbrowser.js.logic.configManager.setQzoneDisplay(config);
    qqbrowser.js.logic.configManager.setScreenshotDisplay(config);
    qqbrowser.js.logic.configManager.setClearButtonDisplay(config);
    qqbrowser.js.logic.configManager.setCloseConfirm(config);   // added by wilsonteng
	qqbrowser.js.logic.configManager.setStatusbarMute(config);
	qqbrowser.js.logic.configManager.setStatusbarDict(config);
	qqbrowser.js.logic.configManager.setStatusbarDownload(config);
	qqbrowser.js.logic.configManager.setStatusbarTab(config);
	qqbrowser.js.logic.configManager.setStatusbarBlock(config);
	qqbrowser.js.logic.configManager.setStatusbarScale(config);
};

/**
 * 设置打开链接时转到新标签页还是继续停留在当前标签页。
 * @param {Object} config 表示设置信息的 key/value 对。
 */
qqbrowser.js.logic.configManager.setForegroundButtonDisplay = function(config) {
    if (!config.hasOwnProperty('tagsTatus')) {
        return;
    }

    if (config.tagsTatus == 0) {
        // 显示前台按钮，隐藏后台按钮
        qqbrowser.layout.foregroundButton.show(true);
        qqbrowser.layout.backgroundButton.show(false);
    }
    else {
        // 显示后台按钮，隐藏前台按钮
        qqbrowser.layout.backgroundButton.show(true);
        qqbrowser.layout.foregroundButton.show(false);
    }
};

/**
 * 隐藏和显示收藏栏。
 * @param {Object} config 表示设置信息的 key/value 对。
 */
qqbrowser.js.logic.configManager.setFavbarDisplay = function(config) {
 /*   	if( typeof(browser) != "undefined"){
    browser.log("littlestart+configManager+2");
  }*/
    if (!config.hasOwnProperty('favoritesDisplay')) {
        return;
    }

    if (config.favoritesDisplay) {
    	localStorage.setItem("favoritesDisplay", "true");
        qqbrowser.layout.favbar.show(true);
        qqbrowser.layout.favbar.callListener(true);
    }
    else {
    	localStorage.setItem("favoritesDisplay", "false");
        qqbrowser.layout.favbar.show(false);
        qqbrowser.layout.favbar.callListener(false);
    }
};

/**
 * 隐藏和显示QQ空间按钮。
 * @param {Object} config 表示设置信息的 key/value 对。
 */
qqbrowser.js.logic.configManager.setQzoneDisplay = function(config) {
  /*  	if( typeof(browser) != "undefined"){
    browser.log("littlestart+configManager+3");
  }*/
    if (!config.hasOwnProperty('qzoneDisplay')) {
        return;
    }

    if (config.qzoneDisplay) {
    	localStorage.setItem("qzoneDisplay", "true");
        qqbrowser.layout.qzoneButton.show(true);
        qqbrowser.layout.qzoneMenuButton.show(false);
    }
    else {
    	localStorage.setItem("qzoneDisplay", "false");
        qqbrowser.layout.qzoneButton.show(false);
        qqbrowser.layout.qzoneMenuButton.show(false);
    }
};

/**
 * 隐藏和显示截屏按钮。
 * @param {Object} config 表示设置信息的 key/value 对。
 */
qqbrowser.js.logic.configManager.setScreenshotDisplay = function(config) {
  /*  	if( typeof(browser) != "undefined"){
    browser.log("littlestart+configManager+3");
  }*/
    if (!config.hasOwnProperty('screenshotDisplay')) {
        return;
    }

    if (config.screenshotDisplay) {
    	localStorage.setItem("screenshotDisplay", "true");
        qqbrowser.layout.printscreenButton.show(true);
        qqbrowser.layout.printScreenMenuButton.show(true);
    }
    else {
    	localStorage.setItem("screenshotDisplay", "false");
        qqbrowser.layout.printscreenButton.show(false);
        qqbrowser.layout.printScreenMenuButton.show(false);
    }
};

/**
 * 隐藏和显示清除浏览痕迹按钮。
 * @param {Object} config 表示设置信息的 key/value 对。
 */
qqbrowser.js.logic.configManager.setClearButtonDisplay = function(config) {
  /*  	if( typeof(browser) != "undefined"){
    browser.log("littlestart+configManager+4");
  }*/
    if (!config.hasOwnProperty('clearButtonDisplay')) {
        return;
    }

    if (config.clearButtonDisplay) {
    	localStorage.setItem("clearButtonDisplay", "true");
        qqbrowser.layout.cleanButton.show(true);
    }
    else {
    	localStorage.setItem("clearButtonDisplay", "false");
        qqbrowser.layout.cleanButton.show(false);
    } 
};

/**
 * 设置关闭确认。
 * @param {Object} config 表示设置信息的 key/value 对。
 * @author wilsonteng@tencent.com
 */
qqbrowser.js.logic.configManager.setCloseConfirm = function(config) {
    /*	if( typeof(browser) != "undefined"){
    browser.log("littlestart+configManager+5");
  }*/
    if (!config.hasOwnProperty('closeWndConfirm')) {
        return;
    }
    qqbrowser.js.logic.closeConfirm = config.closeWndConfirm;
    	
};

qqbrowser.js.logic.configManager.setStatusbarMute = function (config) {
	if ( !config.hasOwnProperty('statusbarMute') ) {
		return;
	}
	if ( config.statusbarMute ) {
		localStorage.setItem('statusbarMute', 'true');
		qqbrowser.layout.soundControlButton.show( true );
	} else {
		localStorage.setItem('statusbarMute', 'false');
		qqbrowser.layout.soundControlButton.show( false );
	}
};
qqbrowser.js.logic.configManager.setStatusbarDict = function (config) {
	if ( !config.hasOwnProperty('statusbarDict') ) {
		return;
	}
	if ( config.statusbarDict ) {
		localStorage.setItem('statusbarDict', 'true');
		qqbrowser.layout.cloudDictButton.show( true );
	} else {
		localStorage.setItem('statusbarDict', 'false');
		qqbrowser.layout.cloudDictButton.show( false );
	}
};
qqbrowser.js.logic.configManager.setStatusbarDownload = function (config) {
	if ( !config.hasOwnProperty('statusbarDownload') ) {
		return;
	}
	if ( config.statusbarDownload ) {
		localStorage.setItem('statusbarDownload', 'true');
		qqbrowser.layout.downloadButton.show( true );
	} else {
		localStorage.setItem('statusbarDownload', 'false');
		qqbrowser.layout.downloadButton.show( false );
	}
};
qqbrowser.js.logic.configManager.setStatusbarTab = function (config) {
	if ( !config.hasOwnProperty('statusbarTab') ) {
		return;
	}
	if ( config.statusbarTab ) {
		localStorage.setItem('statusbarTab', 'true');
		qqbrowser.extension.builtin.config.get(['tagsTatus'], function( ret ) {
			var ret = JSON.parse( ret )[0];
			if (ret.tagsTatus === 0) {
				// 显示前台按钮，隐藏后台按钮
				qqbrowser.layout.foregroundButton.show(true);
				qqbrowser.layout.backgroundButton.show(false);
			}else {
				// 显示后台按钮，隐藏前台按钮
				qqbrowser.layout.backgroundButton.show(true);
				qqbrowser.layout.foregroundButton.show(false);
			}
		});
	} else {
		localStorage.setItem('statusbarTab', 'false');
		qqbrowser.layout.foregroundButton.show(false);
        qqbrowser.layout.backgroundButton.show(false);
	}
};
qqbrowser.js.logic.configManager.setStatusbarBlock = function (config) {
	if ( !config.hasOwnProperty('statusbarBlock') ) {
		return;
	}
	if ( config.statusbarBlock ) {
		localStorage.setItem('statusbarBlock', 'true');
		qqbrowser.layout.popupBlockButton.show( true );
	} else {
		localStorage.setItem('statusbarBlock', 'false');
		qqbrowser.layout.popupBlockButton.show( false );
	}
};
qqbrowser.js.logic.configManager.setStatusbarScale = function (config) {
	if ( !config.hasOwnProperty('statusbarScale') ) {
		return;
	}
	if ( config.statusbarScale ) {
		localStorage.setItem('statusbarScale', 'true');
		qqbrowser.layout.zoomButtonContainer.style.display = '';
	} else {
		localStorage.setItem('statusbarScale', 'false');
		qqbrowser.layout.zoomButtonContainer.style.display = 'none';
	}
};
/**
 * 获取配置。
 * @param {Array} configArray 每个元素都是一个字符串，表示要查询的项。
 * @param {function} callback 查询的结果会通过回调函数传回来。
 */
qqbrowser.js.logic.configManager.getConfig = function(configArray, callback) {
    qqbrowser.extension.builtin.config.get(configArray, callback); 
};

/**
 * 设置配置。
 * @param {Array} configArray 数组的每个元素都是一个字符串，表示要设置的项（key）。
 * @param {function} callback 设置成功后的回调函数，可以是一个空函数，表示什么都不做。
 */
qqbrowser.js.logic.configManager.setConfig = function(config, callback) {
    if (!callback) {
        callback = function() {};
    }
    qqbrowser.extension.builtin.config.set(config, callback);
};
