// 页面的内核类型
var CORE_TYPE = {
	IE: 0,
	WEBKIT: 1
};

var LIST_TYPE = {
	RECOMMENDED: 1,  // 推荐名单
	USER_HISTORY: 2, // 用户切换记录
	COMPULSORY: 4	// 强制名单
};

var browserListener = {};

if (qqbrowser.js === undefined) {
	qqbrowser.js = {};
}

if (qqbrowser.js.logic === undefined) {
	qqbrowser.js.logic = {};
}

if (qqbrowser.js.logic.skinStatus === undefined) {
	qqbrowser.js.logic.skinStatus = null;
}

// 定义全局变量以完成登陆相关的逻辑（现阶段主要使用于彩贝）
qqbrowser.js.logic.isLogin = null;
qqbrowser.js.logic.isLogout = null;


qqbrowser.js.logic.isAdressfocus = null;
qqbrowser.js.logic.skinActivated = false;
qqbrowser.js.logic.isAero = null;
qqbrowser.js.logic.isFarmAlarmPop = true;
qqbrowser.js.logic.farmAlarmRequest = null;
qqbrowser.js.logic.farmAlarmCount = 0;
qqbrowser.js.logic.hasTabSelected = false;
qqbrowser.js.logic.qzoneSpeedTimer = -1;
qqbrowser.js.logic.lastPercent = 0;

browserListener.init = function() {
	// 配置改变时
	qqbrowser.extension.builtin.config.onConfigChanged.addListener(function(config) {
		//config = eval('(' + config + ')');

		config = JSON.parse(config);

		if (config.hasOwnProperty('caibeiBindConfirm')) { // 用户在操作过程中，如果config发生变化，需要刷新当前记录的config值
			qqbrowser.js.logic.caibeiBindConfirm = config.caibeiBindConfirm;
		}

		if (config.hasOwnProperty('caibeiOptionModified')) {
			qqbrowser.js.logic.caibeiOptionModified = config.caibeiOptionModified;
		}

		// TODO 检查是否会每个设置都进
		qqbrowser.js.logic.configManager.setView(config);
	});

	// 设置aero时
	qqbrowser.os.windows.onDwmCompositionChanged.addListener(function() {
		qqbrowser.js.logic.isAero = browser.os.windows.isDwmCompositionEnabled();
		qqbrowser.js.logic.viewManager.setAero(qqbrowser.js.logic.isAero);
	});


	qqbrowser.skin.onThemeChanged.addListener(function(strTheme) {
		// 换肤后销毁所有通知（因为通知指向的元素位置可能变化）
		NotificationManager.destroyAll();

		// 菜单区域绑定更换
		qqbrowser.js.logic.menuManager.headbarMenuBind(strTheme);

		// 换肤完成后保留当前的皮肤状态
		qqbrowser.js.logic.skinStatus = strTheme;
		Skin.app.Detector.detectThemeGroup(strTheme);
	});

	// about focus
	/*
	 * @function 设置焦点的函数 @description 当现在焦点在网页上的时候，鼠标按住skin部分，会触发这个事件
	 * 如果当前按下是在地址栏中的输入框里，或者是下拉button时， return 1 表示skin需要焦点 如果按下的在其他位置 ， 鼠标释放的时候
	 * return 2 表示不需要焦点，但是需要取消焦点还原，return 0 表示skin不需要焦点，会把焦点还回到页面
	 */
	qqbrowser.skin.window.onSyncCallBack.addListener(function(arg) {
		var para = qqbrowser.js.logic.utils.unpack(arg);
		if ("checkFocus" == para[0]) {
			var elem = document.elementFromPoint(para[1], para[2]);
			if ("address-fav-button" == elem.id) { //快速收藏按钮
				return 2;
			}
			else if (("address-input" == elem.id)
					|| ("address-list-button" == elem.id)) {
				//addressbar.focus();
				var addressInput = document.getElementById('address-input');

				// 如果当前没有有选中状态，那么全选
				if (addressInput.selectionStart === addressInput.selectionEnd) {
					addressbar.selectAllInput();
				}

				return 1;
			} else if ("home-button" == elem.id || ("qqbrowser-widgets-findbar-inputSpace" === elem.id)) {
				return 1;
			}
		} else if ("clearAddressSelectInfo" == para[0]) {
			return 1;
		} else if ("onHitTest" == para[0]) {
			var element = document.elementFromPoint(para[1], para[2]);
			var y = para[2];
			var x = para[1];
			var windowHeight = window.innerHeight;
			var windowWidth = window.innerWidth;
			var borderWidth = qqbrowser.js.logic.viewManager
					.getSkinBorderWidth();
			var resizeTemp = document.getElementById("resize-temp");
			var sizeGrip = document.getElementById("statusbar-size-grip");
			var sizeGripWidth = sizeGrip.offsetWidth;
			var sizeGripHeight = sizeGrip.offsetHeight;

			// 添加一个数据结构，用于菜单栏元素id与其名称的映射
			var menubarName = {
				"main-headbar-menu-file-button" : 'fileMenuButton',
				"main-headbar-menu-edit-button" : 'editMenuButton',
				"main-headbar-menu-view-button" : 'viewMenuButton',
				"main-headbar-menu-favorite-button" : 'favoriteMenuButton',
				"main-headbar-menu-tool-button" : 'toolMenuButton',
				"main-headbar-menu-help-button" : 'helpMenuButton'
			};

			// 浏览器的拖拽及缩放行为
			var dragType = {
				drag : 5,
				leftdown : 3,
				rightdown : 4,
				leftup : 22,
				rightup : 23,
				up : 21,
				left : 12,
				right : 18,
				down : 2,
				sidebar : 27,
				menuSourceArea:  28
			};

			// 标识当前是不是点击到收藏栏收藏的标识位
			var favMenuFlag = false;
			var favElement = element;

			// 由于favFolder以及favItem有子元素，
			// 所以需要遍历其父元素才能判断其是否为收藏元素
			// 现在这种实现方式效率比较差，实际上只需要判断多一层就可以
			// TODO 后期优化
			while(favElement && favElement !== document.body) {
				if (favElement.hasClass('fav-folder') || favElement.hasClass('fav-item')) {
					favMenuFlag = true;
					break;
				}
				favElement = favElement.parentNode;
			}

			var currentDragType = 0;
			var elementId = element.id;

			if (element === Cube('#cube-app-titlebar .icon')[0]) {
				return 0;
			}
			

			if (element.parentNode === Cube('#cube-app-titlebar')[0]) {
				element = element.parentNode;
			}

			if (qqbrowser.js.logic.eventManager.isInDragArea(element.id)) {
				currentDragType = dragType.drag;
			} else if (x <= borderWidth && y >= windowHeight - borderWidth) { // 左下角
				currentDragType = dragType.leftdown;
			} else if (x >= windowWidth - borderWidth - sizeGripWidth
					&& y >= windowHeight - borderWidth - sizeGripHeight) { // 右下角
				currentDragType = dragType.rightdown;
			} else if (y <= borderWidth && x <= borderWidth) { // 左上角
				currentDragType = dragType.leftup;
			} else if (y <= borderWidth && x >= windowWidth - borderWidth) { // 右上角
				currentDragType = dragType.rightup;
			} else if (y <= borderWidth) { // 上边样式
				currentDragType = dragType.up;
			} else if (x <= borderWidth) {
				currentDragType = dragType.left; // 左边样式
			} else if (x >= windowWidth - borderWidth) { // 右边样式
				currentDragType = dragType.right;
			} else if (y >= windowHeight - borderWidth) { // 下边样式
				currentDragType = dragType.down;
			}
			else if (x >= resizeTemp.offsetLeft && //侧边栏区域
					x <= (resizeTemp.offsetLeft + resizeTemp.offsetWidth) &&
					y <= (resizeTemp.offsetTop + resizeTemp.offsetHeight) &&
					y >= resizeTemp.offsetTop) {
				currentDragType = dragType.sidebar;

			// Modified by littleli
			// 主要解决升级为content api之后的菜单问题
			// 菜单三态问题需要更改机制
			// 当菜单展开时，c++先收到的l-button-down事件，
			// 如果此时菜单打开那么通知c++不进行处理（不销毁菜单窗口），由JS进行相应的维护
			} else if ((elementId in menubarName) && qqbrowser.layout[menubarName[elementId]]['isEnable'] === 0) {
				currentDragType = dragType.menuSourceArea;

			// Modified by littleli
			// 主要解决升级为content api之后的菜单问题
			// 当菜单展开时，c++先收到的l-button-down事件，
			// 如果此时菜单打开那么通知c++不进行处理（不销毁菜单窗口），由JS进行相应的维护
			} else if ( favMenuFlag && qqbrowser.js.logic.favbarManager.menuOpen == 0 ) {
				currentDragType = dragType.menuSourceArea;
			}

			return currentDragType;
		}
		return 0;
	});

	/*
	 * 地址栏相关的显示事件
	 */
	qqbrowser.addressbar.onPaste.addListener(function(url) {
		var urls = url.split("\n");
		url = urls.join("");
		var viewManager = qqbrowser.js.logic.viewManager;
		//viewManager.setFocus2Skin();

		// 粘贴时需要记录当时地址栏的选中状态，而不是做简单的全部替换
		var addressInfo = qqbrowser.layout.addressbar.getAddress();
		var newAddress = addressInfo.url.substring(0, addressInfo.select_start) + url + addressInfo.url.substring(addressInfo.select_end);
		var position = addressInfo.select_end + url.length;

		var newAddressInfo = {
			"url" : newAddress,
			select_start : position,
			select_end : position
		};
		qqbrowser.layout.addressbar.setAddress(newAddressInfo);
	});
	qqbrowser.addressbar.onSelectAllText.addListener(function() {
		// 激活皮肤窗口
		var viewManager = qqbrowser.js.logic.viewManager;
		viewManager.setFocus2Skin();
		var addressInfo = qqbrowser.layout.addressbar.getAddress();
		var url = addressInfo.url;
		var newAddressInfo = {
			"url" : url,
			select_start : 0,
			select_end : url.length
		};
		// 保证在焦点回到地址栏之后再做全选操作
		setTimeout(function() {
			qqbrowser.layout.addressbar.setAddress(newAddressInfo);
		}, 100);
	});

	qqbrowser.addressbar.onDeleteText.addListener(function() {
		var addressInfo = Skin.app.TabBar.instance.activeTab.data.addressInfo,
			url = addressInfo.url,
			start = addressInfo.select_start,
			end = addressInfo.select_end, newUrl, newAddressInfo;

		newUrl = url.slice(0, start) + url.slice(end);
		newAddressInfo = {
			"url" : newUrl,
			select_start : newUrl.length,
			select_end : newUrl.length
		};
		qqbrowser.layout.addressbar.setAddress(newAddressInfo);

	});

	qqbrowser.addressbar.onPlasterOpen.addListener(function(url) {
		var index = url.indexOf('\n');
		if (index !== -1) {
			url = url.substring(0, index - 1) + url.substring(index + 1);
		}
		browser.tabs.create(url, 1);
	});

	/**
	 * 浏览器地址栏功能支持
	 */
	qqbrowser.addressbar.onSetFocus.addListener(function() {
		var viewManager = qqbrowser.js.logic.viewManager;
		viewManager.setFocus2Skin();
	});

	/**
	 * 地址栏下拉功能支持
	 */
	qqbrowser.addressbar.onDropDown.addListener(function() {
		var viewManager = qqbrowser.js.logic.viewManager;

		// modified by yinzhou
		if (addressbar.isListShown()) {
			qqbrowser.skin.addressbar.adjustHeight(0);
		} else {
			viewManager.setFocus2Skin();
			addressbar.showAddresslist();
		}
	});

	/**
	 * 控制皮肤界面按钮状态
	 *
	 * @param {string}
			*			extId 扩展的 GUID
	 * @param {number}
			*			state 按钮的状态，0-可用；1-禁用；2-隐藏；3-显示；4-选择；5-不选择
	 */
	qqbrowser.skin.onSetButtonStatus.addListener(function(extId, state) {
		switch (extId) {
			case "{510EEC09-09E9-4003-AFDD-CCB3803286C3}": // 清理浏览痕迹
				if (state == 4) {
					qqbrowser.layout.cleanButton.addClass("selected");
				} else if (state == 5) {
					qqbrowser.layout.cleanButton.removeClass("selected");
				}
				break;

			case "{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}": // 收藏面板
				if (state === 0) { // normal
					qqbrowser.layout.favButton.removeClass("open");
					qqbrowser.layout.favButton.removeClass("pressed");
					setTimeout(function() {
						qqbrowser.layout.favButton.isEnable = 1;
					}, 200);
				} else if (state === 4) { // pressed
					qqbrowser.layout.favButton.addClass("open");
					qqbrowser.layout.favButton.isEnable = 0;
				}
				break;

			default:
		}
	});

	/**
	 * 当发生一些事件时，后台 C++ 需要来设置我们前端页面元素的文本，例如当拦截了 一个弹出窗口时，后台需要让状态栏弹窗拦截按钮的数字增加
	 * 1，或者当在网页缩放 菜单中点击了某项时，后台需要设置网页缩放按钮的文字为相应的百分比。
	 *
	 * @param {string}
			*			extId 需要设置文本的扩展的 GUID
	 * @param {string}
			*			text 待设置的文本
	 */
	qqbrowser.skin.setButtonText
			.addListener(function(extId, text) {
		/* 建立扩展 ID 与相应的 div 元素 id 的映射表 */
		var map = {
			"{87281D86-2185-4656-BF0D-C88478545F4C}" : qqbrowser.layout.popupBlockButton.id,
			"{D21B044A-3FDF-4241-865C-5692771BED80}" : qqbrowser.layout.zoomButton.id
		},
				button = qqbrowser.layout.popupBlockButton;

		if (map[extId] === 'statusbar-popup-block-button') {
			if (parseInt(text, 10) !== 0) {
				//button.setText(text);
				// 动态地生成相应的dom元素以完成动态响应数字显示的问题
				button._element.innerHTML = '';
				var textNode = document.createElement('span')	;
				textNode.style.marginLeft = '22px';
				textNode.style.marginRight = '2px';
				textNode.innerText = text;
				button._element.appendChild(textNode);
			} else {
				button._element.innerHTML = '';
			}
		} else {
			document.getElementById(map[extId]).innerText = text;
		}
	});

	qqbrowser.skin.addressbar.onShow.addListener(function(isListShown) {
		setTimeout('addressbar.setIsListShown(' + isListShown + ')', 200);
	});
	// 页面上右键菜单的listener
	qqbrowser.tabs.onBeforeMenu.addListener(function(params) {
		var menuInfo = eval('(' + params + ')');

		var location = {
			leftBottomX : menuInfo.x,
			leftBottomY : menuInfo.y,
			rightTopY : menuInfo.y,
			rightTopX : menuInfo.x
		};
		var contentParams = menuInfo;

		var menuParams = {
			location : location,
			contentParams : contentParams
		};

		qqbrowser.js.logic.menuManager.showMenu('contentMenu', menuParams);
	});
	// 扩展菜单弹出机制
	qqbrowser.skin.onMenuPopupRequest.addListener(function(jsonSource, menuId, jsonPopArea, jsonBuildParams) {
		var source = JSON.parse(jsonSource);
		var popArea = JSON.parse(jsonPopArea);
		var location = {
			leftBottomX : popArea.x,
			leftBottomY : popArea.y + popArea.height,
			rightTopY : popArea.y,
			rightTopX : popArea.x + popArea.width
		};
		var menuParams = {
			location : location
		};
		qqbrowser.js.logic.menuManager.showMenuInEnv(source.envId, menuId,
				menuParams, unescape(source.extId));
	});

	/* 处理与登录相关的事件回调 */
	qqbrowser.account.onBeforeLogin.addListener(function() {
		qqbrowser.js.logic.viewManager.startLoginAnimation();
	});

	qqbrowser.account.onLogin.addListener(function(windowId, uin, strUin, nickName, facePath) {
		var userInfo;

		$("#main").addClass("loggedin");
		qqbrowser.js.logic.accountUin = uin;
		qqbrowser.js.logic.lastLoginFacePath = facePath;
		loggedIn = true;
		qqbrowser.js.logic.viewManager.stopLoginAnimation();
		qqbrowser.layout.logoButton._element.style.background = "url('"
				+ facePath.replace(/\\/g, "/") + "')";
		qqbrowser.layout.logoButton._element.style.backgroundSize = "100%";
		qqbrowser.layout.logoButton._element.style.backgroundPosition = "0px 0px";
		if (jsonp) {
			jsonp.updateQzone();
			jsonp.updateWeiBo();
		}



		qqbrowser.js.logic.isLogin = true;

		// 设置帐号信息
		setTimeout(function() {
			qqbrowser.account.getCurrent(function(accountData) {
				userInfo = JSON.parse(accountData)[0];
				if (typeof userInfo.nUin === "number" && userInfo.nUin !== 0) {
					Skin.app.TitleBar.instance.setData({
						nickname: decodeURIComponent(userInfo.strNickName),
						uin: decodeURIComponent(userInfo.nUin)
					});
				}
			});
		}, 300);
		// 经典大众皮肤更新标题栏帐号信息
	});

	qqbrowser.account.onLoginFinish.addListener(function() {
	});

	qqbrowser.account.onLoginFailed.addListener(function() {
		qqbrowser.js.logic.viewManager.stopLoginAnimation();
		if (loggedIn) {
			qqbrowser.layout.logoButton._element.style.background = "url('"
					+ qqbrowser.js.logic.lastLoginFacePath.replace(/\\/g, "/") + "')";
			qqbrowser.layout.logoButton._element.style.backgroundSize = "100%";
			qqbrowser.layout.logoButton._element.style.backgroundPosition = "0px 0px";
			$("#main").addClass("loggedin");
		} else {
			qqbrowser.layout.logoButton._element.setAttribute('style', '');
			$("#main").removeClass("loggedin");
		}


	});

	qqbrowser.account.onConnectFailed.addListener(function() {
	});

	qqbrowser.account.onUpdate.addListener(function(windowId, uin, strUin, nickName, facePath) {
		if (loggedIn && qqbrowser.js.logic.lastLoginFacePath !== facePath) {
			qqbrowser.layout.logoButton._element.style.background = "url('"
					+ facePath.replace(/\\/g, "/") + "')";
			qqbrowser.layout.logoButton._element.style.backgroundSize = "100%";
			qqbrowser.layout.logoButton._element.style.backgroundPosition = "0px 0px";
		}
	});

	qqbrowser.account.onLogout.addListener(function() {
		loggedIn = false;
		// 注销时删除掉 js 通过 inline style 动态添加的头像，使用原来 css 中的默认 logo
		qqbrowser.layout.logoButton._element.setAttribute('style', '');
		$("#main").removeClass("loggedin");

		// 经典大众皮肤更新标题栏帐号信息
		Skin.app.TitleBar.instance.setData({
			nickname: '',
			uin: ''
		});

		qqbrowser.js.logic.isLogin = false;

		var qzoneTopButton = document.getElementById("qzone-top-button");
		var sideBarWeiBoButton = document.querySelector("#sidebar-weibo-button .sidebar-feed-float");
		if (qzoneTopButton) {
			qzoneTopButton.style.display = "none";
		}
		if (sideBarWeiBoButton) {
			sideBarWeiBoButton.removeClass("show");
		}
		appboxButton.sideBarFeed.removeClass("show");
		if (qqbrowser.js.logic.tipManager) {
			qqbrowser.js.logic.tipManager.qzoneCount = 0;
			qqbrowser.js.logic.tipManager.friendCount = 0;
		}

	});

	// 撤销列表事件
	qqbrowser.recentclosed.onRemoved.addListener(function(isClean, undoListCount) {
		if (undoListCount == 0) { // 没有撤销列表时，禁用按钮
			qqbrowser.layout.undoButton.disable();
			qqbrowser.layout.undolistButton.disable();
		}
	});

	qqbrowser.recentclosed.onAdded.addListener(function() {
		// 有撤销列表项目时，启用按钮
		qqbrowser.layout.undoButton.enable();
		qqbrowser.layout.undolistButton.enable();
		qqbrowser.js.logic.eventManager.bindUndoButtons();
	});

	qqbrowser.extension.onRequest.addListener(function(reqId, sender, request, callback) {
		sender = JSON.parse(sender);
		request = JSON.parse(request);
		qqbrowser.js.logic.farmAlarmRequest = request;
		var extId = unescape(sender.extId);
		
		// “清理浏览痕迹”扩展
		if (extId === "{510EEC09-09E9-4003-AFDD-CCB3803286C3}") {
			if (request.status === "updateMute") {
				if (request.mute === "1") {
					qqbrowser.layout.soundControlButton.addClass("close");
					qqbrowser.layout.soundControlButton.status = 0;
				}
				else {
					qqbrowser.layout.soundControlButton.removeClass("close");
					qqbrowser.layout.soundControlButton.status = 1;
				}

				return;
			}
		// “弹窗拦截”扩展
		} else if (extId === "{87281D86-2185-4656-BF0D-C88478545F4C}") {
			// 获取当前弹窗拦截按钮的状态，如果此时已隐藏弹窗按钮，则不现实tip
			qqbrowser.extension.builtin.config.get(['statusbarBlock'], function(config) {
				var config = JSON.parse(config)[0];
				if (!config.statusbarBlock) {
					return;
				}
				if (request.show === 1) {
					if (request.poppage != browser.getCurrentPageId() /*通过判断当前page是否要弹气泡的那个page*/) {
						return;
					}
					
					NotificationManager.create($('#statusbar-popup-block-button')[0], 'STATUSBAR.POPUP_BLOCK');
				}
				else if (request.show === 0) {//销毁弹窗气泡
					NotificationManager.destroyByType('STATUSBAR.POPUP_BLOCK');
				}
			});
		}
	});

	qqbrowser.accelerator.onBeforeTriggerd.addListener(function(acceleratorKey) {
		//当acceleratorKey为589时，切换图标
		qqbrowser.extension.builtin.config.get(['statusbarMute'], function( config ) {
			// 判断当前静音按钮是否已隐藏，若已隐藏，则弹出tip，by simonsliu 2012-02-10 状态栏按钮自定义显示隐藏
			var config = JSON.parse(config)[0];
			if ( !config.statusbarMute ) {
				return;
			}
			if (acceleratorKey == 'Acc_Mute') {
				var obj = {};
				if (qqbrowser.layout.soundControlButton.status == 0) {

					obj.mute = "0";
					qqbrowser.layout.soundControlButton.status = 1;
					qqbrowser.layout.soundControlButton.removeClass("close");
					NotificationManager.create(qqbrowser.layout.soundControlButton._element, 'STATUSBAR.SOUND_CONTROL', {isMute: false});
				} else {
					qqbrowser.layout.soundControlButton.status = 0;
					obj.mute = "1";
					qqbrowser.layout.soundControlButton.addClass("close");
					NotificationManager.create(qqbrowser.layout.soundControlButton._element, 'STATUSBAR.SOUND_CONTROL', {isMute: true});
				}
				//给clean发消息，clean会通知所有的皮肤窗口更新静音状态
				obj.command = "updateMute";
				try {
					var cleanGUID = "{510EEC09-09E9-4003-AFDD-CCB3803286C3}";
					qqbrowser.extension.sendRequest(cleanGUID, obj, function(reply) {
					});
				} catch(err) {
				}
			}
		});
	});

	// 密码自动保存扩展发过来的消息
	qqbrowser.extension.onEvent.addListener(function(event, data) {
		data = JSON.parse(data);
		var savePWinfobar = qqbrowser.layout.savePWinfobar;
		var tabBar = Skin.app.TabBar.instance,
			tabData;

		if (event == 'EventAutoFillTip') {
			tabData = tabBar.getTabByData( 'pageId', data.pageId ).data;
			var nickname = data.nickname;
			var title = data.title;
			var tempNickname = unescape(unescape(nickname));
			var tempTitle = unescape(unescape(title));
			savePWinfobar.show(true);
			browser.extension.builtin.statistics.increase(STATIS_TIPBAR_CODESAVE_POPED);
			tabData.savePW = [ tempNickname, tempTitle ];
			savePWinfobar.currentPageId = tabData.pageId;
		}
	}, {
		evtOwner : '{75A78384-8765-4852-ABB7-8D5FA8BF48E2}'
	});


	// QQ空间扩展发送过来的消息
	var qzoneExt = "{75A78384-8765-4852-ABB7-8D5FA8BF48E3}";
	qqbrowser.extension.onRequest.addListener(function(reqId, sender, request, callback) {
		sender = JSON.parse(sender);
		request = JSON.parse(request);
		var windowId = request["windowId"];
		var extId = unescape(sender.extId);
		// 升级安装进度更新
		if (extId === qzoneExt && windowId === browser.window.currentId()) {
			if (jsonp) {
				var qzoneTopButton = document.getElementById("qzone-top-button");
				qzoneTopButton.style.display = "none";
			}
		}
	});

	//农场闹钟事件监听
	qqbrowser.skin.qqfarmDialog.addListener(function() {
		browser.skin.buttonClicked('{75A78384-8765-4852-ABB7-8D5FA8BF48E3}', document.body, 2);
	});
	// 关于对话框
	qqbrowser.skin.aboutDialog.addListener(function(windowId) {
		var oParent = {};
		oParent.type = "window";
		oParent.id = windowId;
		qqbrowser.dialog.create(oParent, "aero\\aboutDialog.html", 336, 249,
				true, escape("关于 QQ浏览器"), true);
	});

	// added by yinzhou
	// 即将触发快捷键时地址栏下拉必须隐藏
	qqbrowser.accelerator.onBeforeTriggerd
			.addListener(function(acceleratorKey) {
		browser.skin.addressbar.adjustHeight(0);
	});

	// 监听标题栏右键菜单的"关闭“事件
	qqbrowser.extension.builtin.onBeforeWindowClosed.addListener(function() {
		qqbrowser.js.logic.closeManager.onWindowClose();
	});

	qqbrowser.skin.window.onActivate
			.addListener(function(dummy, skinActivated) {
		qqbrowser.js.logic.skinActivated = skinActivated;
		if (!skinActivated) {
			addressbar.clearSelectionInfo();
		}
	});


	/**
	 *检查升级对话框
	 */
	qqbrowser.extension.builtin.onCheckUpdate.addListener(function(windowId) {
		var obj = {};
		obj.paramone = "1";
		obj.command = "OnManualCheckUpdate";
		browser.extension.sendRequest("{3E92C4RD-2264-2g12-9BD8-7351394BAGP3}", obj,
				function(reply) {
				});
	});

	/**
	 * 安全提示气泡的消息
	 */
	qqbrowser.extension.onEvent.addListener(function(evtName, evtParam) {
		var results = JSON.parse(evtParam);
		if (results) {
			if (results.status && qqbrowser.layout.safeTipButton) {
				var status = results.status;

				if (status === 'white' || status === 'unknown') {
					qqbrowser.layout.safeTipButton.show(false);
				} else {
					qqbrowser.layout.safeTipButton.show(true);
					qqbrowser.layout.safeTipButton.status = results.status;
					qqbrowser.layout.safeTipButton.addClass(results.status);
					// 先判断是否为第一次及恶意网址会出现tip提示用户
					if (results.first || results.status === "evil") {
						qqbrowser.js.logic.safeTipOpen(status);
					}
				}
			}

		}

	}, {evtOwner : "{0E8E2CF3-1300-41ee-B2B0-7413C0A49719}"});
	
	
	qqbrowser.fullscreen.onNotify.addListener(function(status) {
		//status "0"表明关闭侧边栏 "1”打开侧边栏
		var isShow = status == '0' ? false : true;
		appboxButton && appboxButton.appBoxDockShow && appboxButton.appBoxDockShow(isShow);
	});

	/**alt+F4事件监听关闭窗口
	 */
	qqbrowser.skin.window.onClose.addListener(function() {
		qqbrowser.js.logic.closeManager.onWindowClose();
	});

	/*
	 qqbrowser.history.onVisited.addListener(function() {

	 });
	 */
	 
	// 浏览器启动弹泡事件
	// type:
	// 1 本地没有缓存的网络收藏数据
	// 2 本地有缓存的网络收藏数据
	qqbrowser.bookmark.onBookmarkPopupTips.addListener(function(type) {
		 var notificationFullName = type === 1 ? 'LOGIN.ACCOUNT_NO_LOCAL_BOOKMARK' : (type === 2 ? 'LOGIN.ACCOUNT_HAS_LOCAL_BOOKMARK' : null);
		 if (notificationFullName !== null ) {
			  NotificationManager.create(qqbrowser.layout.logoButton._element, notificationFullName);
		 }
	});
	
	/*
	 * 环境相关的request
	 * @param reqId int
	 * @param sender string JSON.parse(sender) => object {extId: string 扩展UUID, windowId: int}
	 * @param request string JSON.parse(request) => object 传入的请求参数
	 */
	var requestDone = {};
	window.showBookmarkReadonlyNotification = function(reqId, sender, request) {
		sender = JSON.parse(unescape(sender));
		request = JSON.parse(unescape(request));
		if (sender.extId !== '{80944EE7-D5ED-46f6-86DF-53FCE8B945AB}'
			|| request.command !== 'BOOKMARK_READONLY_NOTIFICATION'
			|| qqbrowser.window.currentId() !== sender.windowId
			|| requestDone[reqId]) {
			return;
		}
		
		requestDone[reqId] = true;
		NotificationManager.create(qqbrowser.layout.logoButton._element, 'LOGIN.BOOKMARK_READONLY');
	};
	
	// 新建窗口（不是启动浏览器的第一个窗口）初始化时不会触发qqbrowser.account.onEnvironmentChanged事件，需要先绑定一次
	qqbrowser.extension.onRequest.addListener(showBookmarkReadonlyNotification);
	// 因为皮肤是环境相关的扩展，所以改变帐号需要重新绑定事件。来回切换帐号会导致一个环境下多次绑定一个事件。
	qqbrowser.account.onEnvironmentChanged.addListener(function(int1, int2, account) {
		qqbrowser.extension.onRequest.addListener(showBookmarkReadonlyNotification);
	});
	
	// 收藏在线状态变更
	// stateId：
	// -1 非法值
	// 0  初始值
	// 1  本地（浏览器没有选定自动登录并且未登录，使用本地收藏，此时可对收藏数据作修改）
	// 2  在线（浏览器已登录，使用网络收藏，如果同步状态为0则可对收藏数据作修改）
	// 3  离线（浏览器已经选定自动登录或者浏览器掉线，使用本地缓存网络收藏，此时不可对收藏数据作修改）
	window.loginState = 0;
	qqbrowser.account.onLoginStateChanged.addListener(function(stateId) {
		window.loginState = stateId;
	});
	
	// 新建窗口（不是启动浏览器的第一个窗口）初始化时不会触发qqbrowser.account.onLoginStateChanged事件，需要先绑定一次
	qqbrowser.account.getLoginState(function(state) {
		// 1 未登录
		// 2 登录
		// 3 离线状态—伪登陆状态
		loginState = Number(JSON.parse(state)[0]);
		// qqbrowser.account.getCurrent
	});
};