/**
 * @fileoverview
 * adapter for browser api, control browser actions
 * @author littleli
*/

if (undefined === browser) {
    var browser = {};
}

browser.closeconfirm = {};
browser.extension = {};
browser.extension.onEvent = {};
browser.log = {};
browser.os = {};
browser.os.windows = {};
browser.page = {};
browser.recentclosed = {};
browser.skin = {};
browser.skin.menu = {};
browser.skin.window = {};
browser.tabs = {};
browser.tooltip = {};
browser.window = {};
browser.tip = {};
browser.menuTimer = null;

/**


/**
 *  缁欐墿灞曞彂閫佹秷鎭?
 *  extID : 鎵╁睍Id
 *  cmd : 闇?鎵ц鐨勫懡浠?
 *  callbackFunc : 鍥炶皟鍑芥暟
 */
browser.extension.sendRequest = function(extId, cmd, callbackFunc) {
    if (qqbrowser) {
        qqbrowser.extension.sendRequest(extId, cmd, callbackFunc);
    }
};

/**
 *  鎵╁睍鍙戦?娑堟伅鐩戝惉鍣?
 *  handler : 浜嬩欢澶勭悊鍑芥暟
 *  evtOwner : 鎵╁睍鎷ユ湁鑰?
 */
browser.extension.onEvent.addListener = function(handler, evtOwner) {
    if (qqbrowser) {
        qqbrowser.extension.onEvent.addListener(handler,evtOwner);
    }
};

/**
 * switch current tab index to browser page id
 * index + 1 = id
 */
browser.getCurrentPageId = function() {
    return Skin.app.TabBar.instance.activeTab.data.pageId;
};

/**
 * 鍒ゆ柇褰撳墠鏄〉闈㈣繕鏄祻瑙堝櫒鐜
 */
browser.isPage = function() {
    if (qqbrowser) {
        return 0;
    } else {
        return 1;
    }
};

// qqbrowser.log.info
browser.log = function(message, filter) {
    if (qqbrowser.log.info) {
		if (filter) {
			qqbrowser.log.info('[' + filter + '] ' + message);
		} else {
			qqbrowser.log.info("littleli+xxxx" + message);
		}
    } else {
		if (filter) {
			console.info('[' + filter + '] ' + message);
		} else {
			console.info(message);
		}
    }
};


/**
 * 鐢ㄤ簬妫?祴绯荤粺aero鐜鐨勬敼鍙?
 */

browser.os.windows.isDwmCompositionEnabled = function() {
	if (qqbrowser) {
		return qqbrowser.os.windows.isDwmCompositionEnabled();
	} 
};


/**
 * page go back
 */
browser.page.goBack = function() {
    if (qqbrowser) {
        qqbrowser.page.goBack(browser.getCurrentPageId());
    }
};

/**
 * page go forward
 */
browser.page.goForward = function() {
    if (qqbrowser) {
        qqbrowser.page.goForward(browser.getCurrentPageId());
    }
};

/**
 * page open link
 */
browser.page.navigate= function(url) {
    if (qqbrowser) {
        qqbrowser.page.navigate(browser.getCurrentPageId(), url, 0);
    }
};

/**
 * page go reload
 */
browser.page.reload = function() {
    if (qqbrowser) {
        qqbrowser.page.reload(browser.getCurrentPageId());
    }
};

browser.page.stopLoad = function(pageId) {
    if (qqbrowser) {
        qqbrowser.page.stopLoad(pageId);
    }
};

browser.recentclosed.undo = function() {
    if (qqbrowser) {
        qqbrowser.recentclosed.undo();
    }
};

browser.recentclosed.get = function(func) {
    if (qqbrowser) {
        qqbrowser.recentclosed.get(func);
    }
};

browser.skin.buttonClicked = function(strExtId, button, clickType) {

    var buttonLeftBottom = qqbrowser.js.logic.viewManager.getMenuLeftBottom(button);

    clickType = clickType ? clickType : 1; // 娴忚鍣ㄩ渶瑕佺殑鐐瑰嚮绫诲瀷锛?涓篵utton锛?涓轰笅鎷夊垪琛?
    var div = button;

    //鑾峰彇button鍒癰ody鐨刲eft鍜宼op鐨勫?
    var p = {x: 0 ,y: 0};
    while (div && div != document.body) {
        p.x += div.offsetLeft || 0;
        p.y += div.offsetTop || 0;
        div = div.offsetParent;
    }
    var borderWidth = qqbrowser.js.logic.viewManager
        .getBorderWidth(button);//瑙ｅ喅鍦ㄦ柊鐨偆涓伐鍏锋爮鐨勬寜閽墿澶order鐨勫?锛屼娇寰楄彍鍗曟樉绀轰綅缃笌鎸夐挳涔嬮棿闂磋窛杩囧ぇ
    p.y += button.offsetHeight - borderWidth.bottom;
    if (qqbrowser) {
        qqbrowser.skin.buttonClicked(strExtId, p.x, p.y, clickType);
    }
};

// qqbrowser.skin.dragStart
browser.skin.dragStart = function(dragType) {
    if (qqbrowser) {
        qqbrowser.skin.dragStart(dragType);
    }
};



// qqbrowser.skin.resize
browser.skin.resize = function(positionInfo) {
    if (qqbrowser) {
        qqbrowser.skin.resize(positionInfo);
    }
};

// qqbrowser.skin.setTheme
browser.skin.setTheme = function(strTheme) {
    if (qqbrowser) {
        qqbrowser.skin.setTheme(strTheme);
    }
};

browser.skin.menu.build = function(envId, type, params, extId) {
    var menuMap = {
        mainMenu:            1,
        beforeLoginMenu:     2,
        contentMenu:         3,
        tabMenu:             4,
        toolbarMenu:         5,
        addressbarMenu:      6,
        favbarMenu:          7,
        usefulMenu:          8,
        afterLoginMenu:      9,
        usefulSubMenu:       10,
        tabSubMenu:          11,
        addressbarBlankMenu: 6,
        recentCloseMenu:     18,
        titleBarMenu:        19,
        favFolderMenu:       20,
        favCtxMenu:          21,
        sidebarMenu:         22,
        findbarMenu: 		 27,
        printscreenMenu: 	 28,
        titleMenu: 		 	 29,
		statusbarMenu:		 30
    };

    var typeId = /\d+/.test(menuMap[type]) ? menuMap[type] : type; // 濡傛灉map閲屾病鏈夛紝涓哄瓙鑿滃崟id锛岀洿鎺ヤ紶閫?

    var menuParams = {};
    menuParams = params.contentParams
        ? params.contentParams // 鍙抽敭鑿滃崟闇?鐨勫弬鏁?
        : { // 娴忚鍣ㄦ牴鎹璇嗗埆澶勭悊鏀惰棌澶瑰彸閿彍鍗?
            'favId': params.favId ? params.favId : 0, // 鏀惰棌澶筬av id
            'favType': params.favType ? params.favType : 'favbar', // 鏀惰棌澶筬avType
            'inputText': params.inputText ? params.inputText : '', // 鍦板潃鏍忛?涓殑鏂囧瓧,     //added by lucaszhong 2011/3/6
            'pageId': params.pageId ? params.pageId : 0, // 鏍囩椤靛彸閿垽鏂乏鍙虫爣绛鹃〉鏄惁瀛樺湪 added by lucaszhong 2011/3/8
            'addressInput': params.addressInput ? params.addressInput : false, // 鍦板潃鏍忔槸鍚︽湁杈撳叆
            'triggerOnTab': params.triggerOnTab,
            'findbarInput': params.findbarInput ? params.findbarInput : false,
    		'undoEnabled' : params.undoEnabled ? params.undoEnabled : false		
    };

    if (qqbrowser) {
        qqbrowser.skin.menu.build(envId, typeId, menuParams, function(menuData) {
            browser.skin.menu.popup(envId, type, params,extId, menuData);
        });
    }
};

/**
 * 璋冪敤娴忚鍣ˋPI锛屾鏃堕渶瑕佸垱寤轰竴涓彸閿彍鍗?
 * @param params.type 鑿滃崟绫诲瀷锛屾鍙傛暟娴忚鍣ㄤ細浼犻?缁檓enu椤甸潰
 * @param params.tabId 濡傛灉鏄痶abMenu锛屼細闄勫甫tabId锛岄渶瑕佸皢姝ゅ弬鏁板啀浼犵粰menu椤甸潰锛屼互渚垮璇ab杩涜鎿嶄綔
 * @param params.parentId 鐖惰彍鍗曠殑Id锛屽鏋滄槸椤剁骇鑿滃崟锛屾椤逛负-1
 * @param params.contentParams 椤甸潰鍙抽敭鑿滃崟闇?鐨勫弬鏁帮紝鐩存帴浼犵粰娴忚鍣?
 * @param params.location 鑿滃崟鍑虹幇鐨勫潗鏍?
 */
browser.skin.menu.popup = function(envId, type, params,extId, menuData) {
	var utils = null;
	if (qqbrowser) {
		utils = qqbrowser.js.tools.utils;
	}
    var menuMap = {
        mainMenu:            1,
        beforeLoginMenu:     2,
        contentMenu:         3,
        tabMenu:             4,
        toolbarMenu:         5,
        addressbarMenu:      6,
        favbarMenu:          7,
        usefulMenu:          8,
        afterLoginMenu:      9,
        usefulSubMenu:       10,
        tabSubMenu:          11,
        addressbarBlankMenu: 6,
        recentCloseMenu:     18,
        titleBarMenu:        19,
        favFolderMenu:       20,
        favCtxMenu:          21,
        sidebarMenu:         22,
        findbarMenu: 		 27,
        printscreenMenu: 	 28,
        titleMenu: 		 	 29,
		statusbarMenu:		 30
    };
    var menuParams = {};
    menuParams.nParentId = params.parentId ? params.parentId : 0; // 娌℃湁parentId鏄渶涓婂眰鑿滃崟锛屼负-1
    menuParams.nTypeId = /\d+/.test(menuMap[type]) ? menuMap[type] : type; // 濡傛灉map閲屾病鏈夛紝涓哄瓙鑿滃崟id锛岀洿鎺ヤ紶閫?
    
    // TODO 鏍规嵁閰嶇疆璁剧疆璺緞
    if (type == 'beforeLoginMenu') { // 鐐瑰嚮澶村儚涓旀湭鐧诲綍鏃?
        menuParams.strUrl = 'default/login_menu/before_login_menu.html';
    } else if (type == 'afterLoginMenu') { // 鐐瑰嚮澶村儚涓旂櫥褰曟椂
        menuParams.strUrl = 'default/login_menu/after_login_menu.html';
//      } else if (type == 'addressbarMenu' || type == 'addressbarBlankMenu') { // 鍦板潃鏍忓彸閿彍鍗?
//          menuParams.strUrl = 'aero/addressMenu.html';
    } else if ('favFolderMenu' == type) {
        menuParams.strUrl = 'aero/favFolderMenu.html';
    } else if ('favCtxMenu' == type) {
        menuParams.strUrl = 'aero/favCtxMenu.html';
    } else if ('sidebarMenu' == type) {
        menuParams.strUrl = 'aero/sidebarMenu.html';
    } else { // 鑿滃崟
        menuParams.strUrl = 'aero/menu.html';
    }
	
    menuParams.leftBottomX = params.location.leftBottomX;
    menuParams.leftBottomY = params.location.leftBottomY;
    menuParams.rightTopY = params.location.rightTopY;
    menuParams.rightTopX = params.location.rightTopX;
//  alert(params.folderID);
    menuParams.returnParams = { // 灏嗕紶閫掔粰鑿滃崟椤甸潰鐨勫弬鏁?
        'tabId': params.tabId ? params.tabId : 0, // 閫変腑浜嗛偅涓猼ab锛岀敤浜巘ab鍙抽敭鑿滃崟
        'isTextSelected': type == 'addressbarMenu' ? 1 : 0 // 鏄惁閫変腑浜嗘枃瀛楋紝鐢ㄤ簬鍦板潃鏍忓彸閿彍鍗?
    };
/*      menuParams.params = { // 娴忚鍣ㄦ牴鎹璇嗗埆澶勭悊鏀惰棌澶瑰彸閿彍鍗?
        'favId': params.favId ? params.favId : 0, // 鏀惰棌澶筬av id
        'favType': params.favType ? params.favType : 'favbar', // 鏀惰棌澶筬avType
    }*/

    menuParams.params = params.contentParams
        ? params.contentParams // 鍙抽敭鑿滃崟闇?鐨勫弬鏁?
        : { // 娴忚鍣ㄦ牴鎹璇嗗埆澶勭悊鏀惰棌澶瑰彸閿彍鍗?
            'pageId': params.pageId ? params.pageId : 0,
            'favId': params.favId ? params.favId : 0, // 鏀惰棌澶筬av id
            'favType': params.favType ? params.favType : 'favbar', // 鏀惰棌澶筬avType,
            'inputText': params.inputText ? params.inputText : '', // 鏀惰棌澶筬avType,
            'url':params.url?params.url:'',
            'title':params.title?params.title:''
        };
		
    var favFolderElemet = null;
    if ('favFolderMenu' == type) {
        // 鏀惰棌鏍?浼犲弬
    	
    	// 鍏堝垽鏂槸鍚︿负fav-more锛屽鏋滄槸鐢╢av-more鍘绘壘鍏冪礌锛屽鏋滀笉鏄敤鍏秄olderID鍘绘壘鐩稿簲鐨勫厓绱?
    	if (params.isFavMore) {
    		favFolderElemet = document.getElementById("fav-more");
    		qqbrowser.layout.favbar.activeFolder = "fav-more";
    	} else {
    		favFolderElemet = document.getElementById(params.folderID);
    		qqbrowser.layout.favbar.activeFolder = params.folderID;
    	}
    	
    	favFolderElemet.addClass("open");
    	
        menuParams.params.folderID = params.folderID;
        menuParams.params.startID = params.startID?  params.startID :0;
    }
    menuParams.menuData = JSON.parse(menuData);

    var menuElementMap = {
        mainMenu:            "sysmenu-mainbutton",
        beforeLoginMenu:     "mask-main-headbar-logo",
        contentMenu:         undefined,
        tabMenu:             undefined,
        toolbarMenu:         undefined,
        addressbarMenu:      undefined,
        favbarMenu:          undefined,
        usefulMenu:          "usefulmenu-button",
        afterLoginMenu:      "mask-main-headbar-logo",
        usefulSubMenu:       undefined,
        tabSubMenu:          undefined,
        addressbarBlankMenu: undefined,
        recentCloseMenu:     "undolist-button",
        titleBarMenu:        undefined,
        favFolderMenu:       undefined,
        favCtxMenu:          undefined,
        13:					 "main-headbar-menu-file-button",
		14:					 "main-headbar-menu-view-button",
	    15:					 "main-headbar-menu-favorite-button",
	    16:					 "main-headbar-menu-tool-button",
	    17:					 "main-headbar-menu-help-button",
	    printscreenMenu: 	 'printscreen-menu-button'
        /*101:                 "statusbar-popup-block-button"*/
       /* 102:                 "statusbar-zoom-dropdown-arrow"*/
    };
    //alert('in');
    var menuExtMap = {
        "{87281D86-2185-4656-BF0D-C88478545F4C}":    "statusbar-popup-block-button",
        "{D21B044A-3FDF-4241-865C-5692771BED80}":    "statusbar-zoom-button",
        "{75A78384-8765-4852-ABB7-8D5FA8BF48E3}":	 "qzone-menu-button",
        "{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}": 	 "qqbrowser-widgets-favbar-addfav"
    };
    
    var menuElementName = menuElementMap[type];
    //console.info(type);
    //console.info(menuElementMap[type]);
    
    if(undefined === menuElementName){
        menuElementName = menuExtMap[extId];
    }
    var menuElement = $("#" + menuElementName);
    //console.info("menu popup + menuElement", menuElement);
    menuParams.onCreate = function(json) {
    	if (qqbrowser.js.logic.tipManager) {
			qqbrowser.js.logic.tipManager.hideTooltip();
    		qqbrowser.js.logic.tipManager.enableTooltip(false);
    	}
		
        if (undefined !== menuElement) {
            if(menuElementName == "undolist-button"){
            	var undoButton = $("#undo-button");
                undoButton.removeClass("hover");
                undoButton.addClass("open");
                menuElement.addClass("open");
             //TODO 这里后期得改掉，统一改成再次添加一个.open classname，而不是把原来的class remove，再加另一个
            } else if(menuElementName === "statusbar-zoom-button"){
                var parent = $("#statusbar-zoom-button");
                parent.addClass("open");
                menuElement.addClass("open");
            } else{
                menuElement.addClass("open");
            }
            if (menuElementName == "sysmenu-mainbutton") {
            	qqbrowser.layout.sysmenuMainButton.isEnable = 0;
            } else if (menuElementName == "usefulmenu-button") {
               qqbrowser.layout.usefulmenuButton.isEnable = 0;
            } else if (menuElementName == "statusbar-popup-block-button") {
               qqbrowser.layout.popupBlockButton.isEnable = 0;
            } else if(menuElementName == "undolist-button"){
               qqbrowser.layout.undolistButton.isEnable = 0;
            } else if(menuElementName == "mask-main-headbar-logo"){
                qqbrowser.layout.logoButton.isEnable = 0;
            } else if(menuElementName == "statusbar-zoom-button"){
                qqbrowser.layout.zoomButton.isEnable = 0;
            } else if(menuElementName == "undolist-button"){
                qqbrowser.layout.undolistButton.isEnable = 0;
            } else if(menuElementName == "qzone-menu-button"){
                qqbrowser.layout.qzoneMenuButton.isEnable = 0;
                qqbrowser.layout.qzoneButton.addClass('open');
            } else if (menuElementName == "main-headbar-menu-file-button") {
            	qqbrowser.layout.fileMenuButton.isEnable = 0;
			} else if (menuElementName == "main-headbar-menu-view-button") {
            	qqbrowser.layout.viewMenuButton.isEnable = 0;
            } else if (menuElementName == "main-headbar-menu-favorite-button") {
            	qqbrowser.layout.favoriteMenuButton.isEnable = 0;
            } else if (menuElementName == "main-headbar-menu-tool-button") {
            	qqbrowser.layout.toolMenuButton.isEnable = 0;
            } else if (menuElementName == "main-headbar-menu-help-button") {
            	qqbrowser.layout.helpMenuButton.isEnable = 0;
            } else if (menuElementName == 'printscreen-menu-button') {
            	qqbrowser.layout.printScreenMenuButton.isEnable = 0;
            	qqbrowser.layout.printscreenButton.addClass('open');
            } else if (menuElementName == 'qqbrowser-widgets-favbar-addfav') {
            	qqbrowser.layout.favbar._addFavMenuButton.isEnable = 0;
            	qqbrowser.layout.favbar._addFavMenuButton.addClass("open");
            }
        }
    };
    // 姝unction鏄彍鍗曢殣钘忔椂璋冪敤鐨勶紝闇?牴鎹璁剧疆鏍囧織锛岀劧鍚庡啀鐐瑰嚮鏃跺喅瀹氭槸鍚︽樉绀鸿彍鍗?
    menuParams.onDestroy = function(json) {
    	// 鏄剧ず鑿滃崟鐨勬椂鍊欑鐢ㄧ毊鑲や笂鐨則ooltip鍔熻兘
    	if (qqbrowser.js.logic.tipManager) {
    		qqbrowser.js.logic.tipManager.enableTooltip(true);
    	}
    	
    	// Modified by littleli
	    // 由于升级到content api之后，hover产生一个新菜单时，
	    // 同步返回的新菜单ID事件会出现在前一个菜单的Ondestory之前
    	// (qqbrowser.js.logic.menuManager.currentId && (qqbrowser.js.logic.menuManager.currentId = null));

    	// 瑙ｅ喅涓夋?鎸夐挳鐨勪笁鎬侀棶棰?
        if (undefined !== menuElement) {
            if(menuElementName === "undolist-button"){
              	var undoButton = $("#undo-button");
                undoButton.removeClass("open");
                menuElement.removeClass("open");

             //TODO 杩欓噷鍚庢湡寰楁敼鎺夛紝缁熶竴鏀规垚鍐嶆娣诲姞涓?釜.open classname锛岃?涓嶆槸鎶婂師鏉ョ殑class remove锛屽啀鍔犲彟涓?釜
            } else if(menuElementName === "statusbar-zoom-button"){
                //var parent = $("#statusbar-zoom-button");
                //parent.removeClass("open");
                menuElement.removeClass("open");
            }else{
                menuElement.removeClass("open");
                menuElement.removeClass("pressed");
            }
            var t;
            if (menuElementName == "sysmenu-mainbutton") {
            	clearTimeout(t);
                t = setTimeout(function() { qqbrowser.layout.sysmenuMainButton.isEnable = 1; }, 200);
            } else if (menuElementName == "usefulmenu-button") {
            	clearTimeout(t);
                t = setTimeout(function() { qqbrowser.layout.usefulmenuButton.isEnable = 1; }, 200);
            } else if (menuElementName == "statusbar-popup-block-button") {
                clearTimeout(t);
                t = setTimeout(function() {qqbrowser.layout.popupBlockButton.isEnable = 1;}, 200);
            } else if(menuElementName == "undolist-button"){
                clearTimeout(t);
                t = setTimeout(function() { qqbrowser.layout.undolistButton.isEnable = 1; },200);
            } else if(menuElementName == "mask-main-headbar-logo"){
                clearTimeout(t);
                t = setTimeout(function() { qqbrowser.layout.logoButton.isEnable = 1; },200);
            } else if(menuElementName == "statusbar-zoom-button"){
                clearTimeout(t);
                t = setTimeout(function() { qqbrowser.layout.zoomButton.isEnable = 1; },200);
            } else if(menuElementName == "undolist-button"){
                clearTimeout(t);
                t = setTimeout(function() {qqbrowser.layout.undolistButton.isEnable = 1; },200);
            } else if(menuElementName == "qzone-menu-button"){
            	qqbrowser.layout.qzoneMenuButton.isEnable = 1;
            	qqbrowser.layout.qzoneButton.removeClass('open');
            } else if (menuElementName == "main-headbar-menu-file-button") {
            	qqbrowser.layout.fileMenuButton.isEnable = 1;
			} else if (menuElementName == "main-headbar-menu-view-button") {
				qqbrowser.layout.viewMenuButton.isEnable = 1;
            } else if (menuElementName == "main-headbar-menu-favorite-button") {
            	qqbrowser.layout.favoriteMenuButton.isEnable = 1;
            } else if (menuElementName == "main-headbar-menu-tool-button") {
            	qqbrowser.layout.toolMenuButton.isEnable = 1;
            } else if (menuElementName == "main-headbar-menu-help-button") {
            	qqbrowser.layout.helpMenuButton.isEnable = 1;
            } else if (menuElementName == 'printscreen-menu-button') {
	            clearTimeout(t);
	            t = setTimeout(function() {qqbrowser.layout.printScreenMenuButton.isEnable = 1; },200);
	            qqbrowser.layout.printscreenButton.removeClass('open');
            } else if (menuElementName == 'qqbrowser-widgets-favbar-addfav') {
	            clearTimeout(t);
	            t = setTimeout(function() {qqbrowser.layout.favbar._addFavMenuButton.isEnable = 1; },200);
            	qqbrowser.layout.favbar._addFavMenuButton.removeClass("open");
            }
        }
        
        // 褰揻avbarFolder鐨勮彍鍗昫estory鍚庯紝鎭㈠鍏舵寜閽殑鏅?鏍峰紡锛屽苟浣挎寜閽鏃跺彲鐐瑰嚮
        if (undefined !== favFolderElemet) {
        	if (qqbrowser.js.logic.favbarManager.openArray.length > 0) {
				qqbrowser.js.logic.favbarManager.openArray.shift();
			}
        	
        	console.info("onDestory-mousedown menuOpen:",  qqbrowser.js.logic.favbarManager.menuOpen);
        	qqbrowser.js.logic.favbarManager.menuOpen = 1;
        	console.info("onDestory-mousedown menuOpen:",  qqbrowser.js.logic.favbarManager.menuOpen);
        	// 鍘绘帀宸查?涓璮older鐨勯?涓睘鎬?
    		favFolderElemet.removeClass("open");
    		if (qqbrowser.layout.favbar.activeFolder) { // 鍔犲畾鏃跺櫒浠ヨВ鍐虫爣璇嗕綅琚彁鍓嶆竻绌虹殑闂
    			delete qqbrowser.layout.favbar.activeFolder;
    			
    		}
    	}
    };

    menuParams.envId = envId;

    if (qqbrowser) {
    	// 鑿滃崟寮瑰嚭鏃惰褰曞綋鍓嶈彍鍗旾D
    	qqbrowser.js.logic.menuManager.currentId =  qqbrowser.skin.menu.popup(menuParams);
	    console.info('adapter createMenu qqbrowser.js.logic.menuManager.currentId:', qqbrowser.js.logic.menuManager.currentId);
    }
};

/**
 * 鐐瑰嚮鑿滃崟椤瑰彂鐢熺殑浜嬩欢
 * @param menuId 鑿滃崟鐨処d
 * @param itemId 鑿滃崟椤圭殑Id
 */
browser.skin.menu.click = function(menuId, itemId) {
    if (qqbrowser) {
        qqbrowser.skin.menu.click(menuId, itemId);
    }
};

// 闅愯棌瀛愯彍鍗?
browser.skin.menu.hideSubMenu = function(parentId) {
    if (qqbrowser) {
        qqbrowser.skin.menu.hideSubMenu(parentId);
    }

};

/**
 * menu 椤甸潰鍒濆鍖栵紝浠庢祻瑙堝櫒 API 鑾峰彇鎵?渶鐨勬暟鎹?
 * @param menuId 娴忚鍣ㄧ敓鎴愮殑鍞竴 ID锛岃皟鐢?menu 椤甸潰鏃朵綔涓哄弬鏁颁紶閫掕繘椤甸潰
 */
browser.skin.menu.init = function(menuId) {
    /*browser.log("crisinit+");*/
    if (qqbrowser) {
        qqbrowser.skin.menu.init(menuId, function(menuData) {
            // 绌烘椂璋冧竴涓粯璁ょ殑鑿滃崟
            qqbrowser.log.info("menuData: " + menuData);
            if (menuData == '') {
                return menu.build({});
            }

            // 灏嗕紶杩囨潵鐨?json string 杞崲涓?object
            menuData = JSON.parse(menuData);

            // 鏍规嵁鍙栧緱鐨勮彍鍗曢」鏁扮粍鏋勯?鑿滐紝杩斿洖瀹藉拰楂?
            return menu.build(menuData);
        });
    }
};


/**
 * 鐒︾偣绠＄悊
 * qqbrowser.skin.window.setFocus(windowId);
 * 璁剧疆鐒︾偣鍒扮毊鑲や笂
 */
browser.skin.window.setFocus = function() {
    var windowId = browser.window.currentId();
    if (qqbrowser) {
        qqbrowser.skin.window.setFocus(windowId);
    }
};

/**
 * 鐒︾偣绠＄悊
 * qqbrowser.skin.window.setFocus(windowId);
 * 璁剧疆鐒︾偣鍒扮綉椤典笂
 */
browser.skin.window.setFocusToWeb = function() {
	var windowId = browser.window.currentId();
	if(qqbrowser) {
		qqbrowser.skin.window.setFocusToWeb(windowId);
	}
};

// qqbrowser.skin.window.show
browser.skin.window.show = function() {
    if (qqbrowser) {
        qqbrowser.skin.window.show();
    }
};

/**
 * create tab
 * @param fromType 0 skin, 1 address input, 2 bookmark
 * @param search search or not, boolean
 */
browser.tabs.create = function(url, fromType, search) {
    url = url ? url : "about:blank";
    search = search ? search : 0;

    if (qqbrowser) {
        qqbrowser.tabs.create(url, fromType, 0, search);
    }
};


/**
 * drag tab
 * record the tab's index
 */
browser.tabs.drag = function(pageId, index) {
    if (qqbrowser) {
        qqbrowser.tabs.drag(pageId, index);
    }
};

/**
 * 椤甸潰鍐呮煡鎵綼pi
 * @param string keyWord: 鍏抽敭瀛?
 * @param bool next 鍙杢rue涓哄悜涓嬫煡鎵? false涓哄悜涓婃煡鎵?
 * @param bool lowerCase 鍙杢rue涓哄皬鍐? false涓哄ぇ鍐?
 * @param bool findNext 鏍囪瘑鏄惁涓哄悗缁煡鎵?
 */
browser.tabs.findText = function(keyWord, next, lowerCase, findNext) {
	if (qqbrowser) {
		qqbrowser.tabs.findText(keyWord, next, lowerCase, findNext);
	}
};

//qqbrowser.tabs.home(0)
browser.tabs.home = function() {
	if (qqbrowser) {
		qqbrowser.tabs.home(0);
	}
};


browser.tabs.stopFinding = function() {
	if (qqbrowser) {
		qqbrowser.tabs.stopFinding(true);
	}
};

/**
 * qqbrowser.tabs.home(0)
 */
browser.tabs.home = function() {
    if (qqbrowser) {
        qqbrowser.tabs.home(0);
    }
};

/**
 * remove tab
 */
browser.tabs.remove = function(pageId) {
    if (qqbrowser) {
        qqbrowser.tabs.remove(pageId);
    }
};

/**
 * 鍒囨崲閫夋嫨tab鏃?
 */
browser.tabs.select = function(pageId) {
    if (qqbrowser) {
        qqbrowser.js.logic.layoutManager.resize();
        qqbrowser.tabs.select(pageId);
    }
};

browser.tooltip.create = function(popRect, trackRect, params, func) {
	if(qqbrowser) {
		var windowId = browser.window.currentId();
		return qqbrowser.tooltip.create(windowId, popRect, trackRect, params, func);
	} 
};

browser.tooltip.destroy = function(tooltipId) {
	if(qqbrowser) {
		qqbrowser.tooltip.destroy(tooltipId);
	} 	
};

browser.tip.create = function(tipArgs){
    if(qqbrowser) {
        var windowId = browser.window.currentId();
        return qqbrowser.tip.create(windowId, tipArgs);
    }
};

/**
 * 鑾峰彇褰撳墠windowid
 * qqbrowser.window.currentId
 */
browser.window.currentId = function() {
    if (qqbrowser) {
        return qqbrowser.window.currentId();
    }
};

// qqbrowser.window.close()
browser.window.close = function() {
    if (qqbrowser) {
        qqbrowser.window.close();
    }
};

// qqbrowser.window.maximize()
browser.window.maximize = function() {
    if (qqbrowser) {
        qqbrowser.window.maximize();
    }
};

// qqbrowser.window.minimize()
browser.window.minimize = function() {
    if (qqbrowser) {
        qqbrowser.window.minimize();
    }
};

browser.skin.addressbar = {};
browser.skin.addressbar.pop = function(x, y, width, height) {
    if (qqbrowser) {
        qqbrowser.skin.addressbar.pop(x, y, width, height);
    }
};

browser.skin.addressbar.triggerInputBegin = function() {
    if (qqbrowser) {
        qqbrowser.skin.addressbar.triggerInputBegin();
    }
};

browser.skin.addressbar.triggerInputChange = function(text, inputId, chsInput) {
    if (qqbrowser) {
        qqbrowser.skin.addressbar.triggerInputChange(text, inputId, chsInput);
    }
};

browser.skin.addressbar.adjustHeight = function(addressListheight) {
    if (qqbrowser) {
        qqbrowser.skin.addressbar.adjustHeight(addressListheight);
    }
};

browser.skin.addressbar.triggerDroplistShowByClick = function() {
    if (qqbrowser) {
        qqbrowser.skin.addressbar.triggerDroplistShowByClick();
    }
};

browser.skin.addressbar.triggerInputAccept = function(text) {
    if (qqbrowser) {
        qqbrowser.skin.addressbar.triggerInputAccept(text);
    }
};

browser.skin.addressbar.deleteResult = function(extId, itemId) {
	if (qqbrowser) {
		qqbrowser.skin.addressbar.deleteResult(extId, itemId);
	}
};

browser.tabs.coreSwitch = function() {
    if (qqbrowser) {
        qqbrowser.tabs.coreSwitch(browser.getCurrentPageId());
    }
};

browser.skin.addressbar.init = function(func1, func2) {
    if (qqbrowser) {
        qqbrowser.skin.addressbar.init(func1, func2);
    }
};
browser.extension.builtin = {};
browser.extension.builtin.statistics = {};
browser.extension.builtin.statistics.increase = function(statis){
    if(qqbrowser){
        qqbrowser.extension.builtin.statistics.increase(statis);
    }

};