/**
 * Created by .所有的气泡显示逻辑
 * User: crisweng
 * Date: 11-10-17
 * Time: 下午2:46
 * To change this template use File | Settings | File Templates.
 */
/**
 * @class BtipManager
 * @static
 */
 
 //箭头的方向
 var arrowDirection = {
	none : 0,
	topLeft : 1,
	topRight : 2,
	bottomLeft : 3,
	bottomRight : 4,
	leftTop : 5,
	rightTop : 6,
	leftBottom : 7,
	rightBottom : 8
};

//箭头的风格
var arrowStyle = {
	common : 0,		
	rightAngle : 1, 
	sideling : 2 	
};

qqbrowser.js.logic.BtipManager = {
	/**
	 * 用户自定义ID,用于在tab操作时，判断是否销毁
	 * @type String
	 */
	currentTip:null,
	/**
	 * 目前存在的气泡Id，根据该ID来人工销毁气泡
	 * @type String
	 */
	tooltipId:null,
	nameIdMap: {},
	/**
	 * 显示气泡
	 * @param {string} id 气泡名称，用户可自己定义，用于判断进入哪一个分支
	 * @param {object} options 配置参数
	 * @param {String} options.id 气泡显示位置元素id
	 * @param {Number} [options.liveTime = 10] 气泡持续存在时间
	 * @param {String} [options.status] 气泡内容变化
	 */
	show: function(id, options) {
		var element = document.getElementById(options.id);
		var tipArgs = {},liveTime = 10, position = {};
		if (!element) {
			return;
		}
		this.currentTip = id;
		if (options.liveTime) {
			liveTime = options.liveTime;
		}

		var tabBar = Skin.app.TabBar.instance,
			activeTab = tabBar.activeTab,
			pageId = activeTab.data.pageId,
			coreType = activeTab.data.engine;

		
		if (id === "popupBlockTip") {
			tipArgs = {
				file: "default/newTip/tip.html",
				arrow:{
					//direction:"bottom",
					//point:{x:10, y:10},
					//trianglePosition:{x:"right", y:"custom"},
					//customTrianglePosition:{x:170, y:0}
					direction:arrowDirection.bottomRight,
					point:{x:10, y:10},
					offset:12,
					style:arrowStyle.rightAngle
				},
				//followSide: "bottomRight",
				livetime: liveTime,

				//详细的参数说明请参考文件：skin/default/newTip/tip.js
				param: {
					id:id,
					//trianglePosition:{direction:"custom", x:173},
					//direction:"bottom",
					isTitle:"true",
					isAction:"false",
					isIcon:"true",
					isCloseButton: "true"
				}
			};
			position = qqbrowser.js.logic.downloadManager.getPosition(element);
			tipArgs.arrow.point.x = parseInt(position.Left + element.offsetWidth / 2, 10) - 8;
			tipArgs.arrow.point.y = position.Top;

		} else if (id === "sidebarTip") {
			tipArgs = {
				file: "default/newTip/tip.html",
				arrow:{
					//direction:"right",
					//point:{x:10, y:10},
					//trianglePosition:{x:"auto", y:"center"},
					//customTrianglePosition:{x:null, y:null}
					direction:arrowDirection.rightTop,
					point:{x:10, y:10},
					offset:40,
					style:arrowStyle.common
				},
				//followSide: "bottomRight",
				livetime: liveTime,
				param: {
					id:"sidebarTip",
					//trianglePosition:{direction:"custom", y:0},
					//direction:"right",
					isTitle:"false",
					isAction:"false",
					isIcon:"true",
					isCloseButton: "true"
				}
			};
			position = qqbrowser.js.logic.downloadManager.getPosition(element);
			tipArgs.arrow.point.y = parseInt(position.Top + element.offsetHeight / 2, 10);
			tipArgs.arrow.point.x = position.Left;
		} else if (id == "soundControlTip") {
			tipArgs = {
				file: "default/newTip/tip.html",
				arrow:{
					//direction:"bottom",
					//point:{x:10, y:10},
					//trianglePosition:{x:"right", y:"custom"},
					//customTrianglePosition:{x:60, y:0}
					direction:arrowDirection.bottomRight,
					point:{x:10, y:10},
					offset:12,
					style:arrowStyle.rightAngle
				},
				livetime: liveTime,
				param: {
					id:id,
					isTitle:"false",
					isAction:"false",
					isIcon:"true",
					isCloseButton: "true",
					status:options.status
				}
			};
			position = qqbrowser.js.logic.downloadManager.getPosition(element);
			tipArgs.arrow.point.x = parseInt(position.Left + element.offsetWidth / 2, 10);
			tipArgs.arrow.point.y = position.Top;

		} else if (id == "coreChangeTip") {
			tipArgs = {
				file: "default/newTip/tip.html",
				arrow:{
					//direction:"top",
					//point:{x:10, y:10},
					//trianglePosition:{x:"custom", y:"custom"},
					//customTrianglePosition:{x:183, y:0}
					direction:arrowDirection.topRight,
					point:{x:10, y:10},
					offset:40,
					style:arrowStyle.common
				},
				//followSide: "topRight",
				livetime: liveTime,
				param: {
					id:id,
					//trianglePosition:{direction:"custom", x:186},
					//direction:"top",
					isTitle:"false",
					isAction:"true",
					isIcon:"false",
					isCloseButton: "false",
					status:options.status
				}
			};
			position = qqbrowser.js.logic.downloadManager.getPosition(element);
			tipArgs.arrow.point.x = parseInt(position.Left + element.offsetWidth / 2, 10);
			tipArgs.arrow.point.y = position.Top + element.offsetHeight;
		} else if (id == "compulsoryCoreTypeBalloontip") {
			tipArgs = {
				file: 'default/newTip/tip.html?pageId=' + pageId + '&coreType=' + coreType,
				arrow:{
					//direction:"top",
					//point:{x:10, y:10},
					//trianglePosition:{x:"custom", y:"custom"},
					//customTrianglePosition:{x:183, y:0}
					direction:arrowDirection.topRight,
					point:{x:10, y:10},
					offset:40,
					style:arrowStyle.common
				},
				//followSide: "topRight",
				livetime: liveTime,
				param: {
					id:id,
					//trianglePosition:{direction:"custom", x:186},
					//direction:"top",
					isTitle:"true",
					isAction:"true",
					isIcon:"false",
					isCloseButton: 'true',
					status:options.status
				}
			};
			position = qqbrowser.js.logic.downloadManager.getPosition(element);
			tipArgs.arrow.point.x = parseInt(position.Left + element.offsetWidth / 2, 10);
			tipArgs.arrow.point.y = position.Top + element.offsetHeight;
			// 数据统计：强名单下点击切换按钮的次数
			browser.extension.builtin.statistics.increase(STATIS_CORESWITCHEX_SWITCH);
		} else if (id == 'mismatchedCoreTypeBalloontip') {
			tipArgs = {
				file: 'default/newTip/tip.html?pageId=' + pageId + '&coreType=' + coreType,
				arrow:{
					//direction:"top",
					//point:{x:10, y:10},
					//trianglePosition:{x:"custom", y:"custom"},
					//customTrianglePosition:{x:183, y:0}
					direction:arrowDirection.topRight,
					point:{x:10, y:10},
					offset:40,
					style:arrowStyle.common
				},
				//followSide: "topRight",
				livetime: liveTime,
				param: {
					id:id,
					//trianglePosition:{direction:"custom", x:186},
					//direction:"top",
					isTitle:"true",
					isAction:"true",
					isIcon:"false",
					isCloseButton: 'true',
					status:options.status
				}
			};
			position = qqbrowser.js.logic.downloadManager.getPosition(element);
			tipArgs.arrow.point.x = parseInt(position.Left + element.offsetWidth / 2, 10);
			tipArgs.arrow.point.y = position.Top + element.offsetHeight;
			// 数据统计：标记tips出现的次数
			browser.extension.builtin.statistics.increase(coreType == CORE_TYPE.IE ? STATIS_CORESWITCHEX_IE_TIPS_SHOW : STATIS_CORESWITCHEX_WK_TIPS_SHOW);
		} else if (id == "cloudDictTip") {
			tipArgs = {
				file: "default/newTip/tip.html",
				arrow:{
					//direction:"bottom",
					//point:{x:10, y:10},
					//trianglePosition:{x:"right", y:"custom"},
					//customTrianglePosition:{x:160, y:0}
					direction:arrowDirection.bottomRight,
					point:{x:10, y:10},
					offset:12,
					style:arrowStyle.rightAngle
				},
				//followSide: "bottomRight",
				livetime: liveTime,
				param: {
					id:id,
					//trianglePosition:{direction:"custom", x:163},
					//direction:"bottom",
					isTitle:"false",
					isAction:"false",
					isIcon:"true",
					isCloseButton: "true"
				}
			};
			position = qqbrowser.js.logic.downloadManager.getPosition(element);
			tipArgs.arrow.point.x = parseInt(position.Left + element.offsetWidth / 2, 10);
			tipArgs.arrow.point.y = position.Top;
		} else if (id == "secureTip") {
			var tipArgs = {
				file: "default/tip/tip.html",
				arrow:{
					//direction:"bottom",
					//point:{x:10, y:10},
					//trianglePosition:{x:"right", y:"auto"},
					//customTrianglePosition:{x:null,y:null}
					direction:arrowDirection.bottomRight,
					point:{x:10, y:10},
					offset:12,
					style:arrowStyle.rightAngle
				},
				//followSide: "bottomRight",
				livetime: liveTime,
				param: {
					id:"secureTip",
					//trianglePosition:{x:0, y:7},
					//direction:"bottom",
					//closeButton:"false",
					title:"false",
					status: options.status
				}
			};
			var position = qqbrowser.js.logic.downloadManager.getPosition(element);
			tipArgs.arrow.point.x = parseInt(position.Left + element.offsetWidth / 2, 10);
			tipArgs.arrow.point.y = position.Top;
		} else if (id == 'downloadEdu') {
			// 弹出用户教育气泡
			var tipArgs = {
				file: "default/tip/tip.html",
				arrow:{
					//direction:"bottom",
					//point:{x:10, y:10},
					//trianglePosition:{x:"right", y:"auto"},
					//customTrianglePosition:{x:0,y:null}
					direction:arrowDirection.bottomRight,
					point:{x:10, y:10},
					offset:12,
					style:arrowStyle.rightAngle
				},
				//followSide: "bottomRight",
				param: {
					id : 'downloadEdu',
					text : '您可以在此查看下载任务'
				}
			};
			var element = document.getElementById("statusbar-download-button");
			var position = qqbrowser.js.logic.downloadManager.getPosition(element);
			tipArgs.arrow.point.x = parseInt(position.Left + element.offsetWidth / 2, 10);
			tipArgs.arrow.point.y = position.Top;
		} else if (id == 'donwloadAutoContinue') {
			// 弹出断点续传气泡
			var tipArgs = {
				file: "default/tip/tip.html",
				arrow:{
					//direction:"bottom",
					//point:{x:10, y:10},
					//trianglePosition:{x:"right", y:"auto"},
					//customTrianglePosition:{x:null,y:null}
					direction:arrowDirection.bottomRight,
					point:{x:10, y:10},
					offset:12,
					style:arrowStyle.rightAngle
				},
				//followSide: "bottomRight",
				param: {
					text:"正在下载上次未完成的任务..."
				}
			};
			var element = document.getElementById("statusbar-download-button");
			var position = qqbrowser.js.logic.downloadManager.getPosition(element);
			tipArgs.arrow.point.x = parseInt(position.Left + element.offsetWidth / 2, 10);
			tipArgs.arrow.point.y = position.Top;
		} else {
			return;
		}
		this.destroyTips([id]);
		this.tooltipId = browser.tip.create(tipArgs);
		this.nameIdMap[this.currentTip] = this.tooltipId;
	},
	/**
	 * 对只适用于指定的标签的tip，在进行标签操作时，将气泡销毁
	 */
	destroyTip: function() {
		if (this.currentTip === "coreChangeTip" || this.currentTip === "popupBlockTip"
				|| this.currentTip === "secureTip") {
			qqbrowser.tip.destroy(this.tooltipId);
		}
	},
	/**
	 * 将当前气泡销毁
	 */
	destroyAllTip: function() {
		qqbrowser.tip.destroy(this.tooltipId);
	},
	destroyTips: function(tipNames) {
		for (var i = 0, len = tipNames.length; i < len; i++) {
			if (typeof this.nameIdMap[tipNames[i]] === 'number') {
				qqbrowser.tip.destroy(this.nameIdMap[tipNames[i]]);
			}
		}
	}
};