/**
 * Create a regular expression that will match a particular class name
 * @param className
 * @returns a regular expression for a particular class name
 */
Element.prototype.regexForClassName = function(className){
	var fn = arguments.callee;
	if(!fn._lookup) {
		fn._lookup = {};
	}
	if(className in fn._lookup) {
		return fn._lookup[className];
	}
	
	return (fn._lookup[className] = new RegExp("(^|\\s)" + className + "(\\s|$)"));
};

/**
 *  Determine whether an element has the specified class name
 * @param className
 * @returns bool
 */
Element.prototype.hasClass = function(className) {
	var elementClassName = this.className;
	if(!elementClassName) {
		return false;
	}
	if (elementClassName === className) {
		return true;
	}
	
	return this.regexForClassName(className).test(elementClassName);
};

/**
 * Add the specified class name to the element.
 * @param className
 */
Element.prototype.setClass = function(className) {
	if(!className) {
		return;
	}
	
	if (this.hasClass(className)) {
		return;
	}
	
	this.className = className;
};

/**
 * Add the specified class name to the element.
 * @param className
 */
Element.prototype.addClass = function(className) {
	if(!className) {
		return;
	}
	
	if (this.hasClass(className)) {
		return;
	}
	
	this.className += " " + className;
};
/**
 * Remove the specified class name from the element
 * @param className
 */
Element.prototype.removeClass = function(className) {
	if(!className) {
		return;
	}
	
	var regex = this.regexForClassName(className);
	this.className = this.className.replace(regex, " ").trim();
};

/**
 * If the element has the class name, remove it, otherwise add it.
 * @param className
 */
Element.prototype.toggleClass = function(className) {
	if(!className) {
		return;
	}
	
	var regex = this.regexForClassName(className);
	var elementClassName = this.className;
	
	if(regex.test(elementClassName)) {
		this.className = elementClassName.replace(regex, " ").trim();
	} else {
		this.className += " " + className;
	}
};
Element.prototype.removeAllChild = function() {
	var nodes = this.childNodes;
	var len = nodes.length;
	for(var i=0;i<len;i++){
		this.removeChild(nodes[0]);
	}
};
Element.prototype.insertAfter = function(newElement,targetElement) {
	if (this.lastChild == targetElement) {
		this.appendChild(newElement);
	} else {
		this.insertBefore(newElement,targetElement.nextSibling);
	}
}
