var MENU_TYPE = {
	BOOKMARK_BUTTON: 0,
	MENUBAR_BOOKMARK: 1,
	BOOKMARK_FOLDER: 2,
	BOOKMARKBAR_MORE: 3,
	BOOKMARKBAR_OFFLINE: 4,
	BOOKMARK_URL_CONTEXT: 5,
	BOOKMARK_FOLDER_CONTEXT: 6,
	BOOKMARKBAR_BLANK_CONTEXT: 7,
	BOOKMARKBAR_IMPORT_AND_EXPORT: 8,
	BOOKMARK_SORT: 9
};

var MenuFactory = {
	// 点击展开菜单按钮时，收起该菜单及按钮的标识位
	favbarFolderOpen: 0,
	currentMenuId: null,
	
	createMenu: function(menuParams, options) {
		if (options.rect) {
			$.extend(menuParams, options.rect);
		/* 左键菜单根据元素的位置、高宽画菜单位置 */
		} else if (options.element) {
			var $element = $(options.element),
				offset = $element.offset();

			menuParams.leftBottomX = options.isSubMenu ? offset.left + 5 : offset.left;
			menuParams.leftBottomY = offset.top + $element.outerHeight();
			menuParams.rightTopX = options.isSubMenu ? (offset.left + $element.outerWidth() - 5) : (offset.left + $element.outerWidth());
			menuParams.rightTopY = offset.top;
		/* 右键菜单直接取鼠标当前坐标值 */
		} else if(options.coordinate) {
			menuParams.leftBottomX = menuParams.rightTopX = options.coordinate.x;
			menuParams.leftBottomY = menuParams.rightTopY = options.coordinate.y;
		} else {
			alert('参数未提供，无法计算菜单坐标值。');
		}
		
		menuParams.onCreate = function(json) {
			// 显示菜单的时候禁用皮肤上的tooltip功能
			if (qqbrowser && qqbrowser.js && qqbrowser.js.logic && qqbrowser.js.logic.tipManager) {
				qqbrowser.js.logic.tipManager.enableTooltip(false);
			}
			
			if(options.onCreate) {
				options.onCreate.call(this);
			}
		};
		
		menuParams.onDestroy = function(json) {
			// 显示菜单的时候禁用皮肤上的tooltip功能
			if (qqbrowser && qqbrowser.js && qqbrowser.js.logic && qqbrowser.js.logic.tipManager) {
				qqbrowser.js.logic.tipManager.enableTooltip(true);
			}
			
			if(options.onDestroy) {
				options.onDestroy.call(this);
			}
		};
		
		window.TooltipFactory && window.TooltipFactory.destroy();
		return qqbrowser.skin.menu.popup(menuParams);
	},
	
	/**
	 * 弹出有收藏数据的菜单，包括：
     * 1. 地址栏左侧收藏按钮的弹出菜单
     * 2. 系统菜单栏的收藏菜单项
	 * 3. 收藏文件夹菜单（任意展开收藏文件夹的地方）
	 * 4. 收藏栏的“更多”菜单（可看成一个“虚拟文件夹”，没有“添加到收藏”菜单项）
	 *
	 * @param Int menuType 菜单类型，MENU_TYPE枚举值。
	 * @param Int folderId 文件夹id，根文件夹id在改版后为1，遗留的则不是1。
	 * @param Int parentMenuId 父菜单id，没有父菜单则为0（有效的菜单id > 0，因此用特殊值0表示无父菜单）。
	 * @param Object options
	 */
	createBookmarkMenu: function(menuType, folderId, options) {
		var defaultOptions = {
				parentMenuId: 0,
				rootMenuId: 0,
				rootMenuType: menuType,
				highlightFirst: false,
				fromIndex: 0,
				// 用于标识使用本地未备份文件夹的数据接口
				isOffline: false,
				// 用于标识主菜单、收藏菜单以及更多菜单是否显示本地未备份文件夹
				hasOffline: false,
				isSubMenu: false,
				loginState: window.loginState || 0
			},
			options = $.extend({}, defaultOptions, options || {});

		var menuParams = {
			envId: 0,
			nParentId: options.parentMenuId,
			nTypeId: 20,
			strUrl: 'aero/menuBookmark.html',
			returnParams: {
				 tabId: 0,
				 isTextSelected: 0
			},
			params: {},
			// menuData可以在菜单页面用qqbrowser.skin.menu.init的回调函数参数
			menuData: [{
				menuType: menuType,
				folderId: folderId,
				parentMenuId: options.rootMenuId,
				rootMenuId: options.rootMenuId,
				rootMenuType: options.rootMenuType,
				highlightFirst: options.highlightFirst,
				fromIndex: options.fromIndex,
				isOffline: options.isOffline,
				hasOffline: options.hasOffline,
				loginState: options.loginState
			}] /* 必须是数组 */
		};
		
		options.element && options.element.addClass && options.element.addClass('open');
		
		return this.createMenu(menuParams, options);
	},
	
	createCommonMenu: function(menuType, options) {
		var defaultOptions = {
				parentMenuId: 0,
				rootMenuId: 0,
				highlightFirst: false,
				loginState: window.loginState || 0
			},
			options = $.extend({}, defaultOptions, options || {});

		var menuParams = {
			envId: 0,
			nParentId: options.parentMenuId,
			nTypeId: 21,
			strUrl: 'aero/menuCommon.html',
			returnParams: {
				 tabId: 0,
				 isTextSelected: 0
			},
			params: {},
			// menuData可以在菜单页面用qqbrowser.skin.menu.init的回调函数参数
			menuData: [{
				menuType: menuType,
				parentMenuId: options.parentMenuId || options.rootMenuId,
				rootMenuId: options.rootMenuId,
				highlightFirst: options.highlightFirst,
				loginState: options.loginState
			}]
		};
		if(options.bookmark) {
			menuParams.menuData[0].bookmark = options.bookmark;
		}
		
		return this.createMenu(menuParams, options);
	}
};