﻿FUI.ns('FCS.PcApp');

FCS.PcApp.Tab = {
	firstFeedId: null,
	lastFeedId: null,
	userProfile: null,
	fetchCount: 0,
	isLock: false,
	isOver: false,
	feedUrlConfig: { 'getFeeds': FCE.common.clientdomain() + '/feedoperation/fetch',
		'getNewestFeeds': FCE.common.clientdomain() + '/feedoperation/fetchnewest',
		'forward': FCE.common.clientdomain() + '/feedoperation/forward',
		'getUser': FCE.common.clientdomain() + '/feedoperation/getprofileforpc',
		'getServices': FCE.common.clientdomain() +'/region/getJsonRegionContent'
	},
	init: function() {
		var t = this;
		FCS.PcApp.Feed.init();
		this.feedsPannel = $('#feeds');
		this.loadData();
		this.recommendServices();
		$("#morefeeds").click(function() {
			t.fetchOldData();
		});
	},
	loadData: function(isTop) {
		var t = this;
		$.ajax({
			url: this.feedUrlConfig.getFeeds,
			type: "GET",
			dataType: "json",
			cache: false,
			success: function(obj) {
				$("#firstloadfeed").hide();
				FCS.PcApp.Feed.startTime = FCS.PcApp.Feed.stringToTime(obj.time);
				var count = obj.feeds.length;
				if (count > 0) {
					t.firstFeedId = obj.feeds[0].feedId;
					t.lastFeedId = obj.feeds[count - 1].feedId;

					for (var i = 0; i < count; i++) {
						if (obj.feeds[i].category == "status:publish" || obj.feeds[i].category == "status:republish")
							t.feedsPannel.append(FCS.PcApp.Feed.formatItem(obj.feeds[i]));
					}
				}
				else {
					$("#nofeeds").show();
					$("#servbindpanel").removeClass("hide");
				}

				if (count < 1) {
					t.isOver = true;
				}
				else {
					$("#loadfeed").show();
				}

				t.isLock = false;
			},
			error: function() {
				$("#firstloadfeed").hide();
				$("#feederror").show();
				t.isLock = false;
			}
		});
	},
	loadNewData: function(isTop) {
		var t = this;
		$.ajax({
			url: this.feedUrlConfig.getNewestFeeds,
			type: "GET",
			data: { offset: t.firstFeedId },
			dataType: "json",
			cache: false,
			success: function(obj) {
				var count = obj.length;
				if (count > 0) {
					t.firstFeedId = obj[0].feedId;
					if (count >= 20) {
						t.feedsPannel.html('');
						FCS.PcApp.Feed.feeds = {};
						t.lastFeedId = obj[count-1].feedId;
					}

					for (var i = count - 1; i >= 0; i--) {
						if (obj[i].category == "status:publish" || obj[i].category == "status:republish")
							t.feedsPannel.prepend(FCS.PcApp.Feed.formatItem(obj[i]));
					}
				}

				t.isLock = false;
			},
			error: function() {
				t.isLock = false;
			}
		});
	},
	loadOldData: function() {
		if (this.fetchCount < 3) {
			this.fetchOldData();
		}
		else {
			$("#morefeeds").show();
		}
	},
	fetchOldData: function() {
		var t = this;
		if (!t.isLock) {
			if (!t.isOver) {
				$("#loadfeed").show();
				t.fetchCount++;
				t.isLock = true;
				var data = { predicate: 1,
					categories: 0,
					offset: t.lastFeedId
				};

				$.ajax({
					url: this.feedUrlConfig.getFeeds,
					type: "GET",
					data: data,
					dataType: "json",
					cache: false,
					success: function(obj) {
						FCS.PcApp.Feed.startTime = FCS.PcApp.Feed.stringToTime(obj.time);
						var count = obj.feeds.length;

						if (count > 0) {
							t.lastFeedId = obj.feeds[count - 1].feedId;

							for (var i = 0; i < count; i++) {
								if (obj.feeds[i].category == "status:publish" || obj.feeds[i].category == "status:republish")
									t.feedsPannel.append(FCS.PcApp.Feed.formatItem(obj.feeds[i]));
							}
						}

						if (count < 1) {
							t.isOver = true;
							$("#morefeeds").hide();
						}

						t.isLock = false;
						$("#loadfeed").hide();
					},
					error: function() {
						t.isLock = false;
						$("#loadfeed").hide();
					}
				});
			}
		}
	},
	recommendServices: function() {
		var t = this;
		var content = $("#servbindcontent");
		var item = '';
		var template = ['<li id="service{4}">',
							'<div class="servinf">',
								'<p class=""><a href="{0}" target="_blank" class="fn" title="{1}" hideFocus="true">{1}</a><a href="{0}" title="{6}" class="{5}" target="_blank" et="bindserviebtn" hideFocus="true">{6}</a></p>',
								'<p>{2}</p>',
							'</div>',
							'<div class="servlogo">',
								'<a href="{0}" class="" target="_blank" title="{1}" hideFocus="true"><img src="{3}" class="" style="width:32px;height:32px" /></a>',
							'</div>',
						'</li>'].join('');
		var check = function(rid) {
			var bindService = parent.userprofile.services;
			for (var i = 0; i < bindService.length; i++) {
				if (rid == bindService[i].serviceId) {
					return true;
				}
			}

			return false;
		};
		$("#servbindloading").show();
		$.ajax({
			url: this.feedUrlConfig.getServices,
			type: "GET",
			data: { pageName: '聚享_PCTab页', itemName: '聚享_PCTab页_推荐服务' },
			dataType: "json",
			cache: false,
			success: function(result) {
				if (result.length == 0) {
					$("#servbindloaderror").show();
					$("#moreServices").hide();
				}
				for (var i = 0; i < result.length; i++) {
					var statusTitle = '我要绑定';
					var statusClass = 'btny4t';

					if (check(result[i].serviceid)) {
						statusTitle = '已绑定';
						statusClass = 'btng3t';
					}
					
					item = $(template.format(result[i].url, result[i].name, result[i].summary, result[i].icon, result[i].serviceid, statusClass, statusTitle));
					item.find("a[et='bindserviebtn']").click(function() {
						$("#popup").show();
						$("#popupmask").show();
					});

					content.append(item);
				}
				$("#servbindloading").hide();
				$("#moreServices").show();
			},
			error: function() {
				$("#servbindloading").hide();
				$("#moreServices").hide();
				$("#servbindloaderror").show();
			}
		});
	}
};

var isOpenServicePanel = false;
$(document).ready(function() {
	$('body').bind('click', function(e) { FCE.common.alinkEventHandler(e) });
	$("#moreServices").attr('href', FCE.common.domain + '/service');
	FCS.PcApp.NavBar.init(FCS.PcApp.NavBar.homePage);
	FCS.PcApp.Tab.init();
	FCS.PcApp.NavBar.homeLinkHandler = function() {
		if (!isOpenServicePanel) {
			$(this).find(".dot").remove();
			$(this).attr('title', '我的首页');
			FCS.PcApp.Tab.loadNewData();
			return false;
		}
		else {
			location.reload();
		}
	};
	$("#servbindpanelbtn").click(function() {
		$("#servbindpanel").toggleClass("hide");
		isOpenServicePanel = isOpenServicePanel ? false : true;
		$("#servbindpanelbtn").blur();
	});

	$("#scrollclient").scroll(function() {
		var scrollHeight = this.scrollHeight;
		if (this.scrollTop + this.clientHeight >= scrollHeight) {
			FCS.PcApp.Tab.loadOldData();
		}
	});

	$("#popup").find("a").each(function() {
		$(this).click(function() {
			parent.location.reload();
			return false;
		});
	});
	
	$('#delete_feed').click(function(){
		FCS.PcApp.Feed.deleteFeed();
	});
	$('#cancel_delete').click(function(){
		FCS.PcApp.Feed.cancelDeleteFeed();
	});
	$('#close_delete_feed').click(function(){
		FCS.PcApp.Feed.cancelDeleteFeed();
	});
	
	
	FCS.PcApp.watracer.PV('http://juxiang.com/pctab/home', 'pctab/home');
	$('body').bind('click', function(e) { FCS.PcApp.watracer.reg(e) });
});

parent.refreshExHandler = function(obj) {
	var result = eval("(" + obj + ")");

	if (result.type == "comment") {
		FCS.PcApp.Feed.addComment(result.object.feedId);
	}
	else if (result.type == "forward") {
		var result = FCS.PcApp.Feed.addForward(result.object);
		FCS.PcApp.Tab.feedsPannel.prepend(FCS.PcApp.Feed.formatItem(result));
	}
}

parent.publisHandler = function(obj) {
	var result = $.xml2json(obj).feed;
	var profile = parent.userprofile.profile;
	result.author = {
		name: profile.nickname,
		portrait: profile.portraitTiny,
		homepage: '/' + profile.userId,
		id: profile.userId
	};

	result.source = {
		title: "\u98de\u4fe1PC\u5ba2\u6237\u7aef",
		permalink: "http://feixin.10086.cn/download/pcclient/",
		icon: "/img/temp/network_links.png"
	};

	FCS.PcApp.Tab.feedsPannel.prepend(FCS.PcApp.Feed.formatItem(result));
	$('#nofeeds').hide();
}

