FUI.ns('FSE.dynamicPanel');
FSE.dynamicPanel.currLiItem = null;
FSE.dynamicPanel = FUI.create({
    init: function(content, opt) {
        this.opt = this.opt = jQuery.extend(this.opt, FSE.dynamicPanel.defaults, opt || {});
        if (isNaN(parseFloat(this.opt.loadDatacondition))) {
            this.loadDatacondition = FUI.widget.dynamicPanel.defaults.loadDatacondition;
        } else {
            this.opt.loadDatacondition = parseFloat(this.opt.loadDatacondition);
            if (this.opt.loadDatacondition > 1.0) {
                this.opt.loadDatacondition = 1.0;
            }
        }
        this.loadCount = 0;
        this.lastClass = this.opt.lastClass;
        this.maxId = 0;
        this.cacheHTML = null;
        this.initEvent();
        this.topClass = this.opt.topClass;
        // жȫǷʼɹ
        if (FSE.common.Config.GlobalInit) {
            this.loadData('now', '');
        } else {
            this.showContentError();
        }
    },
    initEvent: function() {
        _this = this;
        document.getElementById(this.opt.contentId).onscroll = function() {
            if (!_this.dataLoading && this.clientHeight + this.scrollTop >= parseInt(this.scrollHeight * _this.opt.loadDatacondition)) {
                if (_this.loadCount < 100 && _this.opt.minId > -2) {
                    _this.loadData('after');
                    _this.loadCount++;
                }
            }
        };
    },
    loadData: function(type, ver) {
        if (!FSE.common.Config.GlobalInit) {
            return;
        }
        this.dataLoading = true;
        _this = this;
        // ݼ
        switch (type) {
            case 'now': // ݰ汾Żȡ50
                _this.showContentLoad();
                FSE.data.tab.getByVersion({
                    dataType: 'html',
                    success: function(data) {
						// ûж̬ûֱȥͨӭҳ
						if(data.length < 1 && parent.userprofile.profile.isFreshman != 1){
							setTimeout(function(){
								location.href = 'welcome.htm?cv='+parent.getquerystring('cv');}
							,100);
						}
						else{
							with (_this) {
								displayData(false, data);
								dataLoading = false;
								showContentLoad();
								// Ĭϻ10¼
								//_this.loadData('after');
							}
						}
                    },
                    error: function(msg) {
                        with (_this) {
                            dataLoading = false;
                            showContentLoad();
                            showContentError();
                        }
                    }
                });
                break;
            case 'before': // 汾Żȡ֮
                if (_this.maxId == -1) {
                    return;
                }
				if(_this.maxId == 0){
					_this.loadData('now', '');
					return;
				}
                _this.showBeforeLoading();
                FSE.data.tab.getNewByVersion({
                    dataType: 'html',
                    data: { 'version': _this.maxId },
                    success: function(data) {
                        _this.displayData(true, data);
                        _this.showBeforeLoading();
                        _this.dataLoading = false;
                    },
                    error: function(msg) {
                        _this.showBeforeLoading();
                        _this.dataLoading = false;
                    }
                });
                break;
            case 'after': // ȡǰ汾10
                _this.showAfterLoading();

                // if (_this.cacheHTML) {
                // _this.displayData(false, _this.cacheHTML);
                // _this.cacheHTML = '';
                // }

                FSE.data.tab.getByMinId({
                    dataType: 'html',
                    data: { 'id': _this.opt.minId },
                    success: function(data) {
                        if (data.length < 1) {
                            _this.opt.minId = -2;
                        }
                        //_this.cacheHTML = data;
                        _this.displayData(false, data);
                        _this.showAfterLoading();
                        _this.dataLoading = false;
                    },
                    error: function(msg) {
                        _this.loadCount--;
                        _this.showAfterLoading();
                        _this.dataLoading = false;
                    }
                });
                break;
        }
    },
    setCurr: function(li) {
        if (FSE.dynamicPanel.currLiItem) {
            FSE.dynamicPanel.currLiItem.className = "";
        }

        li.className = "hover";
        FSE.dynamicPanel.currLiItem = li;
    },
    displayData: function(newData, data) {
        var containerItem = document.getElementById(this.opt.containerId);

        var div = document.createElement("div");
        div.innerHTML = data;

        var styleName = 'cont_wrap_light';
        var _this = this;
        var lilist = div.getElementsByTagName('li');
        var alist = div.getElementsByTagName('a');

        if (!newData) {
            styleName = _this.lastClass;
        } else {
            if (lilist.length % 2 == 0)
                styleName = _this.topClass;
            else
                styleName = _this.topClass == 'cont_wrap_light' ? 'cont_wrap_deep' : 'cont_wrap_light';
            _this.topClass = styleName;
        }

        for (var i = 0, j = lilist.length; i < j; i++) {
            if (i == 0) {
                try {// ȡǰId
                    var maxId = parseInt(lilist[i].id.split('_')[1]);
                    if (maxId > _this.maxId) {
                        _this.maxId = maxId;
                    }
                }
                catch (e) {
                    _this.maxId = -1;
                }

            }
            lilist[i].getElementsByTagName('div')[0].className = 'cont_wrap ' + styleName;

            try {// ȡǰId
                var _minId = parseInt(lilist[i].id.split('_')[1]);
                if (_minId < _this.opt.minId || _this.opt.minId < 0) {
                    _this.opt.minId = _minId;
                }
            }
            catch (e) {
                _this.opt.minId = -1;
            }
            styleName = styleName == 'cont_wrap_light' ? 'cont_wrap_deep' : 'cont_wrap_light';

            var imgs = lilist[i].getElementsByTagName("img");
            for (_i = 0, _j = imgs.length; _i < _j; _i++) {
                // ͷԲ
                if (imgs[_i].className == "user_head") {
                    var head_span = document.createElement('span');
                    head_span.className = 'group_bg';
                    imgs[_i].parentNode.insertBefore(head_span, imgs[_i]);
                }
                imgs[_i].isnew = 1;
                imgs[_i].id = lilist[i].id + "_" + _i;
            }
        };

        if (!newData)
            _this.lastClass = styleName;

        for (i = 0, j = alist.length; i < j; i++) {
            alist[i].target = '';
            alist[i].link = alist[i].href;
            alist[i].href = "javascript:void(0);";
            alist[i].onclick = function() {
                FSE.common.openUrl(this.link);
                return false;
            }
        }

        if (newData) {
            containerItem.innerHTML = div.innerHTML + containerItem.innerHTML;
            containerItem.scrollTop = 0;
        } else {
            containerItem.innerHTML += div.innerHTML;
        };
        div.innerHTML = "";

        var items = containerItem.getElementsByTagName('li');
        for (var i = 0, j = items.length; i < j; i++) {
            //¼
            items[i].onmouseover = function() {
                _this.setCurr(this);
            };
        }

        var aitems = containerItem.getElementsByTagName('a');

        //ͻǷ֧
        var clientCommit = FSE.common.getClientVars() != "";
        for (i = 0, j = aitems.length; i < j; i++) {
            if (clientCommit && /^MoodComment/ig.test(aitems[i].id)) {
                try {
                    aitems[i].onclick = function() {
                        FSE.common.PcFunction.t_openCommentWindow(this.id.split('_')[1]);
                        window.event.cancelBubble = true;
                    }
                }
                catch (e) { }
            }
            else {
                aitems[i].onclick = function() {
                    FSE.common.openUrl(this.link);
                    return false;
                }
            }
        }

        var imgitems = containerItem.getElementsByTagName('img');

        for (i = 0, j = imgitems.length; i < j; i++) {
            var t = imgitems[i];
            var id = t.id;
            if (t.isnew == '1' && !t.achv) {
                if (t.className == "user_head") {// ͷ
                    t.onerror = function() {
                        this.src = "../common/img/img_error.jpg";
                    }
                }
                else {// ͼƬӽ
                    var img = new Image();
                    img.pid = id;
                    var src = t.src;
                    t.src = "../common/img/ajax-loader.gif";
                    img.onload = function() {
                        var tImg = document.getElementById(this.pid);
                        tImg.src = this.src;
                        //tImg.isnew = '0';
                    };
                    img.onerror = function() {
                        var tImg = document.getElementById(this.pid);
                        tImg.src = "../common/img/img_error.jpg";
                        //tImg.isnew = '0';
                    };
                    img.src = src;
                }
                t.isnew = '0';
            }
        }
        delete div;

    },
    showAfterLoading: function() {
        $('#dynamic_after').toggle();
    },
    showBeforeLoading: function() {
        $('#dynamic_before').toggle();
    },
    showContentLoad: function() {
        $('#dynamic_now').toggle();
        $("#dynamic_now_loading").attr("src", "img/loading.gif");
    },
    showContentError: function() {
        $('#content_error').show();
    }
});

FSE.dynamicPanel.counter = 0;
FSE.dynamicPanel.prefixName = 'dynamicPanel_';
FSE.dynamicPanel.itemsName = '_items';
FSE.dynamicPanel.loadingName = '_loading';
FSE.dynamicPanel.defaults = {
    loadDatacondition: 1.0,
    containerId: 'dynamic_Content',
    dataLoading: false,
    lastClass: 'cont_wrap_deep',
    topClass: 'cont_wrap_deep',
    minId: -1,
    contentId: 'content_div'
};
