﻿FUI.ns('FCS.PcApp');

FCS.PcApp.Tab = {
	firstFeedId: null,
	lastFeedId: null,
	userProfile: null,
	fetchCount: 0,
	isLock: false,
	isOver: false,
	feedUrlConfig: { 'getFeeds': FCE.common.clientdomain()+'/feedoperation/fetchatme',
		'getNewestFeeds': FCE.common.clientdomain()+ '/feedoperation/fetchnewest',
		'forward': FCE.common.clientdomain()+'/feedoperation/forward',
		'getUser': FCE.common.clientdomain()+'/feedoperation/getprofileforpc'
	},
	init: function() {
		var t = this;
		FCS.PcApp.Feed.init();
		this.feedsPannel = $('#feeds');
		this.loadData();
		$("#morefeeds").click(function() {
			t.fetchOldData();
		});
	},
	loadData: function(isTop) {
		var t = this;
		$.ajax({
			url: this.feedUrlConfig.getFeeds,
			type: "GET",
			dataType: "json",
			cache: false,
			success: function(obj) {
				$("#firstloadfeed").hide();
				FCS.PcApp.Feed.startTime = FCS.PcApp.Feed.stringToTime(obj.time);
				var count = obj.feeds.length;
				if (count > 0) {
					t.firstFeedId = obj.feeds[0].feedId;
					t.lastFeedId = obj.feeds[count - 1].feedId;

					for (var i = 0; i < count; i++) {
						t.feedsPannel.append(FCS.PcApp.Feed.formatItem(obj.feeds[i]));
					}
				}
				else {
					$("#nofeeds").show();
					$("#servbindpanel").removeClass("hide");
				}

				if (count < 20) {
					t.isOver = true;
				}
				else {
					$("#loadfeed").show();
				}

				t.isLock = false;
			},
			error: function() {
				$("#firstloadfeed").hide();
				$("#feederror").show();
				t.isLock = false;
			}
		});
	},
	loadOldData: function() {
		if (this.fetchCount < 3) {
			this.fetchOldData();
		}
		else {
			$("#morefeeds").show();
		}
	},
	fetchOldData: function() {
		var t = this;
		if (!t.isLock) {
			if (!t.isOver) {
				$("#loadfeed").show();
				t.fetchCount++;
				t.isLock = true;
				var data = { predicate: 1,
					categories: 0,
					offset: t.lastFeedId
				};

				$.ajax({
					url: this.feedUrlConfig.getFeeds,
					type: "GET",
					data: data,
					dataType: "json",
					cache: false,
					success: function(obj) {
						FCS.PcApp.Feed.startTime = FCS.PcApp.Feed.stringToTime(obj.time);
						var count = obj.feeds.length;

						if (count > 0) {
							t.lastFeedId = obj.feeds[count - 1].feedId;

							for (var i = 0; i < count; i++) {
								t.feedsPannel.append(FCS.PcApp.Feed.formatItem(obj.feeds[i]));
							}
						}

						if (count < 20) {
							t.isOver = true;
							$("#morefeeds").hide();
						}

						t.isLock = false;
						$("#loadfeed").hide();
					},
					error: function() {
						t.isLock = false;
						$("#loadfeed").hide();
					}
				});
			}
		}
	}
};

$(document).ready(function() {
	$('body').bind('click', function(e) { FCE.common.alinkEventHandler(e) });
	FCS.PcApp.NavBar.init(FCS.PcApp.NavBar.atmePage);
	FCS.PcApp.Tab.init();
	
	$("#scrollclient").scroll(function() {
		var scrollHeight = this.scrollHeight;
		if (this.scrollTop + this.clientHeight >= scrollHeight) {
			FCS.PcApp.Tab.loadOldData();
		}
	});
	FCS.PcApp.watracer.PV('http://juxiang.com/pctab/atme', 'pctab/atme');
	$('body').bind('click', function(e) { FCS.PcApp.watracer.reg(e) });
});

parent.refreshExHandler = function(obj) {
	var result = eval("(" + obj + ")");

	if (result.type == "comment") {
		FCS.PcApp.Feed.addComment(result.object.feedId);
	}
	else if (result.type == "forward") {
		var result = FCS.PcApp.Feed.addForward(result.object);
		FCS.PcApp.Tab.feedsPannel.prepend(FCS.PcApp.Feed.formatItem(result));
	}
}

