﻿
/*
* Core.js
* 
* Fanweixiao,zsl 2009/09/17
* 
* Implements namespace feature, js file loader,class system and debug 
*/
if (typeof FUI == "undefined" || !FUI)
{
    /**
    *全局的命名空间，如果FUI已经存在，不会覆盖掉
    */
    var FUI = {};
}

FUI.apply = function(o, c)
{
    if (o && c)
    {
        for (var p in c)
        {
            o[p] = c[p];
        }
    }
    return o;
};
(function()
{
    var initializing = false,
    //获取函数的参数数组 
	    argumentNames = function argumentNames(fn)
	    {
	        var names = fn.toString().match(/^[\s\(]*function[^(]*\(([^\)]*)\)/)[1].replace(/\s+/g, '').split(',');
	        return names.length == 1 && !names[0] ? [] : names;
	    },
		debugModel = false;

    FUI.apply(FUI, {
        /*
        @namespace FUI
        @description 用于声明命名空间
        @example 
        
        FUI.ns('com.company');
        FUI.ns('F','F.sample');
        com.compay.demo=function(){}
        F.demo=function(){}
        F.sample.demo=function(){}
        */
        ns: function()
        {
            var a = arguments, o = null, i, j, d;
            for (i = 0; i < a.length; i = i + 1)
            {
                d = ("" + a[i]).split(".");
                o = window;
                for (j = 0; j < d.length; j = j + 1)
                {
                    o[d[j]] = o[d[j]] || {};
                    o = o[d[j]];
                }
            }
            return o;
        },
        /*
        @description 该方法用于动态的从外部加载脚本文件,可以跨域
        @example 
        FUI().load('test.js',function(H){});
        @todo
        加载多个模块
        合并多个模块
        控制模块之间的依赖关系
        */
        load: function(url, callback)
        {
            var script = null, F = this;
            script = document.createElement("script");
            script.type = "text/javascript";
            if (script.readyState)
            {  //IE
                script.onreadystatechange = function()
                {
                    if (script.readyState == "loaded" ||
					script.readyState == "complete")
                    {
                        script.onreadystatechange = null;
                        if (typeof callback === 'function')
                        {
                            callback();
                        }
                    }
                };
            } else
            {  //Others
                script.onload = function()
                {
                    if (typeof callback === 'function')
                    {
                        callback();
                    }
                };
            }
            script.src = url;
            document.getElementsByTagName("head")[0].appendChild(script);
            return this;
        },

        /*
        @description 用于JavaScript中的类的声明和继承
        init():构造函数
        extend：实现继承
        _super：调用父类中同名的方法
        @example
        var Person = FUI.create({
        init: function(name) {
        this.name = name;
        },
        getName: function() {
        return this.name;
        }
        });
        #################################继承###########################################
        var Employee = FUI.create(Person, {
        init: function($super, name, employeeID) {
        $super(name);
        this.employeeID = employeeID;
        },
        getEmployeeID: function() {
        return this.employeeID;
        },
        getName: function($super) {
        return "Employee name: " + $super();
        }
        });
        ######################################################################
        */
        create: function(baseClass, prop)
        {
            // 只接受一个参数的情况
            if (typeof (baseClass) === "object")
            {
                prop = baseClass;
                baseClass = null;
            }

            // 本次调用所创建的类（构造函数）
            function F()
            {
                // 如果父类存在，则实例对象的baseprototype指向父类的原型
                // 这就提供了在实例对象中调用父类方法的途径
                if (baseClass)
                {
                    this.baseprototype = baseClass.prototype;
                }
                this.init.apply(this, arguments);
            }

            // 如果此类需要从其它类扩展
            if (baseClass)
            {
                var middleClass = function() { };
                middleClass.prototype = baseClass.prototype;
                F.prototype = new middleClass();
                F.prototype.constructor = F;
            }

            // 覆盖父类的同名函数
            for (var name in prop)
            {
                if (prop.hasOwnProperty(name))
                {
                    // 如果此类继承自父类baseClass并且父类原型中存在同名函数name
                    if (baseClass &&
							typeof (prop[name]) === "function" &&
							argumentNames(prop[name])[0] === "$super")
                    {
                        // 重定义子类的原型方法prop[name]
                        // - 这里面有很多JavaScript方面的技巧:
                        // - 比如$super封装了父类方法的调用，但是调用时的上下文指针要指向当前子类的实例对象
                        // - 将$super作为方法调用的第一个参数
                        F.prototype[name] = (function(name, fn)
                        {
                            return function()
                            {
                                var that = this;
                                $super = function()
                                {
                                    return baseClass.prototype[name].apply(that, arguments);
                                };
                                return fn.apply(this, Array.prototype.concat.apply($super, arguments));
                            };
                        })(name, prop[name]);

                    } else
                    {
                        F.prototype[name] = prop[name];
                    }
                }
            }

            return F;
        },
        /*
        @namespace FUI.debug
        @description 用于调试的打开和关闭
        @example
        <pre>//打开调试功能
        FUI.debug.on();
        //打印调试内容
        FUI.debug.log();
        //关闭打印日志功能
        FUI.debug.off();</pre>	
        */
        debug: {
            log: function() { },
            on: function()
            {
                if (window.console && console.log && !debugModel)
                {
                    FUI.debug.log = function(a, type)
                    {
                        var type = type || '';
                        console.log(a, type);
                    }
                    debugModel = true;
                }
            },
            off: function()
            {
                if (debugModel)
                {
                    debugModel = false;
                    FUI.debug.log = function() { };
                }
            }
        }
    });



})();
FUI.ns('FUI.lan.array', 'FUI.lan.string', 'FUI.util', 'FUI.widget'); /*
* Array.js
* 
* zsl 2009/09/22
* 
* 主要对扩展了Array中一些常用的功能some,every,lastIndexOf,indexOf,reduce,reduceRight,uniq,without
*
* require:Core/Core.js
*/


/*有关数组的一些扩展*/
(function()
{

    var la = FUI.lan.array,
			slice = Array.prototype.slice;

    /*
    callback 
    为数组中每个元素执行的回调函数
    scope 
    回调函数执行的作用域
    ##################################################################
    描述：
    为数组中的每个元素执行回调函数，直到回调函数返回true，就结束整个过程，some函数就返回true,否则返回false;
    sample:
    FUI.debug.on();
    function isBigEnough(element, index, array) {
    return (element >= 10);
    }
    var passed = FUI.some([2, 5, 8, 1, 4],isBigEnough);
    FUI.debug.log(passed);
    passed = FUI.some([12, 5, 8, 1, 4],isBigEnough);
    // passed is true
    FUI.debug.log(passed);
		
		//应用实例：checkboxTree如果父节点选中，那么子节点至少会有一个会被选中
		
		*/

    la.some = function(arr, callback /*, scope*/)
    {
        var i = 0,
				len = arr.length >>> 0;
        if (typeof callback != "function") throw new TypeError();

        var scope = arguments[2];
        for (; i < len; i++)
        {
            if (i in arr &&
				  callback.call(scope, arr[i], i, arr))
                return true;
        }
        return false;
    };
    /*
    @description
    为数组中的每个元素执行回调函数，如果每次都返回true，some函数就返回true,否则返回false;
    @param {Function} callback 
    为数组中每个元素执行的回调函数
    @param scope 
    回调函数执行的作用域
    ##################################################################

    @example
    FUI.debug.on();
    function isBigEnough(element, index, array) {
    return (element >= 10);
    }
		
		var passed = FUI.every([2, 5, 18, 21, 4],isBigEnough);//false
    FUI.debug.log(passed);
    passed = FUI.every([3,5,6,8,9],isBigEnough);//false
    FUI.debug.log(passed);
    passed = FUI.every([12, 15, 18, 11, 14],isBigEnough);//true
		
		FUI.debug.log(passed);
	  
    */
    la.every = function(arr, callback /*, scope*/)
    {
        var i = 0,
				len = arr.length >>> 0;

        if (typeof callback != "function") throw new TypeError();

        var scope = arguments[2];
        for (; i < len; i++)
        {
            if (i in arr &&
				  !callback.call(scope, arr[i], i, arr))
                return false;
        }
        return true;
    };
    /*
    @description 该函数返回数组中指定元素的最后一个索引
    @param {Array}要处理的数组
    @param searchElement 
    @param 要查找的元素
    fromIndex 
    从fromIndex开始往后查找，默认的是指定数组的长度，即寻找整个数组，如果fromIndex大于或者等于数组的长度，会查找整个数组，如果fromIndex			为负值，那么是指定的是数组末尾的偏移量。
    @example 示例：
    var index = array.lastIndexOf(9);
    FUI.debug.log(index);

		index = array.lastIndexOf(7);
    FUI.debug.log(index);

		index = array.lastIndexOf(2, 3);
    FUI.debug.log(index);

		index = array.lastIndexOf(2, 1);
    FUI.debug.log(index);

		index = array.lastIndexOf(2, -2);
    FUI.debug.log(index);

		index = array.lastIndexOf(2, -1);
    FUI.debug.log(index);
    */
    la.lastIndexOf = function(arr, ele /*, from*/)
    {
        var len = arr.length;

        var from = Number(arguments[2]);
        if (isNaN(from))
        {
            from = len - 1;
        }
        else
        {
            from = (from < 0)
			   ? Math.ceil(from)
			   : Math.floor(from);
            if (from < 0)
                from += len;
            else if (from >= len)
                from = len - 1;
        }

        for (; from > -1; from--)
        {
            if (from in arr &&
			  arr[from] === ele)
                return from;
        }
        return -1;
    };
    /*
    @description 查找数组中某个元素的第一个索引
    参数：
    @param {Array}arr:要查找的数组
    @param elt:要查找的元素
    @param from:
    指定开始查找的索引，默认为0，搜索整个数组；如果from大于或者等于数组的长度，返回-1，如果是负值，指定的是到数组末尾的偏移量；	  
    */
    la.indexOf = function(arr, elt /*, from*/)
    {
        var len = arr.length >>> 0;

        var from = Number(arguments[2]) || 0;
        from = (from < 0)
			 ? Math.ceil(from)
			 : Math.floor(from);
        if (from < 0)
            from += len;

        for (; from < len; from++)
        {
            if (from in arr &&
			  arr[from] === elt)
                return from;
        }
        return -1;
    };


    /*
    @description 把数组中的每个元素按照fun指定的方式进行累计(从左向右)运算，返回累计后的结果
    @param {Array} 要处理的数组
    @param {Function} 
    对数组中每个元素要调用的函数
    @param initialValue 可选
    为第一次调用回调函数指定它的一个参数
    对函数的执行够过程描述：
    回调函数中的参数四个，分别为：
    previousValue:上一次执行回调函数返回的结果或者reduce函数中指定的initValue；callback(previousValue, currentValue, index, array){
    currentValue:要执行回调函数的当前元素
    index：当前元素的索引值
    array:当前数组
    如：
    没有指定初始值：
    FUI.reduce([0,1,2,3,4]，function(previousValue, currentValue, index, array){
    return previousValue + currentValue;
    });
    // 第一次调用
    previousValue = 0, currentValue = 1, index = 1
    // 第二次调用
    previousValue = 1, currentValue = 2, index = 2
    // 第三次调用
    previousValue = 3, currentValue = 3, index = 3
    // 第四次调用
    previousValue = 6, currentValue = 4, index = 4
    }
	
	指定初始值：
    [0,1,2,3,4].reduce(function(previousValue, currentValue, index, array){
    return previousValue + currentValue;
    }, 10);
    // 第一次调用
    previousValue = 10, currentValue = 0, index = 0
	
	// 第二次调用
    previousValue = 10, currentValue = 1, index = 1
	
	// 第三次调用
    previousValue = 11, currentValue = 2, index = 2
	
	// 第四次调用
    previousValue = 13, currentValue = 3, index = 3

	// 第五次调用
    previousValue = 16, currentValue = 4, index = 4
	
	sample:
    var total = FUI.reduce([0, 1, 2, 3],function(a, b){ return a + b; });
    FUI.debug.log(total);
    var flattened = FUI.reduce([[0,1], [2,3], [4,5]],function(a,b) {
    return a.concat(b);
    }, []);
    FUI.debug.log(flattened);
	
	  */
    la.reduce = function(arr, fun /*, initial*/)
    {
        var len = arr.length >>> 0;
        if (typeof fun != "function") throw new TypeError();

        // 如果没有初始值并且是一个空数组
        if (len == 0 && arguments.length == 2) throw new TypeError();

        var i = 0;
        if (arguments.length >= 3)
        {
            var rv = arguments[2];
        }
        else
        {
            do
            {
                if (i in arr)
                {
                    rv = arr[i++];
                    break;
                }
                // 如果数组为空，没有初始值
                if (++i >= len)
                    throw new TypeError();
            }
            while (true);
        }
        for (; i < len; i++)
        {
            if (i in arr)
                rv = fun.call(null, rv, arr[i], i, arr);
        }

        return rv;
    };
    /*
    @description 把数组中的每个元素按照fun指定的方式进行累计(从右到左)运算，返回累计后的结果
    @param fun 
    对数组中每个元素要调用的函数
    @param initialValue 可选
    为第一次调用回调函数指定它的一个参数
	
	@example 对函数的执行够过程描述：
    回调函数中的参数四个，分别为：
    previousValue:上一次执行回调函数返回的结果或者reduce函数中指定的initValue；callback(previousValue, currentValue, index, array){
    currentValue:要执行回调函数的当前元素
    index：当前元素的索引值
    array:当前数组
    如：
    没有指定初始值：
    [0,1,2,3,4].reduceRight(function(previousValue, currentValue, index, array){
    return previousValue + currentValue;
    });
	
	//第一次调用
    previousValue = 4, currentValue = 3, index = 3
	
	// 第二次调用
    previousValue = 7, currentValue = 2, index = 2
	
	// 第三次调用
    previousValue = 9, currentValue = 1, index = 1
	
	//第四次调用
    previousValue = 10, currentValue = 0, index = 0
    指定初始值：
    [0,1,2,3,4].reduceRight(function(previousValue, currentValue, index, array){
    return previousValue + currentValue;
    }, 10);
	
	// 第一次调用
    previousValue = 10, currentValue = 4, index = 4
	
	// 第二次调用
    previousValue = 14, currentValue = 3, index = 3
	
	// 第三次调用
    previousValue = 17, currentValue = 2, index = 2
	
	// 第四次调用
    previousValue = 19, currentValue = 1, index = 1
	
	// 第五次调用
    previousValue = 20, currentValue = 0, index = 0

    var total1 = FUI.reduceRight([0, 1, 2, 3],function(a, b) { return a + b; });
    FUI.debug.log(total1);
    var flattened1 = FUI.reduceRight([[0, 1], [2, 3], [4, 5]],function(a, b) {
    return a.concat(b);
    }, []);
    FUI.debug.log(flattened1);


	  */
    la.reduceRight = function(arr, fun /*, initial*/)
    {
        var len = arr.length >>> 0;
        if (typeof fun != "function") throw new TypeError();

        // 如果没有初始值或者是空数组，就没有值可返回
        if (len == 0 && arguments.length == 2) throw new TypeError();

        var i = len - 1;
        if (arguments.length >= 3)
        {
            var rv = arguments[2];
        }
        else
        {
            do
            {
                if (i in arr)
                {
                    rv = arr[i--];
                    break;
                }

                // 如果数组中没有值，就没有初始值返回
                if (--i < 0)
                    throw new TypeError();
            }
            while (true);
        }

        for (; i >= 0; i--)
        {
            if (i in arr)
                rv = fun.call(null, rv, arr[i], i, arr);
        }
        return rv;
    };
    /*
    @description 删除数组中的重复的元素
    @param arr:要操作的数组
    @example
    var arr= FUI.uniq([1,1,4,5,5]);
    FUI.debug.log(arr);
    */
    la.uniq = function(arr)
    {
        var ra = [],
		      l = arr.length,
			  i = 0,
			  obj = {};
        for (; i < l; i++)
        {
            obj[arr[i]] = null;
        }
        for (var key in obj)
        {
            ra.push(key);
        }
        return ra;
    };
    /*
    @description 删除数组中指定的元素
    参数：要操作的数组
    @param elen:要删除的元素
    @example
    FUI.debug.log('without函数测试');
    var arr= FUI.without([1,4,4,5],4,5);
    FUI.debug.log(arr);
    arr = FUI.without([5,6,7,8],7,8);
    FUI.debug.log(arr);
    */
    la.without = function(arr/*,ele1,ele2*/)
    {
        var eles = slice.call(arguments, 1),
		  	   i = 0,
			   l = eles.length,
			   ele = null,
			   index = 0;
        arr = la.uniq(arr); //去除重复的
        for (; i < l; i++)
        {
            index = la.indexOf(arr, eles[i]);
            arr.splice(index, 1);
        }
        return arr;
    };


    FUI.apply(FUI, la);
})();



var Config = {
    ///	<summary>
    /// 返回配置对象中指定的key所对应的键值	
    ///	</summary>
    ///	<param name="opt" type="String">
    ///	</param>
    ///	<returns type="Object" />
    getOption: function(opt)
    {
        if (typeof this.option[opt] === 'undefined')
            return null;
        else
            return this.option[opt];
    },
    ///	<summary>
    /// 设置配置对象中的键值对
    ///	</summary>
    ///	<param name="opt" type="String">
    ///	</param>
    ///	<param name="val" type="Object">
    ///	</param>    
    ///	<returns type="Object" />
    setOption: function(opt, val)
    {
        if (this.option)
            this.option[opt] = val;
        return this;
    },
    ///	<summary>
    /// 取得整个配置对象
    ///	</summary>
    getOptions: function()
    {
        return this.option;
    }


}/*
* Cookie.js
* 
* zsl 2009/09/24
* 
* 用于设置和获取cookie的值,set(name,value);get(name);
*
* require:Core/Core.js
*/

    /*
    @class FUI.util.Cookies

*/
    /** @namespace */
    FUI.util.Cookies = {
        /*
        ///	<summary>   
        ///	@description 用指定名字和值生成一个cookie
        ///	@param {String}name:cookie名
        ///	@param value:cookie值
        ///	@param expires:可选，指定过期时间，
        ///	@param path:可选，该属性指定可以访问该cookie的web页面地址，默认的是创建该cookie得页面，和该页面在相同目录下的其他页面以及所有子目录下的页面。
        ///	如：在http://www.fetion.com.cn/space/index.html页面上创建了一个cookie，那么像http://www.fetion.com.cn/space/mood.html，http://www.fetion.com.cn/space/favarite/mood.html都能访问上述创建的cookie，但是http://www.fetion.com.cn/index.html就不能访问了。
        ///	如果指定path指定为‘/’,那么http://www.fetion.com.cn下的所有文件都可以访问Cookie.
		
///	@param domain:可选,如果想跨域访问cookie，必须使用属性，如果在order.example.com下的文件想访问在catalog.example.com的页面中设置的cookie,如果在order.example.com下生成的cookie把domain得值设为'/',那么像catalog.example.com,test.example.com下的文件都可以访问该cookie。
        ///	@param secure:可选，该属性指定cookie的值怎样通过网络进行传输，默认为false，即不是通过一般的http进行传输，如果指定为true，则服务器端和浏览器必须通过https进行连接。
        ///	@example 
        ///	FUI.util.Cookies.set('username','zhangsan');
        ///	</summary>
        */
        set: function(name, value)
        {
            var argv = arguments;
            var argc = arguments.length;
            var expires = argv[2] || null;
            var path = argv[3] || '/';
            var domain = argv[4] || null;
            var secure = argv[5] || false;
            document.cookie = name + "=" + escape(value) + ((expires == null) ? "" : ("; expires=" + expires.toGMTString())) + ((path == null) ? "" : ("; path=" + path)) + ((domain == null) ? "" : ("; domain=" + domain)) + ((secure == true) ? "; secure" : "");
        },
        /*
        ///	<summary>       
        ///    @description 获取指定cookie的值
        ///    @param cookie的名字
        ///    @example
        ///    FUI.util.Cookies.get('username');
        ///	</summary>
        */
        get: function(name)
        {
            var arg = name + "=";
            var alen = arg.length;
            var clen = document.cookie.length;
            var i = 0;
            var j = 0;
            while (i < clen)
            {
                j = i + alen;
                if (document.cookie.substring(i, j) == arg)
                    return FUI.util.Cookies.getCookieVal(j);
                i = document.cookie.indexOf(" ", i) + 1;
                if (i == 0)
                    break;
            }
            return null;
        },
        /**
        ///	<summary>       
        ///    @description 清除指定名字的cookies
        ///    @param cookie名字
        ///    @example 
        ///    FUI.util.Cookies.clear('username');
        ///	</summary>    
        */
        clear: function(name)
        {
            if (FUI.util.Cookies.get(name))
            {
                document.cookie = name + "=" + "; expires=Thu, 01-Jan-70 00:00:01 GMT";
            }
        },
        /** @private */
        getCookieVal: function(offset)
        {
            var endstr = document.cookie.indexOf(";", offset);
            if (endstr == -1)
            {
                endstr = document.cookie.length;
            }
            return unescape(document.cookie.substring(offset, endstr));
        }


    };

    CSS = {
        //视口的宽度和高度
        viewport: function()
        {
            var de = document.documentElement;
            var w = self.innerWidth || (de && de.clientWidth) || document.body.clientWidth,
        h = self.innerHeight || (de && de.clientHeight) || document.body.clientHeith;
            return {
                width: w, height: h
            }
        },
        pageHeight: function()
        {
            // handle IE 6
            if ($.browser.msie && $.browser.version < 7)
            {
                var scrollHeight = Math.max(
                                document.documentElement.scrollHeight,
                                document.body.scrollHeight
                        );
                var offsetHeight = Math.max(
                                document.documentElement.offsetHeight,
                                document.body.offsetHeight
                        );

                if (scrollHeight < offsetHeight)
                {
                    return $(window).height() + 'px';
                } else
                {
                    return scrollHeight + 'px';
                }
                // handle Opera
            } else if ($.browser.opera)
            {
                return Math.max(
                                window.innerHeight,
                                $(document).height()
                        ) + 'px';
                // handle "good" browsers
            } else
            {

                return $(document).height() + 'px';
            }
        },
        pageWidth: function()
        {
            // handle IE 6
            if ($.browser.msie && $.browser.version < 7)
            {
                var scrollWidth = Math.max(
                                document.documentElement.scrollWidth,
                                document.body.scrollWidth
                        );
                var offsetWidth = Math.max(
                                document.documentElement.offsetWidth,
                                document.body.offsetWidth
                        );

                if (scrollWidth < offsetWidth)
                {
                    return $(window).width() + 'px';
                } else
                {
                    return scrollWidth + 'px';
                }
                // handle Opera
            } else if ($.browser.opera)
            {
                return Math.max(
                                window.innerWidth,
                                $(document).width()
                        ) + 'px';
                // handle "good" browsers
            } else
            {
                return $(document).width() + 'px';
            }
        },
        //整个文档的大小
        pageSize: function()
        {
            return {
                width: CSS.pageWidth(),
                height: CSS.pageHeight()
            }
        },
        //让元素居中，参数为jQuery对象
        centerWindow: function(obj)
        {
            var de, ww, wh, wsl, wst, ow, oh, l, t, viewport;
            de = document.documentElement;
            viewport = CSS.viewport();
            ww = viewport.width;
            wh = viewport.height;
            wsl = self.pageXOffset || (de && de.scrollLeft) || document.body.scrollLeft;
            wst = self.pageYOffset || (de && de.scrollTop) || document.body.scrollTop;
            ow = obj.width();
            oh = obj.height();
            l = wsl + ww / 2 - ow / 2;
            t = wst + wh / 2 - oh / 2;
            obj.css({ left: l, top: t });
        },
        //
        radioClass: function(ele, className)
        {
            if (className.constructor === Array) c = c.join(" ");
            return jQuery(ele).addClass(c).siblings().removeClass(c).end();
        },
        //设置一个元素的样式值
        setStyle: function(ele, attr, val)
        {

        },
        //获取指定元素的样式值
        getStyle: function(ele, attr)
        {

        }


    }; /*
* Function.js
* 
* zsl 2009/09/22
* 
* 对函数常用功能扩展
*/
    FUI.apply(Function.prototype, (function()
    {

        /*
        ///<summary>
        ///@description 该函数用于创建一个函数的委托，作用域为obj
        ///任何函数都可以直接调用该方法，如W.createDelegate(obj)；
        ///这样就会自动创建一个作用域为obj的新函数，它的this指向obj,
        ///@param obj：要代理的函数的作用域
        ///@param args:为函数指定参数，数组形式
        ///@param appendArgs:如果没有该参数，args会覆盖掉向新生成的函数的参数；如果该参数为true,args会追加到新生成的函数的参数的后面；如果该参数为数字，args会插入到新生成的函数的参数里面，位置为appendsArgs指定的位置。
        ///@example	
        ///function W(){
        ///var ar=arguments;

///return this.name+' age: '+Array.prototype.slice.call(arguments,0).join(',');
        ///}
        ///var obj={
        ///name:'zhaohaoduo'
        ///}
        ///var ow=W.createDelegate(obj,['23'],true);
        /// // ow=W.createDelegate(obj,['23'],1);
        /// //ow=W.createDelegate(obj);
        /// FUI.debug.log(ow('56','78'));
        ///</summary>
        */
        var createDelegate = function(obj, args, appendArgs)
        {
            var method = this;
            return function()
            {
                var callArgs = args || arguments;
                if (appendArgs === true)
                {
                    callArgs = Array.prototype.slice.call(arguments, 0);
                    callArgs = callArgs.concat(args);
                } else if (typeof appendArgs == "number")
                {
                    callArgs = Array.prototype.slice.call(arguments, 0); // copy arguments first
                    var applyArgs = [appendArgs, 0].concat(args); // create method call params
                    Array.prototype.splice.apply(callArgs, applyArgs); // splice them in
                }
                return method.apply(obj || window, callArgs);
            };
        };
        /*
        @description 该函数用于在指定的时间后执行一个函数
        参数：
        @param millis 指定多长时间后执行一个函数
        @param obj	函数的作用域
        @param args 	函数的参数
        @param appendArgs 函数要追加的参数
        @example
        (function(){
        alert('延迟三秒');
        }).defer(3000)
        */
        var defer = function(millis, obj, args, appendArgs)
        {
            var fn = this.createDelegate(obj, args, appendArgs);
            if (millis > 0)
            {
                return setTimeout(fn, millis);
            }
            fn();
            return 0;
        };
        /*
        @description 该函数用于缓存函数执行后的结果
		
		注意该函数对window对象下的函数不太管用//why
        @param cache:缓存对象
        @param obj：函数的作用域
        @example
        var fib = {
        fib: function(n){
        if (n == 0 || n == 1)
        return 1;
        return this.fib(n-1) + this.fib(n-2);
        },
        fib_memo: function(n){
        if (n == 0 || n == 1)
        return 1;
        return this.fib_memo(n-1) + this.fib_memo(n-2);
        }
        }
	
	fib.fib_memo = fib.fib_memo.memoize(fib);
	
	
    //var f= fib.memoize();	
        var start=new Date().getTime();
        var result=fib.fib(30);
        //var send=new Date();
        var end=new Date().getTime();
        var duration=end-start;
        */
        var memoize = function(obj, cache)
        {
            var method = this,
				cache = cache || {},
				obj = obj || window;
            return function()
            {
                var key = Array.prototype.join.call(arguments, '_');
                if (!(key in cache))
                {
                    cache[key] = method.apply(obj, arguments);
                }
                return cache[key];
            };
        };
        /*
        @description 函数的curry化
        该函数作用是为函数预填充一些参数(注意：curry是数学家Haskell Brooks Curry的名字)；
        @example
        比如有一个函数f， 而这个函数接收若干个参数， 比如4个，其中前两个参数在处理一类问题的总是固定的，处理另外一类问题又是另一组相对固定的值。 所以如果我打算处理A类问题时， 我希望前两个参数不用每次都去填， 处理B类问题也是如此。这时curry就可以起到这个作用了。 我可以为处理A类问题定义一个函数fa， 如var fa = f.curry(arga1, arga2)，这样参数arg1和arg2就算是预填进函数f了。 这样在处理A类问题时， 我们可以直接条用函数fa， 比如fa(arg3, arg4)，这时我们只需指定后两个参数arg3和arg4即可。 同样， 处理B类问题， var fb = f.curry(argb1, argb2)，然后调用fb(arg3, arg4)， 即指定后两个参数即可。 换句话说， 我们分别为函数fa和fb指定了前两个参数的默认值。 JavaScript言语本身是不支持函数参数的默认值的， 所以这个curry函数非常有用。

    function f(a,b,c,d){
        return a+b+c+d;
        }
        var f12=f.curry(1,2);
        FUI.debug.log(f12(3,4));
        FUI.debug.log(f12(5,6));
	
	附加：一个更加高级的版本
        Function.prototype.partial = function(){
        var fn = this, args = Array.prototype.slice.call(arguments);
        return function(){
        var arg = 0;
        for ( var i = 0; i < args.length && arg < arguments.length; i++ )
        if ( args[i] === undefined )
        args[i] = arguments[arg++];
        return fn.apply(this, args);
        };
        };
        var delay = setTimeout.partial(undefined, 10);

	delay(function(){
        alert( "A call to this function will be temporarily delayed." );
        });
	
	var bindClick = document.body.addEventListener
        .partial("click", undefined, false);
	
	bindClick(function(){
        alert( "Click event bound via curried function." );
        });
        */
        var curry = function()
        {
            var slice = Array.prototype.slice;
            if (!arguments.length) return this;
            var __method = this, args = slice.call(arguments, 0);
            return function()
            {
                var a = args.concat(slice.call(arguments, 0));
                return __method.apply(this, a);
            }
        };


        return {
            createDelegate: createDelegate,
            defer: defer,
            memoize: memoize,
            curry: curry
        };
    })());




    /*
    Timer.js
    * json.js
    * 
    * zsl 2009/09/24
    * 
    * inspired by Douglas Crockford"s json.js
    *
    * 主要有encode(把json对象转换成字符串的形式)，decode(把字符串转换成json对象的形式)
    *required:Core/Core.js 
    */
    /** @namespace */
    FUI.util.JSON = function()
    {
        //判断浏览器是否支持json

        var isNative = window.JSON && window.JSON.toString() == '[object JSON]';
        /** @private */
        function f(n)
        {
            // Format integers to have at least two digits.
            return n < 10 ? '0' + n : n;
        }

        if (typeof Date.prototype.toJSON !== 'function')
        {

            Date.prototype.toJSON = function(key)
            {

                return this.getUTCFullYear() + '-' +
                 f(this.getUTCMonth() + 1) + '-' +
                 f(this.getUTCDate()) + 'T' +
                 f(this.getUTCHours()) + ':' +
                 f(this.getUTCMinutes()) + ':' +
                 f(this.getUTCSeconds()) + 'Z';
            };

            String.prototype.toJSON =
        Number.prototype.toJSON =
        Boolean.prototype.toJSON = function(key)
        {
            return this.valueOf();
        };
        }

        var cx = /[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
        escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
        gap,
        indent,
        meta = {    // table of character substitutions
            '\b': '\\b',
            '\t': '\\t',
            '\n': '\\n',
            '\f': '\\f',
            '\r': '\\r',
            '"': '\\"',
            '\\': '\\\\'
        },
        rep;

        /** @private */
        function quote(string)
        {

            // If the string contains no control characters, no quote characters, and no
            // backslash characters, then we can safely slap some quotes around it.
            // Otherwise we must also replace the offending characters with safe escape
            // sequences.

            escapable.lastIndex = 0;
            return escapable.test(string) ?
            '"' + string.replace(escapable, function(a)
            {
                var c = meta[a];
                return typeof c === 'string' ? c :
                    '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
            }) + '"' :
            '"' + string + '"';
        }

        /** @private */
        function str(key, holder)
        {

            // Produce a string from holder[key].

            var i,          // The loop counter.
            k,          // The member key.
            v,          // The member value.
            length,
            mind = gap,
            partial,
            value = holder[key];

            // If the value has a toJSON method, call it to obtain a replacement value.

            if (value && typeof value === 'object' &&
                typeof value.toJSON === 'function')
            {
                value = value.toJSON(key);
            }

            // If we were called with a replacer function, then call the replacer to
            // obtain a replacement value.

            if (typeof rep === 'function')
            {
                value = rep.call(holder, key, value);
            }

            // What happens next depends on the value's type.

            switch (typeof value)
            {
                case 'string':
                    return quote(value);

                case 'number':

                    // JSON numbers must be finite. Encode non-finite numbers as null.

                    return isFinite(value) ? String(value) : 'null';

                case 'boolean':
                case 'null':

                    // If the value is a boolean or null, convert it to a string. Note:
                    // typeof null does not produce 'null'. The case is included here in
                    // the remote chance that this gets fixed someday.

                    return String(value);

                    // If the type is 'object', we might be dealing with an object or an array or
                    // null.

                case 'object':

                    // Due to a specification blunder in ECMAScript, typeof null is 'object',
                    // so watch out for that case.

                    if (!value)
                    {
                        return 'null';
                    }

                    // Make an array to hold the partial results of stringifying this object value.

                    gap += indent;
                    partial = [];

                    // Is the value an array?

                    if (Object.prototype.toString.apply(value) === '[object Array]')
                    {

                        // The value is an array. Stringify every element. Use null as a placeholder
                        // for non-JSON values.

                        length = value.length;
                        for (i = 0; i < length; i += 1)
                        {
                            partial[i] = str(i, value) || 'null';
                        }

                        // Join all of the elements together, separated with commas, and wrap them in
                        // brackets.

                        v = partial.length === 0 ? '[]' :
                    gap ? '[\n' + gap +
                            partial.join(',\n' + gap) + '\n' +
                                mind + ']' :
                          '[' + partial.join(',') + ']';
                        gap = mind;
                        return v;
                    }

                    // If the replacer is an array, use it to select the members to be stringified.

                    if (rep && typeof rep === 'object')
                    {
                        length = rep.length;
                        for (i = 0; i < length; i += 1)
                        {
                            k = rep[i];
                            if (typeof k === 'string')
                            {
                                v = str(k, value);
                                if (v)
                                {
                                    partial.push(quote(k) + (gap ? ': ' : ':') + v);
                                }
                            }
                        }
                    } else
                    {

                        // Otherwise, iterate through all of the keys in the object.

                        for (k in value)
                        {
                            if (Object.hasOwnProperty.call(value, k))
                            {
                                v = str(k, value);
                                if (v)
                                {
                                    partial.push(quote(k) + (gap ? ': ' : ':') + v);
                                }
                            }
                        }
                    }

                    // Join all of the member texts together, separated with commas,
                    // and wrap them in braces.

                    v = partial.length === 0 ? '{}' :
                gap ? '{\n' + gap + partial.join(',\n' + gap) + '\n' +
                        mind + '}' : '{' + partial.join(',') + '}';
                    gap = mind;
                    return v;
            }
        }


        /** @scope FUI.util.JSON */
        return {
            encode: isNative ? JSON.stringify : function(value, replacer, space)
            {

                // The stringify method takes a value and an optional replacer, and an optional
                // space parameter, and returns a JSON text. The replacer can be a function
                // that can replace values, or an array of strings that will select the keys.
                // A default replacer method can be provided. Use of the space parameter can
                // produce text that is more easily readable.

                var i;
                gap = '';
                indent = '';

                // If the space parameter is a number, make an indent string containing that
                // many spaces.

                if (typeof space === 'number')
                {
                    for (i = 0; i < space; i += 1)
                    {
                        indent += ' ';
                    }

                    // If the space parameter is a string, it will be used as the indent string.

                } else if (typeof space === 'string')
                {
                    indent = space;
                }

                // If there is a replacer, it must be a function or an array.
                // Otherwise, throw an error.

                rep = replacer;
                if (replacer && typeof replacer !== 'function' &&
                    (typeof replacer !== 'object' ||
                     typeof replacer.length !== 'number'))
                {
                    throw new Error('JSON.stringify');
                }

                // Make a fake root object containing our value under the key of ''.
                // Return the result of stringifying the value.

                return str('', { '': value });
            },
            decode: isNative ? JSON.parse : function(text)
            {
                return eval("(" + text + ')');
            }
        }
    } ();
    /*
    @description 把json对象转换成字符串的形式
    @example
    var myJSONObject = {"bindings": [
    {"ircEvent": "PRIVMSG", "method": "newURI", "regex": "^http://.*"},
    {"ircEvent": "PRIVMSG", "method": "deleteURI", "regex": "^delete.*"},
    {"ircEvent": "PRIVMSG", "method": "randomURI", "regex": "^random.*"}
    ]
    };
    FUI.debug.log(FUI.encode(myJSONObject));
    */
    FUI.encode = FUI.util.JSON.encode;
    /*
    @description 把字符串转换成json对象的形式
    @example
    var myjsonstring = '{"bindings":[{"ircEvent":"PRIVMSG","method":"newURI","regex":"^http://.*"},{"ircEvent":"PRIVMSG","method":"deleteURI","regex":"^delete.*"},{"ircEvent":"PRIVMSG","method":"randomURI","regex":"^random.*"}]}';
    FUI.debug.log(FUI.decode(myjsonstring));
    */
    FUI.decode = FUI.util.JSON.decode;

    /*
    String.js
    * String.js
    * 
    * zsl 2009/09/22
    * 
    * 主要对扩展了String中一些常用的功能trim,trimRight,trimLeft,truncate,stripTags,escapeHTML,unescapeHTML,camelCase,hyphenate
    *
    * require:required:Core/Core.js
    */

    (function()
    {

        var ls = FUI.lan.string;
        /*
        @description 删除字符串两侧的空格
        @param str:要处理的字符串
        */
        ls.trim = function(str)
        {
            return (str || "").replace(/^\s+|\s+$/g, "");
        };

        /*
        @description 删除字符串右侧的空白
        @param str:删除字符串右边的空格
        */
        ls.trimRight = function(str)
        {
            return (str || "").replace(/\s+$/, '');
        };
        /*
        @description 删除字符串左侧的空白
        @param str:删除字符串左边的空格
        */
        ls.trimLeft = function(str)
        {
            return (str || "").replace(/^\s+/, '');
        };
        /*
        @description 截取字符串中指定长度的子串
        @param str:要截取的字符串
        @param length:要截取的长度
        @param truncation:用于替换的字符串
        @example 
        str='飞信WAP网站是中国移动飞信的手机门户网站。在这里您可以随时随地享受飞信的无缝网络信息交流服务，全方位体验飞信带来的多彩生活！';
        FUI.debug.log(FUI.truncate(str,20));
        */
        ls.truncate = function(str, length, truncation)
        {
            length = length || 30;
            truncation = typeof truncation == 'undefined' ? '...' : truncation;
            return str.length > length ?
			  str.slice(0, length - truncation.length) + truncation : String(str);
        };

        ls.byteLength = function(source)
        {
            return String(source).replace(/[^\x00-\xff]/g, "ci").length;
        };

        ls.byteSub = function(source, length)
        {
            source = String(source);
            if (length < 0 || this.byteLength(source) <= length)
                return source;
            source = source.substr(0, length).replace(/([^\x00-\xff])/g, "\x241 ")//双字节字符替换成两个
                .substr(0, length)//截取长度
                .replace(/[^\x00-\xff]$/, "")//去掉临界双字节字符
                .replace(/([^\x00-\xff]) /g, "\x241"); //还原
            return source;
        };

        ls.byteTruncate = function(source, length, limit, truncation)
        {
            if (typeof truncation == 'undefined')
                truncation = '...';
            length *= 2;
            limit *= 2;
            if (this.byteLength(source) < length)
                return source;
            else
                return this.byteSub(source, limit) + truncation;
        };

        /*
        @description 去除html标签
        @param str 含有html标签的字符串
        @example str='<dl><dt> <a href="https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Global_Objects/Array/pop" rel="internal">pop</a> </dt><dd> Removes the last element from an array and returns that element. </dd><dt> <a </dd></dl>';
        FUI.debug.log(FUI.stripTags(str));
        */
        ls.stripTags = function(str)
        {
            return (str || "").replace(/<\w+(\s+("[^"]*"|'[^']*'|[^>])+)?>|<\/\w+>/gi, '');
        };
        /*
        @description 编码html标签
        @param str: 要编码的字符串
        @example 
        str='<dl><dt> <a href="https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Global_Objects/Array/pop" 			rel="internal">pop</a> </dt><dd> Removes the last element from an array and returns that element. </dd><dt> <a </dd></dl>';
        FUI.debug.log(FUI.escapeHTML(str));
        */
        ls.escapeHTML = function(str)
        {
            return (str || "").replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
        };
        /*
        @description 解码经escapeHTML编编码后的html字符串
        @param str：要处理的字符串
        @example
        var str='<dl><dt> <a href="https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Global_Objects/Array/pop" 			rel="internal">pop</a> </dt><dd> Removes the last element from an array and returns that element. </dd><dt> <a </dd></dl>';
        str=FUI.escapeHTML(str);
        FUI.debug.log(FUI.unescapeHTML(str));
        */
        ls.unescapeHTML = function(str)
        {
            return ls.stripTags(str).replace(/&lt;/g, '<').replace(/&gt;/g, '>').replace(/&amp;/g, '&');
        };
        /*
        @description    把一个带有连字符形式的字符串转换为骆驼符号形式的字符串
        @param    要处理的字符串
        @example
        var str='background-color';
        FUI.debug.log(FUI.camelCase(str));
        */
        ls.camelCase = function(str)
        {
            return (str || "").replace(/-\D/g, function(match)
            {
                return match.charAt(1).toUpperCase();
            });
        }
        /*
        @description    把骆驼符号形式的字符串转换为带有连字符形式的字符串
        @param 要处理的字符串
        @example 
        var str="background-Color";
        FUI.debug.log(FUI.hyphenate(str));
        */
        ls.hyphenate = function(str)
        {
            return (str || "").replace(/[A-Z]/g, function(match)
            {
                return ('-' + match.charAt(0).toLowerCase());
            });
        }


        FUI.apply(FUI, ls);

    })();

    /*
    Timer.js
    * Timer.js
    * 
    * zsl 2009/09/22
    * 
    * 主要对扩展了String中一些常用的功能trim,trimRight,trimLeft,truncate,stripTags,escapeHTML,unescapeHTML,camelCase,hyphenate
    *
    * require:required:Core/Core.js,Array.js
    */

    /*
    * dialog.js
    * 
    * zsl 2009/10/14
    * 
    * required : core.js,css.js,jQuery-1.3.2
    */
    //<div style="width: 500px;" class="favorites_layer" id="_fx_dialog">
    //	<div class="inbox_bg">
    //		<div class="inbox_layer01">
    //			<div class="layer_tit lay_bg01">
    //				<h6 id="_fx_dialog_title">这里是标题</h6>
    //				<div class="close"> </div>
    //			</div>
    //			<div class="layer_center" id="_fx_dialog_content">
    //                这里是内容
    //			</div>
    //          <div class="layer_bot">
    //					<input type="submit" value="确定" name="button" class="button01 l_join01" id="_fx_dialog_ok"/>
    //					<input type="submit" value="取消" name="button" class="button01 l_join02" id="_fx_dialog_cancel"/>
    //			</div>
    //		</div>
    //	</div>
    //</div>
    FUI.widget.Dialog = FUI.create({
        init: function(content, opt)
        {
            this.content = content || '这里是内容';

            this.opt = jQuery.extend(this.opt, FUI.widget.Dialog.defaults, opt || {});
            if (typeof this.opt.beforeShow == 'function')
            {
                this.opt.beforeShow(this);
            }
            if (document.getElementById(this.opt.containerId)) return false;
            this.initMarkup();

            this.title = document.getElementById(this.opt.titleId);
            this.contentContainer = document.getElementById(this.opt.contentId);

            if (this.opt.close)
            {
                this.isClose();
            }
            this.close = document.getElementById(this.opt.closeId);
            this.buttonContainer = document.getElementById(this.opt.buttonsId);

            if (this.title)
            {
                this.setTitle(this.opt.title);
            }
            if (this.contentContainer)
            {
                this.setContent(this.content);
            }
            if (this.buttonContainer)
            {
                this.createButton(this.opt.buttons);
            }
            if (typeof this.opt.afterShow == 'function')
            {
                this.opt.afterShow(this);
            }
            this.initEvent();
        },
        initMarkup: function()
        {
            var container = document.createElement("div");
            this.container = container;
            container.className = this.opt.containerClassName;
            delete this.opt.containerClassName;
            container.id = this.opt.containerId;
            delete this.opt.containerId;
            container.style.position = "absolute";
            var dh = this._buildHTML();
            container.innerHTML = dh;
            delete dh;

            if (this.opt.width)
            {
                this.setWidth(this.opt.width);
            }
            if (this.opt.height)
            {
                this.setHeight(this.opt.height);
            }
            if (this.opt.zIndex)
            {
                container.style.zIndex = this.opt.zIndex;
            }
            document.body.appendChild(container);
            if (this.opt.top)
            {
                $(container).css({ left: this.opt.left, top: this.opt.top });
            } else if (this.opt.align)
            {
                this.setPositin(this.container, this.opt.align);
            }

            if (this.opt.modal)
            {
                this.setModal();
            }
        },
        _buildHTML: function()
        {
            return ['<div class="inbox_bg">',
                    '<div class="inbox_layer01">',
                         '<div class="layer_tit lay_bg01"><h6 id="' + this.opt.titleId + '"></h6></div>',
                         '<div class="layer_center" id="' + this.opt.contentId + '"></div>',
                         '<div class="layer_bot" id="' + this.opt.buttonsId + '"></div>',
                     '</div>',
                 '</div>'].join("");
        },
        initEvent: function()
        {
            if (this.close) this.close.onclick = this.destroy(this);
            var thiscontainer = this.container;
            var _this = this;
            if (this.opt.autoAdjust)
            {
                $(window).bind("scroll", function()
                {
                    CSS.centerWindow(jQuery(thiscontainer));
                    if (_this.opt.modal)
                    {
                        _this.resizeModal();
                    }
                }).bind("resize", function()
                {
                    CSS.centerWindow(jQuery(thiscontainer));
                    if (_this.opt.modal)
                    {
                        _this.resizeModal();
                    }
                });
            }
        },
        setContent: function(content)
        {
            var length = content.length, index = content.indexOf("#");
            var pcontent = content.substring(index + 1, length);
            // TODO:BUG 如果HTML里面带有#有问题
            if (index != -1)
            {
                if (/^URL/.test(content))
                {//URL#http://www.baidu.com
                    var iframe = '<iframe id="_fx_dialog_frame" style="height:' + this.opt.height + 'px; width:100%;" scrolling="no" frameborder="0" allowtransparency="yes"></iframe>';
                    var fiframe = document.getElementById("_fx_dialog_frame");
                    if (!fiframe)
                        this.contentContainer.innerHTML = iframe;

                    document.getElementById("_fx_dialog_frame").src = pcontent;
                    this.iframe = document.getElementById("_fx_dialog_frame");
                } else
                {
                    var pcccontent = document.getElementById(pcontent);
                    this.innerContent = pcccontent;
                    pcccontent.style.display = "block";
                    var html = document.createElement("div").appendChild(pcccontent).innerHTML;
                    this.contentContainer.innerHTML = html;
                }
            } else
            {
                this.contentContainer.innerHTML = content;
            }
        },
        setTitle: function(title)
        {
            this.title.innerHTML = title;
        },
        setPositin: function(ele, align)
        {
            align = align;
            switch (align)
            {
                case "center":
                    CSS.centerWindow(jQuery(ele));
                    break;
            }
        },
        setWidth: function(width)
        {
            this.container.style.width = width + "px";
        },
        setHeight: function(height)
        {
            if (this.container) this.container.style.height = height + "px";
            if (this.iframe) this.iframe.style.height = height + "px";
        },
        isClose: function()
        {
            jQuery(this.title).after('<div class="close" id="' + this.opt.closeId + '"></div>');
        },
        createButton: function(buttons)
        {
            var i = 1, idPre = "_fx_dialog_", classes = "button01 l_join0", self = this;

            for (var key in buttons)
            {
                var button = document.createElement("button");
                button.id = idPre + key;
                button.className = classes + i;
                button.onclick = this._buttonClick(buttons[key]["handler"], self);
                button.innerHTML = buttons[key]["label"];
                this.buttonContainer.appendChild(button);
                i++;
            }
        },
        _buttonClick: function(fun, me)
        {
            return function()
            {
                fun(me);
            }
        },
        setModal: function()
        {
            var bgiframe = $('<iframe id="_fx_dialog_iframeId" style="width:100%;height:100%;opacity:0;position:absolute;border-width:0px;background:#000" src="about:blank"></iframe>');
            var bgpanel = $('<div class="_fx_dialog_bg" style="filter: alpha(opacity=60);background:#fff;position:absolute;left:0;top:0;height:3000px;width:3000px "></div>');
            if (jQuery.browser.msie && jQuery.browser.version == "6.0")
                bgpanel.append(bgiframe);
            var bs = CSS.pageSize();
            var bw = bs.width;
            var bh = bs.height;
            var zIndex = this.container.style.zIndex - 1;
            bgpanel.css({ width: bw, height: bh, opacity: 0.6, zIndex: zIndex });
            $("body").append(bgpanel);
            this.bgpanel = bgpanel;
        },
        resizeModal: function()
        {
            if (this.bgpanel)
            {
                var bs = CSS.pageSize();
                var bw = bs.width;
                var bh = bs.height;
                this.bgpanel.css({ width: bw, height: bh });
            }
        },
        hide: function() { this.destroy(this)() },
        destroy: function(me)
        {
            return function()
            {
                if (typeof me.opt.beforeClose == "function") { me.opt.beforeClose(me); }
                if (me.bgpanel) me.bgpanel.remove();
                if (me.container) jQuery(me.container).remove();
                if (typeof me.opt.afterClose == "function") { me.opt.afterClose(me); }
                delete me.content;
                delete me.title;
                delete me.contentContainer;
                //delete me.close;
                delete me.buttonContainer;
                delete me.container;
                delete me.opt.afterClose;
                delete me.opt.beforeClose;
                delete me.opt.buttons;
                // delete me.opt.containerId; delete me.opt.titleId; delete me.opt.contentId; delete me.opt.buttonsId; delete me.opt.closeId;

                if (me.opt.beforeShow) { delete me.opt.beforeShow; }
                if (me.opt.afterShow) { delete me.opt.afterShow; }

                if (me.innerContent)
                {

                    document.body.appendChild(me.innerContent);
                    me.innerContent.style.display = "none";
                }
                //delete me.opt.close;
                //delete me.opt.title;

            }
        }
    });
    FUI.widget.Dialog.defaults = {
        //        buttons: {
        //            ok: {
        //                label: "确定",
        //                handler: function() { 
        //                }
        //            },
        //            cancel: {
        //                label: "取消",
        //                handler: function() {
        //                }
        //            }
        //        },
        width: 300,
        height: 400,
        title: "这里是标题",
        modal: true,
        align: "center",
        zIndex: 9999,
        close: true,
        containerClassName: "favorites_layer",
        autoAdjust: true,
        afterClose: function() { },
        containerId: '_fx_dialog',
        titleId: '_fx_dialog_title',
        contentId: '_fx_dialog_content',
        buttonsId: '_fx_dialog_buttons',
        closeId: '_fx_dialog_close'
    }
    /*
    <!-- 统一的弹出层结构代码 -->
    <div class="model_popup_layer" style="width:260px;">
    <div class="modebox">
    <!-- 弹出层头部 是否可拖动需要JS交互根据不同需求来进行判断 -->
    <div class="box_tr">
    <div class="box_tl">
    <div class="box_tm">
    <h2><img alt="" class="icon_title" src="http://res.fetionpic.com/img/blank/spacer.gif" />删除日志</h2>
    <div class="op_text"><a href="#"><img src="http://res.fetionpic.com/img/blank/spacer.gif" alt="关闭" class="icon_model_close"></a></div>
    </div>
    </div>
    </div>
    <!-- 弹出层头部 end -->
    <!-- 中间 -->
    <div class="box_mr">
    <div class="box_ml">
    <div class="box_mm">
    <div class="pop_content">
    <div class="popup_c">
    <!-- JS加载的层内容 -->
    <div class="pop_img">
    <div class="pop_bg"></div>
    </div>
    <div class="pop_text">你确定要删除该日记吗？<br />
    删除后无法恢复！</div>
    <!-- JS加载的层内容 end -->
    </div>
    <!-- 按钮 -->
    <!-- JS加载的层内容 end -->
    </div>
    <!-- 按钮 -->
    <div class="layer_bnt">
    <input id="button" class="btn_69x21 hand mr20" name="button" type="submit" value="确 定" />
    <input id="button" class="btn_file69x21 hand" name="button" type="submit" value="取 消" />
    </div>
    <!-- 按钮 end -->
    </div>
    </div>
    </div>
    </div>
    <!-- 中间 end -->
    <!-- 尾部 -->
    <div class="box_br">
    <div class="box_bl">
    <div class="box_bm">
    </div>
    </div>
    </div>
    <!-- 尾部 end -->
    </div>
    </div>
    <!-- 统一的弹出层结构代码 end -->
    */

    FUI.widget.Msg = FUI.create(FUI.widget.Dialog, {
        _buildHTML: function()
        {
            return ['<div class="modebox">',
		'<div class="box_tr"><div class="box_tl"><div class="box_tm"><h2><img alt="" class="icon_title" src="http://res.fetionpic.com/img/blank/spacer.gif" /><span id="' + this.opt.titleId + '"></span></h2></div></div></div>',
		'<div class="box_mr"><div class="box_ml"><div class="box_mm">',
		    '<div class="pop_content"><div class="popup_c" id="' + this.opt.contentId + '">',
			    '<div class="pop_img"><div class="pop_bg" id="' + this.opt.iconId + '"></div></div>',
			    '<div class="pop_text" id="fx_pop_text"></div>',
			'</div></div>',
			'<div class="layer_bnt" id="' + this.opt.buttonsId + '"></div>',

		'</div></div></div>',

		'<div class="box_br"><div class="box_bl"><div class="box_bm"></div></div></div>',

	'</div>'].join("");
        },
        setContent: function($super, content)
        {

            if (this.opt.alert)
            {
                jQuery("#fx_pop_text").prepend(content);
                if (this.opt.icon) document.getElementById(this.opt.iconId).className = this.opt.icon;
            } else
            {
                $super(content);
            }
        },
        createButton: function(buttons)
        {
            var i = 1, idPre = "_fx_dialog_", classes = { ok: "btn_69x21 hand mr20", cancel: "btn_file69x21 hand" }, self = this;

            for (var key in buttons)
            {
                var button = document.createElement("button");
                button.id = idPre + key;
                button.className = classes[key];
                button.onclick = this._buttonClick(buttons[key]["handler"], self);
                button.innerHTML = buttons[key]["label"];
                this.buttonContainer.appendChild(button);
                i++;
            }
        },
        isClose: function()
        {
            //if (this.opt.close) {
            jQuery(this.title).after('<div class="op_text"><a href="javascript:void(0)"><img class="icon_model_close" id="' + this.opt.closeId + '" alt="关闭" src="http://res.fetionpic.com/img/blank/spacer.gif"/></a></div>');
            //}
        }

    });
    FUI.widget.Msg.show = function(opt)
    {
        var width = opt.width || 260;
        var height = opt.height || "";
        var title = opt.title || "这里是标题";
        var msg = opt.msg || "这里是提示信息";
        var classname = "model_popup_layer";
        var buttons = opt.buttons || {};
        new FUI.widget.Msg(msg, {
            title: title,
            containerClassName: classname,
            height: height,
            width: width,
            buttons: buttons,
            alert: true,
            containerId: '_fx_msg',
            titleId: '_fx_msg_title',
            contentId: '_fx_msg_content',
            buttonsId: '_fx_msg_buttons',
            closeId: '_fx_msg_close',
            iconId: '_fx_dialog_icon'
        });
    }



    /*
    <div class="pop_content">
    <div class="pop_img">
    <div class="pop_bg"/>
    </div>
    <div class="pop_text">删除该文件夹，会把文件夹中的所有文件同时删除，<br/>
    您确定还要删除吗？</div>
    </div>
    */
    FUI.widget.MessageBox = FUI.create(FUI.widget.Dialog, {
        _buildHTML: function()
        {
            return ['<div class="inbox_bg">',
                            '<div class="inbox_layer01">',
                                 '<div class="layer_tit lay_bg01"><h6 id="_fx_dialog_title"></h6></div>',
                                     '<div class="layer_center" id="_fx_dialog_content">',
                                         '<div class="pop_content">',
					                        '<div class="pop_img">',
						                        '<div class="pop_bg"></div>',
					                        '</div>',
					                        '<div class="pop_text" id="fx_pop_text"></div>',
				                         '</div>',
                                        '<div class="layer_bot" id="_fx_dialog_buttons"></div>',
                                    '</div>',
                             '</div>',
                         '</div>'].join("");
        },
        setContent: function(content)
        {
            jQuery("#fx_pop_text").prepend(content);
        }
    });




    /*
    <!-- 统一的提示层代码 -->
    <div class="model_fade_layer" style="width:500px">
    <div class="model_fade_inner">
    <div class="inner">
    <h6>
    <!-- JS加载需要更改的内容 -->已发送已发送已发送已发送已发送已发送已发送已发送已发送已发送已发送已发送 
    <!-- JS加载需要更改的内容 end --></h6>
    </div>
    </div>
    </div>
    <!-- 统一的提示层代码 end -->
    */

    FUI.widget.Tips = FUI.create(FUI.widget.Dialog, {
        init: function(content, opt)
        {
            this.content = content || '这里是内容';
            var defalts = { modal: false, containerClassName: 'model_fade_layer', delay: 3000 };
            this.opt = jQuery.extend(FUI.widget.Dialog.defaults, defalts, opt || {});
            this.initMarkup();
            this.contentContainer = document.getElementById(this.opt.contentId);

            if (this.contentContainer) this.setContent(this.content);
            this.initEvent();
            var me = this;
            window.setTimeout(me.destroy(me), this.opt.delay);
        },
        _buildHTML: function()
        {
            return [
	        '<div class="model_fade_inner">',
		        '<div class="inner">',
			        '<h6 id="' + this.opt.contentId + '"></h6>',
		        '</div>',
	        '</div>'].join("");
        }
    });

    FUI.widget.Tips.show = function(opt)
    {
        var content = opt.content || "这里是内容",
    delay = opt.delay || 3000;
        new FUI.widget.Tips(content, {
            delay: delay,
            height: 35,
            width: "",
            containerId: '_fx_tips',
            contentId: '_fx_tips_content',
            containerId: '_fx_tips'
        })
    };
    /*
    <div class="onload_layer"><img src="/img/home/uncm/onload.gif"/><strong>正在载入中，请稍等…</strong></div>
    */
    FUI.widget.LoadMask = FUI.create(FUI.widget.Dialog, {
        init: function(content, opt)
        {
            this.content = content || '正在载入中，请稍等…';
            var defalts = { modal: true, containerClassName: 'onload_layer', height: 50, width: 216 };
            this.opt = jQuery.extend(FUI.widget.Dialog.defaults, defalts, opt || {});
            this.initMarkup();
            this.contentContainer = document.getElementById(this.opt.contentId);

            if (this.contentContainer) this.setContent(this.content);
            this.initEvent();
        },
        _buildHTML: function()
        {
            var imgpath = this.opt.imgPath || "/img/home/uncm/onload.gif";
            return ['<img src="' + imgpath + '" width="32px" height="32px"/>',
		        '<strong id="' + this.opt.contentId + '"></strong>'].join("");
        }
    });


    /*
    *打印log信息
    *
    *zsl,* zsl 2009/09/27
    *
    *用于打印log信息
    *
    ** require:Core/Core.js
    *
    */
    /**
    * @constructor
    */
    FUI.widget.Logger = function()
    {
        this.init.apply(this, arguments);
    }
    FUI.widget.Logger.prototype.init = function()
    {
        this.initMarkup();
        this.cache = ['以下是调试信息'];
        this.outputList = document.getElementById('outputList');
        this.container = document.getElementById('sparrow');
    }
    /*
    *   
    */
    FUI.widget.Logger.prototype.initMarkup = function()
    {

        var div = document.createElement('div');
        div.id = "sparrow";
        var template = [
				  '<div class="top">',
				  '<span class="clear" id="sparrow_clear" title="清除"></span><span class="close" id="sparrow_close" title="关闭"></span>',
				  '</div>',
				  '<div class="main">',
				  '<ul id="outputList">',
				  '</ul>',
				  '</div>',
				  '<div class="bottom">',
				  '</div>'
				  ].join('');
        div.innerHTML = template;
        document.body.appendChild(div);
        this.initEvent();
    }
    FUI.widget.Logger.prototype.initEvent = function()
    {
        var ua = navigator.userAgent.toLowerCase();
        var clear = document.getElementById('sparrow_clear');
        var close = document.getElementById('sparrow_close');
        clear.onclick = this.createClearClick(this);
        close.onclick = this.createCloseClick(this);
        //if (/msie/.test(ua)) {
        window.onresize = window.onscroll = this.Fixed(this);
        // }
    }
    /*
    @description    清除打印控制台
    */
    FUI.widget.Logger.prototype.createClearClick = function(me)
    {
        return function()
        {
            me.outputList.innerHTML = '';
        }
    }
    /*
    @description    关闭打印控制台
    */
    FUI.widget.Logger.prototype.createCloseClick = function(me)
    {
        return function()
        {
            document.body.removeChild(me.container);
        }
    }
    /*
    @description 添加log信息
    */
    FUI.widget.Logger.prototype.addMessage = function(message, type)
    {
        var type = type || 'debug';
        var newMsg = document.createElement('LI');
        newMsg.className = type;
        newMsg.innerHTML = ['<span class="icon"></span>', message].join('');
        this.outputList.appendChild(newMsg);
        this.outputList.scrollTop = this.outputList.scrollHeight;
    }
    /*
    用于iex下position:fixed修补
    */
    FUI.widget.Logger.prototype.Fixed = function(me)
    {
        return function()
        {
            var obj = me.container;
            var cheight = 380 || obj.offsetHeight || obj.clientHeight;
            var de = document.documentElement;
            var winHeight = de.innerHeight || (de && de.clientHeight) || document.body.clientHeight;
            var scrollT = self.pageYOffset || (de && de.scrollTop) || document.body.scrollTop;
            obj.style.top = scrollT + winHeight - cheight + 'px';
        }
    }


    if (typeof console === 'undefined' || !console)
    {
        FUI.ns('console');
        var logger = null;
        window.console.log = function(message, type)
        {
            if (!logger)
            {
                logger = new FUI.widget.Logger();
            }
            logger.addMessage(message, type);
        }
    }
    /*
    * tab.js
    * 
    * zsl 2009/11/4
    * 
    * required : core.js,css.js,jQuery-1.3.2
    */







    FUI.widget.SimpleTab = FUI.create({
        init: function(ele, opt)
        {
            this.ele = typeof ele == 'string' ? document.getElementById(ele) : ele;
            this.opt = jQuery.extend(FUI.widget.SimpleTab.defaults, opt);
            this.initEvent();
        },
        initEvent: function()
        {
            var self = this,
            tabcontainer = jQuery(':first-child', this.ele).eq(0),
            timer;

            tabcontainer.bind(self.opt.eventType, function(e)
            {
                if (self.opt.eventType == 'mouseover')
                {
                    if (timer) window.clearTimeout(timer);
                    timer = window.setTimeout(function()
                    {
                        self.mouseHandler(e);
                    }, self.opt.delay);
                } else
                {
                    self.mouseHandler(e);
                }
            });
            this.tabcontainer = tabcontainer;
        },
        mouseHandler: function(event)
        {
            var t = event.target,
            tabc = this.opt.tabClass,
            regEx = new RegExp("(^|\\s)" + tabc + "(\\s|$)"),
            tabcontainer = this.tabcontainer,
            tabbuttons,
            index,
            tp;

            if (this.opt.tabClass)
            {
                tabbuttons = jQuery('.' + this.opt.tabClass, tabcontainer[0]);
            } else
            {
                tabbuttons = jQuery('li', tabcontainer[0]);
            }
            tp = jQuery(this._clonset(t, this.opt.tabTagName || 'li'));
            index = tabbuttons.index(tp);

            if (regEx.test(tp[0].className) || t.tagName.toLowerCase() == "a")
            {
                if (this.opt.tabOutClass)
                {
                    tp.removeClass(this.opt.tabOutClass);
                    tp.siblings().removeClass(this.opt.currentClass).addClass(this.opt.tabOutClass);
                }

                tp.addClass(this.opt.currentClass).siblings().removeClass(this.opt.currentClass);

            }
            this._showTabPanel(index);
        },

        _showTabPanel: function(index)
        {

            var tabpanel;
            if (this.opt.tabPanelClass)
            {
                tabpanels = jQuery('.' + this.opt.tabPanelClass);
            } else if (this.opt.tabPanelContainer)
            {
                tabpanels = jQuery(this.opt.tabPanelContainer).children();
            } else
            {
                tabpanels = jQuery(this.ele).children().slice(1);
            }
            if (this.opt.tabPanelHideClass)
            {
                tabpanels.eq(index).removeClass(this.opt.tabPanelHideClass);
                if (this.opt.tabPanelShowClass)
                {
                    tabpanels.eq(index).addClass(this.opt.tabPanelShowClass);
                }
            } else
            {
                tabpanels.eq(index).css("display", "");
            }
            for (var i = 0, l = tabpanels.length; i < l; i++)
            {
                if (i != index)
                {
                    if (this.opt.tabPanelShowClass)
                    {
                        tabpanels.eq(i).removeClassremoveClass(this.opt.tabPanelShowClass);
                    }
                    if (this.opt.tabPanelHideClass)
                    {
                        tabpanels.eq(i).addClass(this.opt.tabPanelHideClass);
                    } else
                    {
                        tabpanels.eq(i).css("display", "none");
                    }
                }
            }
        },
        _clonset: function(target, tagname)
        {
            do
            {
                target = target.parentNode;
            } while (target && target.tagName && target.tagName.toLowerCase() != tagname);
            return target;
        }
    });

    FUI.widget.SimpleTab.defaults = {
        eventType: "click",
        currentClass: "current",
        tabClass: "",
        tabOutClass: "",
        tabTagName: "",
        tabPanelClass: "", //如果tab得内容没有在tab容器中，需要指定该属性或者tabPanelContainer
        tabPanelContainer: "", //支持所有jQuery的选择器
        tabPanelHideClass: "",
        tabPanelShowClass: "",
        autoSwitchToFirst: true,
        stopEvent: true,
        delay: 100
    };
    /*
    * validation.js
    * 
    * zsl 2009/10/14
    * 
    * required : core.js,jQuery-1.3.2
    */

    FUI.widget.Validation = function(id, options)
    {
        this.init.apply(this, arguments);
    }

    //定义验证控件的默认属性
    FUI.widget.Validation.defaults = {
        hideClass: "none", //隐藏正确提示或者错误提示的Class
        validClass: "confirm_right", //验证通过时提示信息的Class
        errorClass: "", //错误提示信息的class
        tipsClass: ""
        //errorTemplate:'<div class="direction_layer"><img src="/img/uncm/space.gif" class="direction_icon"></div><div class="lost_layer"><img src="/img/uncm/space.gif" class="lost_icon">{message}</div>'//错误提示信息模板
    }
    //定义验证规则
    FUI.widget.Validation.rules = {
        required: {
            errmessage: "该项为必填项",
            test: function(obj)
            {
                /*
                检查checkbox和radio是否被选中
                */
                var _getInputsByName = function(name)
                {
                    var result = [];
                    result.numChecked = 0;
                    var inputs = document.getElementsByTagName("input");
                    for (var i = 0, l = inputs.length; i < l; i++)
                    {
                        if (inputs[i].name == 'name')
                        {
                            result.push(inputs[i]);
                            if (inputs[i].checked)
                                result.numChecked++;
                        }
                    }
                    return result;
                }
                /*
                检查所有的input是否为空
                */
                var checkeRequired = function(ele)
                {
                    if (ele.type == "checkbox" || ele.type == "radio")
                        return _getInputsByName(ele.name).numChecked;
                    else
                        return ele.value.length > 0;
                }
                return checkeRequired(obj);
            }
        },
        //电子邮件格式
        email: {
            errmessage: "对不起，您输入的电子邮件地址有误",
            test: function(obj)
            {
                return !obj.value || /^([\w]+)(\.[\w]+)*@([\w\-]+\.){1,5}([A-Za-z]){2,4}$/i.test(obj.value);
            }
        },

        //日期格式
        date: {
            errmessage: "请输入正确的日期格式",
            test: function(obj)
            {
                return !obj.value || /^[0-9]{4}\-\[0-9]{1,2}\-\[0-9]{1,2}$/.test(obj.value);
            }
        },
        //是否只包含数字
        onlyNumber: {
            errmessage: "只能输入数字",
            test: function(obj)
            {
                return !obj.value || /^[0-9]+$/g.test(obj.value);
            }
        },
        //是否是中国移动手机号码
        cmphonenumer: {
            errmessage: "对不起，只能输入中国移动的手机号码",
            test: function(obj)
            {
                return !obj.value || /^1(3[4-9]|5[012789]|8[78])\d{8}$/.test(obj.value);
            }
        },
        //匹配中文字符
        chinese: {
            errmessage: "只能输入中文",
            test: function(obj)
            {
                return !obj.value || /[u4e00-u9fa5]/gi.test(obj.value);
            }
        }
    }
    FUI.widget.Validation.prototype.init = function(id, options)
    {
        this.vform = document.getElementById(id);
        this.opt = jQuery.extend(false, FUI.widget.Validation.rules, FUI.widget.Validation.defaults, options);
        this.initEvent(this.vform);
    }

    //为form元素和单个字段绑定事件
    FUI.widget.Validation.prototype.initEvent = function(form)
    {
        var self = this,
        eles = form.elements;
        jQuery(form).bind("submit", function()
        {
            return self.validateForm(form);
        })
        for (var i = 0, l = eles.length; i < l; i++)
        {
            jQuery(eles[i]).bind("blur", function()
            {
                return self._validateField(this);
            });
        }
    }
    //验证单个字段的内容
    FUI.widget.Validation.prototype._validateField = function(ele)
    {
        var errors = [];
        //debugger;
        for (var name in this.opt)
        {
            var re = new RegExp("(^|\\s)" + name + "(\\s|$)");
            if (re.test(ele.className) && !this.opt[name].test(ele))
            {
                errors.push(this.opt[name].errmessage);
                break;
            }
        }
        //debugger;
        if (errors.length)
        {
            this.showerrors(ele, errors);
        } else
        {
            this.hideErrors(ele);
        }
        return errors.length == 0;
    }
    //验证表单中所有字段的内容
    FUI.widget.Validation.prototype.validateForm = function(form)
    {
        var valid = true;
        var elements = form.elements;
        for (var i = 0, l = elements.length; i < l; i++)
        {
            this.hideErrors(elements[i]);
            if (!this._validateField(elements[i]))
                valid = false;
        }
        return valid;
    }
    //隐藏错误信息
    FUI.widget.Validation.prototype.hideErrors = function(ele)
    {
        var ep = ele.parentNode;
        var error = jQuery(this.last(ep));

        var right = jQuery(this.prev(error[0]));
        if (error && error.hasClass(this.opt.errorClass)) error.addClass(this.opt.hideClass);
        if (error && error.hasClass(this.opt.tipsClass)) error.addClass(this.opt.hideClass);
        if (right && right.hasClass(this.opt.validClass) && right.hasClass(this.opt.hideClass))
        {
            right.removeClass(this.opt.hideClass);
        }
    }
    //显示错误信息
    FUI.widget.Validation.prototype.showerrors = function(ele, errors)
    {

        var ep = ele.parentNode;
        var error = jQuery(this.last(ep));

        var right = jQuery(this.prev(error[0]));
        var template = this.opt.errorTemplate || "";
        var errorClass = this.opt.errorClass;
        //debugger;
        //如果正确提示已经显示出来，那么应该先删除正确提示信息
        if (right && right.hasClass(this.opt.validClass) && (!right.hasClass(this.opt.hideClass)))
        {
            right.addClass(this.opt.hideClass);
        }
        if (error)
        {
            error.removeClass(this.opt.hideClass);
            if (template) error.html(template.replace(/\{message\}/, errors.join("")));
            if (errorClass) error.addClass(errorClass);
        };
    }
    //某个元素的最后一个子元素
    FUI.widget.Validation.prototype.last = function(ele)
    {
        ele = ele.lastChild;
        return ele && ele.nodeType != 1 ? this.prev(ele) : ele;
    }
    //某个元素的前一个子元素
    FUI.widget.Validation.prototype.prev = function(ele)
    {
        do
        {
            ele = ele.previousSibling;
        } while (ele && ele.nodeType != 1);
        return ele;
    }

    //FUI.widget.PPValidation = FUI.create(FUI.widget.Validation, {

    //    _validateField: function(ele) {
    //        var errors = [];
    //        for (var name in this.opt) {
    //            var re = new RegExp("(^|\\s)" + name + "(\\s|$)");
    //            if (re.test(ele.className) && !this.opt[name].test(ele)) {
    //                errors.push(this.opt[name].errmessage);
    //            } else if (!re.test(ele.className)) {
    //                errors.push("请选择正确的问题");
    //                break;
    //            }
    //        }
    //        if (errors.length) {
    //            this.showerrors(ele, errors);
    //        } else {
    //            this.hideErrors(ele);
    //        }
    //        return errors.length == 0;
    //    }

    //});


    /*
    * constellation.js
    * 
    * zsl 2009/11/19
    * 
    * required : core.js,jQuery-1.3.2
    */

    //星座计算器
    var Constellation = function()
    {
        var calculateConstellation = function(month, day)
        {
            var d = new Date(2009, month - 1, day, 0, 0, 0);
            var arr = [
                        ["魔羯座", new Date(2009, 0, 1, 0, 0, 0)],
                        ["水瓶座", new Date(2009, 0, 20, 0, 0, 0)],
                        ["双鱼座", new Date(2009, 1, 19, 0, 0, 0)],
                        ["牡羊座", new Date(2009, 2, 21, 0, 0, 0)],
                        ["金牛座", new Date(2009, 3, 21, 0, 0, 0)],
                        ["双子座", new Date(2009, 4, 21, 0, 0, 0)],
                        ["巨蟹座", new Date(2009, 5, 22, 0, 0, 0)],
                        ["狮子座", new Date(2009, 6, 23, 0, 0, 0)],
                        ["处女座", new Date(2009, 7, 23, 0, 0, 0)],
                        ["天秤座", new Date(2009, 8, 23, 0, 0, 0)],
                        ["天蝎座", new Date(2009, 9, 23, 0, 0, 0)],
                        ["射手座", new Date(2009, 10, 24, 0, 0, 0)],
                        ["魔羯座", new Date(2009, 11, 22, 0, 0, 0)]
                        ];
            for (var i = arr.length - 1; i >= 0; i--)
            {
                if (d >= arr[i][1]) return arr[i][0];
            }
        }
        return {
            show: function(monthsel, daysel, showMark)
            {
                var ms = document.getElementById(monthsel);
                var ds = document.getElementById(daysel);
                var showspan = document.getElementById(showMark);
                ms.onchange = function()
                {
                    showspan.innerHTML = calculateConstellation(this[this.selectedIndex].value, ds[ds.selectedIndex].value);
                }
                ds.onchange = function()
                {
                    showspan.innerHTML = calculateConstellation(ms[ms.selectedIndex].value, this[this.selectedIndex].value);
                }
            },
            calConstellation: function(month, day)
            {
                return calculateConstellation(month, day);
            }
        }
    } (); /*
参数一：textarea的Id
参数二：需要限制的字数
            
           
*/
    var Ctextarea = function()
    {
        var substr = function(textarea, counter, limit)
        {
            var clength = textarea.val().length;
            if (clength > limit)
            {
                textarea.val(textarea.val().substring(0, limit));
            }
            if (counter)
            {
                if (counter.html() != clength)
                { //跳出循环
                    counter.html(clength);
                }
            }
        }

        return function(opt)
        {
            opt = opt || {};
            var $textarea = jQuery(opt.textarea) || '';
            var $couter = opt.counter && jQuery(opt.counter) || '';
            var limit = opt.limit || 128;
            var timer;
            $textarea.focus(function()
            {
                timer = window.setInterval(function()
                {
                    substr($textarea, $couter, limit);
                }, 100);
            });
            $textarea.blur(function()
            {
                window.clearInterval(timer);
                substr($textarea, $couter, limit);
            });
        }
    } ()/*
*用于浏览图片是缩略图的滚动和相册的滚动
*
*zsl,* zsl 2009/11/19
*

*
** require:Core/Core.js
*
*/

    /*
    <!-- 统一的相册滚动结构代码 -->
    <div class="model_album_roll">
    <!-- 上一个按钮 -->
    <a href="javascript:viod(0)"><img alt="" class="up_btn" src="http://res.fetionpic.com/img/blank/spacer.gif" /></a>
    <a href="javascript:viod(0)"><img alt="" class="upfile_btn" src="http://res.fetionpic.com/img/blank/spacer.gif" /></a>
    <!-- 上一个按钮 end -->
    <div class="roll_content">
    <!-- JS加载的层内容 end -->
    <div class="roll_album_list" id="_fx_album_countainer">
    <ul>
    <li>
    <div class="album_topic_mode">
    <div class="table">
    <div class="td">
    <a href="#" title="">
    <img alt="" src="96x120_1.png" /></a></div>
    <div class="hidden">
    </div>
    </div>
    </div>
    <strong><a href="#" title="">我家小可</a></strong>
    </li>
    </ul>
    </div>
    <!-- JS加载的层内容 end --></div>
    <!-- 下一个按钮 -->
    <a href="javascript:viod(0)"><img alt="" class="downfile_btn" src="http://res.fetionpic.com/img/blank/spacer.gif" /></a>
    <a href="javascript:viod(0)"><img alt="" class="down_btn" src="http://res.fetionpic.com/img/blank/spacer.gif" /></a>
	
<!-- 下一个按钮 end -->	
    </div>
    <!-- 统一的相册滚动结构代码 end -->
    */

    FUI.widget.Slide = FUI.create({
        init: function(e, opt)
        {
            this.opt = jQuery.extend(FUI.widget.Slide.defaults, opt || {});

            this.albumCountainer = jQuery('#' + this.opt.albumCountainerId);
            this.albumCountainer.css({ position: "relative", overflow: "hidden" });


            this.albumList = typeof e == "string" ? document.getElementById(e) : e;
            this.albumList.style.position = "absolute";

            var lis = this.albumList.getElementsByTagName("li");
            var li = lis[0];
            var liNumber = lis.length;
            this.totalNumber = liNumber;
            this.li = li;
            this.liNumber = liNumber;

            this.firstLi = li;
            this.lastLi = lis[lis.length - 1];



            this.wh = this.opt.direction == 1 ? 'height' : 'width';
            this.lt = this.opt.direction == 1 ? 'top' : 'left';

            this.isbind = false;

            this.albumList.style[this.lt] = "0px";

            this.distance = this.calDistance(li, liNumber);

            //用于计算第一个距离左边或者最后一个距离右边的距离
            this.br = this.opt.direction == 1 ? "Bottom" : "Right"; this.$lastLi = jQuery(this.lastLi); this.$firstLi = jQuery(this.firstLi);
            this.tl = this.opt.direction == 1 ? "Top" : "Left"; this.wh = this.opt.direction == 1 ? this.$lastLi.height() : this.$lastLi.width();


            this.containersize = { width: this.albumCountainer.width(), height: this.albumCountainer.height() };




            //是否显示两边的箭头
            this.showPointer(this.opt.displayNumber, this.totalNumber);
        },
        itemsClickHandler: function(me)
        {
            var $me = jQuery(me);
            var foffset = this.firstOffset($me);
            var loffset = this.lastOffset($me);

            if (foffset == 0) { this.next(1, this.pre); }
            if (loffset == 0) { this.prev(-1, this.nex); }
        },
        calDistance: function()
        {
            var distance, li = this.li, liNumber = this.liNumber;

            var sizeObj = this.albumCWidthOrHeight(li);
            if (this.opt.direction == 1)
            {//垂直方向

                this.albumCountainer.css("height", sizeObj.cheight);
                jQuery(this.albumList).css("height", sizeObj.height * liNumber);
                if (this.opt.scrollNumber)
                {
                    distance = this.albumCWidthOrHeight(li).height * this.opt.scrollNumber;
                } else
                {
                    distance = this.albumCWidthOrHeight(li).cheight; //默认滚动显示的数量的
                }
            } else
            {//水平方向

                this.albumCountainer.css("width", sizeObj.cwidth);
                jQuery(this.albumList).css("width", sizeObj.width * liNumber);
                if (this.opt.scrollNumber)
                {
                    distance = sizeObj.width * this.opt.scrollNumber;
                } else
                {
                    distance = sizeObj.cwidth;
                }

            }
            return distance;
        },
        //设置总张数
        setTotalNumber: function(number)
        {
            this.totalNumber = number;
        },
        //设置显示的张数
        setdisplayNumer: function(number)
        {
            this.opt.displayNumber = number;
        },
        //根据水平方向还是垂直方向计算容器的高度或者宽度
        albumCWidthOrHeight: function(li)
        {
            var $li = jQuery(li);
            if (this.opt.displayNumber)
            {

                var height = li.offsetHeight + parseInt($li.css("marginTop")) + parseInt($li.css("marginBottom"));
                var width = li.offsetWidth + parseInt($li.css("marginLeft")) + parseInt($li.css("marginRight"));
                return {
                    cwidth: this.opt.displayNumber * width,
                    cheight: this.opt.displayNumber * height,
                    width: width,
                    height: height
                }
            }
        },
        firstOffset: function(f)
        {

            var firstoffset = f.offset()[this.lt];

            //第一个距离上面或者左边的距离

            var fcoff = firstoffset - this.containeroffset - parseInt(f.css("margin" + this.tl));
            return fcoff;
        },
        lastOffset: function($l)
        {
            //this.$lastLi
            var lastoffset = $l.offset()[this.lt] + this.wh + parseInt($l.css("margin" + this.br));

            //debugger;
            //最后一个距离下面或者右面的距离
            var woh = this.opt.direction == 1 ? this.containersize.height : this.containersize.width;
            var lcoff = lastoffset - (this.containeroffset + woh);
            //debugger;
            return lcoff;
        },
        //显示两边的前头
        showPointer: function(displayNumer, totalNumber)
        {
            var self = this;
            if (this._isShowPointer(displayNumer, totalNumber))
            {
                var pre = document.getElementById(this.opt.buttonPrevId);
                var next = document.getElementById(this.opt.buttonNextId);
                var containerParent = jQuery(this.albumCountainer).parent();
                if (!pre)
                {
                    containerParent.before(this.opt.buttonPrevHTML);
                    pre = document.getElementById(this.opt.buttonPrevId);

                }
                if (!next)
                {
                    containerParent.after(this.opt.buttonNextHTML);
                    next = document.getElementById(this.opt.buttonNextId);
                }
                this.pre = pre;
                this.nex = next;

                this.initEvent();

            }
        },
        initEvent: function()
        {
            var self = this;
            jQuery(this.nex).bind(self.opt.buttonPrevEvent, function() { self.prev(-1, this); });
            this.containeroffset = this.albumCountainer.offset()[this.lt];
            if (this.opt.autoAttachClick)
            {
                var that = this;
                jQuery("li", this.albumList).bind("click", function()
                {
                    that.itemsClickHandler(this);
                    return false;
                });
            }


        },
        //判断是否显示两边的箭头
        _isShowPointer: function(displayNumer, totalNumber)
        {
            if (totalNumber > displayNumer) return true;
            return false;
        },
        //返回参数指定的照片的位置
        //参数i是要滚动到的照片的索引
        pos: function(i, distance, cb)
        {
            if (this.animating) return;
            // if (this.opt.wrap != 'circular')
            //i = i < 1 ? 1 : (this.totalNumber && i > this.totalNumber ? this.totalNumber.size : i);

            var pos = parseInt(jQuery(this.albumList).css(this.lt), 10); //计算当前的位置

            var target = pos + distance * i;

            this.animate(target, true, cb);

            this.animating = false;
        },
        //点击上一个按钮，就是往下移的按钮
        next: function(i, obj)
        {

            var firstOffset = this.firstOffset(this.$firstLi), self = this, distance = this.calDistance();
            //debugger;
            if (firstOffset * -1 <= distance)
            {
                distance = firstOffset * -1;
                obj.className = this.opt.buttonPrevDisabledClass;
                jQuery(obj).unbind(this.opt.buttonPrevEvent);
            } else
            {
                obj.className = this.opt.buttonPrevenabledClass;
            }

            var callback = function()
            {
                firstOffset = self.lastOffset(self.$lastLi);
                //对下一个按钮进行处理,也就是往上移的按钮

                if (firstOffset >= 0 && this.isbind)
                {

                    jQuery(self.nex).bind(self.opt.buttonNextEvent, function() { self.prev(-1, this); });
                    self.nex.className = self.opt.buttonNextenabledClass;
                    this.isbind = false;
                }
                if (firstOffset < 0 && !this.isbind)/*else*/{
                    //debugger;
                    jQuery(self.nex).unbind(self.opt.buttonNextEvent);
                    self.nex.className = self.opt.buttonNextDisabledClass;
                    this.isbind = true;
                }


                self.opt.afterMove(self);
            }
            this.pos(i, distance); callback();
        },
        //点击下一个按钮,就是往上移的按钮
        prev: function(i, obj)
        {
            var lastOffset = this.lastOffset(this.$lastLi), self = this, distance = this.calDistance();

            if (lastOffset <= distance)
            {
                //对上一个按钮进行处理
                distance = lastOffset;
                obj.className = this.opt.buttonNextDisabledClass;
                jQuery(obj).unbind(this.opt.buttonPrevEvent);
            } else
            {
                obj.className = this.opt.buttonNextenabledClass;
            }

            var callback = function()
            {

                lastOffset = self.firstOffset(self.$firstLi);
                //对上一个按钮进行处理，也就是往下移的按钮

                if (lastOffset <= 0 && !this.isbind)
                {


                    jQuery(self.pre).bind(self.opt.buttonNextEvent, function() { self.next(1, this); });
                    self.pre.className = self.opt.buttonPrevenabledClass;
                    this.isbind = true;
                }
                if (lastOffset > 0 && this.isbind)
                /*else*/{
                    //debugger;
                    jQuery(self.pre).unbind(self.opt.buttonPrevEvent);
                    self.pre.className = self.opt.buttonPrevDisabledClass;
                    this.isbind = true;
                }
                self.opt.afterMove(self);
            }
            this.pos(i, distance); callback();
        },
        //是否执行动画到p指定的位置
        animate: function(p, a, cb)
        {
            if (this.animating) return;

            var self = this, $list = jQuery(this.albumList);

            this.animating = true;

            if (!this.opt.animation || a == false)
            {
                $list.css(this.lt, p + 'px');
                this.opt.afterMove();
            } else
            {
                var o = this.opt.direction == 1 ? { 'top': p} : { 'left': p };
                $list.animate(o, this.opt.animation, this.opt.easing, cb);
            }
        }
    });
    FUI.widget.Slide.defaults = {
        displayNumber: 4, /*显示的照片数目*/
        scrollNumber: 4, /*设置每次滚动的距离*/
        albumCountainerId: '_fx_album_countainer', /*照片列表容器的id*/
        direction: 1, /*1为垂直方向，0为水平方向*/
        beforeMove: function() { },
        afterMove: function() { },
        buttonPrevHTML: '<a href="javascript:void(0)"><img id="_fx_pre_pointer" alt="" class="upfile_btn" src="http://res.fetionpic.com/img/blank/spacer.gif" /></a>',
        buttonNextHTML: '<a href="javascript:void(0)"><img id="_fx_next_pointer" alt="" class="down_btn" src="http://res.fetionpic.com/img/blank/spacer.gif" /></a>',
        buttonNextEvent: 'click',
        buttonPrevEvent: 'click',
        buttonPrevDisabledClass: "upfile_btn",
        buttonPrevenabledClass: "up_btn",
        buttonNextDisabledClass: "downfile_btn",
        buttonNextenabledClass: "down_btn",
        buttonPrevId: '_fx_pre_pointer',
        buttonNextId: '_fx_next_pointer',
        animation: 'normal',
        easing: 'swing',
        autoAttachClick: false
    }