﻿;Copyright (C) 2004-2013 John T. Haller of PortableApps.com
;Continuation and adaption of Newer code from other portableapps made by Zach Thibeau (other apps I taken code from are Copyrighted by John
;Website: http://portableapps.com/DVDStylerPortable

;This software is OSI Certified Open Source Software.
;OSI Certified is a certification mark of the Open Source Initiative.

;This program is free software; you can redistribute it and/or
;modify it under the terms of the GNU General Public License
;as published by the Free Software Foundation; either version 2
;of the License, or (at your option) any later version.

;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.

;You should have received a copy of the GNU General Public License
;along with this program; if not, write to the Free Software
;Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

!define PORTABLEAPPNAME "DVDStyler Portable"
!define NAME "DVDStylerPortable"
!define APPNAME "DVDStyler"
!define VER "2.5.2.0"
!define APPVER "2.5.2"
!define WEBSITE "PortableApps.com/DVDStylerPortable"
!define DEFAULTEXE "bin/DVDStyler.exe"
!define DEFAULTAPPDIR "DVDStyler"
!define DEFAULTSETTINGSPATH "settings"

;=== Program Details
Name "${PORTABLEAPPNAME}"
OutFile "..\..\${NAME}.exe"
Caption "${PORTABLEAPPNAME} | PortableApps.com"
VIProductVersion "${VER}"
VIAddVersionKey ProductName "${PORTABLEAPPNAME}"
VIAddVersionKey Comments "Allows ${APPNAME} to be run from a removable drive.  For additional details, visit ${WEBSITE}"
VIAddVersionKey CompanyName "PortableApps.com"
VIAddVersionKey LegalCopyright "John T. Haller"
VIAddVersionKey FileDescription "${PORTABLEAPPNAME}"
VIAddVersionKey FileVersion "${VER}"
VIAddVersionKey ProductVersion "${VER}"
VIAddVersionKey InternalName "${PORTABLEAPPNAME}"
VIAddVersionKey LegalTrademarks "PortableApps.com is a trademark of Rare Ideas, LLC."
VIAddVersionKey OriginalFilename "${NAME}.exe"
;VIAddVersionKey PrivateBuild ""
;VIAddVersionKey SpecialBuild ""

;=== Runtime Switches
CRCCheck On
WindowIcon Off
SilentInstall Silent
AutoCloseWindow True
RequestExecutionLevel user
XPStyle On

;=== Include
!include FileFunc.nsh
!insertmacro GetParameters
!insertmacro GetRoot

!include "Registry.nsh"
!include "ReplaceInFile.nsh"
!include "StrRep.nsh"
!include "MUI.nsh"
!include CheckForPlatformSplashDisable.nsh


;=== Program Icon
Icon "..\..\App\AppInfo\appicon.ico"
;Comment: Below I added this section to update DVDStylerPortable to use the latest style
;=== Icon & Stye ===
!define MUI_ICON "..\..\App\AppInfo\appicon.ico"

;=== Languages
!insertmacro MUI_LANGUAGE "English"

LangString LauncherFileNotFound ${LANG_ENGLISH} "${PORTABLEAPPNAME} cannot be started. You may wish to re-install to fix this issue. (ERROR: $MISSINGFILEORPATH could not be found)"
LangString LauncherAlreadyRunning ${LANG_ENGLISH} "Another instance of ${APPNAME} is already running. Please close other instances of ${APPNAME} before launching ${PORTABLEAPPNAME}."
LangString LauncherAskCopyLocal ${LANG_ENGLISH} "${PORTABLEAPPNAME} appears to be running from a location that is read-only. Would you like to temporarily copy it to the local hard drive and run it from there?$\n$\nPrivacy Note: If you say Yes, your personal data within ${PORTABLEAPPNAME} will be temporarily copied to a local drive. Although this copy of your data will be deleted when you close ${PORTABLEAPPNAME}, it may be possible for someone else to access your data later."
LangString LauncherNoReadOnly ${LANG_ENGLISH} "${PORTABLEAPPNAME} can not run directly from a read-only location and will now close."

Var PROGRAMDIRECTORY
Var SETTINGSDIRECTORY
Var ADDITIONALPARAMETERS
Var EXECSTRING
Var PROGRAMEXECUTABLE
Var SECONDARYLAUNCH
Var DISABLESPLASHSCREEN
Var FAILEDTORESTOREKEY
Var DRIVEROOT
Var LASTDRIVEROOT
Var MISSINGFILEORPATH
;Var EXISTSTHUMB
;Var USERPROFILE


Section "Main"
	;=== Check if already running
	System::Call 'kernel32::CreateMutex(i 0, i 0, t "${NAME}") i .r1 ?e'
	Pop $0
	StrCmp $0 0 CheckINI
		StrCpy $SECONDARYLAUNCH "true"

	CheckINI:
		ReadINIStr $ADDITIONALPARAMETERS "$EXEDIR\${NAME}.ini" "${NAME}" "AdditionalParameters"
		ReadINIStr $DISABLESPLASHSCREEN "$EXEDIR\${NAME}.ini" "${NAME}" "DisableSplashScreen"

	;CleanUpAnyErrors:
		;=== Any missing unrequired INI entries will be an empty string, ignore associated errors
		ClearErrors

		;=== Correct PROGRAMEXECUTABLE if blank
		StrCpy "$PROGRAMEXECUTABLE" "${DEFAULTEXE}"

		IfFileExists "$EXEDIR\App\${DEFAULTAPPDIR}\${DEFAULTEXE}" "" NoProgramEXE
			StrCpy "$PROGRAMDIRECTORY" "$EXEDIR\App\${DEFAULTAPPDIR}"
			StrCpy "$SETTINGSDIRECTORY" "$EXEDIR\Data\${DEFAULTSETTINGSPATH}"
			GoTo EndINI

	EndINI:
		IfFileExists "$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" FoundProgramEXE

	NoProgramEXE:
		;=== Program executable not where expected
		StrCpy $MISSINGFILEORPATH $PROGRAMEXECUTABLE
		MessageBox MB_OK|MB_ICONEXCLAMATION `$(LauncherFileNotFound)`
		Abort
		
	FoundProgramEXE:
		;=== Check if running
		StrCmp $SECONDARYLAUNCH "true" GetPassedParameters
		FindProcDLL::FindProc "${DEFAULTEXE}"
		StrCmp $R0 "1" WarnAnotherInstance DisplaySplash

	WarnAnotherInstance:
		MessageBox MB_OK|MB_ICONINFORMATION `$(LauncherAlreadyRunning)`
		Abort
	
	DisplaySplash:
		${CheckForPlatformSplashDisable} $DISABLESPLASHSCREEN
		StrCmp $DISABLESPLASHSCREEN "true" GetPassedParameters
			;=== Show the splash screen while processing registry entries
			InitPluginsDir
			File /oname=$PLUGINSDIR\splash.jpg "${NAME}.jpg"
			newadvsplash::show /NOUNLOAD 1200 0 0 -1 /L $PLUGINSDIR\splash.jpg
	
	GetPassedParameters:
		;=== Get any passed parameters
		${GetParameters} $0
		StrCmp "'$0'" "''" "" LaunchProgramParameters

		;=== No parameters
		StrCpy $EXECSTRING `"$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE"`
		Goto AdditionalParameters

	LaunchProgramParameters:
		StrCpy $EXECSTRING `"$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" $0`

	AdditionalParameters:
		StrCmp $ADDITIONALPARAMETERS "" SettingsDirectory

		;=== Additional Parameters
		StrCpy $EXECSTRING `$EXECSTRING $ADDITIONALPARAMETERS`
	
	SettingsDirectory:
		;=== Set the settings directory if we have a path
		IfFileExists "$SETTINGSDIRECTORY\*.*" RegistryBackup
			CreateDirectory $SETTINGSDIRECTORY
	
	RegistryBackup:
		StrCmp $SECONDARYLAUNCH "true" LaunchAndExit
		;=== Backup the registry
		${registry::KeyExists} "HKEY_CURRENT_USER\Software\DVDStyler-BackupByDVDStylerPortable" $R0
		StrCmp $R0 "0" RestoreSettings
		${registry::MoveKey} "HKEY_CURRENT_USER\Software\DVDStyler" "HKEY_CURRENT_USER\Software\DVDStyler-BackupByDVDStylerPortable" $R0
		Sleep 100

	RestoreSettings:
		IfFileExists "$SETTINGSDIRECTORY\DVDStyler.reg" "" DefaultSettings
		
		${GetRoot} $EXEDIR $DRIVEROOT
		ReadINIStr $LASTDRIVEROOT "$SETTINGSDIRECTORY\DVDStylerPortableSettings.ini" "DVDStylerPortableSettings" "LastDrive"
		StrCmp $LASTDRIVEROOT "" RestoreTheKey
		StrCmp $LASTDRIVEROOT $DRIVEROOT RestoreTheKey
		${ReplaceInFile} "$SETTINGSDIRECTORY\DVDStyler.reg" "$LASTDRIVEROOT\\" "$DRIVEROOT\\"
		Delete "$SETTINGSDIRECTORY\DVDStyler.reg.old"
			
	RestoreTheKey:
		IfFileExists "$WINDIR\system32\reg.exe" "" RestoreTheKey9x
			nsExec::ExecToStack `"$WINDIR\system32\reg.exe" import "$SETTINGSDIRECTORY\DVDStyler.reg"`
			Pop $R0
			StrCmp $R0 '0' LaunchNow ;successfully restored key
	RestoreTheKey9x:
		${registry::RestoreKey} "$SETTINGSDIRECTORY\DVDStyler.reg" $R0
		StrCmp $R0 '0' LaunchNow ;successfully restored key
		StrCpy $FAILEDTORESTOREKEY "true"

	DefaultSettings:
		${GetRoot} $EXEDIR $DRIVEROOT
		IfFileExists "$DRIVEROOT\Documents\*.*" "" DefaultSettingsRoot
			${registry::Write} "HKEY_CURRENT_USER\Software\DVDStyler\Interface" "FileBrowserDir" "$DRIVEROOT\Documents" "REG_SZ" $0
			Goto LaunchNow
		
	DefaultSettingsRoot:
		${registry::Write} "HKEY_CURRENT_USER\Software\DVDStyler\Interface" "FileBrowserDir" "$DRIVEROOT\" "REG_SZ" $0
		${registry::Write} "HKEY_CURRENT_USER\Software\DVDStyler" "Version" "${APPVER}" "REG_SZ" $0
	
	LaunchNow:
		WriteINIStr "$SETTINGSDIRECTORY\DVDStylerPortableSettings.ini" "DVDStylerPortableSettings" "LastDrive" "$DRIVEROOT"
		ExecWait $EXECSTRING
		
	CheckRunning:
		Sleep 1000
		FindProcDLL::FindProc "${DEFAULTEXE}"                  
		StrCmp $R0 "1" CheckRunning
		
		StrCmp $FAILEDTORESTOREKEY "true" SetOriginalKeyBack
		${registry::SaveKey} "HKEY_CURRENT_USER\Software\DVDStyler" "$SETTINGSDIRECTORY\DVDStyler.reg" "" $0
		Sleep 100
	
	SetOriginalKeyBack:
		${registry::DeleteKey} "HKEY_CURRENT_USER\Software\DVDStyler" $R0
		Sleep 100
		${registry::MoveKey} "HKEY_CURRENT_USER\Software\DVDStyler-BackupByDVDStylerPortable" "HKEY_CURRENT_USER\Software\DVDStyler" $R0
		Goto TheEnd
		
	LaunchAndExit:
		SetOutPath "$EXEDIR\Data"
		Exec $EXECSTRING
		
	TheEnd:
	RMDir /r "$PROFILE\.thumb\"
		${registry::Unload}
		newadvsplash::stop /WAIT
SectionEnd