/*
 * Decompiled with CFR 0.152.
 */
package org.homebrew;

import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import org.homebrew.XmlElement;

public class XmlParser {
    private static final int[] cdata_start = new int[]{60, 33, 91, 67, 68, 65, 84, 65, 91};
    private static final int[] cdata_end = new int[]{93, 93, 62};
    private Reader reader;
    private Stack elements = new Stack();
    private XmlElement currentElement = null;

    public XmlElement parse(Reader reader) throws IOException {
        XmlElement xmlElement;
        this.reader = reader;
        this.skipPrologs();
        while (true) {
            String string;
            String string2;
            if ((string2 = this.readTag().trim()).startsWith("</")) {
                string = string2.substring(2, string2.length() - 1);
                if (this.currentElement == null) {
                    throw new IOException("Got close tag '" + string + "' without open tag.");
                }
                if (!string.equals(this.currentElement.getTagName())) {
                    throw new IOException("Expected close tag for '" + this.currentElement.getTagName() + "' but got '" + string + "'.");
                }
                if (this.elements.empty()) {
                    return this.currentElement;
                }
                this.currentElement = (XmlElement)this.elements.pop();
                continue;
            }
            int n = string2.indexOf(" ");
            if (n < 0) {
                if (string2.endsWith("/>")) {
                    string = string2.substring(1, string2.length() - 2);
                    string2 = "/>";
                } else {
                    string = string2.substring(1, string2.length() - 1);
                    string2 = "";
                }
            } else {
                string = string2.substring(1, n);
                string2 = string2.substring(n + 1);
            }
            xmlElement = new XmlElement(string);
            boolean bl = false;
            while (string2.length() > 0) {
                if ((string2 = string2.trim()).equals("/>")) {
                    bl = true;
                    break;
                }
                if (string2.equals(">")) break;
                n = string2.indexOf("=");
                if (n < 0) {
                    throw new IOException("Invalid attribute for tag '" + string + "'.");
                }
                String string3 = string2.substring(0, n);
                string2 = string2.substring(n + 1);
                boolean bl2 = true;
                if (string2.startsWith("\"")) {
                    n = string2.indexOf(34, 1);
                } else if (string2.startsWith("'")) {
                    n = string2.indexOf(39, 1);
                } else {
                    bl2 = false;
                    n = string2.indexOf(32);
                    if (n < 0 && (n = string2.indexOf(62)) < 0) {
                        n = string2.indexOf(47);
                    }
                }
                if (n < 0) {
                    throw new IOException("Invalid attribute for tag '" + string + "'.");
                }
                String string4 = bl2 ? string2.substring(1, n) : string2.substring(0, n);
                xmlElement.setAttribute(string3, string4);
                string2 = string2.substring(n + 1);
            }
            if (!bl) {
                xmlElement.setText(this.readText());
            }
            if (this.currentElement != null) {
                this.currentElement.addChildElement(xmlElement);
            }
            if (!bl) {
                if (this.currentElement != null) {
                    this.elements.push(this.currentElement);
                }
                this.currentElement = xmlElement;
                continue;
            }
            if (this.currentElement == null) break;
        }
        return xmlElement;
    }

    private int peek() throws IOException {
        this.reader.mark(1);
        int n = this.reader.read();
        this.reader.reset();
        return n;
    }

    private void peek(int[] nArray) throws IOException {
        this.reader.mark(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.reader.read();
        }
        this.reader.reset();
    }

    private void skipWhitespace() throws IOException {
        while (Character.isWhitespace((char)this.peek())) {
            this.reader.read();
        }
    }

    private void skipProlog() throws IOException {
        this.reader.skip(2L);
        while (true) {
            int n;
            if ((n = this.peek()) == 62) break;
            if (n == 60) {
                this.skipProlog();
                continue;
            }
            this.reader.read();
        }
        this.reader.read();
    }

    private void skipPrologs() throws IOException {
        while (true) {
            this.skipWhitespace();
            int[] nArray = new int[2];
            this.peek(nArray);
            if (nArray[0] != 60) {
                throw new IOException("Expected '<' but got '" + (char)nArray[0] + "'.");
            }
            if (nArray[1] != 63 && nArray[1] != 33) break;
            this.skipProlog();
        }
    }

    private String readTag() throws IOException {
        this.skipWhitespace();
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.peek();
        if (n != 60) {
            throw new IOException("Expected < but got " + (char)n);
        }
        stringBuffer.append((char)this.reader.read());
        while (this.peek() != 62) {
            stringBuffer.append((char)this.reader.read());
        }
        stringBuffer.append((char)this.reader.read());
        return stringBuffer.toString();
    }

    private String readText() throws IOException {
        StringBuffer stringBuffer;
        block4: {
            stringBuffer = new StringBuffer();
            int[] nArray = new int[cdata_start.length];
            this.peek(nArray);
            if (this.compareIntArrays(nArray, cdata_start)) {
                this.reader.skip(nArray.length);
                int[] nArray2 = new int[cdata_end.length];
                while (true) {
                    this.peek(nArray2);
                    if (this.compareIntArrays(nArray2, cdata_end)) {
                        this.reader.skip(nArray2.length);
                        break block4;
                    }
                    stringBuffer.append((char)this.reader.read());
                }
            }
            while (this.peek() != 60) {
                stringBuffer.append((char)this.reader.read());
            }
        }
        return stringBuffer.toString();
    }

    private boolean compareIntArrays(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }
}

