/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.config.OSType;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.security.CPCallbackClassLoaderIf;
import com.sun.deploy.security.CPCallbackHandler;
import com.sun.deploy.security.DeployURLClassPath;
import com.sun.deploy.security.SecureCookiePermission;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.FXLoader;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.progress.Progress;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.util.JNLPUtils;
import com.sun.javaws.util.JfxHelper;
import com.sun.jnlp.BasicServiceImpl;
import com.sun.jnlp.ClipboardServiceImpl;
import com.sun.jnlp.DownloadService2Impl;
import com.sun.jnlp.DownloadServiceImpl;
import com.sun.jnlp.ExtendedServiceImpl;
import com.sun.jnlp.ExtensionInstallerServiceImpl;
import com.sun.jnlp.FileOpenServiceImpl;
import com.sun.jnlp.FileSaveServiceImpl;
import com.sun.jnlp.IntegrationServiceImpl;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.JNLPPreverifyClassLoader;
import com.sun.jnlp.PersistenceServiceImpl;
import com.sun.jnlp.PrintServiceImpl;
import com.sun.jnlp.SingleInstanceServiceImpl;
import java.awt.AWTPermission;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import javax.jnlp.BasicService;
import javax.jnlp.ClipboardService;
import javax.jnlp.DownloadService;
import javax.jnlp.DownloadService2;
import javax.jnlp.ExtendedService;
import javax.jnlp.ExtensionInstallerService;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.IntegrationService;
import javax.jnlp.PersistenceService;
import javax.jnlp.PrintService;
import javax.jnlp.SingleInstanceService;
import sun.misc.SharedSecrets;
import sun.misc.URLClassPath;

public final class JNLPClassLoader
extends URLClassLoader
implements JNLPClassLoaderIf,
CPCallbackClassLoaderIf {
    private static JNLPClassLoader _instance = null;
    private static JNLPPreverifyClassLoader _preverifyCL = null;
    private LaunchDesc _launchDesc = null;
    private AppPolicy _appPolicy;
    private AccessControlContext _acc = null;
    private boolean _initialized = false;
    private Map _jarsInURLClassLoader = new HashMap();
    private ArrayList _jarsNotInURLClassLoader = new ArrayList();
    private static Field ucpField = JNLPClassLoader.getUCPField("ucp");
    private List addedURLs = new ArrayList();
    private JNLPClassLoader _jclParent;
    static /* synthetic */ Class class$java$net$URLClassLoader;

    private JNLPClassLoader(ClassLoader classLoader) {
        super(new URL[0], classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        if (classLoader instanceof JNLPClassLoader) {
            this._jclParent = (JNLPClassLoader)classLoader;
        }
        JNLPClassLoader.setUCP(this, (URLClassPath)new DeployURLClassPath(new URL[0]));
    }

    private void initialize(LaunchDesc launchDesc, AppPolicy appPolicy) {
        this._launchDesc = launchDesc;
        this._acc = AccessController.getContext();
        this._appPolicy = appPolicy;
        this._initialized = true;
        if (this._jclParent != null) {
            this._jclParent.initialize(launchDesc, appPolicy);
            this.drainPendingURLs();
            return;
        }
        if (_preverifyCL != null) {
            _preverifyCL.initialize(launchDesc, appPolicy);
        }
        if (launchDesc.needFX()) {
            try {
                FXLoader.loadFX((JfxRuntime)JfxHelper.getBestJfxInstalled(launchDesc));
            }
            catch (ClassNotFoundException classNotFoundException) {
                Trace.ignored((Throwable)classNotFoundException);
            }
            catch (IllegalStateException illegalStateException) {
                Trace.ignored((Throwable)illegalStateException);
            }
        }
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        ArrayList arrayList = new ArrayList();
        if (resourcesDesc != null) {
            JNLPUtils.sortResourcesForClasspath(resourcesDesc, arrayList, this._jarsNotInURLClassLoader);
            for (int i = 0; i < arrayList.size(); ++i) {
                JARDesc jARDesc = (JARDesc)arrayList.get(i);
                this._jarsInURLClassLoader.put(URLUtil.toNormalizedString((URL)jARDesc.getLocation()), jARDesc);
                if (_preverifyCL != null && _preverifyCL.contains(jARDesc.getLocation())) continue;
                this.addURL2(jARDesc.getLocation());
            }
        }
    }

    public JNLPPreverifyClassLoader getJNLPPreverifyClassLoader() {
        return _preverifyCL;
    }

    public Preloader getPreloader() {
        return Progress.get(null);
    }

    public static JNLPClassLoader createClassLoader() {
        if (_instance == null) {
            JNLPClassLoader jNLPClassLoader;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            _preverifyCL = new JNLPPreverifyClassLoader(classLoader);
            JNLPClassLoader jNLPClassLoader2 = new JNLPClassLoader(_preverifyCL);
            _instance = Config.getMixcodeValue() != 3 ? (!JNLPClassLoader.setDeployURLClassPathCallbacks(jNLPClassLoader2, jNLPClassLoader = new JNLPClassLoader(jNLPClassLoader2)) ? jNLPClassLoader2 : jNLPClassLoader) : jNLPClassLoader2;
        }
        return _instance;
    }

    public static JNLPClassLoader createClassLoader(LaunchDesc launchDesc, AppPolicy appPolicy) {
        JNLPClassLoader jNLPClassLoader = JNLPClassLoader.createClassLoader();
        if (!jNLPClassLoader._initialized) {
            jNLPClassLoader.initialize(launchDesc, appPolicy);
        }
        return jNLPClassLoader;
    }

    public static JNLPClassLoaderIf getInstance() {
        return _instance;
    }

    public LaunchDesc getLaunchDesc() {
        return this._launchDesc;
    }

    public JARDesc getJarDescFromURL(URL uRL) {
        if (this._jclParent != null) {
            return this._jclParent.getJarDescFromURL(uRL);
        }
        String string = URLUtil.toNormalizedString((URL)uRL);
        JARDesc jARDesc = (JARDesc)this._jarsInURLClassLoader.get(string);
        if (jARDesc != null) {
            return jARDesc;
        }
        HashMap<String, JARDesc> hashMap = new HashMap<String, JARDesc>();
        Iterator iterator = this._jarsInURLClassLoader.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            jARDesc = (JARDesc)this._jarsInURLClassLoader.get(string2);
            String string3 = URLUtil.toNormalizedString((URL)DownloadEngine.getKnownRedirectFinalURL((URL)jARDesc.getLocation()));
            if (this._jarsInURLClassLoader.containsKey(string3)) continue;
            hashMap.put(string3, jARDesc);
            if (!string.equals(string3)) continue;
            this._jarsInURLClassLoader.putAll(hashMap);
            return jARDesc;
        }
        this._jarsInURLClassLoader.putAll(hashMap);
        return null;
    }

    public int getDefaultSecurityModel() {
        return this._launchDesc.getSecurityModel();
    }

    public URL getResource(final String string) {
        URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() throws SecurityException {
                URL uRL = null;
                for (int i = 0; uRL == null && i < 3; ++i) {
                    uRL = JNLPClassLoader.super.getResource(string);
                }
                return uRL;
            }
        });
        return uRL;
    }

    private String findLibrary0(String string) {
        ResourcesDesc resourcesDesc = this._launchDesc.getResources();
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        for (int i = 0; i < jARDescArray.length; ++i) {
            if (!jARDescArray[i].isNativeLib()) continue;
            try {
                String string2 = ResourceProvider.get().getLibraryDirForJar(string, jARDescArray[i].getLocation(), jARDescArray[i].getVersion());
                if (string2 == null) continue;
                return new File(string2, string).getAbsolutePath();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        return null;
    }

    protected String findLibrary(String string) {
        if (this._jclParent != null) {
            return this._jclParent.findLibrary(string);
        }
        if (!this._initialized) {
            return super.findLibrary(string);
        }
        String string2 = System.mapLibraryName(string);
        Trace.println((String)("JNLPClassLoader: Finding library " + string2));
        String string3 = this.findLibrary0(string2);
        if (string3 != null) {
            return string3;
        }
        if (OSType.isMac() && (string3 = this.findLibrary0(string2 = "lib" + string + ".jnilib")) != null) {
            return string3;
        }
        Trace.println((String)("JNLPClassLoader: Native library " + string + " not found"), (TraceLevel)TraceLevel.NETWORK);
        return super.findLibrary(string);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        if (!this._initialized) {
            return super.findClass(string);
        }
        try {
            return super.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (!(classNotFoundException.getCause() instanceof JARSigningException) && this.checkPackageParts(string)) {
                return super.findClass(string);
            }
            throw classNotFoundException;
        }
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        try {
            sun.misc.Resource resource = this.getResourceAsResource(string);
            if (resource != null) {
                inputStream = resource.getInputStream();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (inputStream == null) {
            inputStream = super.getResourceAsStream(string);
        }
        return inputStream;
    }

    protected sun.misc.Resource getResourceAsResource(String string) throws MalformedURLException, FileNotFoundException {
        URLClassPath uRLClassPath;
        sun.misc.Resource resource;
        if (this._jclParent != null) {
            try {
                return this._jclParent.getResourceAsResource(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if ((resource = (uRLClassPath = SharedSecrets.getJavaNetAccess().getURLClassPath((URLClassLoader)this)).getResource(string, false)) != null) {
            return resource;
        }
        throw new FileNotFoundException("Resource " + string + " not found");
    }

    public void quiescenceRequested(Thread thread, boolean bl) {
    }

    public void quiescenceCancelled(boolean bl) {
    }

    public URL findResource(String string) {
        URL uRL = super.findResource(string);
        if (!this._initialized) {
            return uRL;
        }
        if (uRL == null && this.checkPackageParts(string)) {
            uRL = super.findResource(string);
        }
        return uRL;
    }

    private boolean checkPackageParts(String string) {
        if (this._jclParent != null) {
            return this.drainPendingURLs();
        }
        boolean bl = false;
        ResourcesDesc.PackageInformation packageInformation = this._launchDesc.getResources().getPackageInformation(string);
        if (packageInformation != null) {
            JARDesc[] jARDescArray = packageInformation.getLaunchDesc().getResources().getPart(packageInformation.getPart());
            for (int i = 0; i < jARDescArray.length; ++i) {
                if (!this._jarsNotInURLClassLoader.contains(jARDescArray[i])) continue;
                this._jarsNotInURLClassLoader.remove(jARDescArray[i]);
                this.addLoadedJarsEntry(jARDescArray[i]);
                this.addURL2(jARDescArray[i].getLocation());
                bl = true;
            }
        }
        return bl;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Resource resource;
        Serializable serializable;
        Permissions permissions = null;
        String string = this.getLaunchDesc().getCodebase().getHost();
        if (string != null && string.length() > 0) {
            if (!string.equals(codeSource.getLocation().getHost()) && DownloadEngine.isKnownRedirectedHost((String)string, (String)codeSource.getLocation().getHost())) {
                serializable = new SocketPermission(codeSource.getLocation().getHost(), "connect,accept");
                permissions = new Permissions();
                ((PermissionCollection)permissions).add((Permission)serializable);
            } else {
                serializable = new SocketPermission(string, "connect,accept");
                permissions = new Permissions();
                ((PermissionCollection)permissions).add((Permission)serializable);
            }
            Trace.println((String)("Grant socket perm for " + codeSource.getLocation() + " : " + permissions), (TraceLevel)TraceLevel.SECURITY);
        }
        serializable = permissions == null ? new Permissions() : permissions;
        URL uRL = codeSource.getLocation();
        JARDesc jARDesc = this.getJarDescFromURL(uRL);
        ToolkitStore.get().getAppContext().put((Object)("deploy-" + uRL.toString()), (Object)jARDesc.getVersion());
        try {
            this._appPolicy.addPermissions(JNLPClassLoader.getInstance(), (PermissionCollection)serializable, codeSource, true);
        }
        catch (ExitException exitException) {
            throw new RuntimeException(exitException);
        }
        if (jARDesc != null && (resource = ResourceProvider.get().getCachedResource(jARDesc.getLocation(), jARDesc.getVersion())) != null && resource.getDataFile() != null) {
            String string2 = resource.getDataFile().getPath();
            ((PermissionCollection)serializable).add(new FilePermission(string2, "read"));
        }
        if (!((PermissionCollection)serializable).implies(new AWTPermission("accessClipboard"))) {
            ToolkitStore.get().getAppContext().put((Object)"UNTRUSTED_URLClassLoader", (Object)Boolean.TRUE);
        }
        ((PermissionCollection)serializable).add((Permission)new SecureCookiePermission(SecureCookiePermission.getURLOriginString((URL)codeSource.getLocation())));
        return serializable;
    }

    public JarFile getJarFile(URL uRL) throws IOException {
        final JARDesc jARDesc = this.getJarDescFromURL(uRL);
        if (jARDesc == null) {
            return null;
        }
        final int n = LaunchDownload.getDownloadType(jARDesc);
        try {
            return (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    int n2 = ResourceProvider.get().incrementInternalUse();
                    try {
                        JarFile jarFile = ResourceProvider.get().getCachedJarFile(jARDesc.getLocation(), jARDesc.getVersion());
                        if (jarFile != null) {
                            JarFile jarFile2 = jarFile;
                            return jarFile2;
                        }
                        JarFile jarFile3 = ResourceProvider.get().getJarFile(jARDesc.getLocation(), jARDesc.getVersion(), n);
                        return jarFile3;
                    }
                    finally {
                        ResourceProvider.get().decrementInternalUse(n2);
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void addLoadedJarsEntry(JARDesc jARDesc) {
        String string = jARDesc.getLocationString();
        if (!this._jarsInURLClassLoader.containsKey(string)) {
            this._jarsInURLClassLoader.put(string, jARDesc);
        }
    }

    public void addResource(URL uRL, String string, String string2) {
        if (this._jclParent != null) {
            this._jclParent.addResource(uRL, string, string2);
            this.drainPendingURLs();
            return;
        }
        JARDesc jARDesc = new JARDesc(uRL, string, true, false, false, null, 0, null);
        String string3 = jARDesc.getLocationString();
        if (!this._jarsInURLClassLoader.containsKey(string3)) {
            this._launchDesc.getResources().addResource(jARDesc);
            this.addLoadedJarsEntry(jARDesc);
            this.addURL2(uRL);
        }
    }

    static boolean setDeployURLClassPathCallbacks(JNLPClassLoader jNLPClassLoader, JNLPClassLoader jNLPClassLoader2) {
        try {
            if (!ResourceProvider.get().hasEnhancedJarAccess()) {
                Trace.println((String)"setDeployURLClassPathCallbacks: no enhanced access", (TraceLevel)TraceLevel.BASIC);
                return false;
            }
            CPCallbackHandler cPCallbackHandler = new CPCallbackHandler((CPCallbackClassLoaderIf)jNLPClassLoader, (CPCallbackClassLoaderIf)jNLPClassLoader2);
            JNLPClassLoader.getDUCP(jNLPClassLoader).setDeployURLClassPathCallback(cPCallbackHandler.getParentCallback());
            JNLPClassLoader.getDUCP(jNLPClassLoader2).setDeployURLClassPathCallback(cPCallbackHandler.getChildCallback());
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception, (boolean)true);
            return false;
        }
        catch (Error error) {
            Trace.ignored((Throwable)error, (boolean)true);
            return false;
        }
        return true;
    }

    private static DeployURLClassPath getDUCP(JNLPClassLoader jNLPClassLoader) {
        return (DeployURLClassPath)JNLPClassLoader.getUCP(jNLPClassLoader);
    }

    private static URLClassPath getUCP(JNLPClassLoader jNLPClassLoader) {
        URLClassPath uRLClassPath = null;
        try {
            uRLClassPath = (URLClassPath)ucpField.get(jNLPClassLoader);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uRLClassPath;
    }

    private static void setUCP(JNLPClassLoader jNLPClassLoader, URLClassPath uRLClassPath) {
        try {
            ucpField.set(jNLPClassLoader, uRLClassPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Field getUCPField(final String string) {
        return (Field)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Field field = (class$java$net$URLClassLoader == null ? (class$java$net$URLClassLoader = JNLPClassLoader.class$("java.net.URLClassLoader")) : class$java$net$URLClassLoader).getDeclaredField(string);
                    field.setAccessible(true);
                    return field;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    protected void addURL(URL uRL) {
        if (this._jclParent != null) {
            this._jclParent.addURL(uRL);
        }
        super.addURL(uRL);
    }

    void addURL2(URL uRL) {
        if (this._jclParent != null) {
            this.drainPendingURLs();
        } else {
            this.putAddedURL(uRL);
        }
        super.addURL(uRL);
    }

    boolean drainPendingURLs() {
        int n;
        List list = this._jclParent.grabAddedURLs();
        for (n = 0; n < list.size(); ++n) {
            super.addURL((URL)list.get(n));
        }
        return n != 0;
    }

    synchronized List grabAddedURLs() {
        List list = this.addedURLs;
        this.addedURLs = new ArrayList();
        return list;
    }

    synchronized void putAddedURL(URL uRL) {
        this.addedURLs.add(uRL);
    }

    public CodeSource[] getTrustedCodeSources(CodeSource[] codeSourceArray) {
        ArrayList<CodeSource> arrayList = new ArrayList<CodeSource>();
        Policy policy = (Policy)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Policy.getPolicy();
            }
        });
        for (int i = 0; i < codeSourceArray.length; ++i) {
            CodeSource codeSource = codeSourceArray[i];
            boolean bl = false;
            PermissionCollection permissionCollection = policy.getPermissions(codeSource);
            try {
                bl = this._appPolicy.addPermissions(JNLPClassLoader.getInstance(), permissionCollection, codeSource, true);
            }
            catch (ExitException exitException) {
                throw new RuntimeException(exitException);
            }
            if (!bl) {
                bl = permissionCollection.implies(new AllPermission());
            }
            if (!bl) {
                bl = this.isTrustedByPolicy(policy, codeSource);
            }
            if (!bl) continue;
            arrayList.add(codeSource);
        }
        return arrayList.toArray(new CodeSource[arrayList.size()]);
    }

    private boolean isTrustedByPolicy(Policy policy, CodeSource codeSource) {
        PermissionCollection permissionCollection = policy.getPermissions(codeSource);
        PermissionCollection permissionCollection2 = policy.getPermissions(new CodeSource(null, (Certificate[])null));
        Enumeration<Permission> enumeration = permissionCollection.elements();
        while (enumeration.hasMoreElements()) {
            Permission permission = enumeration.nextElement();
            if (permissionCollection2.implies(permission)) continue;
            return true;
        }
        return false;
    }

    public BasicService getBasicService() {
        return BasicServiceImpl.getInstance();
    }

    public FileOpenService getFileOpenService() {
        return FileOpenServiceImpl.getInstance();
    }

    public FileSaveService getFileSaveService() {
        return FileSaveServiceImpl.getInstance();
    }

    public ExtensionInstallerService getExtensionInstallerService() {
        return ExtensionInstallerServiceImpl.getInstance();
    }

    public DownloadService getDownloadService() {
        return DownloadServiceImpl.getInstance();
    }

    public ClipboardService getClipboardService() {
        return ClipboardServiceImpl.getInstance();
    }

    public PrintService getPrintService() {
        return PrintServiceImpl.getInstance();
    }

    public PersistenceService getPersistenceService() {
        return PersistenceServiceImpl.getInstance();
    }

    public ExtendedService getExtendedService() {
        return ExtendedServiceImpl.getInstance();
    }

    public SingleInstanceService getSingleInstanceService() {
        return SingleInstanceServiceImpl.getInstance();
    }

    public IntegrationService getIntegrationService() {
        return new IntegrationServiceImpl(this);
    }

    public DownloadService2 getDownloadService2() {
        return DownloadService2Impl.getInstance();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

