/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.NoSuchEventException;
import com.oracle.jrockit.jfr.management.FlightRecorderMBean;
import com.oracle.jrockit.jfr.management.FlightRecordingMBean;
import com.oracle.jrockit.jfr.management.NoSuchRecordingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import oracle.jrockit.jfr.FlightRecording;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.JFRImpl;
import oracle.jrockit.jfr.Logger;
import oracle.jrockit.jfr.MsgLevel;
import oracle.jrockit.jfr.Options;
import oracle.jrockit.jfr.Recording;
import oracle.jrockit.jfr.RecordingOptions;
import oracle.jrockit.jfr.RecordingOptionsImpl;
import oracle.jrockit.jfr.RecordingStream;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.openmbean.EventDefaultType;
import oracle.jrockit.jfr.openmbean.EventDescriptorType;
import oracle.jrockit.jfr.openmbean.EventSettingType;
import oracle.jrockit.jfr.openmbean.JFRStatsType;
import oracle.jrockit.jfr.openmbean.PresetFileType;
import oracle.jrockit.jfr.openmbean.ProducerDescriptorType;
import oracle.jrockit.jfr.openmbean.RecordingOptionsType;
import oracle.jrockit.jfr.openmbean.RecordingType;
import oracle.jrockit.jfr.settings.EventDefaultSet;
import oracle.jrockit.jfr.settings.EventSetting;
import oracle.jrockit.jfr.settings.EventSettings;

@Deprecated
public final class FlightRecorder
extends StandardMBean
implements FlightRecorderMBean {
    private final JFRImpl jfrImpl;
    private final EventSettingType eventSettingType;
    private final RecordingOptionsType recordingOptionsType;
    private final RecordingType recordingType;
    private final EventDescriptorType eventDescriptorType;
    private final ProducerDescriptorType producerDescriptorType;
    private final EventDefaultType eventDefaultType;
    private final PresetFileType presetFileType;
    private final JFRStatsType jfrStatsType;
    private final Logger logger;
    private final Options options;
    private final AtomicLong idCounter = new AtomicLong();
    private final Map<Long, RecordingStream> streams = Collections.synchronizedMap(new HashMap());

    FlightRecorder(Options options, Logger logger, JFRImpl jFRImpl) throws NotCompliantMBeanException, OpenDataException {
        super(FlightRecorderMBean.class);
        this.options = options;
        this.logger = logger;
        this.jfrImpl = jFRImpl;
        this.eventSettingType = new EventSettingType(jFRImpl);
        this.recordingOptionsType = new RecordingOptionsType();
        this.recordingType = new RecordingType(this.recordingOptionsType);
        this.eventDescriptorType = new EventDescriptorType();
        this.eventDefaultType = new EventDefaultType();
        this.presetFileType = new PresetFileType(this.eventDefaultType);
        this.producerDescriptorType = new ProducerDescriptorType(this.eventDescriptorType);
        this.jfrStatsType = new JFRStatsType();
    }

    void destroy() {
        for (RecordingStream recordingStream : this.streams.values()) {
            try {
                recordingStream.close();
            }
            catch (IOException iOException) {}
        }
        this.streams.clear();
    }

    void addEventDefaults(Recording recording, List<CompositeData> list) throws OpenDataException {
        JFR.checkControl();
        recording.getEventSettings().addEventDefaultSet(new EventDefaultSet(this.eventDefaultType.toJavaTypeData(list)));
    }

    @Override
    public void addEventDefaults(ObjectName objectName, List<CompositeData> list) throws OpenDataException, NoSuchRecordingException {
        this.addEventDefaults(this.getRecording(objectName), list);
    }

    private List<CompositeData> getEventDefaults(EventSettings eventSettings) throws OpenDataException {
        return this.eventDefaultType.toCompositeData(eventSettings.getEventDefaults());
    }

    @Override
    public List<CompositeData> getEventDefaults() throws OpenDataException {
        return this.getEventDefaults(this.jfrImpl.getEventSettings());
    }

    List<CompositeData> getEventDefaults(Recording recording) throws OpenDataException {
        return this.getEventDefaults(recording.getEventSettings());
    }

    @Override
    public List<CompositeData> getEventDefaults(ObjectName objectName) throws OpenDataException, NoSuchRecordingException {
        return this.getEventDefaults(this.getRecording(objectName));
    }

    void setEventDefaults(Recording recording, List<CompositeData> list) throws OpenDataException {
        JFR.checkControl();
        recording.getEventSettings().replaceEventDefaultSets(Collections.singletonList(new EventDefaultSet(this.eventDefaultType.toJavaTypeData(list))));
    }

    @Override
    public void setEventDefaults(ObjectName objectName, List<CompositeData> list) throws OpenDataException, NoSuchRecordingException {
        this.setEventDefaults(this.getRecording(objectName), list);
    }

    @Override
    public List<CompositeData> getEventSettings() throws OpenDataException {
        return this.eventSettingType.toCompositeData(this.jfrImpl.getEventSettings().getSettings());
    }

    @Override
    public List<CompositeData> getRecordings() throws OpenDataException {
        Collection<Recording> collection = this.jfrImpl.getRecordings();
        Iterator<Recording> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Recording recording = iterator.next();
            if (recording.isBound()) continue;
            this.logger.log(MsgLevel.TRACE, "Recording %s not bound", recording);
            iterator.remove();
        }
        return this.recordingType.toCompositeData(collection);
    }

    @Override
    public List<CompositeData> getProducers() throws OpenDataException {
        return this.producerDescriptorType.toCompositeData(this.jfrImpl.getProducers());
    }

    @Override
    public List<CompositeData> getEventDescriptors() throws OpenDataException {
        return this.eventDescriptorType.toCompositeData(this.jfrImpl.getEvents());
    }

    @Override
    public void enableDefaultRecording() {
        JFR.checkControl();
        this.jfrImpl.enableDefaultRecording();
    }

    @Override
    public void disableDefaultRecording() {
        JFR.checkControl();
        this.jfrImpl.disableDefaultRecording();
    }

    @Override
    public boolean isDefaultRecordingRunning() {
        return this.jfrImpl.isContinuousModeRunning();
    }

    CompositeData getRecordingOptions(Recording recording) throws OpenDataException {
        return this.recordingOptionsType.toCompositeTypeData(recording);
    }

    @Override
    public CompositeData getRecordingOptions(ObjectName objectName) throws OpenDataException, NoSuchRecordingException {
        return this.getRecordingOptions(this.getRecording(objectName));
    }

    void setRecordingOptions(Recording recording, CompositeData compositeData) throws OpenDataException {
        JFR.checkControl();
        RecordingOptions recordingOptions = this.recordingOptionsType.toJavaTypeData(compositeData);
        try {
            recording.setOptions(recordingOptions);
        }
        catch (IOException iOException) {
            OpenDataException openDataException = new OpenDataException(iOException.getMessage());
            openDataException.initCause(iOException);
            throw openDataException;
        }
    }

    @Override
    public void setRecordingOptions(ObjectName objectName, CompositeData compositeData) throws OpenDataException, NoSuchRecordingException {
        this.setRecordingOptions(this.getRecording(objectName), compositeData);
    }

    ObjectName cloneRecording(Recording recording, String string, boolean bl) throws IOException {
        JFR.checkControl();
        Recording recording2 = this.jfrImpl.cloneRecording(recording, string, bl);
        return this.jfrImpl.bind(recording2);
    }

    @Override
    public ObjectName cloneRecording(ObjectName objectName, String string, boolean bl) throws NoSuchRecordingException, IOException {
        return this.cloneRecording(this.getRecording(objectName), string, bl);
    }

    void copyTo(Recording recording, String string, boolean bl) throws IOException {
        JFR.checkControl();
        recording.copyTo(string, bl);
    }

    @Override
    public void copyTo(ObjectName objectName, String string, boolean bl) throws IllegalStateException, IOException, NoSuchRecordingException {
        this.copyTo(this.getRecording(objectName), string, bl);
    }

    @Override
    public void copyTo(ObjectName objectName, String string) throws IllegalStateException, IOException, NoSuchRecordingException {
        this.copyTo(objectName, string, false);
    }

    @Override
    public ObjectName createRecording(String string) {
        JFR.checkControl();
        Recording recording = this.jfrImpl.createRecording(string);
        return this.jfrImpl.bind(recording);
    }

    @Override
    public ObjectName startRecording(String string, CompositeData compositeData, List<CompositeData> list, List<CompositeData> list2) throws OpenDataException {
        JFR.checkControl();
        Recording recording = this.jfrImpl.createRecording(string);
        try {
            if (list != null) {
                this.updateEventSettings(recording, list);
            }
            if (compositeData != null) {
                this.setRecordingOptions(recording, compositeData);
            }
            if (list2 != null) {
                this.addEventDefaults(recording, list2);
            }
            if (recording.getStartTime() == null) {
                recording.start();
            }
            return this.jfrImpl.bind(recording);
        }
        catch (RuntimeException | OpenDataException exception) {
            this.close(recording);
            throw exception;
        }
    }

    private Recording getRecording(ObjectName objectName) throws NoSuchRecordingException {
        long l = Long.parseLong(objectName.getKeyProperty("id"));
        return this.jfrImpl.getRecording(l);
    }

    public FlightRecordingMBean getRecordingMBean(ObjectName objectName) throws NoSuchRecordingException, OpenDataException {
        try {
            return new FlightRecording(this.getRecording(objectName), this);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw JFR.cannotHappen(notCompliantMBeanException);
        }
    }

    @Override
    public void close(ObjectName objectName) throws NoSuchRecordingException {
        this.close(this.getRecording(objectName));
    }

    void close(Recording recording) {
        JFR.checkControl();
        this.jfrImpl.release(recording);
    }

    private EventSetting getSetting(Recording recording, int n) throws NoSuchEventException {
        return recording.getEventSettings().getSetting(n);
    }

    List<CompositeData> getEventSettings(Recording recording) throws OpenDataException {
        return this.eventSettingType.toCompositeData(recording.getEventSettings().getSettings());
    }

    @Override
    public List<CompositeData> getEventSettings(ObjectName objectName) throws OpenDataException, NoSuchRecordingException {
        return this.getEventSettings(this.getRecording(objectName));
    }

    long getPeriod(Recording recording, int n) throws NoSuchEventException {
        return this.getSetting(recording, n).getPeriod();
    }

    @Override
    public long getPeriod(ObjectName objectName, int n) throws NoSuchEventException, NoSuchRecordingException {
        return this.getPeriod(this.getRecording(objectName), n);
    }

    @Override
    public long getDataSize(ObjectName objectName) throws NoSuchRecordingException {
        return this.getRecording(objectName).getDataSize();
    }

    @Override
    public Date getDataStartTime(ObjectName objectName) throws NoSuchRecordingException {
        return this.getRecording(objectName).getDataStartTime();
    }

    @Override
    public Date getDataEndTime(ObjectName objectName) throws NoSuchRecordingException {
        return this.getRecording(objectName).getDataEndTime();
    }

    long getThreshold(Recording recording, int n) throws NoSuchEventException {
        return this.getSetting(recording, n).getThreshold();
    }

    @Override
    public long getThreshold(ObjectName objectName, int n) throws NoSuchEventException, NoSuchRecordingException {
        return this.getThreshold(this.getRecording(objectName), n);
    }

    boolean isEventEnabled(Recording recording, int n) throws NoSuchEventException {
        return this.getSetting(recording, n).isEnabled();
    }

    @Override
    public boolean isEventEnabled(ObjectName objectName, int n) throws NoSuchEventException, NoSuchRecordingException {
        return this.isEventEnabled(this.getRecording(objectName), n);
    }

    boolean isStackTraceEnabled(Recording recording, int n) throws NoSuchEventException {
        return this.getSetting(recording, n).isStacktraceEnabled();
    }

    @Override
    public boolean isStackTraceEnabled(ObjectName objectName, int n) throws NoSuchEventException, NoSuchRecordingException {
        return this.isStackTraceEnabled(this.getRecording(objectName), n);
    }

    void updateEventSettings(Recording recording, List<CompositeData> list) throws OpenDataException {
        JFR.checkControl();
        recording.getEventSettings().putSettings(this.eventSettingType.toJavaTypeData(list));
    }

    @Override
    public void updateEventSettings(ObjectName objectName, List<CompositeData> list) throws OpenDataException, NoSuchRecordingException {
        this.updateEventSettings(this.getRecording(objectName), list);
    }

    long openStream(Recording recording, Date date, Date date2) throws IOException {
        JFR.checkControl();
        RecordingStream recordingStream = new RecordingStream(recording.getChannel(date, date2));
        long l = this.idCounter.incrementAndGet();
        this.streams.put(l, recordingStream);
        return l;
    }

    long openStream(Recording recording) throws IOException {
        JFR.checkControl();
        RecordingStream recordingStream = new RecordingStream(recording.getChannel());
        long l = this.idCounter.incrementAndGet();
        this.streams.put(l, recordingStream);
        return l;
    }

    @Override
    public long openStream(ObjectName objectName, Date date, Date date2) throws IOException, NoSuchRecordingException {
        return this.openStream(this.getRecording(objectName), date, date2);
    }

    @Override
    public long openStream(ObjectName objectName) throws IOException, NoSuchRecordingException {
        return this.openStream(this.getRecording(objectName));
    }

    @Override
    public void closeStream(long l) throws IOException, IllegalArgumentException {
        JFR.checkControl();
        RecordingStream recordingStream = this.streams.get(l);
        if (recordingStream == null) {
            throw new IllegalArgumentException("No such stream " + l);
        }
        recordingStream.close();
        this.streams.remove(l);
    }

    @Override
    public byte[] readStream(long l) throws IOException, IllegalArgumentException {
        JFR.checkControl();
        RecordingStream recordingStream = this.streams.get(l);
        if (recordingStream == null) {
            throw new IllegalArgumentException("No such stream " + l);
        }
        return recordingStream.read();
    }

    void setEventEnabled(Recording recording, int n, boolean bl) throws NoSuchEventException {
        JFR.checkControl();
        EventDescriptor eventDescriptor = this.jfrImpl.getEvent(n);
        EventSetting eventSetting = this.getSetting(recording, n);
        EventSetting eventSetting2 = new EventSetting(eventDescriptor, bl, eventSetting.isStacktraceEnabled(), eventSetting.getThreshold(), eventSetting.getPeriod());
        recording.getEventSettings().putSettings(Collections.singletonList(eventSetting2));
    }

    @Override
    public void setEventEnabled(ObjectName objectName, int n, boolean bl) throws NoSuchEventException, NoSuchRecordingException {
        this.setEventEnabled(this.getRecording(objectName), n, bl);
    }

    void setPeriod(Recording recording, int n, long l) throws NoSuchEventException {
        JFR.checkControl();
        EventDescriptor eventDescriptor = this.jfrImpl.getEvent(n);
        EventSetting eventSetting = this.getSetting(recording, n);
        EventSetting eventSetting2 = new EventSetting(eventDescriptor, eventSetting.isEnabled(), eventSetting.isStacktraceEnabled(), eventSetting.getThreshold(), l);
        recording.getEventSettings().putSettings(Collections.singletonList(eventSetting2));
    }

    @Override
    public void setPeriod(ObjectName objectName, int n, long l) throws NoSuchRecordingException, NoSuchEventException {
        this.setPeriod(this.getRecording(objectName), n, l);
    }

    void setStackTraceEnabled(Recording recording, int n, boolean bl) throws NoSuchEventException {
        JFR.checkControl();
        EventDescriptor eventDescriptor = this.jfrImpl.getEvent(n);
        EventSetting eventSetting = this.getSetting(recording, n);
        EventSetting eventSetting2 = new EventSetting(eventDescriptor, eventSetting.isEnabled(), bl, eventSetting.getThreshold(), eventSetting.getPeriod());
        recording.getEventSettings().putSettings(Collections.singletonList(eventSetting2));
    }

    @Override
    public void setStackTraceEnabled(ObjectName objectName, int n, boolean bl) throws NoSuchRecordingException, NoSuchEventException {
        this.setStackTraceEnabled(this.getRecording(objectName), n, bl);
    }

    void setThreshold(Recording recording, int n, long l) throws NoSuchEventException {
        JFR.checkControl();
        EventDescriptor eventDescriptor = this.jfrImpl.getEvent(n);
        EventSetting eventSetting = this.getSetting(recording, n);
        EventSetting eventSetting2 = new EventSetting(eventDescriptor, eventSetting.isEnabled(), eventSetting.isStacktraceEnabled(), l, eventSetting.getPeriod());
        recording.getEventSettings().putSettings(Collections.singletonList(eventSetting2));
    }

    @Override
    public void setThreshold(ObjectName objectName, int n, long l) throws NoSuchEventException, NoSuchRecordingException {
        this.setThreshold(this.getRecording(objectName), n, l);
    }

    @Override
    public void start(ObjectName objectName) throws NoSuchRecordingException {
        JFR.checkControl();
        this.getRecording(objectName).start();
    }

    @Override
    public void stop(ObjectName objectName) throws NoSuchRecordingException, IOException {
        JFR.checkControl();
        this.getRecording(objectName).stop();
    }

    @Override
    public long getThreshold(int n) throws NoSuchEventException {
        return this.jfrImpl.getEventSettings().getSetting(n).getThreshold();
    }

    @Override
    public boolean isEventEnabled(int n) throws NoSuchEventException {
        return this.jfrImpl.getEventSettings().getSetting(n).isEnabled();
    }

    @Override
    public boolean isStackTraceEnabled(int n) throws NoSuchEventException {
        return this.jfrImpl.getEventSettings().getSetting(n).isStacktraceEnabled();
    }

    @Override
    public long getGlobalBufferSize() {
        return this.options.globalBufferSize();
    }

    @Override
    public long getThreadBufferSize() {
        return this.options.threadBufferSize();
    }

    @Override
    public long getMaximumRepositoryChunkSize() {
        return this.options.maxChunkSize();
    }

    @Override
    public long getNumGlobalBuffers() {
        return this.options.numGlobalBuffers();
    }

    @Override
    public String getRepositoryPath() {
        return this.options.repository();
    }

    @Override
    public List<CompositeData> getAvailablePresets() throws OpenDataException {
        return this.presetFileType.toCompositeData((Collection)new ArrayList());
    }

    @Override
    public CompositeData getRecordingOptionsDefaults() throws OpenDataException {
        return this.recordingOptionsType.toCompositeTypeData(new RecordingOptionsImpl());
    }

    @Override
    public CompositeData getStatistics() throws OpenDataException {
        return this.jfrStatsType.toCompositeTypeData(this.jfrImpl.getJFRStats());
    }
}

