/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.SecuritySettings;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BadCertificateDialog;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.DeployManifestChecker;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.SessionProperties;
import com.sun.deploy.util.SessionState;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SandboxSecurity {
    private static final String EXPIRED_VERSION_KEY = "ssv.expired.allowed";
    private static final String UNTRUSTED_KEY = "ssv.untrusted.allowed";
    private static final String RUNLOCAL_KEY = "ssv.run.local.allowed";
    private static SessionProperties sessionProps = new SessionProperties("sandbox.properties");
    private static final String FILENAME = "sandbox.properties";
    private static Object blockLock;
    private static String blockKey;
    private static String title;
    private static String masthead;
    private static String runKey;
    private static String cancel;
    private static String securityInfoDescription;
    private static String securityInfoCanel;
    private static String securityInfoTrusted;
    private static String securityRisk;

    public static void resetAcceptedVersion(LocalApplicationProperties localApplicationProperties) {
        if (localApplicationProperties != null) {
            localApplicationProperties.put(EXPIRED_VERSION_KEY, null);
            localApplicationProperties.put(UNTRUSTED_KEY, null);
            localApplicationProperties.put(RUNLOCAL_KEY, null);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            String string = TrustDecider.getLocString(localApplicationProperties.getLocation());
            if (string != null) {
                sessionProps.remove(string);
            }
        }
    }

    public static void isPermissionGranted(CodeSource codeSource, AppInfo appInfo, Preloader preloader) {
        if (codeSource != null && codeSource.getCertificates() != null) {
            try {
                DeployManifestChecker.verify(codeSource.getLocation(), false);
            }
            catch (SecurityException securityException) {
                Trace.ignored(securityException);
                SandboxSecurity.showBlockedDialog(appInfo, securityException.getMessage());
            }
            if (Config.isJavaVersionAtLeast16()) {
                SandboxSecurity.checkSignedSandboxSecurity(codeSource, appInfo, preloader);
            } else {
                Trace.println("Jar has Certs, treating sandbox app as unsigned due to running old JRE", TraceLevel.SECURITY);
                SandboxSecurity.checkUnsignedSandboxSecurity(appInfo);
            }
        } else {
            SandboxSecurity.checkUnsignedSandboxSecurity(appInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void checkSignedSandboxSecurity(CodeSource codeSource, AppInfo appInfo, Preloader preloader) {
        boolean bl = true;
        boolean bl2 = false;
        try {
            block18: {
                try {
                    Object object;
                    List list;
                    TrustDecider.grabDeployLock();
                    TrustDecider.ValidationState validationState = new TrustDecider.ValidationState();
                    Certificate[] certificateArray = null;
                    Certificate[] certificateArray2 = codeSource.getCertificates();
                    boolean bl3 = false;
                    try {
                        TrustDecider.ensureBasicStoresLoaded();
                        list = TrustDecider.breakDownMultiSignerChains(certificateArray2);
                    }
                    catch (Exception exception) {
                        BadCertificateDialog.showDialog(codeSource, appInfo, exception);
                        throw new SecurityException(exception.getMessage(), exception);
                    }
                    Iterator iterator = list.iterator();
                    if (iterator.hasNext()) {
                        object = (List)iterator.next();
                        certificateArray = object.toArray(new X509Certificate[0]);
                        try {
                            validationState = TrustDecider.getValidationState((X509Certificate[])certificateArray, codeSource, 0, appInfo, false, preloader, true);
                        }
                        catch (Exception exception) {
                            BadCertificateDialog.showDialog(codeSource, appInfo, exception);
                            throw new SecurityException(exception.getMessage(), exception);
                        }
                        if (validationState.certValidity == 0) {
                            bl2 = true;
                            bl3 = validationState.rootCAValid;
                        }
                    }
                    if (validationState.trustDecision == 0L) {
                        bl = true;
                    } else {
                        boolean bl4 = bl = bl3 ? SecuritySettings.isCaSignedNever() : SecuritySettings.isSelfSignedNever();
                    }
                    if (bl) {
                        object = bl3 ? "deployment.run.sandbox.signed.never.text" : "deployment.run.sandbox.selfsigned.never.text";
                        SandboxSecurity.showBlockedDialog(appInfo, (String)object);
                    }
                    if (!bl3) {
                        if (SecurityBaseline.isExpired()) {
                            if (SecuritySettings.isSSVModeNever()) {
                                SandboxSecurity.showBlockedDialog(appInfo, "deployment.ssv2.mode.never.text");
                            }
                        } else if (SandboxSecurity.isLocalApp(appInfo) && SecuritySettings.isRunLocalAppletsNever()) {
                            SandboxSecurity.showBlockedDialog(appInfo, "deployment.local.applet.never.text");
                        }
                    }
                    if (validationState.trustDecision != 2L) break block18;
                    int n = SandboxSecurity.showSandboxDialog(appInfo, (X509Certificate[])certificateArray, !validationState.timeValid, !validationState.rootCAValid, validationState.revStatusUnknown);
                    TrustDecider.recordSandboxAnswer(certificateArray, codeSource, validationState, preloader, n);
                }
                catch (InterruptedException interruptedException) {
                    Trace.ignored(interruptedException);
                    SandboxSecurity.showBlockedDialog(appInfo, "deployment.run.sandbox.signed.error");
                    Object var14_17 = null;
                    TrustDecider.releaseDeployLock();
                    return;
                }
            }
            Object var14_16 = null;
            TrustDecider.releaseDeployLock();
            return;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            TrustDecider.releaseDeployLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkUnsignedSandboxSecurity(AppInfo appInfo) {
        if (sessionProps.getProperty(TrustDecider.getLocString(appInfo.getLapURL())) != null) {
            return;
        }
        if (!Environment.isWebJava()) {
            return;
        }
        SessionProperties sessionProperties = sessionProps;
        synchronized (sessionProperties) {
            if (sessionProps.getProperty(TrustDecider.getLocString(appInfo.getLapURL())) != null) {
                return;
            }
            if (SecurityBaseline.isExpired()) {
                SandboxSecurity.checkRunExpired(appInfo);
            } else if (SandboxSecurity.isLocalApp(appInfo)) {
                SandboxSecurity.checkRunLocal(appInfo);
            } else {
                SandboxSecurity.checkRunUntrusted(appInfo);
            }
            sessionProps.setProperty(TrustDecider.getLocString(appInfo.getLapURL()), "true");
        }
    }

    private static void checkRunUntrusted(AppInfo appInfo) {
        if (SecuritySettings.isRunUntrustedNever()) {
            SandboxSecurity.showBlockedDialog(appInfo, "deployment.run.untrusted.never.text");
        }
        String string = JREInfo.getLatest();
        LocalApplicationProperties localApplicationProperties = SandboxSecurity.getLap(appInfo);
        if (string != null && localApplicationProperties != null && string.equals(localApplicationProperties.get(UNTRUSTED_KEY))) {
            return;
        }
        if (SandboxSecurity.showUntrustedDialog(appInfo) && localApplicationProperties != null && string != null) {
            localApplicationProperties.put(UNTRUSTED_KEY, string);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
    }

    private static void checkRunExpired(AppInfo appInfo) {
        if (SecuritySettings.isSSVModeNever()) {
            SandboxSecurity.showBlockedDialog(appInfo, "deployment.ssv2.mode.never.text");
        }
        String string = JREInfo.getLatest();
        LocalApplicationProperties localApplicationProperties = SandboxSecurity.getLap(appInfo);
        if (string != null && localApplicationProperties != null && string.equals(localApplicationProperties.get(EXPIRED_VERSION_KEY))) {
            return;
        }
        if (SandboxSecurity.showExpiredDialog(appInfo, string) && localApplicationProperties != null && string != null) {
            localApplicationProperties.put(EXPIRED_VERSION_KEY, string);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
    }

    private static void checkRunLocal(AppInfo appInfo) {
        if (SecuritySettings.isRunLocalAppletsNever()) {
            SandboxSecurity.showBlockedDialog(appInfo, "deployment.local.applet.never.text");
        }
        if (SecuritySettings.isRunUntrustedNever()) {
            SandboxSecurity.showBlockedDialog(appInfo, "deployment.run.untrusted.never.text");
        }
        String string = JREInfo.getLatest();
        LocalApplicationProperties localApplicationProperties = SandboxSecurity.getLap(appInfo);
        if (string != null && localApplicationProperties != null && string.equals(localApplicationProperties.get(RUNLOCAL_KEY))) {
            return;
        }
        if (SandboxSecurity.showUntrustedDialog(appInfo) && localApplicationProperties != null && string != null) {
            localApplicationProperties.put(RUNLOCAL_KEY, string);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
    }

    private static boolean isLocalApp(AppInfo appInfo) {
        URL uRL = appInfo.getFrom();
        return uRL != null && uRL.getProtocol().equals("file");
    }

    private static LocalApplicationProperties getLap(AppInfo appInfo) {
        return Cache.getLocalApplicationProperties(appInfo.getLapURL());
    }

    public static boolean showUntrustedDialog(AppInfo appInfo) {
        String string = "deployment.ssv.title";
        String string2 = "deployment.ssv.masthead";
        String string3 = "deployment.ssv.untrusted.main";
        String string4 = "deployment.ssv.localapp.main";
        String string5 = "deployment.ssv.location";
        Object var6_6 = null;
        String string6 = "deployment.ssv.prompt";
        String string7 = null;
        String string8 = null;
        if (SecuritySettings.isRunUntrustedMultiClick()) {
            string7 = "deployment.ssv.multi.prompt";
            string8 = "deployment.ssv.multi.text";
        }
        String string9 = "deployment.ssv.always";
        String string10 = "deployment.ssv.run";
        String string11 = null;
        String string12 = "deployment.ssv.cancel";
        URL uRL = null;
        String string13 = SandboxSecurity.isLocalApp(appInfo) ? string4 : string3;
        UIFactory uIFactory = ToolkitStore.getUI();
        int n = uIFactory.showSSV3Dialog(null, appInfo, 2, string, string2, string13, string5, string6, string7, string8, string10, string11, string12, string9, uRL);
        if (n == 2) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        throw new SecurityException("User declined to run unsigned sandbox app", null);
    }

    private static boolean showExpiredDialog(AppInfo appInfo, String string) {
        String string2 = "deployment.ssv.title";
        String string3 = "deployment.ssv.masthead";
        String string4 = SandboxSecurity.isLocalApp(appInfo) ? "deployment.ssv.expired.localapp.main" : "deployment.ssv.expired.main";
        String string5 = "deployment.ssv.location";
        String string6 = "deployment.ssv.expired.recommend";
        String string7 = "deployment.ssv.update.prompt";
        String string8 = null;
        String string9 = null;
        if (SecuritySettings.isSSVModeMultiClick()) {
            string8 = "deployment.ssv.multi.prompt";
            string9 = "deployment.ssv.multi.text";
        }
        String string10 = "deployment.ssv.always";
        String string11 = "deployment.ssv.run";
        String string12 = "deployment.ssv.update";
        String string13 = "deployment.ssv.cancel";
        URL uRL = null;
        try {
            uRL = new URL("http://java.com/download");
        }
        catch (Exception exception) {
            // empty catch block
        }
        UIFactory uIFactory = ToolkitStore.getUI();
        ToolkitStore.getUI();
        int n = uIFactory.showSSV3Dialog(null, appInfo, 2, string2, string3, string4, string5, string7, string8, string9, string11, string12, string13, string10, uRL);
        ToolkitStore.getUI();
        if (n == 2) {
            return true;
        }
        ToolkitStore.getUI();
        if (n == 0) {
            return false;
        }
        throw new SecurityException("User declined to run on insecure or expired JRE", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showBlockedDialog(AppInfo appInfo, String string) {
        String string2 = ResourceManager.getString(string);
        Trace.println(string2, TraceLevel.BASIC);
        Object object = blockLock;
        synchronized (object) {
            String string3;
            String string4 = null;
            String string5 = ResourceManager.getString("deployment.blocked.title");
            String string6 = ResourceManager.getString("deployment.blocked.masthead");
            if (string2 == null) {
                string2 = ResourceManager.getString("deployment.blocked.text");
            }
            String string7 = ResourceManager.getString("common.ok_btn");
            String string8 = ResourceManager.getString("common.detail.button");
            URL uRL = appInfo.getLapURL();
            String string9 = string3 = uRL == null ? null : uRL.toString();
            if (string3 == null || !string3.equals(blockKey)) {
                appInfo.setVendor(null);
                ToolkitStore.getUI().showPublisherInfo(null, appInfo, string5, string6, string2, string7, string8, string4);
            }
            blockKey = string3;
        }
        throw new BlockedException(string2, null);
    }

    private static String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    private static int showSandboxDialog(AppInfo appInfo, X509Certificate[] x509CertificateArray, boolean bl, boolean bl2, boolean bl3) {
        ArrayList<String> arrayList = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(securityInfoDescription);
        arrayList2.add(securityInfoCanel);
        String string = CertUtils.extractSubjectAliasName(x509CertificateArray[0]);
        if (bl2) {
            arrayList = new ArrayList<String>();
            arrayList.add(securityRisk);
            String string2 = SandboxSecurity.getMessage("security.dialog.notverified.subject");
            arrayList2.add(SandboxSecurity.getMessage("security.info.publisher.unknown").replaceAll(string2, string2.toUpperCase()));
            arrayList2.add(SandboxSecurity.getMessage("sandbox.security.info.selfsigned.state"));
            string = string2.toUpperCase();
        } else if (bl) {
            arrayList = new ArrayList();
            arrayList.add(SandboxSecurity.combineMessage(securityRisk, SandboxSecurity.getMessage("sandbox.security.dialog.expired.signed.label")));
            arrayList2.add(securityInfoTrusted);
            arrayList2.add(SandboxSecurity.getMessage("sandbox.security.info.expired.state"));
        } else if (bl3) {
            arrayList = new ArrayList();
            arrayList.add(SandboxSecurity.combineMessage(securityRisk, SandboxSecurity.getMessage("sandbox.security.info.selfsigned.revocation.unknown")));
            arrayList2.add(securityInfoTrusted);
            arrayList2.add(SandboxSecurity.getMessage("sandbox.security.info.revocation.unsure.state"));
        } else {
            arrayList2.add(securityInfoTrusted);
            arrayList2.add(SandboxSecurity.getMessage("sandbox.security.info.trusted.state"));
        }
        if (arrayList != null) {
            arrayList.addAll(arrayList2);
        }
        return ToolkitStore.getUI().showSandboxSecurityDialog(appInfo, title, masthead, string, appInfo.getFrom(), true, !bl && !bl2 && !bl3, runKey, cancel, arrayList != null ? arrayList.toArray(new String[arrayList.size()]) : null, arrayList == null ? arrayList2.toArray(new String[arrayList2.size()]) : null, true, x509CertificateArray, 0, x509CertificateArray.length, bl2 || bl || bl3);
    }

    private static String combineMessage(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("\n\n");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    static {
        SessionState.register(sessionProps);
        blockLock = new Object();
        blockKey = null;
        title = SandboxSecurity.getMessage("deployment.ssv.title");
        masthead = SandboxSecurity.getMessage("deployment.ssv.masthead");
        runKey = "deployment.ssv.run";
        cancel = SandboxSecurity.getMessage("deployment.ssv.cancel");
        securityInfoDescription = SandboxSecurity.getMessage("sandbox.security.info.description");
        securityInfoCanel = SandboxSecurity.getMessage("sandbox.security.info.cancel");
        securityInfoTrusted = SandboxSecurity.getMessage("sandbox.security.info.trusted");
        securityRisk = SandboxSecurity.getMessage("sandbox.security.info.risk");
    }
}

