/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import sun.security.provider.certpath.CertPathHelper;
import sun.security.provider.certpath.DistributionPointFetcher;
import sun.security.provider.certpath.OCSP;
import sun.security.x509.X509CRLEntryImpl;

class RevocationChecker {
    private final X509Certificate anchor;
    private final Date date;
    private final String sigProvider;
    private final boolean checkOCSP;
    private final boolean checkCRLs;
    private final boolean checkBoth;
    private URI ocspResponderURI;
    private final X509Certificate ocspResponderCert;
    private final boolean onlyPublisher;
    private final X509CRL configCrl;
    private final Date timestamp;
    private long maxClockSkew = 900000L;
    private X509Certificate issuerCert;
    private boolean certCanSignCRL = true;
    private static final boolean[] ALL_REASONS = new boolean[]{true, true, true, true, true, true, true, true, true};
    private static Class[] PARAMS = new Class[]{class$java$security$cert$X509CRLSelector == null ? (class$java$security$cert$X509CRLSelector = RevocationChecker.class$("java.security.cert.X509CRLSelector")) : class$java$security$cert$X509CRLSelector, class$java$util$Date == null ? (class$java$util$Date = RevocationChecker.class$("java.util.Date")) : class$java$util$Date, Long.TYPE};
    private static Class[] TYPES = new Class[]{class$java$security$cert$X509CRLSelector == null ? (class$java$security$cert$X509CRLSelector = RevocationChecker.class$("java.security.cert.X509CRLSelector")) : class$java$security$cert$X509CRLSelector, Boolean.TYPE, class$java$security$PublicKey == null ? (class$java$security$PublicKey = RevocationChecker.class$("java.security.PublicKey")) : class$java$security$PublicKey, class$java$lang$String == null ? (class$java$lang$String = RevocationChecker.class$("java.lang.String")) : class$java$lang$String, class$java$util$List == null ? (class$java$util$List = RevocationChecker.class$("java.util.List")) : class$java$util$List, array$Z == null ? (array$Z = RevocationChecker.class$("[Z")) : array$Z, class$java$util$Set == null ? (class$java$util$Set = RevocationChecker.class$("java.util.Set")) : class$java$util$Set, class$java$util$Date == null ? (class$java$util$Date = RevocationChecker.class$("java.util.Date")) : class$java$util$Date};
    static /* synthetic */ Class class$java$security$cert$X509CRLSelector;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$security$PublicKey;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class class$java$util$Set;

    RevocationChecker(X509Certificate x509Certificate, PKIXParameters pKIXParameters, final boolean bl, final boolean bl2, String string, X509Certificate x509Certificate2, boolean bl3, X509CRL x509CRL, Date date) {
        if (!bl && !bl2) {
            throw new IllegalArgumentException();
        }
        this.date = pKIXParameters.getDate();
        this.sigProvider = pKIXParameters.getSigProvider();
        this.anchor = x509Certificate;
        this.issuerCert = x509Certificate;
        this.checkOCSP = bl;
        this.checkCRLs = bl2;
        boolean bl4 = this.checkBoth = bl && bl2;
        if (string != null) {
            try {
                this.ocspResponderURI = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                Trace.securityPrintln("Can't parse OCSP responder URI: " + this.ocspResponderURI);
                Trace.ignored(uRISyntaxException);
            }
        }
        this.ocspResponderCert = x509Certificate2;
        this.onlyPublisher = bl3;
        this.configCrl = x509CRL;
        this.timestamp = date;
        final String string2 = Config.getStringProperty("deployment.security.validation.clockskew");
        if (string2 != null) {
            try {
                this.maxClockSkew = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Trace.ignored(numberFormatException);
            }
        }
        final String string3 = Config.getStringProperty("deployment.security.validation.timeout");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (bl) {
                    if (string3 != null) {
                        System.setProperty("com.sun.security.ocsp.timeout", string3);
                    }
                    if (string2 != null) {
                        System.setProperty("com.sun.security.ocsp.clockSkew", string2);
                    }
                }
                if (bl2) {
                    System.setProperty("com.sun.security.enableCRLDP", "true");
                    if (string3 != null) {
                        System.setProperty("com.sun.security.crls.timeout", string3);
                    }
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void check(X509Certificate x509Certificate) throws CertificateException {
        block12: {
            try {
                try {
                    if (this.onlyPublisher && x509Certificate.getBasicConstraints() != -1) {
                        Trace.securityPrintln("Skipping revocation check, not publisher cert");
                        Object var6_2 = null;
                        this.updateState(x509Certificate);
                        return;
                    }
                    if (this.checkOCSP) {
                        this.checkOCSP(x509Certificate);
                        break block12;
                    }
                    if (this.checkCRLs) {
                        this.checkCRLs(x509Certificate);
                    }
                }
                catch (CertificateException certificateException) {
                    if (!this.checkBoth) throw certificateException;
                    if (certificateException instanceof CertificateRevokedException) {
                        throw certificateException;
                    }
                    CertificateException certificateException2 = certificateException;
                    Trace.securityPrintln("Failing over to CRLs: " + certificateException.getMessage());
                    try {
                        this.checkCRLs(x509Certificate);
                    }
                    catch (CertificateException certificateException3) {
                        if (certificateException3 instanceof CertificateRevokedException) {
                            throw certificateException3;
                        }
                        certificateException2.addSuppressed(certificateException3);
                        throw certificateException2;
                    }
                    Object var6_4 = null;
                    this.updateState(x509Certificate);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                this.updateState(x509Certificate);
                throw throwable;
            }
        }
        Object var6_3 = null;
        this.updateState(x509Certificate);
    }

    private void updateState(X509Certificate x509Certificate) {
        this.issuerCert = x509Certificate;
        this.certCanSignCRL = RevocationChecker.certCanSignCRL(x509Certificate);
    }

    private static boolean certCanSignCRL(X509Certificate x509Certificate) {
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null) {
            return blArray[6];
        }
        return false;
    }

    private void checkOCSP(X509Certificate x509Certificate) throws CertificateException {
        URI uRI;
        URI uRI2 = uRI = this.ocspResponderURI != null ? this.ocspResponderURI : OCSP.getResponderURI(x509Certificate);
        if (uRI == null) {
            throw new StatusUnknownException("Certificate does not specify OCSP responder");
        }
        X509Certificate x509Certificate2 = this.ocspResponderCert != null ? this.ocspResponderCert : this.issuerCert;
        try {
            OCSP.RevocationStatus revocationStatus = OCSP.check((X509Certificate)x509Certificate, (X509Certificate)this.issuerCert, (URI)uRI, (X509Certificate)x509Certificate2, (Date)this.date);
            Trace.securityPrintln("OCSP Response: " + (Object)((Object)revocationStatus.getCertStatus()));
            if (revocationStatus.getCertStatus() == OCSP.RevocationStatus.CertStatus.REVOKED) {
                Date date = revocationStatus.getRevocationTime();
                if (this.timestamp == null || date.before(this.timestamp)) {
                    throw new CertificateRevokedException(date, revocationStatus.getRevocationReason(), x509Certificate2.getSubjectX500Principal(), revocationStatus.getSingleExtensions());
                }
            } else if (revocationStatus.getCertStatus() == OCSP.RevocationStatus.CertStatus.UNKNOWN) {
                throw new StatusUnknownException();
            }
        }
        catch (IOException iOException) {
            throw new StatusUnknownException(iOException);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            String string = "OCSP response error: ";
            String string2 = certPathValidatorException.getMessage();
            if (string2 != null && string2.startsWith(string)) {
                String string3 = string2.substring(string.length());
                Trace.securityPrintln(string3);
                if (string3.equals("UNAUTHORIZED") || string3.equals("TRY_LATER") || string3.equals("INTERNAL_ERROR")) {
                    throw new StatusUnknownException(certPathValidatorException);
                }
            }
            throw new CertificateException(certPathValidatorException);
        }
    }

    private void checkCRLs(X509Certificate x509Certificate) throws CertificateException {
        X509CRLSelector x509CRLSelector = new X509CRLSelector();
        x509CRLSelector.setCertificateChecking(x509Certificate);
        try {
            CertPathHelper.setDateAndTime(x509CRLSelector, this.date, this.maxClockSkew);
        }
        catch (IllegalAccessError illegalAccessError) {
            RevocationChecker.setDateAndTime(x509CRLSelector, this.date, this.maxClockSkew);
        }
        boolean[] blArray = new boolean[9];
        Set<TrustAnchor> set = Collections.singleton(new TrustAnchor(this.anchor, null));
        Collection collection = null;
        try {
            collection = DistributionPointFetcher.getCRLs((X509CRLSelector)x509CRLSelector, (boolean)this.certCanSignCRL, (PublicKey)this.issuerCert.getPublicKey(), (String)this.sigProvider, Collections.emptyList(), (boolean[])blArray, set, (Date)this.date);
        }
        catch (CertStoreException certStoreException) {
            for (Throwable throwable = certStoreException.getCause(); throwable != null; throwable = throwable.getCause()) {
                if (!(throwable instanceof IOException)) continue;
                throw new StatusUnknownException(certStoreException);
            }
            throw new CertificateException(certStoreException);
        }
        catch (IllegalAccessError illegalAccessError) {
            collection = RevocationChecker.getCRLs(x509CRLSelector, this.certCanSignCRL, this.issuerCert.getPublicKey(), this.sigProvider, Collections.emptyList(), blArray, set, this.date);
        }
        if (this.configCrl != null) {
            collection.add(this.configCrl);
        }
        if (collection.isEmpty() || !Arrays.equals(blArray, ALL_REASONS)) {
            throw new StatusUnknownException();
        }
        this.checkApprovedCRLs(x509Certificate, collection);
    }

    private static void setDateAndTime(final X509CRLSelector x509CRLSelector, final Date date, final long l) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Class<?> clazz = Class.forName("sun.security.provider.certpath.CertPathHelper");
                    Method method = clazz.getDeclaredMethod("setDateAndTime", PARAMS);
                    method.setAccessible(true);
                    method.invoke(null, x509CRLSelector, date, new Long(l));
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignored(privilegedActionException);
            x509CRLSelector.setDateAndTime(date);
        }
    }

    private static Collection getCRLs(final X509CRLSelector x509CRLSelector, final boolean bl, final PublicKey publicKey, final String string, final List list, final boolean[] blArray, final Set set, final Date date) throws StatusUnknownException {
        try {
            return (Collection)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Class<?> clazz = Class.forName("sun.security.provider.certpath.DistributionPointFetcher");
                    Method method = clazz.getDeclaredMethod("getInstance", null);
                    method.setAccessible(true);
                    Object object = method.invoke(null, new Object[0]);
                    method = clazz.getDeclaredMethod("getCRLs", TYPES);
                    method.setAccessible(true);
                    return method.invoke(object, x509CRLSelector, new Boolean(bl), publicKey, string, list, blArray, set, date);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignored(privilegedActionException);
            throw new StatusUnknownException();
        }
    }

    private void checkApprovedCRLs(X509Certificate x509Certificate, Collection collection) throws CertificateException {
        CRLReason cRLReason = CRLReason.UNSPECIFIED;
        X509CRLEntryImpl x509CRLEntryImpl = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            X509CRL x509CRL = (X509CRL)iterator.next();
            X509CRLEntry x509CRLEntry = x509CRL.getRevokedCertificate(x509Certificate);
            if (x509CRLEntry == null) continue;
            try {
                x509CRLEntryImpl = X509CRLEntryImpl.toImpl(x509CRLEntry);
            }
            catch (CRLException cRLException) {
                throw new CertificateException(cRLException);
            }
            Set<String> set = x509CRLEntryImpl.getCriticalExtensionOIDs();
            if (set != null && !set.isEmpty()) {
                set.remove("2.5.29.21");
                set.remove("2.5.29.29");
                if (!set.isEmpty()) {
                    throw new CertificateException("unresolved critical extensions in CRLEntry");
                }
            }
            if ((cRLReason = x509CRLEntryImpl.getRevocationReason()) == null) {
                cRLReason = CRLReason.UNSPECIFIED;
            }
            Date date = x509CRLEntryImpl.getRevocationDate();
            if (this.timestamp != null && !date.before(this.timestamp)) continue;
            throw new CertificateRevokedException(date, cRLReason, x509CRL.getIssuerX500Principal(), x509CRLEntryImpl.getExtensions());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class StatusUnknownException
    extends CertificateException {
        static final long serialVersionUID = -1133298886602198899L;

        StatusUnknownException() {
        }

        StatusUnknownException(String string) {
            super(string);
        }

        StatusUnknownException(Throwable throwable) {
            super(throwable);
        }
    }
}

