/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

public class DeployManifestChecker {
    private DeployManifestChecker() {
    }

    public static void verify(URL uRL, boolean bl) {
        String string = (String)ToolkitStore.get().getAppContext().get("deploy-" + uRL);
        Resource resource = ResourceProvider.get().getCachedResource(uRL, string);
        if (resource == null || !resource.isJarFile()) {
            return;
        }
        JarFile jarFile = resource.getJarFile();
        try {
            DeployManifestChecker.verify(uRL, jarFile.getManifest().getMainAttributes(), bl);
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
            throw new SecurityException("unexpected exception when trying to access manifest attributes");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void verify(URL uRL, Attributes attributes, boolean bl) {
        String string = attributes.getValue("Permissions");
        if (string == null) {
            Trace.println("Missing Permissions manifest attribute for: " + uRL);
        } else if (string.equals("sandbox")) {
            if (bl) {
                throw new SecurityException("JAR manifest requested to run in sandbox only: " + uRL);
            }
        } else {
            if (!string.equals("all-permissions")) throw new SecurityException("Invalid Permissions value: " + string);
            if (!bl) {
                throw new SecurityException("JAR manifest requested to run in all-permissons only: " + uRL);
            }
        }
        string = attributes.getValue("Codebase");
        if (string != null) {
            String string2 = uRL.getHost();
            String string3 = uRL.getProtocol();
            int n = uRL.getPort();
            String[] stringArray = string.split("\\s");
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                int n2;
                String string4 = null;
                String string5 = null;
                URL uRL2 = null;
                try {
                    uRL2 = new URL(stringArray[i]);
                    string4 = uRL2.getHost();
                    string5 = uRL2.getProtocol();
                    n2 = uRL2.getPort();
                }
                catch (MalformedURLException malformedURLException) {
                    string4 = stringArray[i];
                    int n3 = string4.indexOf(":");
                    if (n3 == -1) {
                        n2 = -1;
                    }
                    string4 = stringArray[i].substring(0, n3);
                    n2 = Integer.parseInt(stringArray[i].substring(n3 + 1));
                }
                if (n2 == -1) {
                    bl4 = true;
                } else if (n2 == n) {
                    bl4 = true;
                }
                if (string5 != null) {
                    if (string5.equals(string3)) {
                        bl2 = true;
                    }
                } else {
                    bl2 = true;
                }
                if (string4.equals("*")) {
                    bl3 = true;
                } else if (string4.indexOf("*") != -1) {
                    if (!string4.startsWith("*.")) throw new SecurityException("Invalid Codebase value: " + stringArray[i]);
                    String string6 = string4.substring(2);
                    if (string2.endsWith(string6)) {
                        bl3 = true;
                    }
                } else if (string4.equals(string2)) {
                    bl3 = true;
                }
                if (bl2 && bl3 && bl4) {
                    return;
                }
                bl3 = false;
                bl2 = false;
                bl4 = false;
            }
            throw new SecurityException("JAR manifest codebase mismatch for " + uRL);
        }
        Trace.println("Missing Codebase manifest attribute for: " + uRL);
    }
}

