/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.util;

import com.iflytek.skintool.domin.Rectangle;
import com.iflytek.skintool.util.BufferedImageBuilder;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import javax.swing.ImageIcon;

public class JavaNinePatchImage {
    private Image mSrcImage;
    private Rectangle mPadding;
    private int mWidth;
    private int mHeight;
    private Image mDestImage;

    public JavaNinePatchImage(Object context, Rectangle padding, int width, int height, Image image) {
        this.mPadding = padding;
        this.mSrcImage = image;
        this.mWidth = width;
        this.mHeight = height;
        this.Like9PatchStretch(padding.getmType());
    }

    private void Like9PatchStretch(int type) {
        int imageWidth = this.mSrcImage.getWidth(null);
        int imageHeight = this.mSrcImage.getHeight(null);
        int x1 = this.mPadding.getmX1();
        int y1 = this.mPadding.getmY1();
        int x2 = this.mPadding.getmX2();
        int y2 = this.mPadding.getmY2();
        PixelGrabber pg = null;
        MemoryImageSource ip = null;
        Toolkit tool = new Window(null).getToolkit();
        if (type == 0) {
            this.horizontalStretch(imageWidth, imageHeight, x1, x2, pg, ip, tool);
            this.verticalStretch(imageWidth, imageHeight, y1, y2, pg, ip, tool);
        } else if (type == 1) {
            this.horizontalStretch(imageWidth, imageHeight, x1, x2, pg, ip, tool);
            ImageIcon temp = new ImageIcon(this.mDestImage);
            this.mDestImage = this.mDestImage.getScaledInstance(temp.getIconWidth(), this.mHeight, 1);
        } else if (type == 2) {
            this.mDestImage = this.mSrcImage.getScaledInstance(this.mWidth, this.mSrcImage.getHeight(null), 1);
            this.verticalStretch(this.mWidth, imageHeight, y1, y2, pg, ip, tool);
        } else {
            this.mDestImage = this.mSrcImage;
        }
    }

    private void horizontalStretch(int imageWidth, int imageHeight, int x1, int x2, PixelGrabber pg, MemoryImageSource ip, Toolkit tool) {
        int stretchWidth = this.mWidth - (x1 + imageWidth - x2);
        if (imageWidth >= this.mWidth) {
            if (imageWidth - (x2 - x1) >= this.mWidth) {
                this.mDestImage = this.mSrcImage.getScaledInstance(this.mWidth, this.mSrcImage.getHeight(null), 1);
                this.mDestImage.flush();
                return;
            }
            this.horizontalStretch(imageWidth, imageHeight, x1, x2, stretchWidth, pg, ip, tool);
            return;
        }
        if (x2 > imageWidth) {
            int totalWidth = x1 + x2;
            x1 = x1 * imageWidth / totalWidth;
            x2 = x2 * imageWidth / totalWidth;
            stretchWidth = this.mWidth - (x1 + imageWidth - x2);
        }
        this.horizontalStretch(imageWidth, imageHeight, x1, x2, stretchWidth, pg, ip, tool);
    }

    private void horizontalStretch(int imageWidth, int imageHeight, int x1, int y1, int stretchWidth, PixelGrabber pg, MemoryImageSource ip, Toolkit tool) {
        Image firstImage = null;
        Image secondImage = null;
        Image thirdImage = null;
        int[] pixels = null;
        if (x1 > 0) {
            pixels = new int[imageWidth * imageHeight];
            pg = new PixelGrabber(this.mSrcImage, 0, 0, imageWidth, imageHeight, pixels, 0, x1);
            try {
                pg.grabPixels();
                ip = new MemoryImageSource(x1, imageHeight, pixels, 0, x1);
                firstImage = tool.createImage(ip);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        pixels = new int[(y1 - x1) * imageHeight];
        pg = new PixelGrabber(this.mSrcImage, x1, 0, y1 - x1, imageHeight, pixels, 0, y1 - x1);
        try {
            pg.grabPixels();
            ip = new MemoryImageSource(y1 - x1, imageHeight, pixels, 0, y1 - x1);
            secondImage = tool.createImage(ip);
            secondImage = secondImage.getScaledInstance(stretchWidth, imageHeight, 1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (y1 < imageWidth) {
            pixels = new int[(imageWidth - y1) * imageHeight];
            pg = new PixelGrabber(this.mSrcImage, y1, 0, imageWidth - y1, imageHeight, pixels, 0, imageWidth - y1);
            try {
                pg.grabPixels();
                ip = new MemoryImageSource(imageWidth - y1, imageHeight, pixels, 0, imageWidth - y1);
                thirdImage = tool.createImage(ip);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.HorizontalMerGeImage(firstImage, secondImage, thirdImage, this.mWidth, imageHeight);
    }

    private void HorizontalMerGeImage(Image firstImage, Image secondImage, Image thirdImage, int stretchWidth, int imageHeight) {
        BufferedImage BufferImageNew = new BufferedImage(stretchWidth, imageHeight, 2);
        BufferedImage image = null;
        int firstWidth = 0;
        if (firstImage != null) {
            int[] ImageArrayFirst = new int[firstImage.getWidth(null) * firstImage.getHeight(null)];
            image = BufferedImageBuilder.getInstance().bufferImage(firstImage);
            firstWidth = firstImage.getWidth(null);
            ImageArrayFirst = image.getRGB(0, 0, firstWidth, firstImage.getHeight(null), ImageArrayFirst, 0, firstWidth);
            BufferImageNew.setRGB(0, 0, firstWidth, firstImage.getHeight(null), ImageArrayFirst, 0, firstWidth);
            ImageArrayFirst = null;
        }
        int secondWidth = 0;
        if (secondImage != null) {
            int[] ImageArraySecond = new int[secondImage.getWidth(null) * secondImage.getHeight(null)];
            image = BufferedImageBuilder.getInstance().bufferImage(secondImage);
            secondWidth = secondImage.getWidth(null);
            ImageArraySecond = image.getRGB(0, 0, secondWidth, secondImage.getHeight(null), ImageArraySecond, 0, secondWidth);
            BufferImageNew.setRGB(firstWidth, 0, secondWidth, secondImage.getHeight(null), ImageArraySecond, 0, secondWidth);
            ImageArraySecond = null;
        }
        if (thirdImage != null) {
            int[] ImageArrayThird = new int[thirdImage.getWidth(null) * thirdImage.getHeight(null)];
            image = BufferedImageBuilder.getInstance().bufferImage(thirdImage);
            ImageArrayThird = image.getRGB(0, 0, thirdImage.getWidth(null), thirdImage.getHeight(null), ImageArrayThird, 0, thirdImage.getWidth(null));
            BufferImageNew.setRGB(firstWidth + secondWidth, 0, thirdImage.getWidth(null), thirdImage.getHeight(null), ImageArrayThird, 0, thirdImage.getWidth(null));
            ImageArrayThird = null;
        }
        this.mDestImage = BufferImageNew;
        BufferImageNew.flush();
    }

    private void verticalStretch(int imageWidth, int imageHeight, int y1, int y2, PixelGrabber pg, MemoryImageSource ip, Toolkit tool) {
        int stretchHeight = this.mHeight - (y1 + imageHeight - y2);
        if (imageHeight >= this.mHeight) {
            if (imageHeight - (y2 - y1) >= this.mHeight) {
                ImageIcon temp = new ImageIcon(this.mDestImage);
                this.mDestImage = this.mDestImage.getScaledInstance(temp.getIconWidth(), this.mHeight, 1);
                return;
            }
            ImageIcon temp = new ImageIcon(this.mDestImage);
            this.verticalStretch(temp.getIconWidth(), imageHeight, y1, y2, stretchHeight, pg, ip, tool);
        } else {
            ImageIcon temp = new ImageIcon(this.mDestImage);
            if (y2 > imageHeight) {
                int totalHeight = y1 + y2;
                y1 = y1 * imageHeight / totalHeight;
                y2 = y2 * imageWidth / totalHeight;
                stretchHeight = this.mHeight - (y1 + imageHeight - y2);
            }
            this.verticalStretch(temp.getIconWidth(), imageHeight, y1, y2, stretchHeight, pg, ip, tool);
        }
    }

    private void verticalStretch(int imageWidth, int imageHeight, int x2, int y2, int stretchHeight, PixelGrabber pg, MemoryImageSource ip, Toolkit tool) {
        Image firstImage = null;
        Image secondImage = null;
        Image thirdImage = null;
        int[] pixels = new int[imageWidth * x2];
        pg = new PixelGrabber(this.mDestImage, 0, 0, imageWidth, x2, pixels, 0, imageWidth);
        try {
            pg.grabPixels();
            ip = new MemoryImageSource(imageWidth, x2, pixels, 0, imageWidth);
            firstImage = tool.createImage(ip);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        pixels = new int[imageWidth * (y2 - x2)];
        pg = new PixelGrabber(this.mDestImage, 0, x2, imageWidth, y2 - x2, pixels, 0, imageWidth);
        try {
            pg.grabPixels();
            ip = new MemoryImageSource(imageWidth, y2 - x2, pixels, 0, imageWidth);
            secondImage = tool.createImage(ip);
            secondImage = secondImage.getScaledInstance(imageWidth, stretchHeight, 1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        pixels = new int[imageWidth * (imageHeight - y2)];
        pg = new PixelGrabber(this.mDestImage, 0, y2, imageWidth, imageHeight - y2, pixels, 0, imageWidth);
        try {
            pg.grabPixels();
            ip = new MemoryImageSource(imageWidth, imageHeight - y2, pixels, 0, imageWidth);
            thirdImage = tool.createImage(ip);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.VerticalMerGeImage(firstImage, secondImage, thirdImage, imageWidth, this.mHeight);
    }

    private void VerticalMerGeImage(Image firstImage, Image secondImage, Image thirdImage, int imageWidth, int stretchHeight) {
        BufferedImage BufferImageNew = new BufferedImage(imageWidth, stretchHeight, 2);
        int[] ImageArrayFirst = new int[firstImage.getWidth(null) * firstImage.getHeight(null)];
        BufferedImage image = BufferedImageBuilder.getInstance().bufferImage(firstImage);
        ImageArrayFirst = image.getRGB(0, 0, firstImage.getWidth(null), firstImage.getHeight(null), ImageArrayFirst, 0, firstImage.getWidth(null));
        BufferImageNew.setRGB(0, 0, firstImage.getWidth(null), firstImage.getHeight(null), ImageArrayFirst, 0, firstImage.getWidth(null));
        ImageArrayFirst = null;
        int[] ImageArraySecond = new int[secondImage.getWidth(null) * secondImage.getHeight(null)];
        image = BufferedImageBuilder.getInstance().bufferImage(secondImage);
        ImageArraySecond = image.getRGB(0, 0, secondImage.getWidth(null), secondImage.getHeight(null), ImageArraySecond, 0, secondImage.getWidth(null));
        BufferImageNew.setRGB(0, firstImage.getHeight(null), secondImage.getWidth(null), secondImage.getHeight(null), ImageArraySecond, 0, secondImage.getWidth(null));
        ImageArraySecond = null;
        int[] ImageArrayThird = new int[thirdImage.getWidth(null) * thirdImage.getHeight(null)];
        image = BufferedImageBuilder.getInstance().bufferImage(thirdImage);
        ImageArrayThird = image.getRGB(0, 0, thirdImage.getWidth(null), thirdImage.getHeight(null), ImageArrayThird, 0, thirdImage.getWidth(null));
        BufferImageNew.setRGB(0, secondImage.getHeight(null) + firstImage.getHeight(null), thirdImage.getWidth(null), thirdImage.getHeight(null), ImageArrayThird, 0, thirdImage.getWidth(null));
        ImageArrayThird = null;
        this.mDestImage = BufferImageNew;
        BufferImageNew.flush();
    }

    public Image getDestImage() {
        return this.mDestImage;
    }

    public int getDestImageWidth() {
        return this.mDestImage.getWidth(null);
    }

    public int getDestImageHeight() {
        return this.mDestImage.getHeight(null);
    }
}

