/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class BufferedImageBuilder {
    private static BufferedImageBuilder mBufferedImageBuilder = null;
    private static final int DEFAULT_IMAGE_TYPE = 2;

    private BufferedImageBuilder() {
    }

    public static BufferedImageBuilder getInstance() {
        if (mBufferedImageBuilder == null) {
            mBufferedImageBuilder = new BufferedImageBuilder();
        }
        return mBufferedImageBuilder;
    }

    public BufferedImage bufferImage(Image image) {
        return this.bufferImage(image, 2);
    }

    public BufferedImage bufferImage(Image image, int type) {
        BufferedImage bufferedImage = null;
        bufferedImage = image.getHeight(null) == 0 ? new BufferedImage(image.getWidth(null), image.getHeight(null) + 1, type) : new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, null, null);
        this.waitForImage(bufferedImage);
        return bufferedImage;
    }

    private void waitForImage(BufferedImage bufferedImage) {
        final ImageLoadStatus imageLoadStatus = new ImageLoadStatus();
        bufferedImage.getHeight(new ImageObserver(){

            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                if (infoflags == 32) {
                    imageLoadStatus.heightDone = true;
                    return true;
                }
                return false;
            }
        });
        bufferedImage.getWidth(new ImageObserver(){

            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                if (infoflags == 32) {
                    imageLoadStatus.widthDone = true;
                    return true;
                }
                return false;
            }
        });
        while (!imageLoadStatus.widthDone && !imageLoadStatus.heightDone) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class ImageLoadStatus {
        public boolean widthDone = true;
        public boolean heightDone = true;

        ImageLoadStatus() {
        }
    }
}

