/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.parser.layout;

import com.iflytek.skintool.model.common.BaseData;
import com.iflytek.skintool.model.layout.AreaData;
import com.iflytek.skintool.model.layout.KeyData;
import com.iflytek.skintool.model.layout.RowData;
import com.iflytek.skintool.parser.common.BaseParser;
import com.iflytek.skintool.parser.common.DimensParser;
import com.iflytek.skintool.parser.common.StyleParser;
import com.iflytek.skintool.parser.layout.AnimationParser;
import com.iflytek.skintool.parser.layout.KeyParser;
import com.iflytek.skintool.parser.layout.RowParser;
import com.iflytek.skintool.parser.utils.ThemeFileManager;
import com.iflytek.skintool.util.ThemeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class AreaParser
extends BaseParser {
    protected StyleParser mStyleParser;
    protected DimensParser mDimensParser;
    protected AnimationParser mAnimationParser;
    protected RowParser mRowParser;
    protected KeyParser mKeyParser;
    protected AreaData mAreaData;
    private String[] mModeAreaStrArray;

    public AreaParser(Object context) {
        super(context);
        this.mFileName = "area.ini";
        this.mRowParser = new RowParser(context);
        this.mKeyParser = new KeyParser(context);
        this.mAnimationParser = new AnimationParser(context);
    }

    public void setStyleParser(StyleParser styleParser) {
        this.mStyleParser = styleParser;
        this.mRowParser.setStyleParser(styleParser);
        this.mKeyParser.setStyleParser(styleParser);
    }

    public void setDimensParser(DimensParser dimensParser) {
        this.mDimensParser = dimensParser;
        this.mRowParser.setDimensParser(dimensParser);
        this.mKeyParser.setDimensParser(dimensParser);
    }

    public String[] getModeAreaStrArray(String tag) {
        this.mAreaData = new AreaData();
        this.parserProperties(tag);
        return this.mModeAreaStrArray;
    }

    public int getAreaType(String tag) {
        this.mAreaData = new AreaData();
        Properties properties = (Properties)this.mPropertiesMap.get(tag);
        if (properties == null) {
            Map<String, Properties> propertiesMap = ThemeFileManager.getInstance().getSkinFile(!this.mLandscape, this.mFileName, this.layoutType);
            if (propertiesMap == null || propertiesMap.isEmpty()) {
                return 0;
            }
            properties = propertiesMap.get(tag);
        }
        if (properties != null && properties.get("AREA_TYPE") != null) {
            int flag = Integer.valueOf((String)properties.get("AREA_TYPE"));
            this.mAreaData.setAreaType(flag);
        }
        return this.mAreaData.getAreaType();
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape) {
        if (key.equalsIgnoreCase("SELECTOR")) {
            this.mModeAreaStrArray = ThemeUtils.splitString(value, ",");
        } else if (key.equalsIgnoreCase("STYLE")) {
            this.mStyleParser.setParserObject(this.layoutType);
            this.mAreaData.setStyle(this.mStyleParser.getParserResult(value));
        } else if (key.equalsIgnoreCase("DIMENS")) {
            this.mDimensParser.setParserObject(this.layoutType);
            this.mAreaData.setDimensData(this.mDimensParser.getParserResult(value));
        } else if (key.equalsIgnoreCase("MODE")) {
            this.mAreaData.setAttrModeStr(value);
        } else if (key.equalsIgnoreCase("SEPARATOR_STYLE")) {
            this.mAreaData.setSeparatorStyleData(this.mStyleParser.getParserResult(value));
        } else if (key.equalsIgnoreCase("SEPARATOR_DIMENS")) {
            this.mAreaData.setSeparatorDimensData(this.mDimensParser.getParserResult(value));
        } else if (key.equalsIgnoreCase("SEPARATOR_LAYOUT")) {
            this.mAreaData.setSeparatorLayoutType(Integer.valueOf(value));
        } else if (key.equalsIgnoreCase("STYLE_TYPE")) {
            this.mAreaData.setThemeType(ThemeUtils.getInt(value));
        } else if (key.equalsIgnoreCase("LAYOUT")) {
            this.mAreaData.setLayoutType(Integer.valueOf(value));
        } else if (key.equalsIgnoreCase("ROW_SET")) {
            String[] stringArray = ThemeUtils.splitString(value, ",");
            if (stringArray != null) {
                this.mRowParser.setParserObject(this.layoutType);
                ArrayList<RowData> tmpRowDataList = new ArrayList<RowData>();
                for (String rowTag : Arrays.asList(stringArray)) {
                    RowData rowData = this.mRowParser.getParserResult(rowTag);
                    rowData.setRowTag(rowTag);
                    if (rowData.getKeySet() == null || rowData.getKeySet().isEmpty()) {
                        rowData.addKeyData(this.mAreaData.getKeyAttribute());
                    }
                    tmpRowDataList.add(rowData);
                }
                this.mAreaData.setRowSet(tmpRowDataList);
            }
        } else if (key.equalsIgnoreCase("CONTENT")) {
            String[] stringArray = ThemeUtils.splitString(value, ",");
            this.mAreaData.setContents(Arrays.asList(stringArray));
        } else if (key.equalsIgnoreCase("AREA_TYPE")) {
            this.mAreaData.setAreaType(ThemeUtils.getInt(value));
        } else if (key.equalsIgnoreCase("ANIMATION")) {
            this.mAnimationParser.setParserObject(landscape, 1);
            this.mAreaData.setAnimation(this.mAnimationParser.getParserResult(value));
        } else if (key.equalsIgnoreCase("KEY_TEMPLATE")) {
            this.mKeyParser.setParserObject(this.layoutType);
            BaseData tmpKeyData = this.mKeyParser.getParserResult(value);
            if (tmpKeyData != null && tmpKeyData instanceof KeyData) {
                this.mAreaData.setKeyAttribute((KeyData)tmpKeyData);
            }
        } else if (key.equalsIgnoreCase("UP_FADE_STYLE")) {
            this.mStyleParser.setParserObject(this.layoutType);
            this.mAreaData.setUp_Fade_Style(this.mStyleParser.getParserResult(value));
        } else if (key.equalsIgnoreCase("UP_FADE_DIMENS")) {
            this.mDimensParser.setParserObject(this.layoutType);
            this.mAreaData.setUp_Fade_Dimens(this.mDimensParser.getParserResult(value));
        }
        return true;
    }

    public void newAreaData() {
        this.mAreaData = new AreaData();
    }

    @Override
    public AreaData getParserResult(String tag) {
        String areaTag = String.valueOf(this.mFileName) + this.mLandscape;
        HashMap<String, AreaData> areaDataPool = (HashMap<String, AreaData>)mAllDataPool.get(areaTag);
        areaDataPool = new HashMap<String, AreaData>();
        this.mAreaData = null;
        if (this.mAreaData == null) {
            this.newAreaData();
            this.mAreaData.setTag(tag);
            this.parserProperties(tag);
            areaDataPool.put(tag, this.mAreaData);
            mAllDataPool.put(areaTag, areaDataPool);
        }
        return this.mAreaData;
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape, boolean mark) {
        return false;
    }
}

